/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.commands;

import java.util.Enumeration;
import megamek.client.Client;
import megamek.client.commands.ClientCommand;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IHex;

public class ShowTileCommand
extends ClientCommand {
    public ShowTileCommand(Client client) {
        super(client, "tile", "print the information about a tile into the chat window. Ussage: #tile 01 01 [dir1 ...] which would show the details for the hex numbered 01 01. The command can be followed with any number of directions (N,NE,SE,S,SW,NW) to list the tiles following those diretions.");
    }

    public String run(String[] stringArray) {
        try {
            int n = 3;
            String string = "";
            String string2 = "";
            Coords coords = new Coords(Integer.parseInt(stringArray[1]) - 1, Integer.parseInt(stringArray[2]) - 1);
            do {
                IHex iHex;
                if ((iHex = this.client.game.getBoard().getHex(coords)) != null) {
                    Enumeration<Entity> enumeration;
                    string = "Details for hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") : " + iHex.toString();
                    if (!this.client.game.getOptions().booleanOption("double_blind") && (enumeration = this.client.game.getEntities(coords)).hasMoreElements()) {
                        string = string + "; Contains entities: " + enumeration.nextElement().getId();
                        while (enumeration.hasMoreElements()) {
                            string = string + ", " + enumeration.nextElement().getId();
                        }
                    }
                    string2 = string2 + string + "\n";
                } else {
                    string2 = string2 + "Hex (" + (coords.x + 1) + ", " + (coords.y + 1) + ") is not on the board.\n";
                }
                if (n >= stringArray.length) continue;
                coords = coords.translated(stringArray[n]);
            } while (++n < stringArray.length);
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return "Error parsing the command.";
    }
}

