/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.TwoColumnConstraints;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Stroke;
import java.util.Vector;

public class TwoColumnLayout
implements LayoutManager2 {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private Vector[] components = new Vector[]{new Vector(), new Vector()};
    private TwoColumnConstraints title = null;
    private int margin = 0;
    private int topBuffer = 0;
    private int indent = 0;
    private int gap = 5;
    private int alignment = 0;
    private int leftRule;
    private int rightRule;
    private int centerRule;
    private int titleHeight;

    public TwoColumnLayout(int n, int n2, int n3, int n4, int n5) {
        this.indent = n3;
        this.gap = n2;
        if (n >= 0 && n <= 50) {
            this.margin = n;
        }
        if (n4 >= 0 && n4 <= 100) {
            this.topBuffer = n4;
        }
        if (n5 == 0 || n5 == 2 || n5 == 1) {
            this.alignment = n5;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        block17: {
            TwoColumnConstraints twoColumnConstraints;
            block16: {
                if (object == null) {
                    return;
                }
                twoColumnConstraints = null;
                try {
                    twoColumnConstraints = (TwoColumnConstraints)object;
                    twoColumnConstraints = (TwoColumnConstraints)twoColumnConstraints.clone();
                }
                catch (Throwable throwable) {
                    return;
                }
                twoColumnConstraints.component = component;
                if (twoColumnConstraints.position != 9) break block16;
                this.title = twoColumnConstraints;
                if (!this.title.stretch) break block17;
                this.title.align = 0;
                break block17;
            }
            if (twoColumnConstraints.position == 29) {
                while (this.components[1].size() > this.components[0].size()) {
                    this.components[0].add(null);
                }
                while (this.components[0].size() > this.components[1].size()) {
                    this.components[1].add(null);
                }
                this.components[0].add(twoColumnConstraints);
                this.components[1].add(null);
            } else if (twoColumnConstraints.position == 15) {
                this.components[0].add(twoColumnConstraints);
            } else if (twoColumnConstraints.position == 16) {
                this.components[0].add(twoColumnConstraints);
                while (this.components[1].size() < this.components[0].size()) {
                    this.components[1].add(null);
                }
            } else if (twoColumnConstraints.position == 26) {
                this.components[1].add(twoColumnConstraints);
            } else if (twoColumnConstraints.position == 27) {
                this.components[1].add(twoColumnConstraints);
                while (this.components[0].size() < this.components[1].size()) {
                    this.components[0].add(null);
                }
            }
        }
    }

    public void layoutContainer(Container container) {
        this.positionRules(container);
        this.positionTitle(container);
        this.positionComponents(container);
    }

    private void positionRules(Container container) {
        int n = this.margin(container);
        if (this.alignment == 0) {
            this.leftRule = n;
            this.centerRule = this.leftRule + this.minimumColumnWidth(0, container) + this.gap;
            this.rightRule = container.getWidth() - n;
        } else if (this.alignment == 2) {
            this.centerRule = (int)(container.getMinimumSize().getWidth() / 2.0);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, container) - this.gap;
            this.rightRule = container.getWidth() - n;
        } else if (this.alignment == 1) {
            this.rightRule = container.getWidth() - n;
            this.centerRule = this.rightRule - this.minimumColumnWidth(1, container);
            this.leftRule = this.centerRule - this.minimumColumnWidth(0, container) - this.gap;
        }
    }

    private void positionTitle(Container container) {
        if (this.title != null) {
            Component component = this.title.component;
            int n = (int)component.getMinimumSize().getWidth();
            this.titleHeight = (int)component.getMinimumSize().getHeight();
            if (component != null) {
                if (this.title.stretch) {
                    n = this.rightRule - this.leftRule;
                    component.setBounds(this.leftRule, 0, n, this.titleHeight);
                } else if (this.title.align == 31) {
                    component.setBounds(this.leftRule, 0, n, this.titleHeight);
                } else if (this.title.align == 35) {
                    int n2 = this.centerRule - n / 2;
                    component.setBounds(n2, 0, n, this.titleHeight);
                } else if (this.title.align == 47) {
                    int n3 = this.rightRule - n;
                    component.setBounds(n3, 0, n, this.titleHeight);
                }
            }
        }
    }

    private void positionComponents(Container container) {
        int n = this.titleHeight + this.minimumClusterHeight();
        int n2 = this.topBuffer(n, container);
        int n3 = 0;
        int n4 = 0;
        if (n2 < 0) {
            n2 = 0;
        }
        int n5 = this.titleHeight + n2;
        for (int i = 0; i < this.rows(); ++i) {
            int n6;
            n3 = this.height(i, 0);
            if (n3 > (n4 = this.height(i, 1))) {
                n6 = (n3 - n4) / 2;
                this.positionComponent(n5, i, 0, container);
                this.positionComponent(n5 + n6, i, 1, container);
                n5 += n3;
                continue;
            }
            if (n3 < n4) {
                n6 = (n4 - n3) / 2;
                this.positionComponent(n5 + n6, i, 0, container);
                this.positionComponent(n5, i, 1, container);
                n5 += n4;
                continue;
            }
            this.positionComponent(n5, i, 0, container);
            this.positionComponent(n5, i, 1, container);
            n5 += n3;
        }
    }

    private void positionComponent(int n, int n2, int n3, Container container) {
        TwoColumnConstraints twoColumnConstraints = null;
        try {
            twoColumnConstraints = (TwoColumnConstraints)this.components[n3].elementAt(n2);
        }
        catch (Throwable throwable) {
            return;
        }
        int n4 = 0;
        if (twoColumnConstraints != null) {
            Component component = twoColumnConstraints.component;
            int n5 = (int)component.getPreferredSize().getWidth();
            int n6 = (int)component.getPreferredSize().getHeight();
            n4 = n3 == 0 ? this.leftRule : this.centerRule;
            if (component != null) {
                if (twoColumnConstraints.stretch && twoColumnConstraints.position == 29) {
                    n5 = this.rightRule - this.leftRule;
                    n4 = this.leftRule;
                } else if (twoColumnConstraints.stretch && n3 == 0) {
                    n5 = this.centerRule - this.leftRule;
                } else if (twoColumnConstraints.stretch && n3 == 1) {
                    n5 = this.rightRule - this.centerRule;
                } else if (twoColumnConstraints.position == 29) {
                    if (n5 > this.rightRule - this.leftRule) {
                        n5 = this.rightRule - this.leftRule;
                    }
                    n4 = this.leftRule;
                }
                if (twoColumnConstraints.indent) {
                    n5 -= this.indent;
                    n4 += this.indent;
                }
                component.setBounds(n4, n, n5, n6);
            }
        }
    }

    private int minimumColumnWidth(int n, Container container) {
        Component component = null;
        TwoColumnConstraints twoColumnConstraints = null;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.components[n].size(); ++i) {
            twoColumnConstraints = (TwoColumnConstraints)this.components[n].elementAt(i);
            if (twoColumnConstraints == null || twoColumnConstraints.position == 29) continue;
            component = twoColumnConstraints.component;
            n3 = (int)component.getMinimumSize().getWidth();
            if (twoColumnConstraints.indent) {
                n3 += this.indent;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int minimumBothColumnsWidth(Container container) {
        Component component = null;
        TwoColumnConstraints twoColumnConstraints = null;
        int n = 0;
        int n2 = 0;
        if (this.title != null) {
            component = this.title.component;
            n = (int)component.getMinimumSize().getWidth();
        }
        for (int i = 0; i < this.components[0].size(); ++i) {
            twoColumnConstraints = (TwoColumnConstraints)this.components[0].elementAt(i);
            if (twoColumnConstraints == null || twoColumnConstraints.position != 29) continue;
            component = twoColumnConstraints.component;
            n2 = (int)component.getMinimumSize().getWidth();
            if (twoColumnConstraints.indent) {
                n2 += this.indent;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int minimumClusterHeight() {
        int n = 0;
        for (int i = 0; i < this.rows(); ++i) {
            n += this.rowHeight(i);
        }
        return n;
    }

    private int rows() {
        int n;
        int n2 = 0;
        int n3 = this.components[0].size();
        n2 = n3 > (n = this.components[1].size()) ? n3 : n;
        return n2;
    }

    private int rowHeight(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.height(n, 0);
        n3 = n4 > (n2 = this.height(n, 1)) ? n4 : n2;
        return n3;
    }

    private int height(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            TwoColumnConstraints twoColumnConstraints = (TwoColumnConstraints)this.components[n2].elementAt(n);
            if (twoColumnConstraints != null) {
                Component component = twoColumnConstraints.component;
                n4 = (int)component.getMinimumSize().getWidth();
                n3 = (int)component.getMinimumSize().getHeight();
                if (twoColumnConstraints.position == 15) {
                    if (n4 > this.centerRule - this.leftRule) {
                        component.setBounds(0, 0, this.centerRule - this.leftRule, n3);
                    }
                } else if (twoColumnConstraints.position == 26) {
                    if (n4 > this.rightRule - this.centerRule) {
                        component.setBounds(0, 0, this.rightRule - this.centerRule, n3);
                    }
                } else if (twoColumnConstraints.position == 29 && n4 > this.rightRule - this.leftRule) {
                    component.setBounds(0, 0, this.rightRule - this.leftRule, n3);
                }
                n3 = (int)component.getMinimumSize().getHeight();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return n3;
    }

    private int margin(Container container) {
        int n = (int)(container.getSize().getWidth() * (double)this.margin / 100.0);
        return n;
    }

    private int topBuffer(int n, Container container) {
        int n2 = (int)container.getSize().getHeight() - n;
        n2 = n2 * this.topBuffer / 100;
        return n2;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.positionTitle(container);
        int n = this.minimumBothColumnsWidth(container);
        int n2 = this.minimumClusterHeight() + this.titleHeight;
        return new Dimension(n, n2);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
        this.leftRule = 0;
        this.rightRule = 0;
        this.centerRule = 0;
        this.titleHeight = 0;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        Component component2;
        TwoColumnConstraints twoColumnConstraints;
        int n;
        Vector vector = this.components[0];
        Vector vector2 = this.components[1];
        for (n = 0; n < vector.size(); ++n) {
            twoColumnConstraints = (TwoColumnConstraints)vector.get(n);
            if (twoColumnConstraints == null || (component2 = twoColumnConstraints.component) == null || !component2.equals(component)) continue;
            if (twoColumnConstraints.position != 29 && twoColumnConstraints.position != 16) break;
            vector2.remove(n);
            break;
        }
        for (n = 0; n < vector2.size(); ++n) {
            twoColumnConstraints = (TwoColumnConstraints)vector2.get(n);
            if (twoColumnConstraints == null || (component2 = twoColumnConstraints.component) == null || !component2.equals(component)) continue;
            if (twoColumnConstraints.position != 29 && twoColumnConstraints.position != 27) break;
            vector.remove(n);
            break;
        }
    }

    public void showRules(Graphics2D graphics2D, Color color) {
        int n = graphics2D.getClipBounds().height;
        Stroke stroke = graphics2D.getStroke();
        Color color2 = graphics2D.getColor();
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 2, 1.5f, new float[]{10.0f, 5.0f}, 5.0f);
        graphics2D.setColor(color);
        graphics2D.drawLine(this.leftRule, 0, this.leftRule, n);
        graphics2D.drawLine(this.centerRule, this.titleHeight, this.centerRule, n);
        graphics2D.drawLine(this.rightRule, 0, this.rightRule, n);
        graphics2D.drawLine(this.leftRule, this.titleHeight, this.rightRule, this.titleHeight);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(this.leftRule + this.indent, this.titleHeight, this.leftRule + this.indent, n);
        graphics2D.drawLine(this.centerRule + this.indent, this.titleHeight, this.centerRule + this.indent, n);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color2);
    }
}

