/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.PropertiesBuilder;
import net.charabia.jsmoothgen.pe.PEFile;
import net.charabia.jsmoothgen.pe.PEResourceDirectory;
import net.charabia.jsmoothgen.pe.res.ResIcon;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.util.codec.IcoCodec;
import net.charabia.util.codec.Quantize;

public class ExeCompiler {
    private Vector m_errors = new Vector();
    private Vector m_listeners = new Vector();

    public void addListener(StepListener listener) {
        this.m_listeners.add(listener);
    }

    public void cleanErrors() {
        this.m_errors.removeAllElements();
    }

    public Vector getErrors() {
        return this.m_errors;
    }

    public CompilerRunner getRunnable(File skelroot, SkeletonBean skel, File basedir, JSmoothModelBean data, File out) {
        return new CompilerRunner(skelroot, skel, basedir, data, out);
    }

    public void compileAsync(File skelroot, SkeletonBean skel, File basedir, JSmoothModelBean data, File out) {
        Thread t = new Thread(new CompilerRunner(skelroot, skel, basedir, data, out));
        t.start();
    }

    public boolean compile(File skelroot, SkeletonBean skel, File basedir, JSmoothModelBean data, File out) throws Exception {
        try {
            this.fireStepChange(0, "Starting compilation");
            File pattern = new File(skelroot, skel.getExecutableName());
            if (!pattern.exists()) {
                this.m_errors.add("Error: Can't find any skeleton at " + skelroot);
                this.fireFailedChange();
                return false;
            }
            this.fireStepChange(10, "Scanning skeleton...");
            PEFile pe = new PEFile(pattern);
            pe.open();
            PEResourceDirectory resdir = pe.getResourceDirectory();
            boolean resb = false;
            if (data.getEmbeddedJar()) {
                if (data.getJarLocation() == null) {
                    this.m_errors.add("Error: Jar is not specified!");
                    this.fireFailedChange();
                    return false;
                }
                this.fireStepChange(40, "Loading Jar...");
                File jarloc = ExeCompiler.concFile(basedir, new File(data.getJarLocation()));
                if (!jarloc.exists()) {
                    this.m_errors.add("Error: Can't find jar at " + jarloc);
                    this.fireFailedChange();
                    return false;
                }
                ByteBuffer jardata = this.load(jarloc);
                this.fireStepChange(60, "Adding Jar to Resources...");
                resb = resdir.replaceResource(skel.getResourceCategory(), skel.getResourceJarId(), 1033, jardata);
                if (!resb) {
                    this.m_errors.add("Error: Can't replace jar resource! It is probably missing from the skeleton.");
                    this.fireFailedChange();
                    return false;
                }
            }
            this.fireStepChange(70, "Adding Properties to Resources...");
            String props = PropertiesBuilder.makeProperties(basedir, data);
            ByteBuffer propdata = this.convert(props);
            resb = resdir.replaceResource(skel.getResourceCategory(), skel.getResourcePropsId(), 1033, propdata);
            if (data.getIconLocation() != null) {
                this.fireStepChange(80, "Loading icon...");
                String iconpath = new File(data.getIconLocation()).isAbsolute() ? data.getIconLocation() : new File(basedir, data.getIconLocation()).getAbsolutePath();
                Image img = this.getScaledImage(iconpath, 32, 32);
                Hashtable set = this.calculateColorCount(img);
                if (img != null) {
                    ResIcon resicon = new ResIcon(img);
                    pe.replaceDefaultIcon(resicon);
                }
            }
            this.fireStepChange(90, "Saving exe...");
            pe.dumpTo(out);
            this.fireCompleteChange();
            return true;
        }
        catch (Exception exc) {
            this.m_errors.add("Error: " + exc.getMessage());
            exc.printStackTrace();
            this.fireFailedChange();
            return false;
        }
    }

    public Image[] loadImages(String path) {
        File f = new File(path);
        if (path.toUpperCase().endsWith(".ICO")) {
            try {
                Image[] images = IcoCodec.loadImages(f);
                if (images != null && images.length > 0) {
                    return images;
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
        ImageIcon icon = new ImageIcon(path, "default icon");
        Image[] imgs = new Image[]{icon.getImage()};
        return imgs;
    }

    public void checkImageLoaded(Image img) {
        MediaTracker mtrack = new MediaTracker(new Canvas());
        mtrack.addImage(img, 1);
        try {
            mtrack.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Hashtable calculateColorCount(Image img) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
        }
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        int colorindex = 0;
        for (int i = 0; i < pixels.length; ++i) {
            Integer pixi;
            Object o;
            int pix = pixels[i];
            if ((pix >> 24 & 0xFF) <= 0 || (o = result.get(pixi = new Integer(pix &= 0xFFFFFF))) != null) continue;
            result.put(pixi, new Integer(colorindex++));
        }
        return result;
    }

    public BufferedImage getQuantizedImage(Image img) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int[][] data = new int[width][height];
        int[] pixelbuffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, pixelbuffer, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            throw new RuntimeException("Can't load the image provided", e);
        }
        for (int i = 0; i < pixelbuffer.length; ++i) {
            data[i % width][i / width] = pixelbuffer[i];
        }
        int[][] savedata = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                savedata[x][y] = data[x][y];
            }
        }
        int[] palette = Quantize.quantizeImage(data, 255);
        byte[] cmap = new byte[1024];
        for (int i = 0; i < palette.length; ++i) {
            cmap[i * 4] = (byte)(palette[i] >> 16 & 0xFF);
            cmap[i * 4 + 1] = (byte)(palette[i] >> 8 & 0xFF);
            cmap[i * 4 + 2] = (byte)(palette[i] & 0xFF);
            cmap[i * 4 + 3] = -1;
        }
        IndexColorModel colmodel = new IndexColorModel(8, palette.length, cmap, 0, true, 0);
        BufferedImage result = new BufferedImage(width, height, 2);
        Hashtable<Integer, Integer> set = new Hashtable<Integer, Integer>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int alpha = savedata[x][y] >> 24 & 0xFF;
                if (alpha == 0) {
                    result.setRGB(x, y, 0);
                    continue;
                }
                int rgb = colmodel.getRGB(data[x][y]);
                set.put(new Integer(rgb |= 0xFF000000), new Integer(rgb));
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }

    public Image checkImageSize(Image img, int width, int height) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        if (w == width && h == height) {
            return img;
        }
        return null;
    }

    public Image getScaledImage(String path, int width, int height) {
        int i;
        int i2;
        Image[] orgimages = this.loadImages(path);
        if (orgimages == null || orgimages.length == 0) {
            return null;
        }
        for (i2 = 0; i2 < orgimages.length; ++i2) {
            this.checkImageLoaded(orgimages[i2]);
        }
        for (i2 = 0; i2 < orgimages.length; ++i2) {
            int w = orgimages[i2].getWidth(null);
            int h = orgimages[i2].getHeight(null);
        }
        Image selected = null;
        for (i = 0; i < orgimages.length && selected == null; ++i) {
            selected = this.checkImageSize(orgimages[i], 32, 32);
        }
        for (i = 0; i < orgimages.length && selected == null; ++i) {
            selected = this.checkImageSize(orgimages[i], 64, 64);
        }
        for (i = 0; i < orgimages.length && selected == null; ++i) {
            selected = this.checkImageSize(orgimages[i], 16, 16);
        }
        if (selected != null) {
            return this.getQuantizedImage(selected);
        }
        int maxsize = 0;
        Image biggest = null;
        for (int i3 = 0; i3 < orgimages.length && selected == null; ++i3) {
            int size = orgimages[i3].getWidth(null) * orgimages[i3].getHeight(null);
            if (size <= maxsize) continue;
            maxsize = size;
            biggest = orgimages[i3];
        }
        if (biggest != null) {
            Image result = biggest.getScaledInstance(32, 32, 16);
            this.checkImageLoaded(result);
            return this.getQuantizedImage(result);
        }
        return null;
    }

    private ByteBuffer load(File in) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        ByteBuffer data = ByteBuffer.allocate((int)in.length());
        data.order(ByteOrder.LITTLE_ENDIAN);
        FileChannel fischan = fis.getChannel();
        fischan.read(data);
        data.position(0);
        fis.close();
        return data;
    }

    private ByteBuffer convert(String data) {
        ByteBuffer result = ByteBuffer.allocate(data.length() + 1);
        result.position(0);
        for (int i = 0; i < data.length(); ++i) {
            result.put((byte)data.charAt(i));
        }
        result.put((byte)0);
        result.position(0);
        return result;
    }

    public static File concFile(File root, File name) {
        if (name.isAbsolute()) {
            return name;
        }
        return new File(root, name.toString());
    }

    public void fireStepChange(int percentComplete, String state) {
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            StepListener l = (StepListener)i.next();
            l.setNewState(percentComplete, state);
        }
    }

    public void fireFailedChange() {
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            StepListener l = (StepListener)i.next();
            l.failed();
        }
    }

    public void fireCompleteChange() {
        Iterator i = this.m_listeners.iterator();
        while (i.hasNext()) {
            StepListener l = (StepListener)i.next();
            l.complete();
        }
    }

    public class CompilerRunner
    implements Runnable {
        private File m_skelroot;
        private SkeletonBean m_skel;
        private JSmoothModelBean m_data;
        private File m_out;
        private File m_basedir;

        public CompilerRunner(File skelroot, SkeletonBean skel, File basedir, JSmoothModelBean data, File out) {
            this.m_skelroot = skelroot;
            this.m_skel = skel;
            this.m_data = data;
            this.m_out = out;
            this.m_basedir = basedir;
        }

        public void run() {
            try {
                ExeCompiler.this.compile(this.m_skelroot, this.m_skel, this.m_basedir, this.m_data, this.m_out);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        public ExeCompiler getCompiler() {
            return ExeCompiler.this;
        }
    }

    public static interface StepListener {
        public void setNewState(int var1, String var2);

        public void failed();

        public void complete();
    }
}

