/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;

public class JsRequiresSemiVisitor
extends JsVisitor {
    private boolean needsSemicolon;

    private JsRequiresSemiVisitor() {
    }

    public static boolean exec(JsStatement lastStatement) {
        JsRequiresSemiVisitor visitor2 = new JsRequiresSemiVisitor();
        visitor2.accept(lastStatement);
        return visitor2.needsSemicolon;
    }

    @Override
    public void visitFor(@NotNull JsFor x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitForIn(@NotNull JsForIn x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitIf(@NotNull JsIf x) {
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStmt = x.getElseStatement();
        JsStatement toCheck = thenStmt;
        if (elseStmt != null) {
            toCheck = elseStmt;
        }
        if (toCheck instanceof JsEmpty) {
            this.needsSemicolon = true;
        } else {
            this.accept(toCheck);
        }
    }

    @Override
    public void visitLabel(@NotNull JsLabel x) {
        if (x.getStatement() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }

    @Override
    public void visitWhile(@NotNull JsWhile x) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
    }
}

