#if defined(CONFIG_BCM_KF_MIPS_BCM963XX) && defined(CONFIG_MIPS_BCM963XX)
/*
* <:copyright-BRCM:2004:DUAL/GPL:standard
* 
*    Copyright (c) 2004 Broadcom Corporation
*    All Rights Reserved
* 
* Unless you and Broadcom execute a separate written software license
* agreement governing use of this software, this software is licensed
* to you under the terms of the GNU General Public License version 2
* (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
* with the following added to such license:
* 
*    As a special exception, the copyright holders of this software give
*    you permission to link this software with independent modules, and
*    to copy and distribute the resulting executable under terms of your
*    choice, provided that you also meet, for each linked independent
*    module, the terms and conditions of the license of that module.
*    An independent module is a module which is not derived from this
*    software.  The special exception does not apply to any modifications
*    of the software.
* 
* Not withstanding the above, under no circumstances may you combine
* this software in any way with any other Broadcom software provided
* under a license other than the GPL, without Broadcom's express prior
* written consent.
* 
* :>
 
*/
/*
 * prom.c: PROM library initialization code.
 *
 */
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/bootmem.h>
#include <linux/blkdev.h>
#include <linux/export.h>
#include <asm/addrspace.h>
#include <asm/bootinfo.h>
#include <asm/cpu.h>
#include <asm/time.h>

#include <bcm_map_part.h>
#include <bcm_cpu.h>
#include <board.h>
#include <boardparms.h>

extern int  do_syslog(int, char *, int);

unsigned char g_blparms_buf[1024];

#if defined(CONFIG_BCM_KF_DSP) && defined(CONFIG_BCM_BCMDSP_MODULE)
unsigned int main_tp_num;
#endif

static void __init create_cmdline(char *cmdline);
UINT32 __init calculateCpuSpeed(void);
void __init retrieve_boot_loader_parameters(void);

#if defined (CONFIG_BCM96328)
const uint32 cpu_speed_table[0x20] = {
    320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 320,
    0, 320, 160, 200, 160, 200, 400, 320, 320, 160, 384, 320, 192, 320, 320, 320
};
#endif

#if defined (CONFIG_BCM96362)
const uint32 cpu_speed_table[0x20] = {
    320, 320, 320, 240, 160, 400, 440, 384, 320, 320, 320, 240, 160, 320, 400, 320,
    320, 320, 320, 240, 160, 200, 400, 384, 320, 320, 320, 240, 160, 200, 400, 400
};
#endif

#if defined (CONFIG_BCM963268)
const uint32 cpu_speed_table[0x20] = {
    0, 0, 400, 320, 0, 0, 0, 0, 0, 0, 333, 400, 0, 0, 320, 400,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif

#if defined (CONFIG_BCM96318)
const uint32 cpu_speed_table[0x04] = {
    166, 400, 250, 333
};
#endif

#if defined (CONFIG_BCM960333)
const uint32 cpu_speed_table[0x04] = {
    200, 400, 333, 0
};
#endif






#if defined (CONFIG_BCM96838)
const uint32 cpu_speed_table[0x3] = {
    600, 400, 240
};
#endif

#if defined (CONFIG_BCM963381)
const uint32 cpu_speed_table[0x04] = {
    300, 800, 480, 600
};
#endif

static char promBoardIdStr[NVRAM_BOARD_ID_STRING_LEN];
const char *get_system_type(void)
{
    kerSysNvRamGetBoardId(promBoardIdStr);
    return(promBoardIdStr);
}

static int prom_argc;
static char **prom_argv, **prom_envp;

unsigned char * r2secr = 0;

EXPORT_SYMBOL(r2secr);

static void prom_init_cmdline_handlehidden(const char * string)
{
	if (string && (strncmp(string, "r2secr=", 7) == 0)) {		
		unsigned int ptr;
		sscanf (string+7, "%x",&ptr);
		r2secr = (unsigned char *) ptr;
	}
}


static void prom_init_cmdline(void)
{
	char *cp;
	int actr;

	actr = 1; /* Always ignore argv[0] */

	cp = &(arcs_cmdline[0]);

	cp += strlen(cp);
	*cp++ = ' ';

	while(actr < prom_argc) {
        if (prom_argv[actr][0] == '.') {
            prom_init_cmdline_handlehidden(&(prom_argv[actr][1]));
        }
        else {
		strcpy(cp, prom_argv[actr]);
		cp += strlen(prom_argv[actr]);
		*cp++ = ' ';
        }
		actr++;
	}
	if (cp != &(arcs_cmdline[0])) /* get rid of trailing space */
		--cp;
	if (prom_argc > 1)
		*cp = '\0';
}

/* --------------------------------------------------------------------------
    Name: prom_init
 -------------------------------------------------------------------------- */

extern struct plat_smp_ops brcm_smp_ops;

void __init prom_init(void)
{
    retrieve_boot_loader_parameters();
    kerSysEarlyFlashInit();

    // too early in bootup sequence to acquire spinlock, not needed anyways
    // only the kernel is running at this point
    kerSysNvRamGetBoardIdLocked(promBoardIdStr);
    printk( "%s prom init\n", promBoardIdStr );

#if defined(CONFIG_BCM_KF_DSP) && defined(CONFIG_BCM_BCMDSP_MODULE)
    main_tp_num = ((read_c0_diag3() & CP0_CMT_TPID) == CP0_CMT_TPID) ? 1 : 0;
    printk("Linux TP ID = %u \n", (unsigned int)main_tp_num);
#endif

    PERF->IrqControl[0].IrqMask=0;

    arcs_cmdline[0] = '\0';

    create_cmdline(arcs_cmdline);

    prom_argc = (int) fw_arg0;
    prom_argv = (char **) fw_arg1;
    prom_envp = (char **) fw_arg2;

    if (prom_argc > 0) {
        /* 1.x.x / 2.x.x TCH bootloader */
        prom_init_cmdline();
    }
    else {
        /* CFE based TCH bootloader */
        retrieve_boot_loader_parameters();
        strcpy(arcs_cmdline, g_blparms_buf);
    }

    strcat(arcs_cmdline, " ");
    strcat(arcs_cmdline, CONFIG_CMDLINE);

    /* Count register increments every other clock */
    mips_hpt_frequency = calculateCpuSpeed() / 2;

#if defined (CONFIG_SMP)
    register_smp_ops(&brcm_smp_ops);
#endif
}


/* --------------------------------------------------------------------------
    Name: prom_free_prom_memory
Abstract: 
 -------------------------------------------------------------------------- */
void __init prom_free_prom_memory(void)
{

}

#if defined(CONFIG_ROOT_NFS) && defined(SUPPORT_SWMDK)
  /* We can't use gendefconfig to automatically fix this, so instead we will
     raise an error here */
  #error "Kernel cannot be configured for both SWITCHMDK and NFS."
#endif

#define HEXDIGIT(d) ((d >= '0' && d <= '9') ? (d - '0') : ((d | 0x20) - 'W'))
#define HEXBYTE(b)  (HEXDIGIT((b)[0]) << 4) + HEXDIGIT((b)[1])

#ifndef CONFIG_ROOT_NFS_DIR
#define CONFIG_ROOT_NFS_DIR	"h:/"
#endif

#ifdef CONFIG_BLK_DEV_RAM_SIZE
#define RAMDISK_SIZE		CONFIG_BLK_DEV_RAM_SIZE
#else
#define RAMDISK_SIZE		0x800000
#endif

/*
 * This function reads in a line that looks something like this from NvRam:
 *
 * CFE bootline=bcmEnet(0,0)host:vmlinux e=192.169.0.100:ffffff00 h=192.169.0.1
 *
 * and retuns in the cmdline parameter based on the boot_type that CFE sets up.
 *
 * for boot from flash, it will use the definition in CONFIG_ROOT_FLASHFS
 *
 * for boot from NFS, it will look like below:
 * CONFIG_CMDLINE="root=/dev/nfs nfsroot=192.168.0.1:/opt/targets/96345R/fs
 * ip=192.168.0.100:192.168.0.1::255.255.255.0::eth0:off rw"
 *
 * for boot from tftp, it will look like below:
 * CONFIG_CMDLINE="root=/dev/ram rw rd_start=0x81000000 rd_size=0x1800000"
 */
static void __init create_cmdline(char *cmdline)
{
	char boot_type = '\0', mask[16] = "";
	char bootline[NVRAM_BOOTLINE_LEN] = "";
	char *localip = NULL, *hostip = NULL, *p = bootline, *rdaddr = NULL;

#if 0 /* TCH */
	/*
	 * too early in bootup sequence to acquire spinlock, not needed anyways
	 * only the kernel is running at this point
	 */
	kerSysNvRamGetBootlineLocked(bootline);
#endif

	while (*p) {
		if (p[0] == 'e' && p[1] == '=') {
			/* Found local ip address */
			p += 2;
			localip = p;
			while (*p && *p != ' ' && *p != ':')
				p++;
			if (*p == ':') {
				/* Found network mask (eg FFFFFF00 */
				*p++ = '\0';
				sprintf(mask, "%u.%u.%u.%u", HEXBYTE(p),
					HEXBYTE(p + 2),
				HEXBYTE(p + 4), HEXBYTE(p + 6));
				p += 4;
			} else if (*p == ' ')
				*p++ = '\0';
		} else if (p[0] == 'h' && p[1] == '=') {
			/* Found host ip address */
			p += 2;
			hostip = p;
			while (*p && *p != ' ')
				p++;
			if (*p == ' ')
				*p++ = '\0';
		} else if (p[0] == 'r' && p[1] == '=') {
			/* Found boot type */
			p += 2;
			boot_type = *p;
			while (*p && *p != ' ')
				p++;
			if (*p == ' ')
				*p++ = '\0';
		} else if (p[0] == 'a' && p[1] == '=') {
			p += 2;
			rdaddr = p;
			while (*p && *p != ' ')
				p++;
			if (*p == ' ')
				*p++ = '\0';
		} else 
			p++;
	}

	if (boot_type == 'h' && localip && hostip) {
		/* Boot from NFS with proper IP addresses */
		sprintf(cmdline, "root=/dev/nfs nfsroot=%s:" CONFIG_ROOT_NFS_DIR
				" ip=%s:%s::%s::eth0:off rw",
				hostip, localip, hostip, mask);
	} else if (boot_type == 'c') {
		/* boot from tftp */
		sprintf(cmdline, "root=/dev/ram0 ro rd_start=%s rd_size=0x%x",
				rdaddr, RAMDISK_SIZE << 10);
	} else {
		/* go with the default, boot from flash */
#ifdef CONFIG_ROOT_FLASHFS
		strcpy(cmdline, CONFIG_ROOT_FLASHFS);
#endif
	}
}

/*  *********************************************************************
    *  calculateCpuSpeed()
    *      Calculate the BCM63xx CPU speed by reading the PLL Config register
    *      and applying the following formula:
    *      Fcpu_clk = (25 * MIPSDDR_NDIV) / MIPS_MDIV
    *  Input parameters:
    *      none
    *  Return value:
    *      none
    ********************************************************************* */

#if defined(CONFIG_BCM96328) || defined(CONFIG_BCM96362) || defined(CONFIG_BCM96816) || defined(CONFIG_BCM96818) || defined(CONFIG_BCM963268) || defined (CONFIG_BCM96828) || defined(CONFIG_BCM963381)
UINT32 __init calculateCpuSpeed(void)
{
    UINT32 mips_pll_fvco;

    mips_pll_fvco = MISC->miscStrapBus & MISC_STRAP_BUS_MIPS_PLL_FVCO_MASK;
    mips_pll_fvco >>= MISC_STRAP_BUS_MIPS_PLL_FVCO_SHIFT;

    return cpu_speed_table[mips_pll_fvco] * 1000000;
}
#endif

#if defined(CONFIG_BCM96318) || defined(CONFIG_BCM960333)
UINT32 __init calculateCpuSpeed(void)
{
	UINT32 uiCpuSpeedTableIdx;				// Index into the CPU speed table (0 to 3)
	
	// Get the strapOverrideBus bits to index into teh CPU speed table	
	uiCpuSpeedTableIdx = STRAP->strapOverrideBus & STRAP_BUS_MIPS_FREQ_MASK;
	uiCpuSpeedTableIdx >>= STRAP_BUS_MIPS_FREQ_SHIFT;
    
    return cpu_speed_table[uiCpuSpeedTableIdx] * 1000000;
}
#endif

#if defined(CONFIG_BCM96838)
UINT32 __init calculateCpuSpeed(void)
{ 
#define OTP_BASE		   0xb4e00400
#define OTP_SHADOW_BRCM_BITS_0_31               0x40
#define OTP_BRCM_VIPER_FREQ_SHIFT               18
#define OTP_BRCM_VIPER_FREQ_MASK                (0x7 << OTP_BRCM_VIPER_FREQ_SHIFT)

    UINT32 otp_shadow_reg = *((volatile UINT32*)(OTP_BASE+OTP_SHADOW_BRCM_BITS_0_31));
	UINT32 uiCpuSpeedTableIdx = (otp_shadow_reg & OTP_BRCM_VIPER_FREQ_MASK) >> OTP_BRCM_VIPER_FREQ_SHIFT;
	
	return cpu_speed_table[uiCpuSpeedTableIdx] * 1000000;
}
#endif


/* Retrieve a buffer of paramters passed by the boot loader.  Functions in
 * board.c can return requested parameter values to a calling Linux function.
 */
void __init retrieve_boot_loader_parameters(void)
{
    extern unsigned char _text;
    unsigned long blparms_magic = *(unsigned long *) (&_text - 8);
    unsigned long blparms_buf = *(unsigned long *) (&_text - 4);
    unsigned char *src = (unsigned char *) blparms_buf;
    unsigned char *dst = g_blparms_buf;

#if 0 
    if( blparms_magic != BLPARMS_MAGIC )
    {
        /* Subtract four more bytes for NAND flash images. */
        blparms_magic = *(unsigned long *) (&_text - 12);
        blparms_buf = *(unsigned long *) (&_text - 8);
        src = (unsigned char *) blparms_buf;
    }
#endif
    if( blparms_magic == BLPARMS_MAGIC )
    {
        do
        {
            *dst++ = *src++;
        } while( (src[0] != '\0' || src[1] != '\0') &&
          (unsigned long) (dst - g_blparms_buf) < sizeof(g_blparms_buf) - 2);
    }

    dst[0] = dst[1] = '\0';
}

#endif // defined(CONFIG_BCM_KF_MIPS_BCM963XX)

