/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __RUNNER_H_INCLUDED
#define __RUNNER_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:55:07   */

#include "access_macros.h"
#ifndef __PACKING_ATTRIBUTE_STRUCT_END__
#include "packing.h"
#endif
#include "rdp_map.h"

/*****************************************************************************************/
/* Runner VPB address space                                                              */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define RUNNER_COMMON_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_COMMON_0_MEM_ADDRESS	( RUNNER_COMMON_0_OFFSET + RUNNER_COMMON_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_COMMON_MEM_COUNTER ( 4096 )
/** Number of registers per entry **/
#define RUNNER_COMMON_MEM_IN_OFFSET ( 8 )

#define RUNNER_COMMON_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_COMMON_1_MEM_ADDRESS	( RUNNER_COMMON_1_OFFSET + RUNNER_COMMON_1_MEM_OFFSET )

#define RUNNER_PRIVATE_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRIVATE_0_MEM_ADDRESS	( RUNNER_PRIVATE_0_OFFSET + RUNNER_PRIVATE_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_PRIVATE_MEM_COUNTER ( 6144 )
/** Number of registers per entry **/
#define RUNNER_PRIVATE_MEM_IN_OFFSET ( 8 )

#define RUNNER_PRIVATE_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRIVATE_1_MEM_ADDRESS	( RUNNER_PRIVATE_1_OFFSET + RUNNER_PRIVATE_1_MEM_OFFSET )

#define RUNNER_INST_MAIN_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_INST_MAIN_0_MEM_ADDRESS	( RUNNER_INST_MAIN_0_OFFSET + RUNNER_INST_MAIN_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_INST_MAIN_MEM_COUNTER ( 7168 )

/** Number of registers per entry **/
#define RUNNER_INST_MAIN_MEM_IN_OFFSET ( 4 )

#define RUNNER_INST_MAIN_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_INST_MAIN_1_MEM_ADDRESS	( RUNNER_INST_MAIN_1_OFFSET + RUNNER_INST_MAIN_1_MEM_OFFSET )

#define RUNNER_CNTXT_MAIN_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_CNTXT_MAIN_0_MEM_ADDRESS	( RUNNER_CNTXT_MAIN_0_OFFSET + RUNNER_CNTXT_MAIN_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_CNTXT_MAIN_MEM_COUNTER ( 1024 )
/** Number of registers per entry **/
#define RUNNER_CNTXT_MAIN_MEM_IN_OFFSET ( 4 )

#define RUNNER_CNTXT_MAIN_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_CNTXT_MAIN_1_MEM_ADDRESS	( RUNNER_CNTXT_MAIN_1_OFFSET + RUNNER_CNTXT_MAIN_1_MEM_OFFSET )

#define RUNNER_PRED_MAIN_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRED_MAIN_0_MEM_ADDRESS	( RUNNER_PRED_MAIN_0_OFFSET + RUNNER_PRED_MAIN_0_MEM_OFFSET )

#define RUNNER_PRED_MAIN_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRED_MAIN_1_MEM_ADDRESS	( RUNNER_PRED_MAIN_1_OFFSET + RUNNER_PRED_MAIN_1_MEM_OFFSET )

#define RUNNER_INST_PICO_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_INST_PICO_0_MEM_ADDRESS	( RUNNER_INST_PICO_0_OFFSET + RUNNER_INST_PICO_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_INST_PICO_MEM_COUNTER ( 4096 )

/** Number of registers per entry **/
#define RUNNER_INST_PICO_MEM_IN_OFFSET ( 4 )

#define RUNNER_INST_PICO_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_INST_PICO_1_MEM_ADDRESS	( RUNNER_INST_PICO_1_OFFSET + RUNNER_INST_PICO_1_MEM_OFFSET )

#define RUNNER_CNTXT_PICO_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_CNTXT_PICO_0_MEM_ADDRESS	( RUNNER_CNTXT_PICO_0_OFFSET + RUNNER_CNTXT_PICO_0_MEM_OFFSET )

/** Number of entries of the function into block **/
#define RUNNER_CNTXT_PICO_MEM_COUNTER ( 512 )
/** Number of registers per entry **/
#define RUNNER_CNTXT_PICO_MEM_IN_OFFSET ( 4 )

#define RUNNER_CNTXT_PICO_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_CNTXT_PICO_1_MEM_ADDRESS	( RUNNER_CNTXT_PICO_1_OFFSET + RUNNER_CNTXT_PICO_1_MEM_OFFSET )

#define RUNNER_PRED_PICO_0_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRED_PICO_0_MEM_ADDRESS	( RUNNER_PRED_PICO_0_OFFSET + RUNNER_PRED_PICO_0_MEM_OFFSET )

#define RUNNER_PRED_PICO_1_MEM_OFFSET 	( 0x00000000 )
#define RUNNER_PRED_PICO_1_MEM_ADDRESS	( RUNNER_PRED_PICO_1_OFFSET + RUNNER_PRED_PICO_1_MEM_OFFSET )

#define RUNNER_REGS_0_CFG_OFFSET 	( 0x00000000 )
#define RUNNER_REGS_0_CFG_ADDRESS	( RUNNER_REGS_0_OFFSET + RUNNER_REGS_0_CFG_OFFSET )

#define RUNNER_REGS_1_CFG_OFFSET 	( 0x00000000 )
#define RUNNER_REGS_1_CFG_ADDRESS	( RUNNER_REGS_1_OFFSET + RUNNER_REGS_1_CFG_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* Data_memory_entry                                                                     */
/* Data memory entry                                                                     */
/*****************************************************************************************/

#define RUNNER_COMMON_MEM_HIGH_DATA_MEM_DATA_VALUE             ( 0x0 )
#define RUNNER_COMMON_MEM_HIGH_DATA_MEM_DATA_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_COMMON_MEM_HIGH_OFFSET ( 0x00000000 )

#define RUNNER_COMMON_0_MEM_HIGH_ADDRESS      	( RUNNER_COMMON_0_MEM_ADDRESS + RUNNER_COMMON_MEM_HIGH_OFFSET )
#define RUNNER_COMMON_0_MEM_HIGH_READ( e, r ) 	READ_32( ( RUNNER_COMMON_0_MEM_HIGH_ADDRESS  + e * 8 ), (r) )
#define RUNNER_COMMON_0_MEM_HIGH_WRITE( e, v )	WRITE_32( ( RUNNER_COMMON_0_MEM_HIGH_ADDRESS + e * 8 ), (v) )

#define RUNNER_COMMON_1_MEM_HIGH_ADDRESS      	( RUNNER_COMMON_1_MEM_ADDRESS + RUNNER_COMMON_MEM_HIGH_OFFSET )
#define RUNNER_COMMON_1_MEM_HIGH_READ( e, r ) 	READ_32( ( RUNNER_COMMON_1_MEM_HIGH_ADDRESS  + e * 8 ), (r) )
#define RUNNER_COMMON_1_MEM_HIGH_WRITE( e, v )	WRITE_32( ( RUNNER_COMMON_1_MEM_HIGH_ADDRESS + e * 8 ), (v) )


extern uint32_t RUNNER_COMMON_MEM_HIGH_ARRAY [ ] ;

#define RUNNER_COMMON_MEM_HIGH_WRITE( i, e, v )	WRITE_32( RUNNER_COMMON_MEM_HIGH_ARRAY [ i ] + e * 8, (v) )
#define RUNNER_COMMON_MEM_HIGH_READ( i, e, r ) 	READ_32( RUNNER_COMMON_MEM_HIGH_ARRAY [ i ] + e * 8, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_memory */
	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON_MEM_HIGH ;
#else
typedef struct
{	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON_MEM_HIGH ;
#endif

/*****************************************************************************************/
/* Data_memory_entry                                                                     */
/* Data memory entry                                                                     */
/*****************************************************************************************/

#define RUNNER_COMMON_MEM_LOW_DATA_MEM_DATA_VALUE             ( 0x0 )
#define RUNNER_COMMON_MEM_LOW_DATA_MEM_DATA_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_COMMON_MEM_LOW_OFFSET ( 0x00000004 )

#define RUNNER_COMMON_0_MEM_LOW_ADDRESS      	( RUNNER_COMMON_0_MEM_ADDRESS + RUNNER_COMMON_MEM_LOW_OFFSET )
#define RUNNER_COMMON_0_MEM_LOW_READ( e, r ) 	READ_32( ( RUNNER_COMMON_0_MEM_LOW_ADDRESS  + e * 8 ), (r) )
#define RUNNER_COMMON_0_MEM_LOW_WRITE( e, v )	WRITE_32( ( RUNNER_COMMON_0_MEM_LOW_ADDRESS + e * 8 ), (v) )

#define RUNNER_COMMON_1_MEM_LOW_ADDRESS      	( RUNNER_COMMON_1_MEM_ADDRESS + RUNNER_COMMON_MEM_LOW_OFFSET )
#define RUNNER_COMMON_1_MEM_LOW_READ( e, r ) 	READ_32( ( RUNNER_COMMON_1_MEM_LOW_ADDRESS  + e * 8 ), (r) )
#define RUNNER_COMMON_1_MEM_LOW_WRITE( e, v )	WRITE_32( ( RUNNER_COMMON_1_MEM_LOW_ADDRESS + e * 8 ), (v) )


extern uint32_t RUNNER_COMMON_MEM_LOW_ARRAY [ ] ;

#define RUNNER_COMMON_MEM_LOW_WRITE( i, e, v )	WRITE_32( RUNNER_COMMON_MEM_LOW_ARRAY [ i ] + e * 8, (v) )
#define RUNNER_COMMON_MEM_LOW_READ( i, e, r ) 	READ_32( RUNNER_COMMON_MEM_LOW_ARRAY [ i ] + e * 8, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_memory */
	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON_MEM_LOW ;
#else
typedef struct
{	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON_MEM_LOW ;
#endif

/*****************************************************************************************/
/* Data_memory_entry                                                                     */
/* Data memory entry                                                                     */
/*****************************************************************************************/

#define RUNNER_PRIVATE_MEM_HIGH_DATA_MEM_DATA_VALUE             ( 0x0 )
#define RUNNER_PRIVATE_MEM_HIGH_DATA_MEM_DATA_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_PRIVATE_MEM_HIGH_OFFSET ( 0x00000000 )

#define RUNNER_PRIVATE_0_MEM_HIGH_ADDRESS      	( RUNNER_PRIVATE_0_MEM_ADDRESS + RUNNER_PRIVATE_MEM_HIGH_OFFSET )
#define RUNNER_PRIVATE_0_MEM_HIGH_READ( e, r ) 	READ_32( ( RUNNER_PRIVATE_0_MEM_HIGH_ADDRESS  + e * 8 ), (r) )
#define RUNNER_PRIVATE_0_MEM_HIGH_WRITE( e, v )	WRITE_32( ( RUNNER_PRIVATE_0_MEM_HIGH_ADDRESS + e * 8 ), (v) )

#define RUNNER_PRIVATE_1_MEM_HIGH_ADDRESS      	( RUNNER_PRIVATE_1_MEM_ADDRESS + RUNNER_PRIVATE_MEM_HIGH_OFFSET )
#define RUNNER_PRIVATE_1_MEM_HIGH_READ( e, r ) 	READ_32( ( RUNNER_PRIVATE_1_MEM_HIGH_ADDRESS  + e * 8 ), (r) )
#define RUNNER_PRIVATE_1_MEM_HIGH_WRITE( e, v )	WRITE_32( ( RUNNER_PRIVATE_1_MEM_HIGH_ADDRESS + e * 8 ), (v) )


extern uint32_t RUNNER_PRIVATE_MEM_HIGH_ARRAY [ ] ;

#define RUNNER_PRIVATE_MEM_HIGH_WRITE( i, e, v )	WRITE_32( RUNNER_PRIVATE_MEM_HIGH_ARRAY [ i ] + e * 8, (v) )
#define RUNNER_PRIVATE_MEM_HIGH_READ( i, e, r ) 	READ_32( RUNNER_PRIVATE_MEM_HIGH_ARRAY [ i ] + e * 8, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_memory */
	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE_MEM_HIGH ;
#else
typedef struct
{	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE_MEM_HIGH ;
#endif

/*****************************************************************************************/
/* Data_memory_entry                                                                     */
/* Data memory entry                                                                     */
/*****************************************************************************************/

#define RUNNER_PRIVATE_MEM_LOW_DATA_MEM_DATA_VALUE             ( 0x0 )
#define RUNNER_PRIVATE_MEM_LOW_DATA_MEM_DATA_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_PRIVATE_MEM_LOW_OFFSET ( 0x00000004 )

#define RUNNER_PRIVATE_0_MEM_LOW_ADDRESS      	( RUNNER_PRIVATE_0_MEM_ADDRESS + RUNNER_PRIVATE_MEM_LOW_OFFSET )
#define RUNNER_PRIVATE_0_MEM_LOW_READ( e, r ) 	READ_32( ( RUNNER_PRIVATE_0_MEM_LOW_ADDRESS  + e * 8 ), (r) )
#define RUNNER_PRIVATE_0_MEM_LOW_WRITE( e, v )	WRITE_32( ( RUNNER_PRIVATE_0_MEM_LOW_ADDRESS + e * 8 ), (v) )

#define RUNNER_PRIVATE_1_MEM_LOW_ADDRESS      	( RUNNER_PRIVATE_1_MEM_ADDRESS + RUNNER_PRIVATE_MEM_LOW_OFFSET )
#define RUNNER_PRIVATE_1_MEM_LOW_READ( e, r ) 	READ_32( ( RUNNER_PRIVATE_1_MEM_LOW_ADDRESS  + e * 8 ), (r) )
#define RUNNER_PRIVATE_1_MEM_LOW_WRITE( e, v )	WRITE_32( ( RUNNER_PRIVATE_1_MEM_LOW_ADDRESS + e * 8 ), (v) )


extern uint32_t RUNNER_PRIVATE_MEM_LOW_ARRAY [ ] ;

#define RUNNER_PRIVATE_MEM_LOW_WRITE( i, e, v )	WRITE_32( RUNNER_PRIVATE_MEM_LOW_ARRAY [ i ] + e * 8, (v) )
#define RUNNER_PRIVATE_MEM_LOW_READ( i, e, r ) 	READ_32( RUNNER_PRIVATE_MEM_LOW_ARRAY [ i ] + e * 8, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* data_memory */
	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE_MEM_LOW ;
#else
typedef struct
{	uint32_t data_mem	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* data_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE_MEM_LOW ;
#endif

/*****************************************************************************************/
/* Instruction_memory_entry                                                              */
/* Instruction memory entry                                                              */
/*****************************************************************************************/

#define RUNNER_INST_MAIN_MEM_ENTRY_INSTRUCTION_INSTRUCTION_VALUE             ( 0x0 )
#define RUNNER_INST_MAIN_MEM_ENTRY_INSTRUCTION_INSTRUCTION_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_INST_MAIN_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_INST_MAIN_0_MEM_ENTRY_ADDRESS      	( RUNNER_INST_MAIN_0_MEM_ADDRESS + RUNNER_INST_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_INST_MAIN_0_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_INST_MAIN_0_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_INST_MAIN_0_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_INST_MAIN_0_MEM_ENTRY_ADDRESS + e * 4 ), (v) )

#define RUNNER_INST_MAIN_1_MEM_ENTRY_ADDRESS      	( RUNNER_INST_MAIN_1_MEM_ADDRESS + RUNNER_INST_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_INST_MAIN_1_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_INST_MAIN_1_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_INST_MAIN_1_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_INST_MAIN_1_MEM_ENTRY_ADDRESS + e * 4 ), (v) )


extern uint32_t RUNNER_INST_MAIN_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_INST_MAIN_MEM_ENTRY_WRITE( i, e, v )	WRITE_32( RUNNER_INST_MAIN_MEM_ENTRY_ARRAY [ i ] + e * 4, (v) )
#define RUNNER_INST_MAIN_MEM_ENTRY_READ( i, e, r ) 	READ_32( RUNNER_INST_MAIN_MEM_ENTRY_ARRAY [ i ] + e * 4, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Instructions_memory */
	uint32_t instruction	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_MAIN_MEM_ENTRY ;
#else
typedef struct
{	uint32_t instruction	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Instructions_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_MAIN_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* Context_mem_entry                                                                     */
/* Context mem entry                                                                     */
/*****************************************************************************************/

#define RUNNER_CNTXT_MAIN_MEM_ENTRY_CONTEXT_ENTRY_CONTEXT_MEM_ENTRY_VALUE             ( 0x0 )
#define RUNNER_CNTXT_MAIN_MEM_ENTRY_CONTEXT_ENTRY_CONTEXT_MEM_ENTRY_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_CNTXT_MAIN_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_CNTXT_MAIN_0_MEM_ENTRY_ADDRESS      	( RUNNER_CNTXT_MAIN_0_MEM_ADDRESS + RUNNER_CNTXT_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_CNTXT_MAIN_0_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_CNTXT_MAIN_0_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_CNTXT_MAIN_0_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_CNTXT_MAIN_0_MEM_ENTRY_ADDRESS + e * 4 ), (v) )

#define RUNNER_CNTXT_MAIN_1_MEM_ENTRY_ADDRESS      	( RUNNER_CNTXT_MAIN_1_MEM_ADDRESS + RUNNER_CNTXT_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_CNTXT_MAIN_1_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_CNTXT_MAIN_1_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_CNTXT_MAIN_1_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_CNTXT_MAIN_1_MEM_ENTRY_ADDRESS + e * 4 ), (v) )


extern uint32_t RUNNER_CNTXT_MAIN_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_CNTXT_MAIN_MEM_ENTRY_WRITE( i, e, v )	WRITE_32( RUNNER_CNTXT_MAIN_MEM_ENTRY_ARRAY [ i ] + e * 4, (v) )
#define RUNNER_CNTXT_MAIN_MEM_ENTRY_READ( i, e, r ) 	READ_32( RUNNER_CNTXT_MAIN_MEM_ENTRY_ARRAY [ i ] + e * 4, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Context_mem_entry */
	uint32_t context_entry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_MAIN_MEM_ENTRY ;
#else
typedef struct
{	uint32_t context_entry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_mem_entry */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_MAIN_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* prediction_memory_core                                                                */
/* Prediction memory MAIN core                                                           */
/*****************************************************************************************/



#define RUNNER_PRED_MAIN_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_PRED_MAIN_0_MEM_ENTRY_ADDRESS        	( RUNNER_PRED_MAIN_0_MEM_ADDRESS + RUNNER_PRED_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_PRED_MAIN_0_MEM_ENTRY_READ_I( r, i ) 	READ_I_16( ( RUNNER_PRED_MAIN_0_MEM_ENTRY_ADDRESS ), (i), (r) )
#define RUNNER_PRED_MAIN_0_MEM_ENTRY_WRITE_I( v, i )	WRITE_I_16( ( RUNNER_PRED_MAIN_0_MEM_ENTRY_ADDRESS ), (i), (v) )

#define RUNNER_PRED_MAIN_1_MEM_ENTRY_ADDRESS        	( RUNNER_PRED_MAIN_1_MEM_ADDRESS + RUNNER_PRED_MAIN_MEM_ENTRY_OFFSET )
#define RUNNER_PRED_MAIN_1_MEM_ENTRY_READ_I( r, i ) 	READ_I_16( ( RUNNER_PRED_MAIN_1_MEM_ENTRY_ADDRESS ), (i), (r) )
#define RUNNER_PRED_MAIN_1_MEM_ENTRY_WRITE_I( v, i )	WRITE_I_16( ( RUNNER_PRED_MAIN_1_MEM_ENTRY_ADDRESS ), (i), (v) )


extern uint32_t RUNNER_PRED_MAIN_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_PRED_MAIN_MEM_ENTRY_WRITE( i, k, v )	WRITE_I_16( RUNNER_PRED_MAIN_MEM_ENTRY_ARRAY [ i ], (k), (v) )
#define RUNNER_PRED_MAIN_MEM_ENTRY_READ( i, k, r ) 	READ_I_16( RUNNER_PRED_MAIN_MEM_ENTRY_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MEM_PRED_MAIN */
	uint16_t pred_mem	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_MAIN_MEM_ENTRY ;
#else
typedef struct
{	uint16_t pred_mem	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MEM_PRED_MAIN */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_MAIN_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* Instruction_memory_entry                                                              */
/* Instruction memory entry                                                              */
/*****************************************************************************************/

#define RUNNER_INST_PICO_MEM_ENTRY_INSTRUCTION_INSTRUCTION_VALUE             ( 0x0 )
#define RUNNER_INST_PICO_MEM_ENTRY_INSTRUCTION_INSTRUCTION_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_INST_PICO_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_INST_PICO_0_MEM_ENTRY_ADDRESS      	( RUNNER_INST_PICO_0_MEM_ADDRESS + RUNNER_INST_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_INST_PICO_0_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_INST_PICO_0_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_INST_PICO_0_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_INST_PICO_0_MEM_ENTRY_ADDRESS + e * 4 ), (v) )

#define RUNNER_INST_PICO_1_MEM_ENTRY_ADDRESS      	( RUNNER_INST_PICO_1_MEM_ADDRESS + RUNNER_INST_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_INST_PICO_1_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_INST_PICO_1_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_INST_PICO_1_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_INST_PICO_1_MEM_ENTRY_ADDRESS + e * 4 ), (v) )


extern uint32_t RUNNER_INST_PICO_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_INST_PICO_MEM_ENTRY_WRITE( i, e, v )	WRITE_32( RUNNER_INST_PICO_MEM_ENTRY_ARRAY [ i ] + e * 4, (v) )
#define RUNNER_INST_PICO_MEM_ENTRY_READ( i, e, r ) 	READ_32( RUNNER_INST_PICO_MEM_ENTRY_ARRAY [ i ] + e * 4, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Instructions_memory */
	uint32_t instruction	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_PICO_MEM_ENTRY ;
#else
typedef struct
{	uint32_t instruction	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Instructions_memory */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_PICO_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* Context_mem_entry                                                                     */
/* Context mem entry                                                                     */
/*****************************************************************************************/

#define RUNNER_CNTXT_PICO_MEM_ENTRY_CONTEXT_ENTRY_CONTEXT_MEM_ENTRY_VALUE             ( 0x0 )
#define RUNNER_CNTXT_PICO_MEM_ENTRY_CONTEXT_ENTRY_CONTEXT_MEM_ENTRY_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_CNTXT_PICO_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_CNTXT_PICO_0_MEM_ENTRY_ADDRESS      	( RUNNER_CNTXT_PICO_0_MEM_ADDRESS + RUNNER_CNTXT_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_CNTXT_PICO_0_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_CNTXT_PICO_0_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_CNTXT_PICO_0_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_CNTXT_PICO_0_MEM_ENTRY_ADDRESS + e * 4 ), (v) )

#define RUNNER_CNTXT_PICO_1_MEM_ENTRY_ADDRESS      	( RUNNER_CNTXT_PICO_1_MEM_ADDRESS + RUNNER_CNTXT_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_CNTXT_PICO_1_MEM_ENTRY_READ( e, r ) 	READ_32( ( RUNNER_CNTXT_PICO_1_MEM_ENTRY_ADDRESS  + e * 4 ), (r) )
#define RUNNER_CNTXT_PICO_1_MEM_ENTRY_WRITE( e, v )	WRITE_32( ( RUNNER_CNTXT_PICO_1_MEM_ENTRY_ADDRESS + e * 4 ), (v) )


extern uint32_t RUNNER_CNTXT_PICO_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_CNTXT_PICO_MEM_ENTRY_WRITE( i, e, v )	WRITE_32( RUNNER_CNTXT_PICO_MEM_ENTRY_ARRAY [ i ] + e * 4, (v) )
#define RUNNER_CNTXT_PICO_MEM_ENTRY_READ( i, e, r ) 	READ_32( RUNNER_CNTXT_PICO_MEM_ENTRY_ARRAY [ i ] + e * 4, (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Context_mem_entry */
	uint32_t context_entry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_PICO_MEM_ENTRY ;
#else
typedef struct
{	uint32_t context_entry	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Context_mem_entry */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_PICO_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* Prediction_memory_pico                                                                */
/* Prediction memory PICO core                                                           */
/*****************************************************************************************/



#define RUNNER_PRED_PICO_MEM_ENTRY_OFFSET ( 0x00000000 )

#define RUNNER_PRED_PICO_0_MEM_ENTRY_ADDRESS        	( RUNNER_PRED_PICO_0_MEM_ADDRESS + RUNNER_PRED_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_PRED_PICO_0_MEM_ENTRY_READ_I( r, i ) 	READ_I_16( ( RUNNER_PRED_PICO_0_MEM_ENTRY_ADDRESS ), (i), (r) )
#define RUNNER_PRED_PICO_0_MEM_ENTRY_WRITE_I( v, i )	WRITE_I_16( ( RUNNER_PRED_PICO_0_MEM_ENTRY_ADDRESS ), (i), (v) )

#define RUNNER_PRED_PICO_1_MEM_ENTRY_ADDRESS        	( RUNNER_PRED_PICO_1_MEM_ADDRESS + RUNNER_PRED_PICO_MEM_ENTRY_OFFSET )
#define RUNNER_PRED_PICO_1_MEM_ENTRY_READ_I( r, i ) 	READ_I_16( ( RUNNER_PRED_PICO_1_MEM_ENTRY_ADDRESS ), (i), (r) )
#define RUNNER_PRED_PICO_1_MEM_ENTRY_WRITE_I( v, i )	WRITE_I_16( ( RUNNER_PRED_PICO_1_MEM_ENTRY_ADDRESS ), (i), (v) )


extern uint32_t RUNNER_PRED_PICO_MEM_ENTRY_ARRAY [ ] ;

#define RUNNER_PRED_PICO_MEM_ENTRY_WRITE( i, k, v )	WRITE_I_16( RUNNER_PRED_PICO_MEM_ENTRY_ARRAY [ i ], (k), (v) )
#define RUNNER_PRED_PICO_MEM_ENTRY_READ( i, k, r ) 	READ_I_16( RUNNER_PRED_PICO_MEM_ENTRY_ARRAY [ i ], (k), (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MEM_PRED_PICO */
	uint16_t mem_pred_pico	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_PICO_MEM_ENTRY ;
#else
typedef struct
{	uint16_t mem_pred_pico	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MEM_PRED_PICO */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_PICO_MEM_ENTRY ;
#endif

/*****************************************************************************************/
/* Global_control                                                                        */
/* Global control                                                                        */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED2_RESREVED_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED2_RESREVED_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_CNTXT_REB_EN_DISABLE_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_CNTXT_REB_EN_DISABLE_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_CNTXT_REB_EN_ENABLE_VALUE                    ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED1_RESREVED_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED1_RESREVED_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_B_LS_0_REGULER_MODE_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_B_LS_0_LS_VALUE                              ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_B_LS_0_LS_VALUE_RESET_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_A_LS_0_REGULER_MODE_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_A_LS_0_LS_VALUE                              ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRVT_A_LS_0_LS_VALUE_RESET_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CMN_LS_0_REGULER_MODE_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CMN_LS_0_LS_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CMN_LS_0_LS_VALUE_RESET_VALUE                     ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_DMA_LS_0_REGULER_MODE_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_DMA_LS_0_LS_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_DMA_LS_0_LS_VALUE_RESET_VALUE                     ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRED_LS_0_REGULER_MODE_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRED_LS_0_LS_VALUE                                ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PRED_LS_0_LS_VALUE_RESET_VALUE                    ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CNTXT_LS_0_REGULER_MODE_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CNTXT_LS_0_LS_VALUE                               ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_CNTXT_LS_0_LS_VALUE_RESET_VALUE                   ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PGM_LS_0_REGULER_MODE_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PGM_LS_0_LS_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PGM_LS_0_LS_VALUE_RESET_VALUE                     ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_DEFAULT_FREQUENCY_VALUE             ( 0x15E )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MICRO_SEC_VAL_DEFAULT_FREQUENCY_VALUE_RESET_VALUE ( 0x15E )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED0_RESREVED_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_RESERVED0_RESREVED_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PICO_EN_RUNNER_DISABLED_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PICO_EN_RUNNER_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_PICO_EN_RUNNER_ENABLED_VALUE                      ( 0x1 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_EN_RUNNER_DISABLED_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_EN_RUNNER_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_MAIN_EN_RUNNER_ENABLED_VALUE                      ( 0x1 )


#define RUNNER_REGS_CFG_GLOBAL_CTRL_OFFSET ( 0x00000000 )

#define RUNNER_REGS_0_CFG_GLOBAL_CTRL_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_GLOBAL_CTRL_OFFSET )
#define RUNNER_REGS_0_CFG_GLOBAL_CTRL_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_GLOBAL_CTRL_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_GLOBAL_CTRL_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_GLOBAL_CTRL_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_GLOBAL_CTRL_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_GLOBAL_CTRL_OFFSET )
#define RUNNER_REGS_1_CFG_GLOBAL_CTRL_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_GLOBAL_CTRL_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_GLOBAL_CTRL_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_GLOBAL_CTRL_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_GLOBAL_CTRL_ARRAY [ ] ;

#define RUNNER_REGS_CFG_GLOBAL_CTRL_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_GLOBAL_CTRL_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_GLOBAL_CTRL_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_GLOBAL_CTRL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t reserved2        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* main_cntx_reb_en */
	uint32_t main_cntxt_reb_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t reserved1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRVT_B_mem_tie_to_0 */
	uint32_t prvt_b_ls_0      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRVT_A_mem_tie_to_0 */
	uint32_t prvt_a_ls_0      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CMN_mem_tie_to_0 */
	uint32_t cmn_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_mem_tie_to_0 */
	uint32_t dma_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRED_mem_tie_to_0 */
	uint32_t pred_ls_0        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNTXT_mem_tie_to_0 */
	uint32_t cntxt_ls_0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PGM_mem_tie_to_0 */
	uint32_t pgm_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Micro_sec_val */
	uint32_t micro_sec_val    	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t reserved0        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PICO_enable */
	uint32_t pico_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MAIN_enable */
	uint32_t main_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_GLOBAL_CTRL ;
#else
typedef struct
{	uint32_t main_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MAIN_enable */
	uint32_t pico_en          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PICO_enable */
	uint32_t reserved0        	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t micro_sec_val    	: 10 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Micro_sec_val */
	uint32_t pgm_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PGM_mem_tie_to_0 */
	uint32_t cntxt_ls_0       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNTXT_mem_tie_to_0 */
	uint32_t pred_ls_0        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRED_mem_tie_to_0 */
	uint32_t dma_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_mem_tie_to_0 */
	uint32_t cmn_ls_0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CMN_mem_tie_to_0 */
	uint32_t prvt_a_ls_0      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRVT_A_mem_tie_to_0 */
	uint32_t prvt_b_ls_0      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRVT_B_mem_tie_to_0 */
	uint32_t reserved1        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
	uint32_t main_cntxt_reb_en	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* main_cntx_reb_en */
	uint32_t reserved2        	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_GLOBAL_CTRL ;
#endif

/*****************************************************************************************/
/* CPU_Wakeup                                                                            */
/* Writing to this register generates a request towards the runner scheduler.            */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_CPU_WAKEUP_RESERVED0_RESERVED_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_RESERVED0_RESERVED_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_URGENT_REQ_NOT_URGENT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_URGENT_REQ_NOT_URGENT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_URGENT_REQ_URGENT_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_REQ_TRGT_MAIN_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_REQ_TRGT_MAIN_VALUE_RESET_VALUE         ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_REQ_TRGT_PICO_VALUE                     ( 0x1 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_THREAD_NUM_DEFAULT_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_CPU_WAKEUP_THREAD_NUM_DEFAULT_VALUE_RESET_VALUE    ( 0x0 )


#define RUNNER_REGS_CFG_CPU_WAKEUP_OFFSET ( 0x00000004 )

#define RUNNER_REGS_0_CFG_CPU_WAKEUP_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_CPU_WAKEUP_OFFSET )
#define RUNNER_REGS_0_CFG_CPU_WAKEUP_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_CPU_WAKEUP_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_CPU_WAKEUP_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_CPU_WAKEUP_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_CPU_WAKEUP_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_CPU_WAKEUP_OFFSET )
#define RUNNER_REGS_1_CFG_CPU_WAKEUP_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_CPU_WAKEUP_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_CPU_WAKEUP_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_CPU_WAKEUP_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_CPU_WAKEUP_ARRAY [ ] ;

#define RUNNER_REGS_CFG_CPU_WAKEUP_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_CPU_WAKEUP_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_CPU_WAKEUP_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_CPU_WAKEUP_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved0 	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_Request */
	uint32_t urgent_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_target */
	uint32_t req_trgt  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Thread_Number */
	uint32_t thread_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CPU_WAKEUP ;
#else
typedef struct
{	uint32_t thread_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Thread_Number */
	uint32_t req_trgt  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Req_target */
	uint32_t urgent_req	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Urgent_Request */
	uint32_t reserved0 	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CPU_WAKEUP ;
#endif

/*****************************************************************************************/
/* Interrupt_Control                                                                     */
/* Interrupt control                                                                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_INT_CTRL_RESERVED0_RESERVED_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_RESERVED0_RESERVED_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT9_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT9_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT9_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT8_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT8_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT8_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT7_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT7_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT7_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT6_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT6_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT6_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT5_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT5_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT5_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT4_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT4_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT4_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT3_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT3_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT3_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT2_STS_INTERRUPT_IS_NOT_SET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT2_STS_INTERRUPT_IS_NOT_SET_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT2_STS_INTERRUPT_IS_SET_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_INT_CTRL_INT1_STS_INTERRUPT_CLEARED_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT1_STS_INTERRUPT_CLEARED_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT0_STS_INTERRUPT_CLEARED_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_INT_CTRL_INT0_STS_INTERRUPT_CLEARED_VALUE_RESET_VALUE    ( 0x0 )


#define RUNNER_REGS_CFG_INT_CTRL_OFFSET ( 0x00000008 )

#define RUNNER_REGS_0_CFG_INT_CTRL_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_INT_CTRL_OFFSET )
#define RUNNER_REGS_0_CFG_INT_CTRL_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_INT_CTRL_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_INT_CTRL_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_INT_CTRL_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_INT_CTRL_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_INT_CTRL_OFFSET )
#define RUNNER_REGS_1_CFG_INT_CTRL_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_INT_CTRL_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_INT_CTRL_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_INT_CTRL_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_INT_CTRL_ARRAY [ ] ;

#define RUNNER_REGS_CFG_INT_CTRL_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_INT_CTRL_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_INT_CTRL_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_INT_CTRL_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt9_status */
	uint32_t int9_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt8_status */
	uint32_t int8_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt7_status */
	uint32_t int7_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt6_status */
	uint32_t int6_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt5_status */
	uint32_t int5_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt4_status */
	uint32_t int4_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt3_status */
	uint32_t int3_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt2_status */
	uint32_t int2_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_1_status */
	uint32_t int1_sts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_0_status */
	uint32_t int0_sts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_INT_CTRL ;
#else
typedef struct
{	uint32_t int0_sts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_0_status */
	uint32_t int1_sts 	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_1_status */
	uint32_t int2_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt2_status */
	uint32_t int3_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt3_status */
	uint32_t int4_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt4_status */
	uint32_t int5_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt5_status */
	uint32_t int6_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt6_status */
	uint32_t int7_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt7_status */
	uint32_t int8_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt8_status */
	uint32_t int9_sts 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt9_status */
	uint32_t reserved0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_INT_CTRL ;
#endif

/*****************************************************************************************/
/* Interrupt_Mask                                                                        */
/* Interrupt mask                                                                        */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_INT_MASK_RESERVED0_RESERVED_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_RESERVED0_RESERVED_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT9_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT9_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT8_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT8_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT7_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT7_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT6_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT6_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT5_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT5_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT4_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT4_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT3_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT3_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT2_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT2_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT1_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT1_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT0_MASK_INTERRUPT_MASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_INT_MASK_INT0_MASK_INTERRUPT_MASK_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_INT_MASK_OFFSET ( 0x0000000C )

#define RUNNER_REGS_0_CFG_INT_MASK_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_INT_MASK_OFFSET )
#define RUNNER_REGS_0_CFG_INT_MASK_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_INT_MASK_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_INT_MASK_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_INT_MASK_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_INT_MASK_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_INT_MASK_OFFSET )
#define RUNNER_REGS_1_CFG_INT_MASK_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_INT_MASK_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_INT_MASK_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_INT_MASK_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_INT_MASK_ARRAY [ ] ;

#define RUNNER_REGS_CFG_INT_MASK_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_INT_MASK_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_INT_MASK_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_INT_MASK_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_9_mask */
	uint32_t int9_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_8_mask */
	uint32_t int8_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Inerrupt_7_mask */
	uint32_t int7_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_6_mask */
	uint32_t int6_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_5_mask */
	uint32_t int5_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_4_mask */
	uint32_t int4_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_3_mask */
	uint32_t int3_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_2_mask */
	uint32_t int2_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_1_mask */
	uint32_t int1_mask	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_0_mask */
	uint32_t int0_mask	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_INT_MASK ;
#else
typedef struct
{	uint32_t int0_mask	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_0_mask */
	uint32_t int1_mask	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_1_mask */
	uint32_t int2_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_2_mask */
	uint32_t int3_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_3_mask */
	uint32_t int4_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_4_mask */
	uint32_t int5_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_5_mask */
	uint32_t int6_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_6_mask */
	uint32_t int7_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Inerrupt_7_mask */
	uint32_t int8_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_8_mask */
	uint32_t int9_mask	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_9_mask */
	uint32_t reserved0	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_INT_MASK ;
#endif

/*****************************************************************************************/
/* Look-up_table_Configuration                                                           */
/* Look-up table Configuration                                                           */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP0_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEP_1_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEP_1_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_2_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_4_VALUE                                 ( 0x2 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_8_VALUE                                 ( 0x3 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_16_VALUE                                ( 0x4 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_32_VALUE                                ( 0x5 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_64_VALUE                                ( 0x6 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_128_VALUE                               ( 0x7 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_256_VALUE                               ( 0x8 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_512_VALUE                               ( 0x9 )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_STEPS_1K_VALUE                                ( 0xA )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define RUNNER_REGS_CFG_LKUP0_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define RUNNER_REGS_CFG_LKUP0_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_32_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_32_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_64_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_128_VALUE                          ( 0x2 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_256_VALUE                          ( 0x3 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_512_VALUE                          ( 0x4 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_1K_VALUE                           ( 0x5 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_2K_VALUE                           ( 0x6 )
#define RUNNER_REGS_CFG_LKUP0_CFG_TABLE_SIZE_ENTRIES_4K_VALUE                           ( 0x7 )
#define RUNNER_REGS_CFG_LKUP0_CFG_R1_RESERVED_VALUE                                     ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_R1_RESERVED_VALUE_RESET_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define RUNNER_REGS_CFG_LKUP0_CFG_OFFSET ( 0x00000010 )

#define RUNNER_REGS_0_CFG_LKUP0_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP0_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP0_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP0_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP0_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP0_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP0_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP0_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP0_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP0_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP0_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP0_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP0_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP0_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP0_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP0_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP0_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP0_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t r1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP0_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_Configuration                                                           */
/* Look-up table Configuration                                                           */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP1_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEP_1_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEP_1_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_2_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_4_VALUE                                 ( 0x2 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_8_VALUE                                 ( 0x3 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_16_VALUE                                ( 0x4 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_32_VALUE                                ( 0x5 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_64_VALUE                                ( 0x6 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_128_VALUE                               ( 0x7 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_256_VALUE                               ( 0x8 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_512_VALUE                               ( 0x9 )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_STEPS_1K_VALUE                                ( 0xA )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define RUNNER_REGS_CFG_LKUP1_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define RUNNER_REGS_CFG_LKUP1_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_32_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_32_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_64_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_128_VALUE                          ( 0x2 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_256_VALUE                          ( 0x3 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_512_VALUE                          ( 0x4 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_1K_VALUE                           ( 0x5 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_2K_VALUE                           ( 0x6 )
#define RUNNER_REGS_CFG_LKUP1_CFG_TABLE_SIZE_ENTRIES_4K_VALUE                           ( 0x7 )
#define RUNNER_REGS_CFG_LKUP1_CFG_RESERVED0_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define RUNNER_REGS_CFG_LKUP1_CFG_OFFSET ( 0x00000014 )

#define RUNNER_REGS_0_CFG_LKUP1_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP1_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP1_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP1_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP1_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP1_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP1_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP1_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP1_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP1_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP1_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP1_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP1_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP1_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP1_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP1_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP1_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP1_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP1_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_Configuration                                                           */
/* Look-up table Configuration                                                           */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP2_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEP_1_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEP_1_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_2_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_4_VALUE                                 ( 0x2 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_8_VALUE                                 ( 0x3 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_16_VALUE                                ( 0x4 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_32_VALUE                                ( 0x5 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_64_VALUE                                ( 0x6 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_128_VALUE                               ( 0x7 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_256_VALUE                               ( 0x8 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_512_VALUE                               ( 0x9 )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_STEPS_1K_VALUE                                ( 0xA )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define RUNNER_REGS_CFG_LKUP2_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define RUNNER_REGS_CFG_LKUP2_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_32_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_32_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_64_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_128_VALUE                          ( 0x2 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_256_VALUE                          ( 0x3 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_512_VALUE                          ( 0x4 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_1K_VALUE                           ( 0x5 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_2K_VALUE                           ( 0x6 )
#define RUNNER_REGS_CFG_LKUP2_CFG_TABLE_SIZE_ENTRIES_4K_VALUE                           ( 0x7 )
#define RUNNER_REGS_CFG_LKUP2_CFG_RESERVED0_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define RUNNER_REGS_CFG_LKUP2_CFG_OFFSET ( 0x00000018 )

#define RUNNER_REGS_0_CFG_LKUP2_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP2_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP2_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP2_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP2_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP2_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP2_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP2_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP2_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP2_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP2_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP2_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP2_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP2_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP2_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP2_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP2_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP2_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP2_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_Configuration                                                           */
/* Look-up table Configuration                                                           */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP3_CFG_RESERVED1_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_RESERVED1_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEP_1_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEP_1_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_2_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_4_VALUE                                 ( 0x2 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_8_VALUE                                 ( 0x3 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_16_VALUE                                ( 0x4 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_32_VALUE                                ( 0x5 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_64_VALUE                                ( 0x6 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_128_VALUE                               ( 0x7 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_256_VALUE                               ( 0x8 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_512_VALUE                               ( 0x9 )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_STEPS_1K_VALUE                                ( 0xA )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_RESERVED0_VALUE                               ( 0xB )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_RESERVED1_VALUE                               ( 0xC )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_RESERVED2_VALUE                               ( 0xD )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_RESERVED3_VALUE                               ( 0xE )
#define RUNNER_REGS_CFG_LKUP3_CFG_MAX_HOP_RESERVED4_VALUE                               ( 0xF )
#define RUNNER_REGS_CFG_LKUP3_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_HASH_TYPE_HASH_FOR_INCREMENTAL_KEYS_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_HASH_TYPE_CRC16_VALUE                                 ( 0x1 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_32_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_32_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_64_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_128_VALUE                          ( 0x2 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_256_VALUE                          ( 0x3 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_512_VALUE                          ( 0x4 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_1K_VALUE                           ( 0x5 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_2K_VALUE                           ( 0x6 )
#define RUNNER_REGS_CFG_LKUP3_CFG_TABLE_SIZE_ENTRIES_4K_VALUE                           ( 0x7 )
#define RUNNER_REGS_CFG_LKUP3_CFG_RESERVED0_RESERVED_VALUE                              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_BASE_ADDRESS_DEFAULT_VALUE                            ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE                ( 0x0 )


#define RUNNER_REGS_CFG_LKUP3_CFG_OFFSET ( 0x0000001C )

#define RUNNER_REGS_0_CFG_LKUP3_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP3_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP3_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP3_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP3_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP3_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP3_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP3_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP3_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP3_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP3_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP3_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP3_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP3_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP3_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP3_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP3_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP3_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_base_address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t table_size  	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Table_Size */
	uint32_t hash_type   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Hash_Type */
	uint32_t max_hop     	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Max_Hop */
	uint32_t reserved1   	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP3_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_CAM_configuration                                                       */
/* Look-up table CAM configuration                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_RESERVED0_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_OFFSET ( 0x00000020 )

#define RUNNER_REGS_0_CFG_LKUP0_CAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP0_CAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP0_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP0_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP0_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP0_CAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP0_CAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP0_CAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP0_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP0_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP0_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP0_CAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP0_CAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP0_CAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP0_CAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP0_CAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP0_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP0_CAM_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_CAM_configuration                                                       */
/* Look-up table CAM configuration                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_RESERVED0_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_OFFSET ( 0x00000024 )

#define RUNNER_REGS_0_CFG_LKUP1_CAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP1_CAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP1_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP1_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP1_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP1_CAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP1_CAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP1_CAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP1_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP1_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP1_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP1_CAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP1_CAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP1_CAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP1_CAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP1_CAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP1_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP1_CAM_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_CAM_configuration                                                       */
/* Look-up table CAM configuration                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_RESERVED0_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_OFFSET ( 0x00000028 )

#define RUNNER_REGS_0_CFG_LKUP2_CAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP2_CAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP2_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP2_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP2_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP2_CAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP2_CAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP2_CAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP2_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP2_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP2_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP2_CAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP2_CAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP2_CAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP2_CAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP2_CAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP2_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP2_CAM_CFG ;
#endif

/*****************************************************************************************/
/* Look-up_table_CAM_configuration                                                       */
/* Look-up table CAM configuration                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_RESREVED1_RESREVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_RESREVED1_RESREVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_CAM_EN_CAM_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_CAM_EN_CAM_ENABLED_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_RESERVED0_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_OFFSET ( 0x0000002C )

#define RUNNER_REGS_0_CFG_LKUP3_CAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP3_CAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP3_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP3_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP3_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP3_CAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP3_CAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP3_CAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP3_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP3_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP3_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP3_CAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP3_CAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP3_CAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP3_CAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP3_CAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Resreved */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP3_CAM_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t reserved0   	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t cam_en      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_enable */
	uint32_t resreved1   	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Resreved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP3_CAM_CFG ;
#endif

/*****************************************************************************************/
/* PSRAM_config_Register                                                                 */
/* PSRAM config Register. Contains configurations such as buffer size and ddr base addre */
/* ss that are used for PSRAM address calculations (from buffer number) when DMA instruc */
/* tion addr_calc flag is set.                                                           */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PSRAM_CFG_RSERVED2_RSERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_RSERVED2_RSERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_DMA_BASE_DEFAULT_VALUE                       ( 0x30 )
#define RUNNER_REGS_CFG_PSRAM_CFG_DMA_BASE_DEFAULT_VALUE_RESET_VALUE           ( 0x30 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_SIZE_BUFFER_SIZE_2K_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_SIZE_BUFFER_SIZE_2K_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_SIZE_BUFFER_SIZE_4K_VALUE             ( 0x1 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_SIZE_BUFFER_SIZE_16K_VALUE            ( 0x2 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_SIZE_BUFFER_SIZE_128BYTE_VALUE        ( 0x3 )
#define RUNNER_REGS_CFG_PSRAM_CFG_RSERVED1_RSERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_RSERVED1_RSERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_OFFSET_DEFAULT_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_CFG_BUFFER_OFFSET_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )


#define RUNNER_REGS_CFG_PSRAM_CFG_OFFSET ( 0x00000030 )

#define RUNNER_REGS_0_CFG_PSRAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_PSRAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PSRAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PSRAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PSRAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PSRAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_PSRAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PSRAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PSRAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PSRAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PSRAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PSRAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PSRAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PSRAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PSRAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Rserved */
	uint32_t rserved2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_base_address */
	uint32_t dma_base     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_size */
	uint32_t buffer_size  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
	uint32_t rserved1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Offset */
	uint32_t buffer_offset	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_CFG ;
#else
typedef struct
{	uint32_t buffer_offset	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Offset */
	uint32_t rserved1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
	uint32_t buffer_size  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_size */
	uint32_t dma_base     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_base_address */
	uint32_t rserved2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_CFG ;
#endif

/*****************************************************************************************/
/* CAM_configuration                                                                     */
/* CAM configuration                                                                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_CAM_CFG_RESERVED0_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CAM_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_CAM_CFG_STOP_VALUE_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CAM_CFG_STOP_VALUE_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_CAM_CFG_OFFSET ( 0x00000034 )

#define RUNNER_REGS_0_CFG_CAM_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_CAM_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_CAM_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_CAM_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_CAM_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_CAM_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_CAM_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_CAM_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_CAM_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_CAM_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_CAM_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_CAM_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_CAM_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_CAM_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserevd */
	uint32_t reserved0 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Stop_Value */
	uint32_t stop_value	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CAM_CFG ;
#else
typedef struct
{	uint32_t stop_value	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Stop_Value */
	uint32_t reserved0 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserevd */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CAM_CFG ;
#endif

/*****************************************************************************************/
/* Counters_Configuration                                                                */
/* Counters Configuration                                                                */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_CNTR_CFG_RESERVED0_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_CNTR_CFG_RESERVED0_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_CNTR_CFG_BASE_ADDRESS_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CNTR_CFG_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_CNTR_CFG_OFFSET ( 0x00000038 )

#define RUNNER_REGS_0_CFG_CNTR_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_CNTR_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_CNTR_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_CNTR_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_CNTR_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_CNTR_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_CNTR_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_CNTR_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_CNTR_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_CNTR_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_CNTR_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_CNTR_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_CNTR_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_CNTR_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_CNTR_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_CNTR_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_CNTR_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved0   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CNTR_CFG ;
#else
typedef struct
{	uint32_t base_address	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Base_Address */
	uint32_t reserved0   	: 19 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CNTR_CFG ;
#endif

/*****************************************************************************************/
/* DDR_config_Register                                                                   */
/* DDR config Register. Contains configurations such as buffer size and ddr base address */
/*  that are used for DDR address calculations (from buffer number) when DMA instruction */
/*  addr_calc flag is set.                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_DDR_CFG_RSERVED2_RSERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_RSERVED2_RSERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_DMA_BASE_DEFAULT_VALUE                       ( 0x30 )
#define RUNNER_REGS_CFG_DDR_CFG_DMA_BASE_DEFAULT_VALUE_RESET_VALUE           ( 0x30 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_SIZE_BUFFER_SIZE_2K_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_SIZE_BUFFER_SIZE_2K_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_SIZE_BUFFER_SIZE_4K_VALUE             ( 0x1 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_SIZE_BUFFER_SIZE_16K_VALUE            ( 0x2 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_SIZE_RESERVED_VALUE                   ( 0x3 )
#define RUNNER_REGS_CFG_DDR_CFG_RSERVED1_RSERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_RSERVED1_RSERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_OFFSET_DEFAULT_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_DDR_CFG_BUFFER_OFFSET_DEFAULT_VALUE_RESET_VALUE      ( 0x0 )


#define RUNNER_REGS_CFG_DDR_CFG_OFFSET ( 0x0000003C )

#define RUNNER_REGS_0_CFG_DDR_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_DDR_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_DDR_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_DDR_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_DDR_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_DDR_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_DDR_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_DDR_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_DDR_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_DDR_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_DDR_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_DDR_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_DDR_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_DDR_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_DDR_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Rserved */
	uint32_t rserved2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_base_address */
	uint32_t dma_base     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_size */
	uint32_t buffer_size  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
	uint32_t rserved1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Offset */
	uint32_t buffer_offset	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_CFG ;
#else
typedef struct
{	uint32_t buffer_offset	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_Offset */
	uint32_t rserved1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
	uint32_t buffer_size  	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Buffer_size */
	uint32_t dma_base     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DMA_base_address */
	uint32_t rserved2     	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Rserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_CFG ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 0-3                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE3_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE3_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE2_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE2_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE1_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE0_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_RELEASE0_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_OFFSET ( 0x00000040 )

#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Release_Request */
	uint32_t release3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Status */
	uint32_t status3  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Release_Request */
	uint32_t release2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Status */
	uint32_t status2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Release_Request */
	uint32_t release1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Status */
	uint32_t status1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved_for_eco */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Release_Request */
	uint32_t release0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Status */
	uint32_t status0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0 ;
#else
typedef struct
{	uint32_t status0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Status */
	uint32_t release0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved_for_eco */
	uint32_t status1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Status */
	uint32_t release1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Status */
	uint32_t release2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status3  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Status */
	uint32_t release3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 4-7                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE7_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE7_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE6_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE6_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE5_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE5_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE4_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_RELEASE4_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_OFFSET ( 0x00000044 )

#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1 ;
#else
typedef struct
{	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 8-11                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED3_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED3_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE11_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE11_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED2_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED2_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE10_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE10_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED1_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED1_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE9_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE9_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_NOT_TAKEN_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_TAKEN_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED0_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RESERVED0_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE8_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_RELEASE8_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_NOT_TAKEN_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_TAKEN_VALUE                  ( 0x1 )


#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_OFFSET ( 0x00000048 )

#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Release_Request */
	uint32_t release11	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Status */
	uint32_t status11 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Release_Request */
	uint32_t release10	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Status */
	uint32_t status10 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Release_Request */
	uint32_t release9 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Status */
	uint32_t status9  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Release_Request */
	uint32_t release8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Status */
	uint32_t status8  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2 ;
#else
typedef struct
{	uint32_t status8  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Status */
	uint32_t release8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status9  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Status */
	uint32_t release9 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status10 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Status */
	uint32_t release10	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status11 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Status */
	uint32_t release11	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 12-15                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE7_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE7_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE6_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE6_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE5_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE5_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE4_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_RELEASE4_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_OFFSET ( 0x0000004C )

#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSC_SEMAPHOR_STS_3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3 ;
#else
typedef struct
{	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3 ;
#endif

/*****************************************************************************************/
/* DDR_look-up_Global_Mask                                                               */
/* DDR look-up Global Mask                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_OFFSET ( 0x00000050 )

#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK0_OFFSET )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK0_OFFSET )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_DDR_LKUP_MASK0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_DDR_LKUP_MASK0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_DDR_LKUP_MASK0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK0 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK0 ;
#endif

/*****************************************************************************************/
/* DDR_look-up_Global_Mask                                                               */
/* DDR look-up Global Mask                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_OFFSET ( 0x00000054 )

#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK1_OFFSET )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK1_OFFSET )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_DDR_LKUP_MASK1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_DDR_LKUP_MASK1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_DDR_LKUP_MASK1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK1 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK1 ;
#endif

/*****************************************************************************************/
/* DDR_look-up_Global_Mask                                                               */
/* DDR look-up Global Mask                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_OFFSET ( 0x00000058 )

#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK2_OFFSET )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK2_OFFSET )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_DDR_LKUP_MASK2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_DDR_LKUP_MASK2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_DDR_LKUP_MASK2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK2 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK2 ;
#endif

/*****************************************************************************************/
/* DDR_look-up_Global_Mask                                                               */
/* DDR look-up Global Mask                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_OFFSET ( 0x0000005C )

#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK3_OFFSET )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_DDR_LKUP_MASK3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_DDR_LKUP_MASK3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_DDR_LKUP_MASK3_OFFSET )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_DDR_LKUP_MASK3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_DDR_LKUP_MASK3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_DDR_LKUP_MASK3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_DDR_LKUP_MASK3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_DDR_LKUP_MASK3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_DDR_LKUP_MASK3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK3 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_DDR_LKUP_MASK3 ;
#endif

/*****************************************************************************************/
/* PSRAM_look-up_Global_Mask                                                             */
/* PSRAM look-up Global Mask                                                             */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_OFFSET ( 0x00000060 )

#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_OFFSET )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_OFFSET )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK0 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK0 ;
#endif

/*****************************************************************************************/
/* PSRAM_look-up_Global_Mask                                                             */
/* PSRAM look-up Global Mask                                                             */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_OFFSET ( 0x00000064 )

#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_OFFSET )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_OFFSET )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK1 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK1 ;
#endif

/*****************************************************************************************/
/* PSRAM_look-up_Global_Mask                                                             */
/* PSRAM look-up Global Mask                                                             */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_OFFSET ( 0x00000068 )

#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_OFFSET )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_OFFSET )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK2 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK2 ;
#endif

/*****************************************************************************************/
/* PSRAM_look-up_Global_Mask                                                             */
/* PSRAM look-up Global Mask                                                             */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_RESERVED0_RESERVED_VALUE                                    ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_RESERVED0_RESERVED_VALUE_RESET_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_GLOBAL_MASK_KEY_5_TUPLE_KEY_DEFAULT_VALUE_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_OFFSET ( 0x0000006C )

#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_OFFSET )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PSRAM_LKUP_MASK3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_OFFSET )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PSRAM_LKUP_MASK3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PSRAM_LKUP_MASK3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved0 */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK3 ;
#else
typedef struct
{	uint32_t global_mask	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_Mask */
	uint32_t reserved0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved0 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PSRAM_LKUP_MASK3 ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_RESERVED1_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_RESERVED1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_OFFSET ( 0x00000070 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_H_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_H_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_H_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_H_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_H_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_H_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_H_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_H_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H ;
#else
typedef struct
{	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_OFFSET ( 0x00000074 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_L_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_L_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_L_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK0_L_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_L_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_L_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_L_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK0_L_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Global_mask_L */
	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L ;
#else
typedef struct
{	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_RESERVED1_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_RESERVED1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_OFFSET ( 0x00000078 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_H_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_H_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_H_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_H_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_H_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_H_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_H_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_H_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H ;
#else
typedef struct
{	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_OFFSET ( 0x0000007C )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_L_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_L_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_L_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK1_L_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_L_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_L_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_L_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK1_L_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Global_mask_L */
	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L ;
#else
typedef struct
{	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_RESERVED1_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_RESERVED1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_OFFSET ( 0x00000080 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_H_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_H_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_H_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_H_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_H_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_H_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_H_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_H_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H ;
#else
typedef struct
{	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_OFFSET ( 0x00000084 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_L_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_L_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_L_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK2_L_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_L_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_L_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_L_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK2_L_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Global_mask_L */
	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L ;
#else
typedef struct
{	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_RESERVED1_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_RESERVED1_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_OFFSET ( 0x00000088 )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_H_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_H_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_H_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_H_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_H_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_H_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_H_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_H_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_H_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H ;
#else
typedef struct
{	uint32_t base_address	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_H */
	uint32_t reserved1   	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H ;
#endif

/*****************************************************************************************/
/* Look-up_global_mask                                                                   */
/* Look-up global mask                                                                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_BASE_ADDRESS_DEFAULT_VALUE             ( 0xFF )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_BASE_ADDRESS_DEFAULT_VALUE_RESET_VALUE ( 0xFF )


#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_OFFSET ( 0x0000008C )

#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_L_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_L_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_L_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_GLBL_MASK3_L_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_L_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_L_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_L_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_L_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_GLBL_MASK3_L_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Global_mask_L */
	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L ;
#else
typedef struct
{	uint32_t base_address	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Global_mask_L */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L ;
#endif

/*****************************************************************************************/
/* Look_up_configuration                                                                 */
/* Lookup hash configuration.                                                            */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_LKUP_CFG_R1_RESERVED_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_CFG_R1_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_CFG_LKUP_NVAL_CAM_SEARCH_DONT_SEARCH_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_CFG_LKUP_NVAL_CAM_SEARCH_DONT_SEARCH_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_LKUP_CFG_LKUP_NVAL_CAM_SEARCH_SEARCH_VALUE                  ( 0x1 )


#define RUNNER_REGS_CFG_LKUP_CFG_OFFSET ( 0x00000090 )

#define RUNNER_REGS_0_CFG_LKUP_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_LKUP_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_LKUP_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_LKUP_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_LKUP_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_LKUP_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_LKUP_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_LKUP_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_LKUP_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_LKUP_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_LKUP_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_LKUP_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_LKUP_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_LKUP_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_LKUP_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_LKUP_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t r1                  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Lkup_nval_cam_search */
	uint32_t lkup_nval_cam_search	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_CFG ;
#else
typedef struct
{	uint32_t lkup_nval_cam_search	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Lkup_nval_cam_search */
	uint32_t r1                  	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_LKUP_CFG ;
#endif

/*****************************************************************************************/
/* Main_profiling_sts                                                                    */
/* main profiling status                                                                 */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_TRACE_WRITE_PNT_TRACE_WRITE_POINTER_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_TRACE_WRITE_PNT_TRACE_WRITE_POINTER_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_RESERVED2_RESERVED2_VALUE                                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_RESERVED2_RESERVED2_VALUE_RESET_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_PROFILING_ACTIVE_PROFILING_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_PROFILING_ACTIVE_PROFILING_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_IDLE_NO_ACTIVE_TASK_IDLE_NO_ACTIVE_TASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_IDLE_NO_ACTIVE_TASK_IDLE_NO_ACTIVE_TASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_CURR_THREAD_NUM_CURR_THREAD_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_CURR_THREAD_NUM_CURR_THREAD_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_RESERVED1_RESERVED_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_RESERVED1_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_AGU_NEXT_PC_DEFAULT_VALUE                                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_AGU_NEXT_PC_DEFAULT_VALUE_RESET_VALUE                     ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_OFFSET ( 0x000000B0 )

#define RUNNER_REGS_0_CFG_MAIN_PROFILING_STS_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_PROFILING_STS_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_PROFILING_STS_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_PROFILING_STS_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_PROFILING_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_PROFILING_STS_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_PROFILING_STS_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_PROFILING_STS_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_PROFILING_STS_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_PROFILING_STS_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_PROFILING_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_PROFILING_STS_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_PROFILING_STS_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_PROFILING_STS_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_PROFILING_STS_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_PROFILING_STS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Trace_write_pointer */
	uint32_t trace_write_pnt    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t reserved2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Profiling_active */
	uint32_t profiling_active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE_no_active_task */
	uint32_t idle_no_active_task	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CURR_thread_num */
	uint32_t curr_thread_num    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved1 */
	uint32_t reserved1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AGU_next_pc */
	uint32_t agu_next_pc        	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_PROFILING_STS ;
#else
typedef struct
{	uint32_t agu_next_pc        	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AGU_next_pc */
	uint32_t reserved1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved1 */
	uint32_t curr_thread_num    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CURR_thread_num */
	uint32_t idle_no_active_task	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE_no_active_task */
	uint32_t profiling_active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Profiling_active */
	uint32_t reserved2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t trace_write_pnt    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Trace_write_pointer */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_PROFILING_STS ;
#endif

/*****************************************************************************************/
/* Main_profiling_cfg                                                                    */
/* main profiling confuguration                                                          */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_RSV2_RSV_VALUE                             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_RSV2_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_TRACE_BASE_ADDR_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_TRACE_BASE_ADDR_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_STOP_RESERVED_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_STOP_RESERVED_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_START_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_START_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_RSV1_RSV_VALUE                             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_RSV1_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_TRACE_PC_EN_RESERVED_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_TRACE_PC_EN_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_TASK2_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_TASK2_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_TASK1_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_PROF_TASK1_RESERVED_VALUE_RESET_VALUE      ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_OFFSET ( 0x000000B4 )

#define RUNNER_REGS_0_CFG_MAIN_PROFILING_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_PROFILING_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_PROFILING_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_PROFILING_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_PROFILING_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_PROFILING_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_PROFILING_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_PROFILING_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_PROFILING_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_PROFILING_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_PROFILING_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_PROFILING_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_PROFILING_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_PROFILING_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_PROFILING_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_PROFILING_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_BASE_ADDR */
	uint32_t trace_base_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_STOP */
	uint32_t prof_stop      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_START */
	uint32_t prof_start     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_PC_EN */
	uint32_t trace_pc_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK2 */
	uint32_t prof_task2     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK1 */
	uint32_t prof_task1     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_PROFILING_CFG ;
#else
typedef struct
{	uint32_t prof_task1     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK1 */
	uint32_t prof_task2     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK2 */
	uint32_t trace_pc_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_PC_EN */
	uint32_t rsv1           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t prof_start     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_START */
	uint32_t prof_stop      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_STOP */
	uint32_t trace_base_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_BASE_ADDR */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_PROFILING_CFG ;
#endif

/*****************************************************************************************/
/* Main_stall_cnt1                                                                       */
/* main stall count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_ACC_STALL_CNT_RESERVED1_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_ACC_STALL_CNT_RESERVED1_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_LD_STALL_CNT_RESERVED1_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_LD_STALL_CNT_RESERVED1_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_OFFSET ( 0x000000B8 )

#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_STALL_CNT1_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_STALL_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_STALL_CNT1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_STALL_CNT1_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_STALL_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_STALL_CNT1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_STALL_CNT1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_STALL_CNT1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_STALL_CNT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ACC_STALL_CNT */
	uint32_t acc_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LD_STALL_CNT */
	uint32_t ld_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_STALL_CNT1 ;
#else
typedef struct
{	uint32_t ld_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LD_STALL_CNT */
	uint32_t acc_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACC_STALL_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_STALL_CNT1 ;
#endif

/*****************************************************************************************/
/* Main_stall_cnt2                                                                       */
/* main stall count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_STORE_STALL_CNT_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_STORE_STALL_CNT_RESERVED0_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_LDIO_STALL_CNT_RESERVED0_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_LDIO_STALL_CNT_RESERVED0_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_OFFSET ( 0x000000BC )

#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_STALL_CNT2_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_STALL_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_STALL_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_STALL_CNT2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_STALL_CNT2_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_STALL_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_STALL_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_STALL_CNT2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_STALL_CNT2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_STALL_CNT2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_STALL_CNT2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_STALL_CNT2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* STORE_STALL_CNT */
	uint32_t store_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LDIO_STALL_CNT */
	uint32_t ldio_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_STALL_CNT2 ;
#else
typedef struct
{	uint32_t ldio_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LDIO_STALL_CNT */
	uint32_t store_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STORE_STALL_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_STALL_CNT2 ;
#endif

/*****************************************************************************************/
/* Main_task_cnt1                                                                        */
/* main task1 count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_TASK1_CNT_TASK1_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_TASK1_CNT_TASK1_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_TASK1_CNT_OFFSET ( 0x000000C0 )

#define RUNNER_REGS_0_CFG_MAIN_TASK1_CNT_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_TASK1_CNT_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_TASK1_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_TASK1_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_TASK1_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_TASK1_CNT_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_TASK1_CNT_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_TASK1_CNT_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_TASK1_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_TASK1_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_TASK1_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_TASK1_CNT_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_TASK1_CNT_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_TASK1_CNT_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_TASK1_CNT_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_TASK1_CNT_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_TASK1_CNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TASK1_CNT */
	uint32_t task1_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_TASK1_CNT ;
#else
typedef struct
{	uint32_t task1_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TASK1_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_TASK1_CNT ;
#endif

/*****************************************************************************************/
/* Main_task_cnt2                                                                        */
/* main task2 count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_TASK2_CNT_TASK2_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_TASK2_CNT_TASK2_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_TASK2_CNT_OFFSET ( 0x000000C4 )

#define RUNNER_REGS_0_CFG_MAIN_TASK2_CNT_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_TASK2_CNT_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_TASK2_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_TASK2_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_TASK2_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_TASK2_CNT_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_TASK2_CNT_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_TASK2_CNT_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_TASK2_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_TASK2_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_TASK2_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_TASK2_CNT_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_TASK2_CNT_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_TASK2_CNT_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_TASK2_CNT_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_TASK2_CNT_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_TASK2_CNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TASK2_CNT */
	uint32_t task2_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_TASK2_CNT ;
#else
typedef struct
{	uint32_t task2_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TASK2_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_TASK2_CNT ;
#endif

/*****************************************************************************************/
/* Main_idle_cnt1                                                                        */
/* main idle count                                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_IDLE_CNT1_IDLE_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_IDLE_CNT1_IDLE_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_IDLE_CNT1_OFFSET ( 0x000000C8 )

#define RUNNER_REGS_0_CFG_MAIN_IDLE_CNT1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_IDLE_CNT1_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_IDLE_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_IDLE_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_IDLE_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_IDLE_CNT1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_IDLE_CNT1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_IDLE_CNT1_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_IDLE_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_IDLE_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_IDLE_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_IDLE_CNT1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_IDLE_CNT1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_IDLE_CNT1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_IDLE_CNT1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_IDLE_CNT1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_IDLE_CNT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IDLE */
	uint32_t idle_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_IDLE_CNT1 ;
#else
typedef struct
{	uint32_t idle_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_IDLE_CNT1 ;
#endif

/*****************************************************************************************/
/* Version                                                                               */
/* Version register                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_VERSION_ADDR_VERSION_VERSION_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_VERSION_ADDR_VERSION_VERSION_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_VERSION_ADDR_OFFSET ( 0x000000E0 )

#define RUNNER_REGS_0_CFG_VERSION_ADDR_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_VERSION_ADDR_OFFSET )
#define RUNNER_REGS_0_CFG_VERSION_ADDR_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_VERSION_ADDR_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_VERSION_ADDR_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_VERSION_ADDR_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_VERSION_ADDR_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_VERSION_ADDR_OFFSET )
#define RUNNER_REGS_1_CFG_VERSION_ADDR_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_VERSION_ADDR_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_VERSION_ADDR_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_VERSION_ADDR_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_VERSION_ADDR_ARRAY [ ] ;

#define RUNNER_REGS_CFG_VERSION_ADDR_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_VERSION_ADDR_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_VERSION_ADDR_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_VERSION_ADDR_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Version */
	uint32_t version	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_VERSION_ADDR ;
#else
typedef struct
{	uint32_t version	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Version */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_VERSION_ADDR ;
#endif

/*****************************************************************************************/
/* Ramrd_mask_config                                                                     */
/* Ramrd mask for range search. The register holds 2 mask that can be chosen by runner c */
/* ore for range seraches.                                                               */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_MASK_VALUE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK1_MASK_VALUE_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_MASK_VALUE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_MASK0_MASK_VALUE_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_OFFSET ( 0x000000EC )

#define RUNNER_REGS_0_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_RAMRD_RANGE_MASK_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_RAMRD_RANGE_MASK_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_RAMRD_RANGE_MASK_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_RAMRD_RANGE_MASK_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_RAMRD_RANGE_MASK_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* MASK1 */
	uint32_t mask1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK0 */
	uint32_t mask0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG ;
#else
typedef struct
{	uint32_t mask0	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK0 */
	uint32_t mask1	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MASK1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG ;
#endif

/*****************************************************************************************/
/* Metal_fix                                                                             */
/* 32 bit register for metal fixes.                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_METAL_FIX_REG_METAL_FIX_METAL_FIX_REG_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_METAL_FIX_REG_METAL_FIX_METAL_FIX_REG_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_METAL_FIX_REG_OFFSET ( 0x000000F0 )

#define RUNNER_REGS_0_CFG_METAL_FIX_REG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_METAL_FIX_REG_OFFSET )
#define RUNNER_REGS_0_CFG_METAL_FIX_REG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_METAL_FIX_REG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_METAL_FIX_REG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_METAL_FIX_REG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_METAL_FIX_REG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_METAL_FIX_REG_OFFSET )
#define RUNNER_REGS_1_CFG_METAL_FIX_REG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_METAL_FIX_REG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_METAL_FIX_REG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_METAL_FIX_REG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_METAL_FIX_REG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_METAL_FIX_REG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_METAL_FIX_REG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_METAL_FIX_REG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_METAL_FIX_REG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Metal_fix */
	uint32_t metal_fix	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_METAL_FIX_REG ;
#else
typedef struct
{	uint32_t metal_fix	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Metal_fix */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_METAL_FIX_REG ;
#endif

/*****************************************************************************************/
/* Timer_target                                                                          */
/* Controls which timer is associated with which core                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_TIMER_TARGET_RESERVED_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_RESERVED_RESERVED_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_0_2_MAIN_CORE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_0_2_MAIN_CORE_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_0_2_PICO_CORE_VALUE             ( 0x1 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_1_3_MAIN_CORE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_1_3_MAIN_CORE_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_1_3_PICO_CORE_VALUE             ( 0x1 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_4_6_MAIN_CORE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_4_6_MAIN_CORE_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_4_6_PICO_CORE_VALUE             ( 0x1 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_5_7_MAIN_CORE_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_5_7_MAIN_CORE_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_TIMER_TARGET_TIMER_5_7_PICO_CORE_VALUE             ( 0x1 )


#define RUNNER_REGS_CFG_TIMER_TARGET_OFFSET ( 0x000000F4 )

#define RUNNER_REGS_0_CFG_TIMER_TARGET_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_TIMER_TARGET_OFFSET )
#define RUNNER_REGS_0_CFG_TIMER_TARGET_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_TIMER_TARGET_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_TIMER_TARGET_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_TIMER_TARGET_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_TIMER_TARGET_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_TIMER_TARGET_OFFSET )
#define RUNNER_REGS_1_CFG_TIMER_TARGET_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_TIMER_TARGET_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_TIMER_TARGET_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_TIMER_TARGET_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_TIMER_TARGET_ARRAY [ ] ;

#define RUNNER_REGS_CFG_TIMER_TARGET_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_TIMER_TARGET_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_TIMER_TARGET_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_TIMER_TARGET_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved 	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_0_2 */
	uint32_t timer_0_2	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_1_3 */
	uint32_t timer_1_3	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_4_6 */
	uint32_t timer_4_6	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_5_7 */
	uint32_t timer_5_7	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_TIMER_TARGET ;
#else
typedef struct
{	uint32_t timer_5_7	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_5_7 */
	uint32_t timer_4_6	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_4_6 */
	uint32_t timer_1_3	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_1_3 */
	uint32_t timer_0_2	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_0_2 */
	uint32_t reserved 	: 28 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_TIMER_TARGET ;
#endif

/*****************************************************************************************/
/* Scheduler_main_config                                                                 */
/* Main scheduler configuration                                                          */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_SCH_CFG_RESERVED_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_RESERVED_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_ARB_CLASS_USE_STRICT_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_ARB_CLASS_USE_STRICT_VALUE_RESET_VALUE         ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_ARB_CLASS_USE_RR_VALUE                         ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_B_DONT_USE_CLASS_B_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_B_DONT_USE_CLASS_B_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_B_USE_CLASS_B_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_A_DONT_USE_CLASS_A_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_A_DONT_USE_CLASS_A_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_USE_CLASS_A_USE_CLASS_A_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_31_24_STRICT_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_31_24_STRICT_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_31_24_RR_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_23_16_STRICT_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_23_16_STRICT_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_23_16_RR_VALUE                           ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_15_8_STIRCT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_15_8_STIRCT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_15_8_RR_VALUE                            ( 0x1 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_7_0_STRICT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_7_0_STRICT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_CLASS_7_0_RR_VALUE                             ( 0x1 )


#define RUNNER_REGS_CFG_MAIN_SCH_CFG_OFFSET ( 0x000000F8 )

#define RUNNER_REGS_0_CFG_MAIN_SCH_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_SCH_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_SCH_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_SCH_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_SCH_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_SCH_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_SCH_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_SCH_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_SCH_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_SCH_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_SCH_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_SCH_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_SCH_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_SCH_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_SCH_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_SCH_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_SCH_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserver */
	uint32_t reserved   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* New_class_arb */
	uint32_t arb_class  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_b */
	uint32_t use_class_b	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_a */
	uint32_t use_class_a	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_31_24 */
	uint32_t class_31_24	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_23_16 */
	uint32_t class_23_16	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_15_8 */
	uint32_t class_15_8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_7_0 */
	uint32_t class_7_0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_SCH_CFG ;
#else
typedef struct
{	uint32_t class_7_0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_7_0 */
	uint32_t class_15_8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_15_8 */
	uint32_t class_23_16	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_23_16 */
	uint32_t class_31_24	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_31_24 */
	uint32_t use_class_a	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_a */
	uint32_t use_class_b	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_b */
	uint32_t arb_class  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* New_class_arb */
	uint32_t reserved   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserver */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_SCH_CFG ;
#endif

/*****************************************************************************************/
/* Scheduler_pico_config                                                                 */
/* Pico scheduler configuration                                                          */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_SCH_CFG_RESERVED_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_RESERVED_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_ARB_CLASS_USE_STRICT_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_ARB_CLASS_USE_STRICT_VALUE_RESET_VALUE         ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_ARB_CLASS_USE_RR_VALUE                         ( 0x1 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_B_DONT_USE_CLASS_B_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_B_DONT_USE_CLASS_B_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_B_USE_CLASS_B_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_A_DONT_USE_CLASS_A_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_A_DONT_USE_CLASS_A_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_USE_CLASS_A_USE_CLASS_A_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_R1_RESERVE_VALUE                               ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_R1_RESERVE_VALUE_RESET_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_R0_RESERVE_VALUE                               ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_R0_RESERVE_VALUE_RESET_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_15_8_STIRCT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_15_8_STIRCT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_15_8_RR_VALUE                            ( 0x1 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_7_0_STRICT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_7_0_STRICT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_CLASS_7_0_RR_VALUE                             ( 0x1 )


#define RUNNER_REGS_CFG_PICO_SCH_CFG_OFFSET ( 0x000000FC )

#define RUNNER_REGS_0_CFG_PICO_SCH_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_SCH_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_SCH_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_SCH_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_SCH_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_SCH_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_SCH_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_SCH_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_SCH_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_SCH_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_SCH_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_SCH_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_SCH_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_SCH_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_SCH_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_SCH_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_SCH_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserver */
	uint32_t reserved   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* New_class_arb */
	uint32_t arb_class  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_b */
	uint32_t use_class_b	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_a */
	uint32_t use_class_a	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R1 */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R0 */
	uint32_t r0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_15_8 */
	uint32_t class_15_8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_7_0 */
	uint32_t class_7_0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_SCH_CFG ;
#else
typedef struct
{	uint32_t class_7_0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_7_0 */
	uint32_t class_15_8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* class_15_8 */
	uint32_t r0         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R0 */
	uint32_t r1         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* R1 */
	uint32_t use_class_a	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_a */
	uint32_t use_class_b	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Use_class_b */
	uint32_t arb_class  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* New_class_arb */
	uint32_t reserved   	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserver */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_SCH_CFG ;
#endif

/*****************************************************************************************/
/* Main_bkpt_0                                                                           */
/* main break point                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_0_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_0_OFFSET ( 0x00000110 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_0_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_0_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_0 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_0 ;
#endif

/*****************************************************************************************/
/* Main_bkpt_1                                                                           */
/* main break point 1                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_1_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_1_OFFSET ( 0x00000114 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_1_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_1_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_1 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_1 ;
#endif

/*****************************************************************************************/
/* Main_bkpt_2                                                                           */
/* main break point 2                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_2_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_2_OFFSET ( 0x00000118 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_2_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_2_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_2 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_2 ;
#endif

/*****************************************************************************************/
/* Main_bkpt_3                                                                           */
/* main break point 3                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_3_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_3_OFFSET ( 0x0000011C )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_3_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_3_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_3 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_3 ;
#endif

/*****************************************************************************************/
/* Main_bkpt_immediate                                                                   */
/* main break point immediate                                                            */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_RESERVED_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_ENABLE_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_ENABLE_RESERVED_VALUE_RESET_VALUE   ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_OFFSET ( 0x00000120 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_IMM_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_IMM_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_IMM_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_IMM_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_IMM_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_IMM_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_IMM_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_IMM_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_IMM_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_IMM_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_IMM_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_IMM_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_IMM_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_IMM_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_IMM_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_IMM_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved2 */
	uint32_t reserved	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE_IMM */
	uint32_t enable  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_IMM ;
#else
typedef struct
{	uint32_t enable  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE_IMM */
	uint32_t reserved	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_IMM ;
#endif

/*****************************************************************************************/
/* Pico_bkpt_0                                                                           */
/* pico break point 0                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_0_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_0_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_0_OFFSET ( 0x00000124 )

#define RUNNER_REGS_0_CFG_PICO_BKPT_0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_0_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_0_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_0 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_0 ;
#endif

/*****************************************************************************************/
/* Pico_bkpt_1                                                                           */
/* pico break point 1                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_1_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_1_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_1_OFFSET ( 0x00000128 )

#define RUNNER_REGS_0_CFG_PICO_BKPT_1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_1_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_1_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_1 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_1 ;
#endif

/*****************************************************************************************/
/* Pico_bkpt_2                                                                           */
/* pico break point 2                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_2_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_2_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_2_OFFSET ( 0x0000012C )

#define RUNNER_REGS_0_CFG_PICO_BKPT_2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_2_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_2_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_2 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_2 ;
#endif

/*****************************************************************************************/
/* Pico_bkpt_3                                                                           */
/* pico break point 3                                                                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_3_RSV_DEFAULT_VALUE                    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_RSV_DEFAULT_VALUE_RESET_VALUE        ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_USE_THREAD_DEFAULT_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_USE_THREAD_DEFAULT_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_ENABLE_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_ENABLE_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_THREAD_DEFAULT_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_THREAD_DEFAULT_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_ADDR_DEFAULT_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_3_ADDR_DEFAULT_VALUE_RESET_VALUE       ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_3_OFFSET ( 0x00000130 )

#define RUNNER_REGS_0_CFG_PICO_BKPT_3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_3_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_3_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_3 ;
#else
typedef struct
{	uint32_t addr      	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ADDR */
	uint32_t thread    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* THREAD */
	uint32_t enable    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE */
	uint32_t use_thread	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* USE_THREAD */
	uint32_t rsv       	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_3 ;
#endif

/*****************************************************************************************/
/* Pico_bkpt_immediate                                                                   */
/* pico break point immediate                                                            */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_IMM_RESERVED_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_IMM_RESERVED_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_IMM_ENABLE_RESERVED_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_IMM_ENABLE_RESERVED_VALUE_RESET_VALUE   ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_IMM_OFFSET ( 0x00000134 )

#define RUNNER_REGS_0_CFG_PICO_BKPT_IMM_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_IMM_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_IMM_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_IMM_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_IMM_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_IMM_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_IMM_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_IMM_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_IMM_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_IMM_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_IMM_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_IMM_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_IMM_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_IMM_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_IMM_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_IMM_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_IMM_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved2 */
	uint32_t reserved	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE_IMM */
	uint32_t enable  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_IMM ;
#else
typedef struct
{	uint32_t enable  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ENABLE_IMM */
	uint32_t reserved	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_IMM ;
#endif

/*****************************************************************************************/
/* cfg_1588                                                                              */
/* 1588 configuration (Master and Slave)                                                 */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_CFG_1588_RSV1_RESERVED0_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_RSV1_RESERVED0_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_WKUP_DIS_ENABLE_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_WKUP_DIS_DISABLE_VALUE                ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_WKUP_DIS_DISABLE_VALUE_RESET_VALUE    ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_CORE_SEL_MAIN_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_CORE_SEL_MAIN_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_CORE_SEL_PICO_VALUE                   ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_THRD_NUM_RESERVED0_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_SLV_1588_THRD_NUM_RESERVED0_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_RSV0_RESERVED0_VALUE                           ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_RSV0_RESERVED0_VALUE_RESET_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_WKUP_DIS_ENABLE_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_WKUP_DIS_DISABLE_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_WKUP_DIS_DISABLE_VALUE_RESET_VALUE   ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_CORE_SEL_MAIN_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_CORE_SEL_MAIN_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_CORE_SEL_PICO_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_THRD_NUM_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CFG_1588_MSTR_1588_THRD_NUM_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_CFG_1588_OFFSET ( 0x00000138 )

#define RUNNER_REGS_0_CFG_CFG_1588_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_CFG_1588_OFFSET )
#define RUNNER_REGS_0_CFG_CFG_1588_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_CFG_1588_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_CFG_1588_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_CFG_1588_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_CFG_1588_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_CFG_1588_OFFSET )
#define RUNNER_REGS_1_CFG_CFG_1588_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_CFG_1588_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_CFG_1588_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_CFG_1588_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_CFG_1588_ARRAY [ ] ;

#define RUNNER_REGS_CFG_CFG_1588_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_CFG_1588_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_CFG_1588_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_CFG_1588_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV1 */
	uint32_t rsv1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_WKUP_DIS */
	uint32_t slv_1588_wkup_dis 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_CORE_SEL */
	uint32_t slv_1588_core_sel 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_THRD_NUM */
	uint32_t slv_1588_thrd_num 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV0 */
	uint32_t rsv0              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_WKUP_DIS */
	uint32_t mstr_1588_wkup_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_CORE_SEL */
	uint32_t mstr_1588_core_sel	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_THRD_NUM */
	uint32_t mstr_1588_thrd_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CFG_1588 ;
#else
typedef struct
{	uint32_t mstr_1588_thrd_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_THRD_NUM */
	uint32_t mstr_1588_core_sel	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_CORE_SEL */
	uint32_t mstr_1588_wkup_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MSTR_1588_WKUP_DIS */
	uint32_t rsv0              	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV0 */
	uint32_t slv_1588_thrd_num 	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_THRD_NUM */
	uint32_t slv_1588_core_sel 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_CORE_SEL */
	uint32_t slv_1588_wkup_dis 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* SLV_1588_WKUP_DIS */
	uint32_t rsv1              	: 17 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CFG_1588 ;
#endif

/*****************************************************************************************/
/* cfg_8k                                                                                */
/* 8K configuration                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_CFG_8K_RSV_RESERVED0_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_RSV_RESERVED0_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_CORE_SEL_MAIN_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_CORE_SEL_MAIN_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_CORE_SEL_PICO_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_WKUP_DIS_ENABLE_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_WKUP_DIS_DISABLE_VALUE               ( 0x1 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_WKUP_DIS_DISABLE_VALUE_RESET_VALUE   ( 0x1 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_THRD_NUM_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_CFG_8K_GPON_8K_THRD_NUM_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_CFG_8K_OFFSET ( 0x0000013C )

#define RUNNER_REGS_0_CFG_CFG_8K_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_CFG_8K_OFFSET )
#define RUNNER_REGS_0_CFG_CFG_8K_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_CFG_8K_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_CFG_8K_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_CFG_8K_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_CFG_8K_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_CFG_8K_OFFSET )
#define RUNNER_REGS_1_CFG_CFG_8K_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_CFG_8K_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_CFG_8K_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_CFG_8K_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_CFG_8K_ARRAY [ ] ;

#define RUNNER_REGS_CFG_CFG_8K_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_CFG_8K_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_CFG_8K_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_CFG_8K_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv             	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_CORE_SEL */
	uint32_t gpon_8k_core_sel	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_WKUP_DIS */
	uint32_t gpon_8k_wkup_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_THRD_NUM */
	uint32_t gpon_8k_thrd_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CFG_8K ;
#else
typedef struct
{	uint32_t gpon_8k_thrd_num	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_THRD_NUM */
	uint32_t gpon_8k_wkup_dis	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_WKUP_DIS */
	uint32_t gpon_8k_core_sel	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* GPON_8K_CORE_SEL */
	uint32_t rsv             	: 25 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_CFG_8K ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 0-3                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE3_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE3_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS3_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE2_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE2_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS2_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE1_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE1_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS1_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE0_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_RELEASE0_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_STATUS0_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_OFFSET ( 0x00000140 )

#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_0_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_0_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_0_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_0_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Release_Request */
	uint32_t release3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Status */
	uint32_t status3  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Release_Request */
	uint32_t release2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Status */
	uint32_t status2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Release_Request */
	uint32_t release1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Status */
	uint32_t status1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Release_Request */
	uint32_t release0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Status */
	uint32_t status0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0 ;
#else
typedef struct
{	uint32_t status0  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Status */
	uint32_t release0 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_0_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status1  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Status */
	uint32_t release1 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_1_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status2  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Status */
	uint32_t release2 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_2_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status3  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Status */
	uint32_t release3 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_3_Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 4-7                     */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE7_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE7_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS7_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE6_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE6_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS6_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE5_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE5_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS5_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE4_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_RELEASE4_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_STATUS4_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_OFFSET ( 0x00000144 )

#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1 ;
#else
typedef struct
{	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 8-11                    */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED3_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED3_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE11_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE11_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS11_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED2_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED2_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE10_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE10_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS10_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED1_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED1_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE9_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE9_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_NOT_TAKEN_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS9_OWNERSHIP_TAKEN_VALUE                  ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED0_RESERVED_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RESERVED0_RESERVED_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE8_DEFAULT_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_RELEASE8_DEFAULT_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_NOT_TAKEN_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE  ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_STATUS8_OWNERSHIP_TAKEN_VALUE                  ( 0x1 )


#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_OFFSET ( 0x00000148 )

#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Release_Request */
	uint32_t release11	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Status */
	uint32_t status11 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Release_Request */
	uint32_t release10	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Status */
	uint32_t status10 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Release_Request */
	uint32_t release9 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Status */
	uint32_t status9  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Release_Request */
	uint32_t release8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Status */
	uint32_t status8  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2 ;
#else
typedef struct
{	uint32_t status8  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Status */
	uint32_t release8 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_8_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status9  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Status */
	uint32_t release9 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_9_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status10 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Status */
	uint32_t release10	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_10_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status11 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Status */
	uint32_t release11	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_11_Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2 ;
#endif

/*****************************************************************************************/
/* Semaphore_Status_and_Control                                                          */
/* This register is used for taking and releasing the Semaphores 12-15                   */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED3_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED3_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE7_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE7_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS7_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED2_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED2_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE6_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE6_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS6_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED1_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED1_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE5_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE5_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS5_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED0_RESERVED_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RESERVED0_RESERVED_VALUE_RESET_VALUE          ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE4_DEFAULT_VALUE                        ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_RELEASE4_DEFAULT_VALUE_RESET_VALUE            ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_NOT_TAKEN_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_STATUS4_OWNERSHIP_TAKEN_VALUE                 ( 0x1 )


#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_OFFSET ( 0x0000014C )

#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_OFFSET )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_3_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_OFFSET )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_3_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_3_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MIPSD_SEMAPHOR_STS_3_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Reserved */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3 ;
#else
typedef struct
{	uint32_t status4  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Status */
	uint32_t release4 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_4_Release_Request */
	uint32_t reserved0	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status5  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Status */
	uint32_t release5 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_5_Release_Request */
	uint32_t reserved1	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status6  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Status */
	uint32_t release6 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_6_Release_Request */
	uint32_t reserved2	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint32_t status7  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7_Status */
	uint32_t release7 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_7Release_Request */
	uint32_t reserved3	: 6 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3 ;
#endif

/*****************************************************************************************/
/* Main_jump_cnt                                                                         */
/* Mispredicted jumps count                                                              */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_JMP_CNT_TAKEN_JMP_CNT_RESERVED0_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_JMP_CNT_TAKEN_JMP_CNT_RESERVED0_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_JMP_CNT_UNTAKEN_JMP_CNT_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_JMP_CNT_UNTAKEN_JMP_CNT_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_JMP_CNT_OFFSET ( 0x00000150 )

#define RUNNER_REGS_0_CFG_MAIN_JMP_CNT_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_JMP_CNT_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_JMP_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_JMP_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_JMP_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_JMP_CNT_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_JMP_CNT_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_JMP_CNT_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_JMP_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_JMP_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_JMP_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_JMP_CNT_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_JMP_CNT_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_JMP_CNT_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_JMP_CNT_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_JMP_CNT_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_JMP_CNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TAKEN_JMP_CNT */
	uint32_t taken_jmp_cnt  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNTAKEN_JMP_CNT */
	uint32_t untaken_jmp_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_JMP_CNT ;
#else
typedef struct
{	uint32_t untaken_jmp_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNTAKEN_JMP_CNT */
	uint32_t taken_jmp_cnt  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TAKEN_JMP_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_JMP_CNT ;
#endif

/*****************************************************************************************/
/* Pico_jump_cnt                                                                         */
/* Mispredicted jumps count                                                              */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_JMP_CNT_TAKEN_JMP_CNT_RESERVED0_VALUE               ( 0x0 )
#define RUNNER_REGS_CFG_PICO_JMP_CNT_TAKEN_JMP_CNT_RESERVED0_VALUE_RESET_VALUE   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_JMP_CNT_UNTAKEN_JMP_CNT_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_JMP_CNT_UNTAKEN_JMP_CNT_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_PICO_JMP_CNT_OFFSET ( 0x00000154 )

#define RUNNER_REGS_0_CFG_PICO_JMP_CNT_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_JMP_CNT_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_JMP_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_JMP_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_JMP_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_JMP_CNT_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_JMP_CNT_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_JMP_CNT_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_JMP_CNT_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_JMP_CNT_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_JMP_CNT_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_JMP_CNT_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_JMP_CNT_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_JMP_CNT_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_JMP_CNT_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_JMP_CNT_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_JMP_CNT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TAKEN_JMP_CNT */
	uint32_t taken_jmp_cnt  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNTAKEN_JMP_CNT */
	uint32_t untaken_jmp_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_JMP_CNT ;
#else
typedef struct
{	uint32_t untaken_jmp_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNTAKEN_JMP_CNT */
	uint32_t taken_jmp_cnt  	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TAKEN_JMP_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_JMP_CNT ;
#endif

/*****************************************************************************************/
/* MAIN_BKPT_CFG                                                                         */
/* Main breakpoint configuration                                                         */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_RSV_RESERVED0_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_RSV_RESERVED0_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_STEP_MODE_RESERVED0_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_STEP_MODE_RESERVED0_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_NEW_FLAGS_VAL_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_NEW_FLAGS_VAL_RESERVED0_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_NEW_PC_VAL_RESERVED0_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_NEW_PC_VAL_RESERVED0_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_HANDLER_ADDR_RESERVED0_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_HANDLER_ADDR_RESERVED0_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_OFFSET ( 0x00000158 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STEP_MODE */
	uint32_t step_mode    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_FLAGS_VAL */
	uint32_t new_flags_val	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_PC_VAL */
	uint32_t new_pc_val   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HANDLER_ADDR */
	uint32_t handler_addr 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_CFG ;
#else
typedef struct
{	uint32_t handler_addr 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HANDLER_ADDR */
	uint32_t new_pc_val   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_PC_VAL */
	uint32_t new_flags_val	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_FLAGS_VAL */
	uint32_t step_mode    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STEP_MODE */
	uint32_t rsv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_CFG ;
#endif

/*****************************************************************************************/
/* PICO_BKPT_CFG                                                                         */
/* Pico breakpoint configuration                                                         */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_CFG_RSV_RESERVED0_VALUE                       ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_RSV_RESERVED0_VALUE_RESET_VALUE           ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_STEP_MODE_RESERVED0_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_STEP_MODE_RESERVED0_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_NEW_FLAGS_VAL_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_NEW_FLAGS_VAL_RESERVED0_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_NEW_PC_VAL_RESERVED0_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_NEW_PC_VAL_RESERVED0_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_HANDLER_ADDR_RESERVED0_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_HANDLER_ADDR_RESERVED0_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_CFG_OFFSET ( 0x0000015C )

#define RUNNER_REGS_0_CFG_PICO_BKPT_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STEP_MODE */
	uint32_t step_mode    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_FLAGS_VAL */
	uint32_t new_flags_val	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_PC_VAL */
	uint32_t new_pc_val   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HANDLER_ADDR */
	uint32_t handler_addr 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_CFG ;
#else
typedef struct
{	uint32_t handler_addr 	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* HANDLER_ADDR */
	uint32_t new_pc_val   	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_PC_VAL */
	uint32_t new_flags_val	: 4 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* NEW_FLAGS_VAL */
	uint32_t step_mode    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STEP_MODE */
	uint32_t rsv          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_CFG ;
#endif

/*****************************************************************************************/
/* MAIN_BKPT_STS                                                                         */
/* Main breakpoint status                                                                */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_MAIN_BKPT_STS_RSV_RESERVED0_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_RSV_RESERVED0_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_ACTIVE_RESERVED0_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_ACTIVE_RESERVED0_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_RSV1_RESERVED0_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_RSV1_RESERVED0_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_BKPT_ADDR_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_BKPT_ADDR_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_MAIN_BKPT_STS_OFFSET ( 0x00000160 )

#define RUNNER_REGS_0_CFG_MAIN_BKPT_STS_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_STS_OFFSET )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_STS_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_STS_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_MAIN_BKPT_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_MAIN_BKPT_STS_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_MAIN_BKPT_STS_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_MAIN_BKPT_STS_OFFSET )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_STS_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_STS_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_MAIN_BKPT_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_MAIN_BKPT_STS_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_MAIN_BKPT_STS_ARRAY [ ] ;

#define RUNNER_REGS_CFG_MAIN_BKPT_STS_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_MAIN_BKPT_STS_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_MAIN_BKPT_STS_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_MAIN_BKPT_STS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACTIVE */
	uint32_t active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BKPT_ADDR */
	uint32_t bkpt_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_STS ;
#else
typedef struct
{	uint32_t bkpt_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BKPT_ADDR */
	uint32_t rsv1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACTIVE */
	uint32_t rsv      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_MAIN_BKPT_STS ;
#endif

/*****************************************************************************************/
/* PICO_BKPT_STS                                                                         */
/* Pico breakpoint status                                                                */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_BKPT_STS_RSV_RESERVED0_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_RSV_RESERVED0_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_ACTIVE_RESERVED0_VALUE                ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_ACTIVE_RESERVED0_VALUE_RESET_VALUE    ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_RSV1_RESERVED0_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_RSV1_RESERVED0_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_BKPT_ADDR_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_BKPT_ADDR_RESERVED0_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_PICO_BKPT_STS_OFFSET ( 0x00000164 )

#define RUNNER_REGS_0_CFG_PICO_BKPT_STS_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_STS_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_BKPT_STS_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_STS_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_BKPT_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_BKPT_STS_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_BKPT_STS_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_BKPT_STS_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_BKPT_STS_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_STS_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_BKPT_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_BKPT_STS_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_BKPT_STS_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_BKPT_STS_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_BKPT_STS_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_BKPT_STS_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_BKPT_STS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV */
	uint32_t rsv      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACTIVE */
	uint32_t active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BKPT_ADDR */
	uint32_t bkpt_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_STS ;
#else
typedef struct
{	uint32_t bkpt_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* BKPT_ADDR */
	uint32_t rsv1     	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACTIVE */
	uint32_t rsv      	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_BKPT_STS ;
#endif

/*****************************************************************************************/
/* Pico_profiling_sts                                                                    */
/* Pico profiling status                                                                 */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_PROFILING_STS_TRACE_WRITE_PNT_TRACE_WRITE_POINTER_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_TRACE_WRITE_PNT_TRACE_WRITE_POINTER_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_RESERVED2_RESERVED2_VALUE                                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_RESERVED2_RESERVED2_VALUE_RESET_VALUE                     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_PROFILING_ACTIVE_PROFILING_VALUE                          ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_PROFILING_ACTIVE_PROFILING_VALUE_RESET_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_IDLE_NO_ACTIVE_TASK_IDLE_NO_ACTIVE_TASK_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_IDLE_NO_ACTIVE_TASK_IDLE_NO_ACTIVE_TASK_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_CURR_THREAD_NUM_CURR_THREAD_VALUE                         ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_CURR_THREAD_NUM_CURR_THREAD_VALUE_RESET_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_RESERVED1_RESERVED_VALUE                                  ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_RESERVED1_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_AGU_NEXT_PC_DEFAULT_VALUE                                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_AGU_NEXT_PC_DEFAULT_VALUE_RESET_VALUE                     ( 0x0 )


#define RUNNER_REGS_CFG_PICO_PROFILING_STS_OFFSET ( 0x000001B0 )

#define RUNNER_REGS_0_CFG_PICO_PROFILING_STS_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_PROFILING_STS_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_PROFILING_STS_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_PROFILING_STS_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_PROFILING_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_PROFILING_STS_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_PROFILING_STS_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_PROFILING_STS_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_PROFILING_STS_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_PROFILING_STS_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_PROFILING_STS_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_PROFILING_STS_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_PROFILING_STS_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_PROFILING_STS_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_PROFILING_STS_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_PROFILING_STS_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_PROFILING_STS_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* Trace_write_pointer */
	uint32_t trace_write_pnt    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t reserved2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Profiling_active */
	uint32_t profiling_active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE_no_active_task */
	uint32_t idle_no_active_task	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CURR_thread_num */
	uint32_t curr_thread_num    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved1 */
	uint32_t reserved1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AGU_next_pc */
	uint32_t agu_next_pc        	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_PROFILING_STS ;
#else
typedef struct
{	uint32_t agu_next_pc        	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* AGU_next_pc */
	uint32_t reserved1          	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved1 */
	uint32_t curr_thread_num    	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CURR_thread_num */
	uint32_t idle_no_active_task	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE_no_active_task */
	uint32_t profiling_active   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Profiling_active */
	uint32_t reserved2          	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved2 */
	uint32_t trace_write_pnt    	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Trace_write_pointer */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_PROFILING_STS ;
#endif

/*****************************************************************************************/
/* Pico_profiling_cfg                                                                    */
/* Pico profiling confuguration                                                          */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_RSV2_RSV_VALUE                             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_RSV2_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_TRACE_BASE_ADDR_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_TRACE_BASE_ADDR_RESERVED_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_STOP_RESERVED_VALUE                   ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_STOP_RESERVED_VALUE_RESET_VALUE       ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_START_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_START_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_RSV1_RSV_VALUE                             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_RSV1_RSV_VALUE_RESET_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_TRACE_PC_EN_RESERVED_VALUE                 ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_TRACE_PC_EN_RESERVED_VALUE_RESET_VALUE     ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_TASK2_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_TASK2_RESERVED_VALUE_RESET_VALUE      ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_TASK1_RESERVED_VALUE                  ( 0x0 )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_PROF_TASK1_RESERVED_VALUE_RESET_VALUE      ( 0x0 )


#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_OFFSET ( 0x000001B4 )

#define RUNNER_REGS_0_CFG_PICO_PROFILING_CFG_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_PROFILING_CFG_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_PROFILING_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_PROFILING_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_PROFILING_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_PROFILING_CFG_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_PROFILING_CFG_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_PROFILING_CFG_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_PROFILING_CFG_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_PROFILING_CFG_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_PROFILING_CFG_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_PROFILING_CFG_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_PROFILING_CFG_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_PROFILING_CFG_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_PROFILING_CFG_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_PROFILING_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* RSV2 */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_BASE_ADDR */
	uint32_t trace_base_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_STOP */
	uint32_t prof_stop      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_START */
	uint32_t prof_start     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t rsv1           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_PC_EN */
	uint32_t trace_pc_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK2 */
	uint32_t prof_task2     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK1 */
	uint32_t prof_task1     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_PROFILING_CFG ;
#else
typedef struct
{	uint32_t prof_task1     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK1 */
	uint32_t prof_task2     	: 5 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_TASK2 */
	uint32_t trace_pc_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_PC_EN */
	uint32_t rsv1           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV1 */
	uint32_t prof_start     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_START */
	uint32_t prof_stop      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PROF_STOP */
	uint32_t trace_base_addr	: 13 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TRACE_BASE_ADDR */
	uint32_t rsv2           	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* RSV2 */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_PROFILING_CFG ;
#endif

/*****************************************************************************************/
/* Pico_stall_cnt1                                                                       */
/* Pico stall count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_STALL_CNT1_ACC_STALL_CNT_RESERVED1_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT1_ACC_STALL_CNT_RESERVED1_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT1_LD_STALL_CNT_RESERVED1_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT1_LD_STALL_CNT_RESERVED1_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_PICO_STALL_CNT1_OFFSET ( 0x000001B8 )

#define RUNNER_REGS_0_CFG_PICO_STALL_CNT1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_STALL_CNT1_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_STALL_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_STALL_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_STALL_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_STALL_CNT1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_STALL_CNT1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_STALL_CNT1_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_STALL_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_STALL_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_STALL_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_STALL_CNT1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_STALL_CNT1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_STALL_CNT1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_STALL_CNT1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_STALL_CNT1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_STALL_CNT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* ACC_STALL_CNT */
	uint32_t acc_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LD_STALL_CNT */
	uint32_t ld_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_STALL_CNT1 ;
#else
typedef struct
{	uint32_t ld_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LD_STALL_CNT */
	uint32_t acc_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ACC_STALL_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_STALL_CNT1 ;
#endif

/*****************************************************************************************/
/* Pico_stall_cnt2                                                                       */
/* pico stall count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_STALL_CNT2_STORE_STALL_CNT_RESERVED0_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT2_STORE_STALL_CNT_RESERVED0_VALUE_RESET_VALUE ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT2_LDIO_STALL_CNT_RESERVED0_VALUE              ( 0x0 )
#define RUNNER_REGS_CFG_PICO_STALL_CNT2_LDIO_STALL_CNT_RESERVED0_VALUE_RESET_VALUE  ( 0x0 )


#define RUNNER_REGS_CFG_PICO_STALL_CNT2_OFFSET ( 0x000001BC )

#define RUNNER_REGS_0_CFG_PICO_STALL_CNT2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_STALL_CNT2_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_STALL_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_STALL_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_STALL_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_STALL_CNT2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_STALL_CNT2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_STALL_CNT2_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_STALL_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_STALL_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_STALL_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_STALL_CNT2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_STALL_CNT2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_STALL_CNT2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_STALL_CNT2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_STALL_CNT2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_STALL_CNT2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* STORE_STALL_CNT */
	uint32_t store_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LDIO_STALL_CNT */
	uint32_t ldio_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_STALL_CNT2 ;
#else
typedef struct
{	uint32_t ldio_stall_cnt 	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* LDIO_STALL_CNT */
	uint32_t store_stall_cnt	: 16 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* STORE_STALL_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_STALL_CNT2 ;
#endif

/*****************************************************************************************/
/* Pico_task_cnt1                                                                        */
/* pico count count                                                                      */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_TASK_CNT1_TASK1_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_TASK_CNT1_TASK1_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_PICO_TASK_CNT1_OFFSET ( 0x000001C0 )

#define RUNNER_REGS_0_CFG_PICO_TASK_CNT1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_TASK_CNT1_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_TASK_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_TASK_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_TASK_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_TASK_CNT1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_TASK_CNT1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_TASK_CNT1_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_TASK_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_TASK_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_TASK_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_TASK_CNT1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_TASK_CNT1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_TASK_CNT1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_TASK_CNT1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_TASK_CNT1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_TASK_CNT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TASK1_CNT */
	uint32_t task1_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_TASK_CNT1 ;
#else
typedef struct
{	uint32_t task1_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TASK1_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_TASK_CNT1 ;
#endif

/*****************************************************************************************/
/* Pico_task_cnt2                                                                        */
/* pico count                                                                            */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_TASK_CNT2_TASK2_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_TASK_CNT2_TASK2_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_PICO_TASK_CNT2_OFFSET ( 0x000001C4 )

#define RUNNER_REGS_0_CFG_PICO_TASK_CNT2_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_TASK_CNT2_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_TASK_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_TASK_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_TASK_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_TASK_CNT2_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_TASK_CNT2_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_TASK_CNT2_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_TASK_CNT2_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_TASK_CNT2_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_TASK_CNT2_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_TASK_CNT2_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_TASK_CNT2_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_TASK_CNT2_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_TASK_CNT2_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_TASK_CNT2_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_TASK_CNT2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* TASK2_CNT */
	uint32_t task2_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_TASK_CNT2 ;
#else
typedef struct
{	uint32_t task2_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* TASK2_CNT */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_TASK_CNT2 ;
#endif

/*****************************************************************************************/
/* Pico_idle_cnt                                                                         */
/* pico idle count                                                                       */
/*****************************************************************************************/

#define RUNNER_REGS_CFG_PICO_IDLE_CNT1_IDLE_CNT_RESERVED_VALUE             ( 0x0 )
#define RUNNER_REGS_CFG_PICO_IDLE_CNT1_IDLE_CNT_RESERVED_VALUE_RESET_VALUE ( 0x0 )


#define RUNNER_REGS_CFG_PICO_IDLE_CNT1_OFFSET ( 0x000001C8 )

#define RUNNER_REGS_0_CFG_PICO_IDLE_CNT1_ADDRESS   	( RUNNER_REGS_0_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_IDLE_CNT1_OFFSET )
#define RUNNER_REGS_0_CFG_PICO_IDLE_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_0_CFG_PICO_IDLE_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_0_CFG_PICO_IDLE_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_0_CFG_PICO_IDLE_CNT1_ADDRESS ), (v) )

#define RUNNER_REGS_1_CFG_PICO_IDLE_CNT1_ADDRESS   	( RUNNER_REGS_1_CFG_ADDRESS + RUNNER_REGS_CFG_PICO_IDLE_CNT1_OFFSET )
#define RUNNER_REGS_1_CFG_PICO_IDLE_CNT1_READ( r ) 	READ_32( ( RUNNER_REGS_1_CFG_PICO_IDLE_CNT1_ADDRESS ), (r) )
#define RUNNER_REGS_1_CFG_PICO_IDLE_CNT1_WRITE( v )	WRITE_32( ( RUNNER_REGS_1_CFG_PICO_IDLE_CNT1_ADDRESS ), (v) )


extern uint32_t RUNNER_REGS_CFG_PICO_IDLE_CNT1_ARRAY [ ] ;

#define RUNNER_REGS_CFG_PICO_IDLE_CNT1_WRITE( i, v )	WRITE_32( RUNNER_REGS_CFG_PICO_IDLE_CNT1_ARRAY [ i ], (v) )
#define RUNNER_REGS_CFG_PICO_IDLE_CNT1_READ( i, r ) 	READ_32( RUNNER_REGS_CFG_PICO_IDLE_CNT1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* IDLE */
	uint32_t idle_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_IDLE_CNT1 ;
#else
typedef struct
{	uint32_t idle_cnt	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* IDLE */
}
__PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG_PICO_IDLE_CNT1 ;
#endif

typedef struct
{
	/* Data_memory_entry */
	RUNNER_COMMON_MEM_HIGH high __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_memory_entry */
	RUNNER_COMMON_MEM_LOW low __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON_MEM ;

typedef struct
{
	/* Data_memory_entry */
	RUNNER_PRIVATE_MEM_HIGH high __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Data_memory_entry */
	RUNNER_PRIVATE_MEM_LOW low __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE_MEM ;

typedef struct
{
	/* Instruction_memory_entry */
	RUNNER_INST_MAIN_MEM_ENTRY entry __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_MAIN_MEM ;

typedef struct
{
	/* Context_mem_entry */
	RUNNER_CNTXT_MAIN_MEM_ENTRY entry __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_MAIN_MEM ;

/*****************************************************************************************/
/* Prediction memory MAIN core                                                           */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define RUNNER_PRED_MAIN_MEM_ENTRY_NUMBER ( 448 )

typedef struct
{
	/* prediction_memory_core */
	RUNNER_PRED_MAIN_MEM_ENTRY entry [ RUNNER_PRED_MAIN_MEM_ENTRY_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_MAIN_MEM ;

typedef struct
{
	/* Instruction_memory_entry */
	RUNNER_INST_PICO_MEM_ENTRY entry __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_PICO_MEM ;

typedef struct
{
	/* Context_mem_entry */
	RUNNER_CNTXT_PICO_MEM_ENTRY entry __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_PICO_MEM ;

/*****************************************************************************************/
/* Prediction memory PICO core                                                           */
/*****************************************************************************************/

/*****************************************************************************************/
/* Registers array numbers                                                               */
/*****************************************************************************************/
#define RUNNER_PRED_PICO_MEM_ENTRY_NUMBER ( 256 )

typedef struct
{
	/* Prediction_memory_pico */
	RUNNER_PRED_PICO_MEM_ENTRY entry [ RUNNER_PRED_PICO_MEM_ENTRY_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_PICO_MEM ;

typedef struct
{
	/* Global_control */
	RUNNER_REGS_CFG_GLOBAL_CTRL global_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CPU_Wakeup */
	RUNNER_REGS_CFG_CPU_WAKEUP cpu_wakeup __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_Control */
	RUNNER_REGS_CFG_INT_CTRL int_ctrl __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Interrupt_Mask */
	RUNNER_REGS_CFG_INT_MASK int_mask __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_Configuration */
	RUNNER_REGS_CFG_LKUP0_CFG lkup0_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_Configuration */
	RUNNER_REGS_CFG_LKUP1_CFG lkup1_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_Configuration */
	RUNNER_REGS_CFG_LKUP2_CFG lkup2_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_Configuration */
	RUNNER_REGS_CFG_LKUP3_CFG lkup3_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_CAM_configuration */
	RUNNER_REGS_CFG_LKUP0_CAM_CFG lkup0_cam_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_CAM_configuration */
	RUNNER_REGS_CFG_LKUP1_CAM_CFG lkup1_cam_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_CAM_configuration */
	RUNNER_REGS_CFG_LKUP2_CAM_CFG lkup2_cam_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_table_CAM_configuration */
	RUNNER_REGS_CFG_LKUP3_CAM_CFG lkup3_cam_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PSRAM_config_Register */
	RUNNER_REGS_CFG_PSRAM_CFG psram_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CAM_configuration */
	RUNNER_REGS_CFG_CAM_CFG cam_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Counters_Configuration */
	RUNNER_REGS_CFG_CNTR_CFG cntr_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_config_Register */
	RUNNER_REGS_CFG_DDR_CFG ddr_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_0 mipsc_semaphor_sts_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_1 mipsc_semaphor_sts_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_2 mipsc_semaphor_sts_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSC_SEMAPHOR_STS_3 mipsc_semaphor_sts_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_look-up_Global_Mask */
	RUNNER_REGS_CFG_DDR_LKUP_MASK0 ddr_lkup_mask0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_look-up_Global_Mask */
	RUNNER_REGS_CFG_DDR_LKUP_MASK1 ddr_lkup_mask1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_look-up_Global_Mask */
	RUNNER_REGS_CFG_DDR_LKUP_MASK2 ddr_lkup_mask2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* DDR_look-up_Global_Mask */
	RUNNER_REGS_CFG_DDR_LKUP_MASK3 ddr_lkup_mask3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PSRAM_look-up_Global_Mask */
	RUNNER_REGS_CFG_PSRAM_LKUP_MASK0 psram_lkup_mask0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PSRAM_look-up_Global_Mask */
	RUNNER_REGS_CFG_PSRAM_LKUP_MASK1 psram_lkup_mask1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PSRAM_look-up_Global_Mask */
	RUNNER_REGS_CFG_PSRAM_LKUP_MASK2 psram_lkup_mask2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PSRAM_look-up_Global_Mask */
	RUNNER_REGS_CFG_PSRAM_LKUP_MASK3 psram_lkup_mask3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK0_H lkup_glbl_mask0_h __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK0_L lkup_glbl_mask0_l __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK1_H lkup_glbl_mask1_h __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK1_L lkup_glbl_mask1_l __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK2_H lkup_glbl_mask2_h __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK2_L lkup_glbl_mask2_l __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK3_H lkup_glbl_mask3_h __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look-up_global_mask */
	RUNNER_REGS_CFG_LKUP_GLBL_MASK3_L lkup_glbl_mask3_l __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Look_up_configuration */
	RUNNER_REGS_CFG_LKUP_CFG lkup_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 28 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_profiling_sts */
	RUNNER_REGS_CFG_MAIN_PROFILING_STS main_profiling_sts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_profiling_cfg */
	RUNNER_REGS_CFG_MAIN_PROFILING_CFG main_profiling_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_stall_cnt1 */
	RUNNER_REGS_CFG_MAIN_STALL_CNT1 main_stall_cnt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_stall_cnt2 */
	RUNNER_REGS_CFG_MAIN_STALL_CNT2 main_stall_cnt2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_task_cnt1 */
	RUNNER_REGS_CFG_MAIN_TASK1_CNT main_task1_cnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_task_cnt2 */
	RUNNER_REGS_CFG_MAIN_TASK2_CNT main_task2_cnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_idle_cnt1 */
	RUNNER_REGS_CFG_MAIN_IDLE_CNT1 main_idle_cnt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 20 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Version */
	RUNNER_REGS_CFG_VERSION_ADDR version_addr __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 8 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Ramrd_mask_config */
	RUNNER_REGS_CFG_RAMRD_RANGE_MASK_CFG ramrd_range_mask_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Metal_fix */
	RUNNER_REGS_CFG_METAL_FIX_REG metal_fix_reg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Timer_target */
	RUNNER_REGS_CFG_TIMER_TARGET timer_target __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Scheduler_main_config */
	RUNNER_REGS_CFG_MAIN_SCH_CFG main_sch_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Scheduler_pico_config */
	RUNNER_REGS_CFG_PICO_SCH_CFG pico_sch_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 16 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_bkpt_0 */
	RUNNER_REGS_CFG_MAIN_BKPT_0 main_bkpt_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_bkpt_1 */
	RUNNER_REGS_CFG_MAIN_BKPT_1 main_bkpt_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_bkpt_2 */
	RUNNER_REGS_CFG_MAIN_BKPT_2 main_bkpt_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_bkpt_3 */
	RUNNER_REGS_CFG_MAIN_BKPT_3 main_bkpt_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_bkpt_immediate */
	RUNNER_REGS_CFG_MAIN_BKPT_IMM main_bkpt_imm __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_bkpt_0 */
	RUNNER_REGS_CFG_PICO_BKPT_0 pico_bkpt_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_bkpt_1 */
	RUNNER_REGS_CFG_PICO_BKPT_1 pico_bkpt_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_bkpt_2 */
	RUNNER_REGS_CFG_PICO_BKPT_2 pico_bkpt_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_bkpt_3 */
	RUNNER_REGS_CFG_PICO_BKPT_3 pico_bkpt_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_bkpt_immediate */
	RUNNER_REGS_CFG_PICO_BKPT_IMM pico_bkpt_imm __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cfg_1588 */
	RUNNER_REGS_CFG_CFG_1588 cfg_1588 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* cfg_8k */
	RUNNER_REGS_CFG_CFG_8K cfg_8k __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_0 mipsd_semaphor_sts_0 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_1 mipsd_semaphor_sts_1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_2 mipsd_semaphor_sts_2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Semaphore_Status_and_Control */
	RUNNER_REGS_CFG_MIPSD_SEMAPHOR_STS_3 mipsd_semaphor_sts_3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Main_jump_cnt */
	RUNNER_REGS_CFG_MAIN_JMP_CNT main_jmp_cnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_jump_cnt */
	RUNNER_REGS_CFG_PICO_JMP_CNT pico_jmp_cnt __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MAIN_BKPT_CFG */
	RUNNER_REGS_CFG_MAIN_BKPT_CFG main_bkpt_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PICO_BKPT_CFG */
	RUNNER_REGS_CFG_PICO_BKPT_CFG pico_bkpt_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* MAIN_BKPT_STS */
	RUNNER_REGS_CFG_MAIN_BKPT_STS main_bkpt_sts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PICO_BKPT_STS */
	RUNNER_REGS_CFG_PICO_BKPT_STS pico_bkpt_sts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 72 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_profiling_sts */
	RUNNER_REGS_CFG_PICO_PROFILING_STS pico_profiling_sts __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_profiling_cfg */
	RUNNER_REGS_CFG_PICO_PROFILING_CFG pico_profiling_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_stall_cnt1 */
	RUNNER_REGS_CFG_PICO_STALL_CNT1 pico_stall_cnt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_stall_cnt2 */
	RUNNER_REGS_CFG_PICO_STALL_CNT2 pico_stall_cnt2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_task_cnt1 */
	RUNNER_REGS_CFG_PICO_TASK_CNT1 pico_task_cnt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_task_cnt2 */
	RUNNER_REGS_CFG_PICO_TASK_CNT2 pico_task_cnt2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Pico_idle_cnt */
	RUNNER_REGS_CFG_PICO_IDLE_CNT1 pico_idle_cnt1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS_CFG ;

typedef struct
{
	/* mem function */
	RUNNER_COMMON_MEM mem [ RUNNER_COMMON_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_COMMON ;

typedef struct
{
	/* mem function */
	RUNNER_PRIVATE_MEM mem [ RUNNER_PRIVATE_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRIVATE ;

typedef struct
{
	/* mem function */
	RUNNER_INST_MAIN_MEM mem [ RUNNER_INST_MAIN_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_MAIN ;

typedef struct
{
	/* mem function */
	RUNNER_CNTXT_MAIN_MEM mem [ RUNNER_CNTXT_MAIN_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_MAIN ;

typedef struct
{
	/* mem function */
	RUNNER_PRED_MAIN_MEM mem __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_MAIN ;

typedef struct
{
	/* mem function */
	RUNNER_INST_PICO_MEM mem [ RUNNER_INST_PICO_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_INST_PICO ;

typedef struct
{
	/* mem function */
	RUNNER_CNTXT_PICO_MEM mem [ RUNNER_CNTXT_PICO_MEM_COUNTER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_CNTXT_PICO ;

typedef struct
{
	/* mem function */
	RUNNER_PRED_PICO_MEM mem __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_PRED_PICO ;

typedef struct
{
	/* cfg function */
	RUNNER_REGS_CFG cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
RUNNER_REGS ;

#define RUNNER_COMMON_NUMBER ( 2 )
#define RUNNER_PRIVATE_NUMBER ( 2 )
#define RUNNER_INST_MAIN_NUMBER ( 2 )
#define RUNNER_CNTXT_MAIN_NUMBER ( 2 )
#define RUNNER_PRED_MAIN_NUMBER ( 2 )
#define RUNNER_INST_PICO_NUMBER ( 2 )
#define RUNNER_CNTXT_PICO_NUMBER ( 2 )
#define RUNNER_PRED_PICO_NUMBER ( 2 )
#define RUNNER_REGS_NUMBER ( 2 )
typedef struct
{
	/* COMMON */
	RUNNER_COMMON common [ RUNNER_COMMON_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved1 [ 65528 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRIVATE */
	RUNNER_PRIVATE private [ RUNNER_PRIVATE_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved2 [ 65528 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* INST_MAIN */
	RUNNER_INST_MAIN inst_main [ RUNNER_INST_MAIN_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved3 [ 32764 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNTXT_MAIN */
	RUNNER_CNTXT_MAIN cntxt_main [ RUNNER_CNTXT_MAIN_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved4 [ 16380 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRED_MAIN */
	RUNNER_PRED_MAIN pred_main [ RUNNER_PRED_MAIN_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved5 [ 15488 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* INST_PICO */
	RUNNER_INST_PICO inst_pico [ RUNNER_INST_PICO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved6 [ 32764 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* CNTXT_PICO */
	RUNNER_CNTXT_PICO cntxt_pico [ RUNNER_CNTXT_PICO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved7 [ 16380 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* PRED_PICO */
	RUNNER_PRED_PICO pred_pico [ RUNNER_PRED_PICO_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* Reserved */
	uint8_t reserved8 [ 380416 ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* REGS */
	RUNNER_REGS regs [ RUNNER_REGS_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
RUNNER_FOR_ALL ;
#endif /* RUNNER_H_INCLUDED */

