/*
   Copyright (c) 2013 Broadcom Corporation
   All Rights Reserved

    <:label-BRCM:2013:DUAL/GPL:standard
    
    Unless you and Broadcom execute a separate written software license
    agreement governing use of this software, this software is licensed
    to you under the terms of the GNU General Public License version 2
    (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
    with the following added to such license:
    
       As a special exception, the copyright holders of this software give
       you permission to link this software with independent modules, and
       to copy and distribute the resulting executable under terms of your
       choice, provided that you also meet, for each linked independent
       module, the terms and conditions of the license of that module.
       An independent module is a module which is not derived from this
       software.  The special exception does not apply to any modifications
       of the software.
    
    Not withstanding the above, under no circumstances may you combine
    this software in any way with any other Broadcom software provided
    under a license other than the GPL, without Broadcom's express prior
    written consent.
    
    :> 
*/             

#ifndef __ETH_H_INCLUDED
#define __ETH_H_INCLUDED

/*  File automatically generated by Reggae at 15/08/2013  10:54:37   */

#include "access_macros.h"
#include "packing.h"
#include "rdp_eth_offsets.h"

/*****************************************************************************************/
/* Ethernet Interface                                                                    */
/*****************************************************************************************/

/*****************************************************************************************/
/* Blocks offsets                                                                        */
/*****************************************************************************************/
/*****************************************************************************************/
/* Functions offsets and addresses                                                       */
/*****************************************************************************************/
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_0_OFFSET + ETH_UNIMAC_TOP_0_UNIMAC_MISC_OFFSET )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_1_OFFSET + ETH_UNIMAC_TOP_1_UNIMAC_MISC_OFFSET )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_2_OFFSET + ETH_UNIMAC_TOP_2_UNIMAC_MISC_OFFSET )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_3_OFFSET + ETH_UNIMAC_TOP_3_UNIMAC_MISC_OFFSET )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_4_OFFSET + ETH_UNIMAC_TOP_4_UNIMAC_MISC_OFFSET )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_OFFSET 	( 0x00000000 )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS	( ETH_UNIMAC_TOP_5_OFFSET + ETH_UNIMAC_TOP_5_UNIMAC_MISC_OFFSET )

/*   'd' is module index   */
/*   'i' is block index    */
/*   'j' is function index */
/*   'e' is function entry */
/*   'k' is register index */

/*****************************************************************************************/
/* UNIMAC_CFG                                                                            */
/* Interface static configuration values                                                 */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_R0_RESERVED_VALUE                              ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_R0_RESERVED_VALUE_RESET_VALUE                  ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_GEN_DISABLED_VALUE                          ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_GEN_DISABLED_VALUE_RESET_VALUE              ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_GEN_ENABLED_VALUE                           ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_PSE_EN_DISABLED_VALUE                       ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_PSE_EN_DISABLED_VALUE_RESET_VALUE           ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_PP_PSE_EN_ENABLED_VALUE                        ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_LAUNCH_ENABLE_DISABLED_VALUE                   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_LAUNCH_ENABLE_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_LAUNCH_ENABLE_ENABLED_VALUE                    ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_EXT_TX_FLOW_CONTROL_DISABLED_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_EXT_TX_FLOW_CONTROL_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_EXT_TX_FLOW_CONTROL_ENABLED_VALUE              ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_DISABLED_VALUE                    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_DISABLED_VALUE_RESET_VALUE        ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_OWRT_ENABLED_VALUE                     ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_DISABLED_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_MAC_CRC_FWD_ENABLED_VALUE                      ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_TXCRCER_DISABLED_VALUE                         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_TXCRCER_DISABLED_VALUE_RESET_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_TXCRCER_ENABLED_VALUE                          ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_SS_MODE_MII_DISABLED_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_SS_MODE_MII_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_SS_MODE_MII_ENABLED_VALUE                      ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_GPORT_MODE_DISABLED_VALUE                      ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_GPORT_MODE_DISABLED_VALUE_RESET_VALUE          ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_GPORT_MODE_ENABLED_VALUE                       ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_DIRECT_GMII_DISABLED_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_DIRECT_GMII_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_DIRECT_GMII_ENABLED_VALUE                      ( 0x1 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET ( 0x00000000 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_CFG_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_CFG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_CFG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_CFG_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0                 	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_gen */
	uint32_t pp_gen             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_pse_en */
	uint32_t pp_pse_en          	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* launch_enable */
	uint32_t launch_enable      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_tx_flow_control */
	uint32_t ext_tx_flow_control	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_crc_owrt */
	uint32_t mac_crc_owrt       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_crc_fwd */
	uint32_t mac_crc_fwd        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* txcrcer */
	uint32_t txcrcer            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ss_mode_mii */
	uint32_t ss_mode_mii        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_mode */
	uint32_t gport_mode         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* direct_gmii */
	uint32_t direct_gmii        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG ;
#else
typedef struct
{	uint32_t direct_gmii        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* direct_gmii */
	uint32_t gport_mode         	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_mode */
	uint32_t ss_mode_mii        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ss_mode_mii */
	uint32_t txcrcer            	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* txcrcer */
	uint32_t mac_crc_fwd        	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_crc_fwd */
	uint32_t mac_crc_owrt       	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_crc_owrt */
	uint32_t ext_tx_flow_control	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* ext_tx_flow_control */
	uint32_t launch_enable      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* launch_enable */
	uint32_t pp_pse_en          	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_pse_en */
	uint32_t pp_gen             	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_gen */
	uint32_t r0                 	: 15 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG ;
#endif

/*****************************************************************************************/
/* UNIMAC_EXT_CFG1                                                                       */
/* Configure additional parameters that influence UNIMAC external logic.                 */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_R1_RESERVED_VALUE                                  ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_R1_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_DATA_VALUE             ( 0xE0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_RXFIFO_CONGESTION_THRESHOLD_DATA_VALUE_RESET_VALUE ( 0xE0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_R0_RESERVED_VALUE                                  ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_R0_RESERVED_VALUE_RESET_VALUE                      ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_DATA_VALUE                            ( 0x600 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_MAX_PKT_SIZE_DATA_VALUE_RESET_VALUE                ( 0x600 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET ( 0x00000004 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG1_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1                         	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rxfifo_congestion_threshold */
	uint32_t rxfifo_congestion_threshold	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0                         	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_pkt_size */
	uint32_t max_pkt_size               	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1 ;
#else
typedef struct
{	uint32_t max_pkt_size               	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* max_pkt_size */
	uint32_t r0                         	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t rxfifo_congestion_threshold	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rxfifo_congestion_threshold */
	uint32_t r1                         	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1 ;
#endif

/*****************************************************************************************/
/* UNIMAC_EXT_CFG2                                                                       */
/* Configure additional parameters that influence UNIMAC external logic.                 */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_R1_RESERVED_VALUE                                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_R1_RESERVED_VALUE_RESET_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_DISABLE_VALUE                  ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_DISABLE_VALUE_RESET_VALUE      ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_REMOTE_LOOPBACK_EN_ENABLE_VALUE                   ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_DISABLE_VALUE                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_DISABLE_VALUE_RESET_VALUE     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_FIFO_OVERRUN_CTL_EN_ENABLE_VALUE                  ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_DISABLE_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_EXT_ENABLE_VALUE              ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_DISABLE_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_BACKPRESSURE_ENABLE_INT_ENABLE_VALUE              ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_R0_RESERVED_VALUE                                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_R0_RESERVED_VALUE_RESET_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_DATA_VALUE                 ( 0x20 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_RXFIFO_PAUSE_THRESHOLD_DATA_VALUE_RESET_VALUE     ( 0x20 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET ( 0x00000008 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_EXT_CFG2_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1                     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* remote_loopback_en */
	uint32_t remote_loopback_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fifo_overrun_ctl_en */
	uint32_t fifo_overrun_ctl_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* backpressure_enable_ext */
	uint32_t backpressure_enable_ext	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* backpressure_enable_int */
	uint32_t backpressure_enable_int	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0                     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rxfifo_pause_threshold */
	uint32_t rxfifo_pause_threshold 	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2 ;
#else
typedef struct
{	uint32_t rxfifo_pause_threshold 	: 9 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rxfifo_pause_threshold */
	uint32_t r0                     	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t backpressure_enable_int	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* backpressure_enable_int */
	uint32_t backpressure_enable_ext	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* backpressure_enable_ext */
	uint32_t fifo_overrun_ctl_en    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* fifo_overrun_ctl_en */
	uint32_t remote_loopback_en     	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* remote_loopback_en */
	uint32_t r1                     	: 12 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2 ;
#endif

/*****************************************************************************************/
/* UNIMAC_STAT_UPDATE_MASK                                                               */
/* Mask bits [32:16] of RSV. 1 indicates update disabled for the respective error condit */
/* ion.                                                                                  */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_R0_RESERVED_VALUE                             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_R0_RESERVED_VALUE_RESET_VALUE                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_GPORT_STAT_UPDATE_MASK_DATA_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_GPORT_STAT_UPDATE_MASK_DATA_VALUE_RESET_VALUE ( 0x0 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET ( 0x0000000C )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0                    	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_stat_update_mask */
	uint32_t gport_stat_update_mask	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK ;
#else
typedef struct
{	uint32_t gport_stat_update_mask	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_stat_update_mask */
	uint32_t r0                    	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK ;
#endif

/*****************************************************************************************/
/* UNIMAC_STAT                                                                           */
/* This registers holds status indications of the UNIMAC                                 */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_R1_RESERVED_VALUE                           ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_R1_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_DISABLED_VALUE               ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_VALID_ENABLED_VALUE                ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_DISABLED_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_DISABLED_VALUE_RESET_VALUE         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_PP_STATS_ENABLED_VALUE                      ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_R0_RESERVED_VALUE                           ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_R0_RESERVED_VALUE_RESET_VALUE               ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_STATS_UPDATE_DISABLED_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_STATS_UPDATE_DISABLED_VALUE_RESET_VALUE ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_STATS_UPDATE_ENABLED_VALUE              ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_DELETE_DISABLED_VALUE                ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_DELETE_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_DELETE_ENABLED_VALUE                 ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_OUT_DISABLED_VALUE                   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_OUT_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_SOP_OUT_ENABLED_VALUE                    ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_DISABLED_VALUE                ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_RX_DETECT_ENABLED_VALUE                 ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_DISABLED_VALUE                ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_DISABLED_VALUE_RESET_VALUE    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LPI_TX_DETECT_ENABLED_VALUE                 ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LAUNCH_ACK_DISABLED_VALUE                   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LAUNCH_ACK_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_LAUNCH_ACK_ENABLED_VALUE                    ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_TX_EMPTY_DISABLED_VALUE                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_TX_EMPTY_ENABLED_VALUE                  ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_TX_EMPTY_ENABLED_VALUE_RESET_VALUE      ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_IN_PAUSE_DISABLED_VALUE                 ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_IN_PAUSE_DISABLED_VALUE_RESET_VALUE     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_MAC_IN_PAUSE_ENABLED_VALUE                  ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_FIFO_DAT_AVL_DISABLED_VALUE              ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_FIFO_DAT_AVL_DISABLED_VALUE_RESET_VALUE  ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_RX_FIFO_DAT_AVL_ENABLED_VALUE               ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_SPEED_S_10MBPS_VALUE                    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_SPEED_S_100MBPS_VALUE                   ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_SPEED_S_1GBPS_VALUE                     ( 0x2 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_SPEED_S_1GBPS_VALUE_RESET_VALUE         ( 0x2 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_SPEED_S_2_5GBPS_VALUE                   ( 0x3 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_DUPLEX_DISABLED_VALUE                   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_DUPLEX_DISABLED_VALUE_RESET_VALUE       ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ETH_DUPLEX_ENABLED_VALUE                    ( 0x1 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_AUTO_CONFIG_EN_DISABLED_VALUE               ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_AUTO_CONFIG_EN_DISABLED_VALUE_RESET_VALUE   ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_AUTO_CONFIG_EN_ENABLED_VALUE                ( 0x1 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET ( 0x00000010 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_STAT_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r1              	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_stats_valid */
	uint32_t pp_stats_valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_stats */
	uint32_t pp_stats        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t r0              	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_stats_update */
	uint32_t mac_stats_update	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_sop_delete */
	uint32_t rx_sop_delete   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_sop_out */
	uint32_t rx_sop_out      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lpi_rx_detect */
	uint32_t lpi_rx_detect   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lpi_tx_detect */
	uint32_t lpi_tx_detect   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* launch_ack */
	uint32_t launch_ack      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_tx_empty */
	uint32_t mac_tx_empty    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_in_pause */
	uint32_t mac_in_pause    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_fifo_dat_avl */
	uint32_t rx_fifo_dat_avl 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth_speed */
	uint32_t eth_speed       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth_duplex */
	uint32_t eth_duplex      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* auto_config_en */
	uint32_t auto_config_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT ;
#else
typedef struct
{	uint32_t auto_config_en  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* auto_config_en */
	uint32_t eth_duplex      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth_duplex */
	uint32_t eth_speed       	: 2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* eth_speed */
	uint32_t rx_fifo_dat_avl 	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_fifo_dat_avl */
	uint32_t mac_in_pause    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_in_pause */
	uint32_t mac_tx_empty    	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_tx_empty */
	uint32_t launch_ack      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* launch_ack */
	uint32_t lpi_tx_detect   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lpi_tx_detect */
	uint32_t lpi_rx_detect   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* lpi_rx_detect */
	uint32_t rx_sop_out      	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_sop_out */
	uint32_t rx_sop_delete   	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* rx_sop_delete */
	uint32_t mac_stats_update	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* mac_stats_update */
	uint32_t r0              	: 3 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
	uint32_t pp_stats        	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_stats */
	uint32_t pp_stats_valid  	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* pp_stats_valid */
	uint32_t r1              	: 7 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT ;
#endif

/*****************************************************************************************/
/* UNIMAC_DEBUG                                                                          */
/* This register holds all debug related configurations                                  */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_R0_RESERVED_VALUE                ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_R0_RESERVED_VALUE_RESET_VALUE    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_DATA_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_DEBUG_SEL_DATA_VALUE_RESET_VALUE ( 0x0 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET ( 0x00000014 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_DEBUG_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_DEBUG_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug_sel */
	uint32_t debug_sel	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG ;
#else
typedef struct
{	uint32_t debug_sel	: 8 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* debug_sel */
	uint32_t r0       	: 24 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG ;
#endif

/*****************************************************************************************/
/* UNIMAC_RST                                                                            */
/* This is a synchronous reset to the UNIMAC core                                        */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_R0_RESERVED_VALUE                    ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_R0_RESERVED_VALUE_RESET_VALUE        ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_DISABLE_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_DISABLE_VALUE_RESET_VALUE ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_UNIMAC_RST_ENABLE_VALUE              ( 0x1 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET ( 0x00000018 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RST_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RST_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RST_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RST_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0        	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* unimac_rst */
	uint32_t unimac_rst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST ;
#else
typedef struct
{	uint32_t unimac_rst	: 1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* unimac_rst */
	uint32_t r0        	: 31 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST ;
#endif

/*****************************************************************************************/
/* UNIMAC_RSV_MASK                                                                       */
/* Mask bits [32:16] of RSV. 1 indicates purge enabled for the respective error conditio */
/* n.                                                                                    */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_R0_RESERVED_VALUE                     ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_R0_RESERVED_VALUE_RESET_VALUE         ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_GPORT_RSV_MASK_DATA_VALUE             ( 0x18 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_GPORT_RSV_MASK_DATA_VALUE_RESET_VALUE ( 0x18 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET ( 0x0000001C )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_RSV_MASK_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* reserved */
	uint32_t r0            	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_rsv_mask */
	uint32_t gport_rsv_mask	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK ;
#else
typedef struct
{	uint32_t gport_rsv_mask	: 18 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* gport_rsv_mask */
	uint32_t r0            	: 14 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* reserved */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK ;
#endif

/*****************************************************************************************/
/* UNIMAC_OVERRUN_COUNTER                                                                */
/* This registers holds the number of 128-bit lines that were received from the UNIMAC I */
/* P, but were thrown due to the fact that the unimac_glue FIFO was full.                */
/*****************************************************************************************/

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_DATA_VALUE             ( 0x0 )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OVERRUN_COUNTER_DATA_VALUE_RESET_VALUE ( 0x0 )


#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET ( 0x00000020 )

#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_0_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_0_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_1_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_1_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_2_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_2_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_3_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_3_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_4_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_4_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )

#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS   	( ETH_UNIMAC_TOP_5_UNIMAC_MISC_ADDRESS + ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_OFFSET )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( r ) 	READ_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (r) )
#define ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( v )	WRITE_32( ( ETH_UNIMAC_TOP_5_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ADDRESS ), (v) )


extern uint32_t ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ARRAY [ ] ;

#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_WRITE( i, v )	WRITE_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ARRAY [ i ], (v) )
#define ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_READ( i, r ) 	READ_32( ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER_ARRAY [ i ], (r) )  

#ifndef _BYTE_ORDER_LITTLE_ENDIAN_
typedef struct
{
	/* overrun_counter */
	uint32_t overrun_counter	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER ;
#else
typedef struct
{	uint32_t overrun_counter	: 32 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* overrun_counter */
}
__PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER ;
#endif

typedef struct
{
	/* UNIMAC_CFG */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_CFG unimac_cfg __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_EXT_CFG1 */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG1 unimac_ext_cfg1 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_EXT_CFG2 */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_EXT_CFG2 unimac_ext_cfg2 __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_STAT_UPDATE_MASK */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT_UPDATE_MASK unimac_stat_update_mask __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_STAT */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_STAT unimac_stat __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_DEBUG */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_DEBUG unimac_debug __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_RST */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RST unimac_rst __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_RSV_MASK */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_RSV_MASK unimac_rsv_mask __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;

	/* UNIMAC_OVERRUN_COUNTER */
	ETH_UNIMAC_TOP_UNIMAC_MISC_UNIMAC_OVERRUN_COUNTER unimac_overrun_counter __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP_UNIMAC_MISC ;

typedef struct
{
	/* unimac_misc function */
	ETH_UNIMAC_TOP_UNIMAC_MISC unimac_misc __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
 __PACKING_ATTRIBUTE_STRUCT_END__
ETH_UNIMAC_TOP ;

#define ETH_UNIMAC_TOP_NUMBER ( 6 )
typedef struct
{
	/* UNIMAC_TOP */
	ETH_UNIMAC_TOP unimac_top [ ETH_UNIMAC_TOP_NUMBER ] __PACKING_ATTRIBUTE_FIELD_LEVEL__ ;
}
__PACKING_ATTRIBUTE_STRUCT_END__ 
ETH_FOR_ALL ;
#endif /* ETH_H_INCLUDED */

