/*
 <:copyright-BRCM:2007:DUAL/GPL:standard
 
    Copyright (c) 2007 Broadcom Corporation
    All Rights Reserved
 
 Unless you and Broadcom execute a separate written software license
 agreement governing use of this software, this software is licensed
 to you under the terms of the GNU General Public License version 2
 (the "GPL"), available at http://www.broadcom.com/licenses/GPLv2.php,
 with the following added to such license:
 
    As a special exception, the copyright holders of this software give
    you permission to link this software with independent modules, and
    to copy and distribute the resulting executable under terms of your
    choice, provided that you also meet, for each linked independent
    module, the terms and conditions of the license of that module.
    An independent module is a module which is not derived from this
    software.  The special exception does not apply to any modifications
    of the software.
 
 Not withstanding the above, under no circumstances may you combine
 this software in any way with any other Broadcom software provided
 under a license other than the GPL, without Broadcom's express prior
 written consent.
 
:>
*/

#ifndef __RDPA_DRV__H_INCLUDED__
#define __RDPA_DRV__H_INCLUDED__

#include "bcmtypes.h"
#include "rdpa_types.h"
//#include "rdpa_api.h"
//#include "rdpa_ag_port.h"

#define RDPA_DRV_VERSION         "0.2"
#define RDPA_DRV_VER_STR         "v" RDPA_DRV_VERSION " " __DATE__ " " __TIME__
#define RDPA_DRV_MODNAME         "Broadcom Runner Packet Processor"

#define RDPA_DRV_NAME            "bcmrdpa"

/* RDPA_DRV Character Device */
#define RDPADRV_MAJOR            251
#define RDPADRV_NAME             RDPA_DRV_NAME
#define RDPADRV_DEVICE_NAME      "/dev/" RDPADRV_NAME

/* RDPA Control Utility Executable */
#define RDPA_CTL_UTILITY_PATH    "/bin/rdpactl"

/* RDPA Proc FS Directory Path */
#define RDPA_PROC_FS_DIR_PATH    RDPA_NAME

#define RDPA_IFNAME_SIZE         36

/* Port TM scheduling capability */
#define RDPA_TM_SP_CAPABLE       0x1
#define RDPA_TM_WRR_CAPABLE      0x2
#define RDPA_TM_WDRR_CAPABLE     0x4
#define RDPA_TM_WFQ_CAPABLE      0x8
#define RDPA_TM_SP_WRR_CAPABLE   0x10

typedef enum {
   RDPA_DRV_SUCCESS              = 0,
   RDPA_DRV_ERROR                = 1,
   RDPA_DRV_NO_ROOT              = 2,
   RDPA_DRV_PORT_NOT_ALLOC       = 3,
   RDPA_DRV_PORT_ID_NOT_VALID    = 4,
   RDPA_DRV_NO_MORE_TMS          = 5,
   RDPA_DRV_TM_NOT_ALLOC         = 6,
   RDPA_DRV_NEW_TM_ALLOC         = 7,
   RDPA_DRV_TM_GET               = 8,
   RDPA_DRV_TM_CFG_GET           = 9,
   RDPA_DRV_TM_CFG_SET           = 10,
   RDPA_DRV_TM_INDEX_GET         = 11,
   RDPA_DRV_PORT_GET             = 12,
   RDPA_DRV_Q_CFG_GET            = 13,
   RDPA_DRV_Q_CFG_SET            = 14,
   RDPA_DRV_Q_RATE_SET           = 15,
   RDPA_DRV_GET_ROOT_BY_IF       = 16,
   RDPA_DRV_SUBS_SET             = 17,
   RDPA_DRV_MODE_GET             = 18,
   RDPA_DRV_SH_DESTROY           = 19,
   RDPA_DRV_IC_ERROR             = 20,
   RDPA_DRV_IC_NOT_FOUND         = 21,
   RDPA_DRV_IC_FLOW_ERROR        = 22,
   RDPA_DRV_ORL_LINK             = 23,
   RDPA_DRV_ORL_UNLINK           = 24,
   RDPA_DRV_BR_GET               = 25,
   RDPA_DRV_BR_LOCAL_SWITCH_SET  = 26,
   RDPA_DRV_LLID_GET             = 27,
   RDPA_DRV_LLID_TM_SET          = 28,
   RDPA_DRV_LLID_TM_GET          = 29,
   RDPA_DRV_LLID_CTRL_TM_SET     = 30,
   RDPA_DRV_LLID_TM_ID_GET       = 31,
   RDPA_DRV_LLID_CTRL_EN_SET     = 32,
   RDPA_DRV_NEW_LLID_ALLOC       = 33,
   RDPA_DRV_QUEUE_STATS_GET      = 34,
   RDPA_DRV_TCONT_GET            = 35,
   RDPA_DRV_TCONT_TM_SET         = 36,
   RDPA_DRV_TCONT_TM_GET         = 37,
   RDPA_DRV_TCONT_TM_ID_GET      = 38,
   RDPA_DRV_Q_ID_NOT_VALID       = 39
} rdpaDrvReturn_code_t;

/*
 *------------------------------------------------------------------------------
 * Common defines for RDPA layers.
 *------------------------------------------------------------------------------
 */
#undef RDPA_DECL
#define RDPA_DECL(x)                 x,  /* for enum declaration in H file */

typedef enum {
   RDPA_DECL(RDPA_IOC_TM)
   RDPA_DECL(RDPA_IOC_IPTV)
   RDPA_DECL(RDPA_IOC_IC)
   RDPA_DECL(RDPA_IOC_SYS)
   RDPA_DECL(RDPA_IOC_PORT)
   RDPA_DECL(RDPA_IOC_BRIDGE)
   RDPA_DECL(RDPA_IOC_LLID)
   RDPA_DECL(RDPA_IOC_SPDSVC)
   RDPA_DECL(RDPA_IOC_DS_WAN_UDP_FILTER)
   RDPA_DECL(RDPA_IOC_MAX)
} rdpa_drv_ioctl_t;

typedef enum {
   RDPA_IOCTL_DEV_PORT,
   RDPA_IOCTL_DEV_LLID,
   RDPA_IOCTL_DEV_TCONT,
   RDPA_IOCTL_DEV_NONE,   //standalone tm, for service q feature
   RDPA_IOCTL_DEV_TYPE_MAX
} rdpa_drv_ioctl_dev_type;

/** IP address family */
typedef enum {
    rdpactl_ip_family_ipv4,
    rdpactl_ip_family_ipv6
} rdpactl_ip_family;

/** IPv4 address */
typedef uint32_t rdpactl_ipv4;

/** IPv6 address */
typedef struct
{
    uint8_t data[16];
} rdpactl_ipv6_t;

/** IPv4 or IPv6 address */
typedef struct {
    rdpactl_ip_family family;      /**< Address family: IPv4 / IPv6 */
    union {
        rdpactl_ipv4 ipv4;         /**< IPv4 address */
        rdpactl_ipv6_t ipv6;       /**< IPv6 address */
    } addr;
} rdpactl_ip_t;

typedef enum {
   RDPA_IOCTL_TM_CMD_GET_ROOT_TM       = 0,
   RDPA_IOCTL_TM_GET_BY_QID            = 1,
   RDPA_IOCTL_TM_CMD_ROOT_TM_CONFIG    = 2,
   RDPA_IOCTL_TM_CMD_TM_CONFIG         = 3,
   RDPA_IOCTL_TM_CMD_ROOT_TM_REMOVE    = 4,
   RDPA_IOCTL_TM_CMD_TM_REMOVE         = 5,
   RDPA_IOCTL_TM_CMD_QUEUE_CONFIG      = 6,
   RDPA_IOCTL_TM_CMD_QUEUE_REMOVE      = 7,
   RDPA_IOCTL_TM_CMD_GET_ROOT_SP_TM    = 8,
   RDPA_IOCTL_TM_CMD_GET_ROOT_WRR_TM   = 9,
   RDPA_IOCTL_TM_CMD_GET_PORT_ORL      = 10,
   RDPA_IOCTL_TM_CMD_ORL_CONFIG        = 11,
   RDPA_IOCTL_TM_CMD_ORL_REMOVE        = 12,
   RDPA_IOCTL_TM_CMD_ORL_LINK          = 13,
   RDPA_IOCTL_TM_CMD_ORL_UNLINK        = 14,
   RDPA_IOCTL_TM_CMD_TM_Q_CONFIG       = 15,
   RDPA_IOCTL_TM_CMD_TM_RL_CONFIG      = 16,
   RDPA_IOCTL_TM_CMD_TM_Q_REMOVE       = 17,
   RDPA_IOCTL_TM_CMD_GET_QUEUE_CONFIG  = 18,
   RDPA_IOCTL_TM_CMD_GET_TM_CAPS       = 19,
   RDPA_IOCTL_TM_CMD_QUEUE_ALLOCATE    = 20,
   RDPA_IOCTL_TM_CMD_QUEUE_DISLOCATE   = 21,
   RDPA_IOCTL_TM_CMD_GET_QUEUE_STATS   = 22,
   RDPA_IOCTL_TM_CMD_GET_TM_CONFIG     = 23,
   RDPA_IOCTL_TM_CMD_QOS_TREE_VERIFY   = 24,
   RDPA_IOCTL_TM_CMD_MAX
} rdpa_drv_ioctl_tm_cmd_t;

typedef struct {
   rdpa_drv_ioctl_tm_cmd_t cmd;
   rdpa_drv_ioctl_dev_type dev_type;
   uint32_t dev_id;
   uint32_t root_tm_id;
   uint32_t tm_id;
   uint32_t dir;
   uint32_t q_id;
   uint32_t index;
   uint32_t level;            /* Next TM level */
   uint32_t arbiter_mode;
   uint32_t priority;
   uint32_t qsize;
   uint32_t shaping_rate;
   uint32_t burst;
   uint32_t weight;
   uint32_t port_sched_type;  /* port tm setting */
   uint32_t max_queues;       /* port tm setting */
   uint32_t max_sp_queues;    /* port tm setting */
   BOOL     port_shaper;      /* port tm setting */
   BOOL     queue_shaper;     /* port tm setting */
   BOOL     orl_linked;
   BOOL     found;
   BOOL     service_queue;
   rdpa_stat_1way_t qstats;
} rdpa_drv_ioctl_tm_t;

typedef enum {
	RDPA_IOCTL_IPTV_CMD_LOOKUP_METHOD_SET,
	RDPA_IOCTL_IPTV_CMD_LOOKUP_METHOD_GET,
	RDPA_IOCTL_IPTV_CMD_ENTRY_ADD,
	RDPA_IOCTL_IPTV_CMD_ENTRY_REMOVE,
	RDPA_IOCTL_IPTV_CMD_ENTRY_FLUSH,
	RDPA_IOCTL_IPTV_CMD_PREFIX_FILTER_SET,
	RDPA_IOCTL_IPTV_CMD_PREFIX_FILTER_GET,	
	RDPA_IOCTL_IPTV_CMD_MAX
} rdpa_drv_ioctl_iptv_cmd_t;

typedef enum {
	RDPA_IOCTL_IPTV_METHOD_MAC,
	RDPA_IOCTL_IPTV_METHOD_MAC_VID,
	RDPA_IOCTL_IPTV_METHOD_GROUP_IP,
	RDPA_IOCTL_IPTV_METHOD_GROUP_IP_SOURCE_IP,
	RDPA_IOCTL_IPTV_METHOD_GROUP_IP_SOURCE_IP_VID,
	RDPA_IOCTL_IPTV_METHOD_MAX
 } rdpa_drv_ioctl_iptv_lookup_method_t;

typedef enum {
	RDPA_IOCTL_IPTV_FILTER_NONE,
	RDPA_IOCTL_IPTV_FILTER_MAC,
	RDPA_IOCTL_IPTV_FILTER_IP,
	RDPA_IOCTL_IPTV_FILTER_MAX
 } rdpa_drv_ioctl_iptv_filter_method_t;

typedef enum {
	RDPA_IOCTL_IPTV_VLAN_UNTAG,
	RDPA_IOCTL_IPTV_VLAN_TRANPARENT,
	RDPA_IOCTL_IPTV_VLAN_TRANSLATION,
	RDPA_IOCTL_IPTV_VLAN_MAX
} rdpa_drv_ioctl_iptv_vlan_action_t;

typedef enum {
	RDPA_IOCTL_IPTV_PORT_LAN0,
	RDPA_IOCTL_IPTV_PORT_LAN1,
	RDPA_IOCTL_IPTV_PORT_LAN2,
	RDPA_IOCTL_IPTV_PORT_LAN3,
	RDPA_IOCTL_IPTV_PORT_LAN4,
	RDPA_IOCTL_IPTV_PORT_LAN5,
	RDPA_IOCTL_IPTV_PORT_LAN6,
	RDPA_IOCTL_IPTV_PORT_LAN7,
	RDPA_IOCTL_IPTV_PORT_MAX
} rdpa_drv_ioctl_iptv_egress_port_t;

typedef enum
{
   RDPACTL_IP_FAMILY_IPV4,
   RDPACTL_IP_FAMILY_IPV6
} rdpactl_ip_family_t;

typedef enum
{
    RDPA_L3_PROTOCOL_OTHER = 0, /**< IC L3 Protocol field = Other */
    RDPA_L3_PROTOCOL_IPV4  = 1, /**< IC L3 Protocol field = IPv4 */
    RDPA_L3_PROTOCOL_IPV6  = 2  /**< IC L3 Protocol field = IPv6 */
} rdpa_l3_protocol_t;

typedef struct {
    rdpactl_ip_family_t ip_family;
    union {
        uint8_t  mac[6];
        uint32_t ipv4;
        uint8_t  ipv6[16];
    } group; /**< multicast group */

    union {
        uint32_t ipv4;
        uint8_t  ipv6[16];
    } src_ip; /**< multicast ssm ip address */

    uint16_t  vid;
} rdpa_drv_ioctl_iptv_key_t;

typedef struct {
    rdpa_drv_ioctl_iptv_vlan_action_t action;
    uint16_t                          vid;
} rdpa_drv_ioctl_iptv_vlan_entry_t;

typedef struct {
    rdpa_drv_ioctl_iptv_key_t         key;
    rdpa_drv_ioctl_iptv_vlan_entry_t  vlan;
} rdpa_drv_ioctl_iptv_entry_t;

typedef struct {
    rdpa_drv_ioctl_iptv_cmd_t           cmd;
    rdpa_drv_ioctl_iptv_lookup_method_t method;
    rdpa_drv_ioctl_iptv_filter_method_t filter_method;
    rdpa_drv_ioctl_iptv_egress_port_t   egress_port;
    rdpa_drv_ioctl_iptv_entry_t         entry;
    uint16_t                            index;
} rdpa_drv_ioctl_iptv_t;

int rdpa_cmd_tm_ioctl(unsigned long arg);
void rdpa_cmd_tm_init(void);

 /* Actions of the optional actions vector */
typedef enum{
    /*4 bytes fields*/
    RDPACTL_IC_SRC_IP          = 0,
    RDPACTL_IC_DST_IP          = 1,
    RDPACTL_IC_IPV6_FLOW_LABEL = 2,
    /*2 bytes fields*/
    RDPACTL_IC_OUTER_TPID      = 3,
    RDPACTL_IC_INNER_TPID      = 4,
    RDPACTL_IC_SRC_PORT        = 5,
    RDPACTL_IC_DST_PORT        = 6,
    RDPACTL_IC_OUTER_VID       = 7,
    RDPACTL_IC_INNER_VID       = 8,
    RDPACTL_IC_DST_MAC         = 9,
    RDPACTL_IC_SRC_MAC         = 10,
    RDPACTL_IC_ETHER_TYPE      = 11,
    /*1 byte fields*/
    RDPACTL_IC_IP_PROTOCOL     = 12,
    RDPACTL_IC_DSCP            = 13,
    RDPACTL_IC_SSID            = 14,
    RDPACTL_IC_INGRESS_PORT    = 15,
    RDPACTL_IC_OUTER_PBIT      = 16,
    RDPACTL_IC_INNER_PBIT      = 17,
    RDPACTL_IC_NUM_OF_VLANS    = 18,
    RDPACTL_IC_L3_PROTOCOL     = 19,
    RDPACTL_IC_GENERIC_1       = 20,
    RDPACTL_IC_GENERIC_2       = 21
} rdpactl_ic_value ;

/** Classification rule mask fields bitmask */
typedef enum
{
    RDPACTL_IC_MASK_SRC_IP          = ( 1 << RDPACTL_IC_SRC_IP ),          /**< Source IP address */
    RDPACTL_IC_MASK_DST_IP          = ( 1 << RDPACTL_IC_DST_IP ),          /**< Destination IP address */
    RDPACTL_IC_MASK_IPV6_FLOW_LABEL = ( 1 << RDPACTL_IC_IPV6_FLOW_LABEL ), /**<  IPv6 Flow Label field */
    RDPACTL_IC_MASK_OUTER_TPID      = ( 1 << RDPACTL_IC_OUTER_TPID ),      /**< Outer TPID */
    RDPACTL_IC_MASK_INNER_TPID      = ( 1 << RDPACTL_IC_INNER_TPID ),      /**< Inner TPID */
    RDPACTL_IC_MASK_SRC_PORT        = ( 1 << RDPACTL_IC_SRC_PORT ),        /**< Source port */
    RDPACTL_IC_MASK_DST_PORT        = ( 1 << RDPACTL_IC_DST_PORT ),        /**< Destination port */
    RDPACTL_IC_MASK_OUTER_VID       = ( 1 << RDPACTL_IC_OUTER_VID ),       /**< Outer VID */
    RDPACTL_IC_MASK_INNER_VID       = ( 1 << RDPACTL_IC_INNER_VID ),       /**< Inner VID */
    RDPACTL_IC_MASK_DST_MAC         = ( 1 << RDPACTL_IC_DST_MAC ),         /**< Destination MAC address */
    RDPACTL_IC_MASK_SRC_MAC         = ( 1 << RDPACTL_IC_SRC_MAC ),         /**< Source MAC address */
    RDPACTL_IC_MASK_ETHER_TYPE      = ( 1 << RDPACTL_IC_ETHER_TYPE ),      /**< Ether Type */
    RDPACTL_IC_MASK_IP_PROTOCOL     = ( 1 << RDPACTL_IC_IP_PROTOCOL ),     /**< Protocol */
    RDPACTL_IC_MASK_DSCP            = ( 1 << RDPACTL_IC_DSCP ),            /**< IP Differentiated Services Code Point */
    RDPACTL_IC_MASK_SSID            = ( 1 << RDPACTL_IC_SSID ),            /**< Ingress SSID */
    RDPACTL_IC_MASK_INGRESS_PORT    = ( 1 << RDPACTL_IC_INGRESS_PORT ),
    RDPACTL_IC_MASK_OUTER_PBIT      = ( 1 << RDPACTL_IC_OUTER_PBIT ),      /**< Outer PBIT */
    RDPACTL_IC_MASK_INNER_PBIT      = ( 1 << RDPACTL_IC_INNER_PBIT ),      /**< Inner PBIT */
    RDPACTL_IC_MASK_NUM_OF_VLANS    = ( 1 << RDPACTL_IC_NUM_OF_VLANS ),    /**< Number of VLAN in packet */
    RDPACTL_IC_MASK_L3_PROTOCOL     = ( 1 << RDPACTL_IC_L3_PROTOCOL ),     /**< L3 Protocol (Other-0, IPv4-1, IPv6-2) */
    RDPACTL_IC_MASK_GENERIC_1       = ( 1 << RDPACTL_IC_GENERIC_1 ),       /**< Generic key 0 (type L2/L3/L4, offset, mask */
    RDPACTL_IC_MASK_GENERIC_2       = ( 1 << RDPACTL_IC_GENERIC_2 ),       /**< Generic key 1 (type L2/L3/L4, offset, mask */
} rdpactl_ic_fields;


typedef enum
{
    RDPACTL_IF_LAN0 = 2,           /**< LAN0 port */
    RDPACTL_IF_LAN1,           /**< LAN1 port */
    RDPACTL_IF_LAN2,           /**< LAN2 port */
    RDPACTL_IF_LAN3,           /**< LAN3 port */
    
    RDPACTL_IF_MAX,
} rdpactl_ingress_port;

typedef enum
{
    RDPACTL_IC_TYPE_ACL = 1, /**< Classification type ACL */
    RDPACTL_IC_TYPE_FLOW = 2,   /**< Classification type Flow */
    RDPACTL_IC_TYPE_QOS = 3,    /**< Classification type QoS */
} rdpactl_ic_type;

/** Forwarding mode */
typedef enum
{
    rdpactl_forwarding_mode_pkt,   /**< Packet-based forwarding */
    rdpactl_forwarding_mode_flow,  /**< Flow-based forwarding */
} rdpactl_forwarding_mode;

typedef enum {
    /** Transparent action */
    RDPACTL_VLAN_CMD_TRANSPARENT = 0,
    /** Add VLAN tag */
    RDPACTL_VLAN_CMD_PUSH = 0x00000001,
    /** Add VLAN tag always (even if packet is double-tagged) */
    RDPACTL_VLAN_CMD_PUSH_ALWAYS = 0x00000002,
    /** Remove VLAN tag */
    RDPACTL_VLAN_CMD_POP = 0x00000004,
    /** Replace VLAN tag */
    RDPACTL_VLAN_CMD_REPLACE = 0x00000008,
    /** Add 2 VLAN tags */
    RDPACTL_VLAN_CMD_PUSH2 = 0x00000010,
    /** Add 2 VLAN tag always (even if packet is double-tagged) */
    RDPACTL_VLAN_CMD_PUSH2_ALWAYS = 0x00000020,
    /** Remove 2 VLAN tags */
    RDPACTL_VLAN_CMD_POP2 = 0x00000040,
    /** Replace 2 VLAN tags */
    RDPACTL_VLAN_CMD_REPLACE2 = 0x00000080,
    /** P-Bit re-marking in VLAN tag*/
    RDPACTL_VLAN_CMD_REMARK = 0x00000100,
    /** Re-mapping according to P-bit in VLAN tag */
    RDPACTL_VLAN_CMD_REMAP = 0x00000200,
    /** Remap DSCP -> P-bit in VLAN tag mapping */
    RDPACTL_VLAN_CMD_DSCP = 0x00000400,
    /** Replace TPID in VLAN tag */
    RDPACTL_VLAN_CMD_TPID = 0x00000800,
} rdpactl_vlan_command;

/** Max number of tags supported by vlan_action */
#define RDPACTL_VLAN_MAX_TAGS          2

/** Outer tag index */
#define RDPACTL_VLAN_TAG_OUT   0 
/** Inner tag index */
#define RDPACTL_VLAN_TAG_IN    1 

/** VLAN tag + pbit */
typedef struct {
    uint16_t vid;       /**< VID */
    uint8_t pbit;     /**< PBIT */
    uint16_t tpid;      /**< TPID */
} rdpactl_vtag_cmd_parm_t;

/** VLAN action parameters */
typedef struct {
    uint32_t cmd;       /**< Action command - combination of ::rdpa_vlan_command bits */
    rdpactl_vtag_cmd_parm_t parm[RDPACTL_VLAN_MAX_TAGS];    /**< Command parameters */
} rdpactl_vtag_action_t;

/** Traffic direction */
typedef enum
{
    rdpactl_dir_ds,        /**< Downstream */
    rdpactl_dir_us         /**< Upstream */
} rdpactl_traffic_dir;

/** Generic field configuration */
typedef struct
{
    rdpa_offset_t type; /**< Packet offset type ::rdpa_offset_t */
    uint32_t offset; /**< Packet offset, must be 2-bytes aligned */ 
    uint32_t mask; /**< 4-byte key binary mask */
} rdpactl_ic_gen_rule_cfg_t;

#define RDPACTL_QUEUEID_BITS_NUMBER 16
#define RDPACTL_WANFLOW_MASK ((~0) << RDPACTL_QUEUEID_BITS_NUMBER)
#define RDPACTL_SERVICEACT_Q_MASK (0x10000UL)
#define RDPACTL_SERVICEQUEUE_MASK (0xFFFFUL)

typedef struct
{
    rdpactl_ic_type type;
    rdpactl_traffic_dir dir;
    //Classification Mask & rule priority
    uint8_t prty;  /**< Defined the priority of classifier. value between 0 - 256, 0 is highest priority */
    uint32_t field_mask; /**< Fields used for classification. A combination of rdpactl_ic_fields */
    uint16_t port_mask;

    rdpactl_ic_gen_rule_cfg_t gen_rule_cfg1;
    rdpactl_ic_gen_rule_cfg_t gen_rule_cfg2;

    //Classification key
    rdpactl_ip_family_t ip_family;
    union {
        uint32_t ipv4;
        uint8_t ipv6[16];
    } src_ip; /**< source ipv4/ipv6 ip */
    union {
        uint32_t ipv4;
        uint8_t ipv6[16];
    } dst_ip; /**< dest ipv4/ipv6 ip */
    uint16_t src_port;  /**< source port */
    uint16_t dst_port;  /**< destination port */
    uint8_t   protocol; /**< IP protocols. For example, UDP(17) */
    uint16_t  outer_vid; /**< Outer VID */
    uint16_t  inner_vid;   /**< Inner VID */
    uint8_t dst_mac[6];  /**<DA  MAC address */
    uint8_t src_mac[6];  /**<SA MAC address */
    uint16_t  etype;  /**< Ethernet type */
    uint8_t   dscp; /**< dscp val */
    uint8_t ingress_port_id; /**<DS- GEM or LLID index US - ingress port index */
    uint8_t   outer_pbits;  /**< Outer pbit */
    uint8_t   inner_pbits;  /**< Inner PBIT */
    uint8_t   number_of_vlans; /**< number of vlans */
    uint32_t   ipv6_label; /**< ipv6 label */
    uint16_t   outer_tpid;  /**< Outer tpid */
    uint16_t   inner_tpid;  /**< Inner tpid */
    uint8_t   version;  
    uint32_t  gen_rule_key_1;   /**< Key for first generic field matching */
    uint32_t  gen_rule_key_2;   /**< Key for second generic field matching */    
    
    //Classification result
    uint8_t qos_method;
    uint8_t wan_flow;
    uint8_t  action; /*< frame action */
    uint8_t forw_mode;
    uint8_t egress_port;
    uint32_t queue_id; /**< Egress queue id and wan flow */
    rdpactl_vtag_action_t vlan_action;
    int8_t opbit_remark; /*-1: no remark */
    int8_t ipbit_remark; /*-1: no remark */
    int8_t dscp_remark; /*-1: no remark */
    int8_t pbit_to_gem;
    uint32_t shaping_rate;  //to be done
    uint32_t shaping_burst_size; //to be done
    uint32_t service_queue_info; 
} rdpactl_classification_rule_t ;

typedef enum {
    RDPA_IOCTL_IC_CMD_ADD_CLASSIFICATION_RULE	= 0,
    RDPA_IOCTL_IC_CMD_DEL_CLASSIFICATION_RULE	= 1,
    RDPA_IOCTL_IC_CMD_ADD	= 2,
    RDPA_IOCTL_IC_CMD_DEL	= 3,
} rdpa_drv_ioctl_ic_cmd_t;

typedef union {
        rdpactl_classification_rule_t *rule;
        //a ingress classifier may be used by several flows. return the ic priority
        uint8_t prty;
} rdpa_drv_ioctl_ic_param_t;

typedef struct {
        rdpa_drv_ioctl_ic_cmd_t cmd;
        rdpa_drv_ioctl_ic_param_t param;
} rdpa_drv_ioctl_ic_t;


typedef enum {
	RDPA_IOCTL_SYS_CMD_WANTYPE_GET,
	RDPA_IOCTL_SYS_CMD_IN_TPID_GET,
	RDPA_IOCTL_SYS_CMD_IN_TPID_SET,
	RDPA_IOCTL_SYS_CMD_OUT_TPID_GET,
	RDPA_IOCTL_SYS_CMD_OUT_TPID_SET,
	RDPA_IOCTL_SYS_CMD_EPON_MODE_SET,
	RDPA_IOCTL_SYS_CMD_ALWAYS_TPID_SET,
	RDPA_IOCTL_SYS_CMD_MAX
} rdpa_drv_ioctl_sys_cmd_t;

typedef union {
	uint16_t		wan_type;
	uint16_t 		inner_tpid;
	uint16_t 		outer_tpid;
	uint16_t 		epon_mode;
	uint16_t 		always_tpid;
} rdpa_drv_ioctl_sys_param_t;

typedef struct {
    rdpa_drv_ioctl_sys_cmd_t           cmd;
    rdpa_drv_ioctl_sys_param_t		param;
} rdpa_drv_ioctl_sys_t;

typedef struct
{
    uint16_t max_sa;                        /**< Max number of SAs that can be learnt on the port */
    uint16_t num_sa;                        /**< RO: Number of SAs learnt on the port. Ignored when setting configuration */
} rdpactl_port_sa_limit_t;

typedef enum {
    RDPA_IOCTL_PORT_CMD_SA_LIMIT_GET,
    RDPA_IOCTL_PORT_CMD_SA_LIMIT_SET,
    RDPA_IOCTL_PORT_CMD_SAL_MISS_ACTION_GET,
    RDPA_IOCTL_PORT_CMD_SAL_MISS_ACTION_SET,
    RDPA_IOCTL_PORT_CMD_DAL_MISS_ACTION_GET,
    RDPA_IOCTL_PORT_CMD_DAL_MISS_ACTION_SET,
    RDPA_IOCTL_PORT_CMD_MAX
} rdpa_drv_ioctl_port_cmd_t;

typedef union {
    uint8_t     sal_miss_action; /**< SA miss action */
    rdpactl_port_sa_limit_t    sa_limit;
    uint8_t     dal_miss_action; /**< DA miss action */
} rdpa_drv_ioctl_port_param_t;

typedef struct {
    rdpa_drv_ioctl_port_cmd_t       cmd;
    uint32_t                        port_idx;
    BOOL                            is_wan_side;
    rdpa_drv_ioctl_port_param_t		param;
} rdpa_drv_ioctl_port_t;

typedef enum {
    RDPA_IOCTL_BR_CMD_FIND_OBJ,
    RDPA_IOCTL_BR_CMD_LOCAL_SWITCH_SET,
    RDPA_IOCTL_BR_CMD_MAX
} rdpa_drv_ioctl_br_cmd_t;

typedef struct {
    rdpa_drv_ioctl_br_cmd_t         cmd;
    uint8_t		               br_index;
    BOOL                          found;
    BOOL                   local_switch;
} rdpa_drv_ioctl_br_t;

typedef enum {
    RDPA_IOCTL_LLID_CMD_NEW,
    RDPA_IOCTL_LLID_CMD_MAX
} rdpa_drv_ioctl_llid_cmd_t;

typedef struct {
    rdpa_drv_ioctl_llid_cmd_t     cmd;
    uint8_t                       llid_index;
} rdpa_drv_ioctl_llid_t;

typedef enum {
    RDPA_IOCTL_SPDSVC_CMD_ENABLE,
    RDPA_IOCTL_SPDSVC_CMD_GET_RESULT,
    RDPA_IOCTL_SPDSVC_CMD_DISABLE,
    RDPA_IOCTL_SPDSVC_CMD_MAX
} rdpa_drv_ioctl_spdsvc_cmd_t;

typedef struct {
    rdpactl_ip_t local_ip_addr;   /**< Local IP Address */
    uint16_t local_port_nbr;   /**< Local UDP Port Number */
    rdpactl_ip_t remote_ip_addr;  /**< Remote IP Address */
    uint16_t remote_port_nbr;  /**< Remote UDP Port Number */
    rdpactl_traffic_dir dir;      /**< Test Direction */
} rdpactl_spdsvc_config_t;

typedef struct {
    uint8_t running;      /**< 0: Test done; 1: Test in progress */
    uint32_t rx_packets;  /**< Number of packets received by the Analyzer */
    uint32_t rx_bytes;    /**< Number of bytes received by the Analyzer */
    uint32_t tx_packets;  /**< Number of packets transmitted by the Generator */
    uint32_t tx_bytes;    /**< Number of bytes transmitted by the Generator */
} rdpactl_spdsvc_result_t;

typedef struct {
    rdpa_drv_ioctl_spdsvc_cmd_t cmd;
    rdpactl_spdsvc_config_t config;
    rdpactl_spdsvc_result_t result;
} rdpa_drv_ioctl_spdsvc_t;

typedef enum {
    RDPA_IOCTL_DS_WAN_UDP_FILTER_CMD_ADD,
    RDPA_IOCTL_DS_WAN_UDP_FILTER_CMD_DELETE,
    RDPA_IOCTL_DS_WAN_UDP_FILTER_CMD_GET,
    RDPA_IOCTL_DS_WAN_UDP_FILTER_CMD_MAX
} rdpa_drv_ioctl_ds_wan_udp_filter_cmd_t;

typedef struct {
    long index;
    uint32_t offset;
    uint32_t value;
    uint32_t mask;
    uint32_t hits;
} rdpactl_ds_wan_udp_filter_t;

typedef struct {
    rdpa_drv_ioctl_ds_wan_udp_filter_cmd_t cmd;
    rdpactl_ds_wan_udp_filter_t filter;
} rdpa_drv_ioctl_ds_wan_udp_filter_t;

#endif /* __RDPA_DRV__H_INCLUDED__ */
