/* drivers/video/ili9481.h
 *
 * ILI9481 LCD controller configuration control.
 *
 * Copyright 2009 DSPG
 *	Shlomi Mor <shlomi.mor@dspg.comk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/


/* When sending commands to ILI9481 via SPI interface, each unit contains 9 bits: */
/* first bit selects whether this is opcode (0) or parameter (1), and the rest 8 bits are the value itself */
#define ILI9481_SPI_PARAMETER_BIT			0x100

/* ILI9481 Internal registers */
#define ILI9481_CMD_NOP					0x00
#define ILI9481_CMD_ENTER_SLEEP_MODE			0x10
#define ILI9481_CMD_EXIT_SLEEP_MODE			0x11
#define ILI9481_CMD_ENTER_PARTIAL_MODE			0x12
#define ILI9481_CMD_ENTER_NORMAL_MODE			0x13
#define ILI9481_CMD_EXIT_INVERT_MODE			0x20
#define ILI9481_CMD_ENTER_INVERT_MODE			0x21
#define ILI9481_CMD_SET_GAMMA_CURVE			0x26
#define ILI9481_CMD_SET_DISPLAY_OFF			0x28
#define ILI9481_CMD_SET_DISPLAY_ON			0x29
#define ILI9481_CMD_SET_COLUMN_ADDRESS			0x2A
#define ILI9481_CMD_SET_PAGE_ADDRESS			0x2B
#define ILI9481_CMD_WRITE_MEMORY_START			0x2C
#define ILI9481_CMD_WRITE_LUT				0x2D
#define ILI9481_CMD_SET_PARTIAL_AREA			0x30
#define ILI9481_CMD_SET_SCROLL_AREA			0x33
#define ILI9481_CMD_SET_TEAR_OFF			0x34
#define ILI9481_CMD_SET_TEAR_ON				0x35
#define ILI9481_CMD_SET_ADRESS_MODE			0x36
#define ILI9481_CMD_SET_SCROLL_START			0x37
#define ILI9481_CMD_EXIT_IDLE_MODE			0x38
#define ILI9481_CMD_ENTER_IDLE_MODE			0x39
#define ILI9481_CMD_SET_PIXEL_FORMAT			0x3A
#define ILI9481_CMD_WRITE_MEMORY_CONTINUE		0x3C
#define ILI9481_CMD_SET_TEAR_SCANLINE			0x44
#define ILI9481_CMD_COMMAND_ACCESS_PROTECT		0xB0
#define ILI9481_CMD_LOW_POWER_MODE_CONTROL		0xB1
#define ILI9481_CMD_FRAME_MEMORY_ACCESS			0xB3
#define ILI9481_CMD_DISPLAY_MODE_SETTING		0xB4
#define ILI9481_CMD_PANEL_DRIVING_SETTING		0xC0
#define ILI9481_CMD_DISPLAY_TIMING_SETTING_N		0xC1
#define ILI9481_CMD_DISPLAY_TIMING_SETTING_P		0xC2
#define ILI9481_CMD_DISPLAY_TIMING_SETTING_I		0xC3
#define ILI9481_CMD_FRAME_RATE_INV_CONTROL		0xC5
#define ILI9481_CMD_INTERFACE_CONTROL			0xC6
#define ILI9481_CMD_GAMMA_SETTING			0xC8
#define ILI9481_CMD_POWER_SETTING			0xD0
#define ILI9481_CMD_VCOM_CONTROL			0xD1
#define ILI9481_CMD_POWER_SETTING_MODE_N		0xD2
#define ILI9481_CMD_POWER_SETTING_MODE_P		0xD3
#define ILI9481_CMD_POWER_SETTING_MODE_I		0xD4


