/*
 *  DSPG dummy mouse driver for Linux/ARM
 *
 */

#include <linux/module.h>
#include <linux/ptrace.h>
#include <linux/interrupt.h>
#include <linux/init.h>
#include <linux/input.h>
#include <linux/io.h>

#include <mach/hardware.h>
#include <asm/irq.h>
#include <asm/hardware/iomd.h>

MODULE_AUTHOR("DSPG (Gal Sasson)");
MODULE_DESCRIPTION("Generic dummy mouse driver");
MODULE_LICENSE("GPL");

static struct input_dev *dummymouse_dev;

static int __init dummymouse_init(void)
{
	int err;

	dummymouse_dev = input_allocate_device();
	if (!dummymouse_dev)
		return -ENOMEM;

	dummymouse_dev->name = "DSPG Dummy Mouse";
	dummymouse_dev->phys = "dummymouse/input0";

    input_set_capability(dummymouse_dev, EV_REL, REL_X);
    input_set_capability(dummymouse_dev, EV_REL, REL_Y);
    input_set_capability(dummymouse_dev, EV_KEY, BTN_LEFT);
    input_set_capability(dummymouse_dev, EV_KEY, BTN_RIGHT);

	err = input_register_device(dummymouse_dev);
	if (err)
		goto err_free_dev;

	return 0;

 err_free_dev:
	input_free_device(dummymouse_dev);

	return err;
}

static void __exit dummymouse_exit(void)
{
	input_unregister_device(dummymouse_dev);
}

module_init(dummymouse_init);
module_exit(dummymouse_exit);
