/*
 *  linux/arch/arm/mach-dmw/include/mach/memory.h
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __MACH_MEMORY_H
#define __MACH_MEMORY_H

/*
 * NOTE: if too big, the DMA region will collide with IO_ADDRESS() direct
 * mappings starting at 0xf0000000. Right now, IO_ADDRESS() mappings
 * extend up to 0xf0400000 (exclusive).
 */
#define CONSISTENT_DMA_SIZE (SZ_128M + SZ_32M)

/*
 * Physical DRAM offset.
 */
#define PHYS_OFFSET UL(0x40000000)

/*
 * Virtual view <-> DMA view memory address translations
 * virt_to_bus: Used to translate the virtual address to an
 *              address suitable to be passed to set_dma_addr
 * bus_to_virt: Used to convert an address for DMA operations
 *              to an address that the kernel can use.
 */
#define __virt_to_bus(x)	__virt_to_phys(x)
#define __bus_to_virt(x)	__phys_to_virt(x)
#define __pfn_to_bus(p)		__pfn_to_phys(p)
#define __bus_to_pfn(b)		__phys_to_pfn(b)

#endif
