/*
 *  linux/arch/arm/mach-dmw/include/mach/hardware.h
 *
 *  This file contains the hardware definitions of the DMW base band family.
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __MACH_HARDWARE_H
#define __MACH_HARDWARE_H

#include <asm/sizes.h>
#include <mach/platform.h>
#include <mach/vmalloc.h>

#define IO_PHYS DMW_DEV_BASE

/* get virtual address for device: offset - dev base + addr */
#define IO_ADDRESS(a) (VMALLOC_END - 0x05000000 + (a))

#endif

