/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractCharVector;
import gnu.lists.FString;

public class CharVector
extends AbstractCharVector<Character> {
    public CharVector(char[] values) {
        this.data = values;
    }

    @Override
    public final Character getRaw(int index) {
        return Character.valueOf(this.data[index]);
    }

    @Override
    public final void setRaw(int index, Character value) {
        this.data[index] = value.charValue();
    }

    public static CharVector castOrNull(Object obj) {
        if (obj instanceof char[]) {
            return new CharVector((char[])obj);
        }
        if (obj instanceof CharVector) {
            return (CharVector)obj;
        }
        if (obj instanceof CharSequence) {
            char[] chars = obj instanceof FString ? ((FString)obj).toCharArray() : obj.toString().toCharArray();
            return new CharVector(chars);
        }
        return null;
    }

    public static CharVector cast(Object value) {
        CharVector vec = CharVector.castOrNull(value);
        if (vec == null) {
            String msg = value == null ? "cannot convert null to CharVector" : "cannot convert a " + value.getClass().getName() + " to CharVector";
            throw new ClassCastException(msg);
        }
        return vec;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof CharVector && CharVector.equals(this, (CharVector)obj);
    }

    @Override
    protected CharVector newInstance(int newLength) {
        return new CharVector(newLength < 0 ? this.data : new char[newLength]);
    }

    @Override
    public int getElementKind() {
        return 29;
    }

    @Override
    public String getTag() {
        return "c16";
    }
}

