/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure3;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import kawa.standard.Scheme;

public class SlotSet
extends Procedure3
implements CanInline,
Inlineable {
    boolean isStatic;
    boolean returnSelf;
    public static final SlotSet setField$Ex = new SlotSet("set-field!", false);
    public static final SlotSet setStaticField$Ex = new SlotSet("set-static-field!", true);
    public static final SlotSet setFieldReturnObject = new SlotSet("set-field-return-object!", false);

    public SlotSet(String string, boolean bl) {
        super(string);
        this.isStatic = bl;
    }

    public static void setField(Object object2, String string, Object object3) {
        SlotSet.apply(false, object2, string, object3);
    }

    public static void setStaticField(Object object2, String string, Object object3) {
        SlotSet.apply(true, object2, string, object3);
    }

    public static void apply(boolean bl, Object object2, String string, Object object3) {
        Interpreter interpreter = Interpreter.defaultInterpreter;
        boolean bl2 = false;
        string = Compilation.mangleNameIfNeeded(string);
        Class<?> clazz = bl ? SlotGet.coerceToClass(object2) : object2.getClass();
        try {
            Field field = clazz.getField(string);
            Class<?> clazz2 = field.getType();
            if ("gnu.mapping.Symbol".equals(clazz2.getName()) && (field.getModifiers() & 0x10) != 0) {
                ((Symbol)field.get(object2)).set(object3);
            } else {
                field.set(object2, interpreter.coerceFromObject(clazz2, object3));
            }
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            bl2 = true;
        }
        String string2 = ClassExp.slotToMethodName("get", string);
        try {
            java.lang.reflect.Method method = clazz.getMethod(string2, SlotGet.noClasses);
            String string3 = ClassExp.slotToMethodName("set", string);
            Class[] classArray = new Class[]{method.getReturnType()};
            java.lang.reflect.Method method2 = clazz.getMethod(string3, classArray);
            Object[] objectArray = new Object[]{interpreter.coerceFromObject(classArray[0], object3)};
            method2.invoke(object2, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            bl2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl2) {
            throw new RuntimeException("illegal access for field " + string);
        }
        throw new RuntimeException("no such field " + string + " in " + clazz.getName());
    }

    public Object apply3(Object object2, Object object3, Object object4) {
        SlotSet.apply(this.isStatic, object2, (String)object3, object4);
        return this.returnSelf ? object2 : Values.empty;
    }

    static Object getField(Type type, String string) {
        if (type instanceof ClassType && string != null) {
            ClassType classType = (ClassType)type;
            gnu.bytecode.Field field = classType.getField(Compilation.mangleNameIfNeeded(string));
            if (field != null) {
                return field;
            }
            String string2 = ClassExp.slotToMethodName("get", string);
            Method method = classType.getMethod(string2, Type.typeArray0);
            if (method == null) {
                return null;
            }
            Type type2 = method.getReturnType();
            String string3 = ClassExp.slotToMethodName("set", string);
            Type[] typeArray = new Type[]{type2};
            method = classType.getMethod(string3, typeArray);
            return method;
        }
        return null;
    }

    static void compileSet(Procedure procedure, ClassType classType, Expression expression, Object object2, Compilation compilation) {
        boolean bl;
        CodeAttr codeAttr = compilation.getCode();
        boolean bl2 = bl = procedure instanceof SlotSet && ((SlotSet)procedure).isStatic;
        if (object2 instanceof gnu.bytecode.Field) {
            boolean bl3;
            gnu.bytecode.Field field = (gnu.bytecode.Field)object2;
            boolean bl4 = field.getStaticFlag();
            Type type = field.getType();
            boolean bl5 = bl3 = "gnu.mapping.Symbol".equals(type.getName()) && (field.getModifiers() & 0x10) != 0;
            if (bl && !bl4) {
                compilation.error('e', "cannot access non-static field `" + field.getName() + "' using `" + procedure.getName() + '\'');
            }
            if (bl3) {
                if (bl4) {
                    codeAttr.emitGetStatic(field);
                } else {
                    codeAttr.emitGetField(field);
                }
            }
            expression.compile(compilation, bl3 ? Target.pushObject : Target.pushValue(type));
            if (bl3) {
                codeAttr.emitInvokeVirtual(Compilation.typeSymbol.getDeclaredMethod("set", 1));
            } else if (bl4) {
                codeAttr.emitPutStatic(field);
            } else {
                codeAttr.emitPutField(field);
            }
            return;
        }
        if (object2 instanceof Method) {
            Method method = (Method)object2;
            boolean bl6 = method.getStaticFlag();
            if (bl && !bl6) {
                compilation.error('e', "cannot call non-static getter method `" + method.getName() + "' using `" + procedure.getName() + '\'');
            }
            Type[] typeArray = method.getParameterTypes();
            expression.compile(compilation, Target.pushValue(typeArray[0]));
            if (bl6) {
                codeAttr.emitInvokeStatic(method);
            } else if (classType.isInterface()) {
                codeAttr.emitInvokeInterface(method);
            } else {
                codeAttr.emitInvokeVirtual(method);
            }
            return;
        }
    }

    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        if (this.isStatic) {
            return Invoke.inlineClassName(applyExp, 0, (InlineCalls)expWalker);
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        if (n != 3) {
            String string = n < 3 ? "too few" : "too many";
            compilation.error('e', string + " arguments to `" + this.getName() + '\'');
            compilation.compileConstant(null, target);
            return;
        }
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Expression expression3 = expressionArray[2];
        Type type = this.isStatic ? Scheme.exp2Type(expression) : expression.getType();
        Object object2 = null;
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            String string = ClassMethods.checkName(expression2, true);
            if (string != null) {
                object2 = SlotSet.getField(classType, string);
                if (object2 == null && type != Type.pointer_type) {
                    compilation.error('e', "no slot `" + string + "' in " + classType.getName());
                }
            } else if (expression2 instanceof QuoteExp && !((object2 = ((QuoteExp)expression2).getValue()) instanceof gnu.bytecode.Field) && !(object2 instanceof Method)) {
                object2 = null;
            }
            if (object2 != null) {
                boolean bl = object2 instanceof gnu.bytecode.Field ? ((gnu.bytecode.Field)object2).getStaticFlag() : ((Method)object2).getStaticFlag();
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue(classType));
                if (this.returnSelf) {
                    compilation.getCode().emitDup(classType);
                }
                SlotSet.compileSet(this, classType, expressionArray[2], object2, compilation);
                if (this.returnSelf) {
                    target.compileFromStack(compilation, classType);
                } else {
                    compilation.compileConstant(Values.empty, target);
                }
                return;
            }
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        if (this.returnSelf && expressionArray.length == 3) {
            return expressionArray[0].getType();
        }
        return Type.void_type;
    }

    static {
        SlotSet.setFieldReturnObject.returnSelf = true;
    }
}

