/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.expr.Special;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderIgnoreRestOfLine;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.util.GeneralHashTable;
import gnu.lists.Convert;
import gnu.lists.F32Vector;
import gnu.lists.F64Vector;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.lists.S16Vector;
import gnu.lists.S32Vector;
import gnu.lists.S64Vector;
import gnu.lists.S8Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import gnu.lists.U16Vector;
import gnu.lists.U32Vector;
import gnu.lists.U64Vector;
import gnu.lists.U8Vector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.math.BigDecimal;

public class LispReader
extends Lexer {
    GeneralHashTable<Integer, Object> sharedStructureTable;
    boolean inQuasiSyntax;
    char readCase = LispReader.lookupReadCase();
    public static final char TOKEN_ESCAPE_CHAR = '\uffff';
    protected boolean seenEscapes;
    static final int SCM_COMPLEX = 1;
    public static final int SCM_NUMBERS = 1;

    public LispReader(LineBufferedReader port) {
        super(port);
    }

    public LispReader(LineBufferedReader port, SourceMessages messages) {
        super(port, messages);
    }

    public Object bindSharedObject(int sharingIndex, Object value) {
        if (sharingIndex >= 0) {
            Integer key;
            GeneralHashTable<Integer, Object> map = this.sharedStructureTable;
            if (map == null) {
                map = new GeneralHashTable();
                this.sharedStructureTable = map;
            }
            if (map.get(key = Integer.valueOf(sharingIndex), this) != this) {
                this.error('w', "a duplicate #n= definition was read");
            }
            map.put(key, value);
        }
        return value;
    }

    public final void readNestedComment(char c1, char c2) throws IOException, SyntaxException {
        int commentNesting = 1;
        int startLine = this.port.getLineNumber();
        int startColumn = this.port.getColumnNumber();
        do {
            int c;
            if ((c = this.read()) == 124) {
                c = this.read();
                if (c == c1) {
                    --commentNesting;
                }
            } else if (c == c1 && (c = this.read()) == c2) {
                ++commentNesting;
            }
            if (c >= 0) continue;
            this.eofError("unexpected end-of-file in " + c1 + c2 + " comment starting here", startLine + 1, startColumn - 1);
            return;
        } while (commentNesting > 0);
    }

    public char getReadCase() {
        return this.readCase;
    }

    public void setReadCase(char readCase) {
        this.readCase = readCase;
    }

    static char lookupReadCase() {
        try {
            String read_case_string = Environment.getCurrent().get("symbol-read-case", (Object)"P").toString();
            if (read_case_string.length() > 0) {
                int read_case = read_case_string.charAt(0);
                if (read_case != 80) {
                    if (read_case == 117) {
                        read_case = 85;
                    } else if (read_case == 100 || read_case == 108 || read_case == 76) {
                        read_case = 68;
                    } else if (read_case == 105) {
                        read_case = 73;
                    }
                }
                return (char)read_case;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return '\u0000';
    }

    public Object readValues(int ch, ReadTable rtable, int sharingIndex) throws IOException, SyntaxException {
        return this.readValues(ch, rtable.lookup(ch), rtable, sharingIndex);
    }

    public Object readValues(int ch, ReadTableEntry entry, ReadTable rtable, int sharingIndex) throws IOException, SyntaxException {
        int startPos = this.tokenBufferLength;
        this.seenEscapes = false;
        int kind = entry.getKind();
        switch (kind) {
            case 0: {
                String err = "invalid character #\\" + (char)ch;
                if (this.interactive) {
                    this.fatal(err);
                } else {
                    this.error(err);
                }
                return Values.empty;
            }
            case 1: {
                return Values.empty;
            }
            case 5: 
            case 6: {
                return entry.read(this, ch, -1, sharingIndex);
            }
        }
        Object result = this.readAndHandleToken(ch, startPos, rtable);
        return this.bindSharedObject(sharingIndex, result);
    }

    protected Object readAndHandleToken(int ch, int startPos, ReadTable rtable) throws IOException, SyntaxException {
        Object value;
        this.readToken(ch, this.getReadCase(), rtable);
        int endPos = this.tokenBufferLength;
        if (!this.seenEscapes && (value = LispReader.parseNumber(this.tokenBuffer, startPos, endPos - startPos, '\u0000', 0, 1)) != null && !(value instanceof String)) {
            return value;
        }
        int readCase = this.getReadCase();
        if (readCase == 73) {
            int upperCount = 0;
            int lowerCount = 0;
            for (int i = startPos; i < endPos; ++i) {
                char ci = this.tokenBuffer[i];
                if (ci == '\uffff') {
                    ++i;
                    continue;
                }
                if (Character.isLowerCase(ci)) {
                    ++lowerCount;
                    continue;
                }
                if (!Character.isUpperCase(ci)) continue;
                ++upperCount;
            }
            readCase = lowerCount == 0 ? 68 : (upperCount == 0 ? 85 : 80);
        }
        boolean handleUri = endPos >= startPos + 2 && this.tokenBuffer[endPos - 1] == '}' && this.tokenBuffer[endPos - 2] != '\uffff' && this.peek() == 58;
        int packageMarker = -1;
        int lbrace = -1;
        int rbrace = -1;
        int braceNesting = 0;
        int j = startPos;
        boolean uriBad = false;
        for (int i = startPos; i < endPos; ++i) {
            char ci = this.tokenBuffer[i];
            if (ci == '\uffff') {
                if (++i >= endPos) continue;
                this.tokenBuffer[j++] = this.tokenBuffer[i];
                continue;
            }
            if (handleUri) {
                if (ci == '{') {
                    if (lbrace < 0) {
                        lbrace = j;
                    } else if (braceNesting == 0) {
                        uriBad = true;
                    }
                    ++braceNesting;
                } else if (ci == '}') {
                    if (--braceNesting < 0) {
                        uriBad = true;
                    } else if (braceNesting == 0) {
                        if (rbrace < 0) {
                            rbrace = j;
                        } else {
                            uriBad = true;
                        }
                    }
                }
            }
            if (braceNesting <= 0) {
                if (ci == ':') {
                    packageMarker = packageMarker >= 0 ? -1 : j;
                } else if (readCase == 85) {
                    ci = Character.toUpperCase(ci);
                } else if (readCase == 68) {
                    ci = Character.toLowerCase(ci);
                }
            }
            this.tokenBuffer[j++] = ci;
        }
        endPos = j;
        int len = endPos - startPos;
        if (lbrace >= 0 && rbrace > lbrace) {
            String prefix = lbrace > 0 ? new String(this.tokenBuffer, startPos, lbrace - startPos) : null;
            String uri = new String(this.tokenBuffer, ++lbrace, rbrace - lbrace);
            ch = this.read();
            ch = this.read();
            Object rightOperand = this.readValues(ch, rtable.lookup(ch), rtable, -1);
            if (!(rightOperand instanceof SimpleSymbol)) {
                this.error("expected identifier in symbol after '{URI}:'");
            }
            return Symbol.valueOf(rightOperand.toString(), uri, prefix);
        }
        if (rtable.initialColonIsKeyword && packageMarker == startPos && len > 1) {
            String str = new String(this.tokenBuffer, ++startPos, endPos - startPos);
            return Keyword.make(str.intern());
        }
        if (rtable.finalColonIsKeyword && packageMarker == endPos - 1 && (len > 1 || this.seenEscapes)) {
            String str = new String(this.tokenBuffer, startPos, len - 1);
            return Keyword.make(str.intern());
        }
        return ReadTable.makeSymbol(new String(this.tokenBuffer, startPos, len));
    }

    /*
     * Enabled aggressive block sorting
     */
    void readToken(int ch, char readCase, ReadTable rtable) throws IOException, SyntaxException {
        boolean inEscapes = false;
        int braceNesting = 0;
        while (true) {
            block25: {
                ReadTableEntry entry;
                int kind;
                block26: {
                    if (ch < 0) {
                        if (!inEscapes) return;
                        this.eofError("unexpected EOF between escapes");
                    }
                    if ((kind = (entry = rtable.lookup(ch)).getKind()) != 0) break block26;
                    if (inEscapes) {
                        this.tokenBufferAppend(65535);
                        this.tokenBufferAppend(ch);
                        break block25;
                    } else if (ch == 125 && --braceNesting >= 0) {
                        this.tokenBufferAppend(ch);
                        break block25;
                    } else {
                        this.unread(ch);
                        return;
                    }
                }
                if (ch == rtable.postfixLookupOperator && !inEscapes) {
                    int next = this.port.peek();
                    if (next == rtable.postfixLookupOperator) {
                        this.unread(ch);
                        return;
                    }
                    if (this.validPostfixLookupStart(next, rtable)) {
                        kind = 5;
                    }
                }
                if (kind == 3) {
                    ch = this.read();
                    if (ch < 0) {
                        this.eofError("unexpected EOF after single escape");
                    }
                    if (rtable.hexEscapeAfterBackslash && (ch == 120 || ch == 88)) {
                        ch = this.readHexEscape();
                    }
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(ch);
                    this.seenEscapes = true;
                } else if (kind == 4) {
                    inEscapes = !inEscapes;
                    this.seenEscapes = true;
                } else if (inEscapes) {
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(ch);
                } else {
                    switch (kind) {
                        case 2: {
                            if (ch == 123 && entry == ReadTableEntry.brace) {
                                ++braceNesting;
                            }
                        }
                        case 6: {
                            this.tokenBufferAppend(ch);
                            break;
                        }
                        case 4: {
                            inEscapes = true;
                            this.seenEscapes = true;
                            break;
                        }
                        case 5: {
                            this.unread(ch);
                            return;
                        }
                        case 1: {
                            this.unread(ch);
                            return;
                        }
                    }
                }
            }
            ch = this.read();
        }
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.readObjectWithSharing(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObjectWithSharing(int sharingIndex) throws IOException, SyntaxException {
        char saveReadState = ((InPort)this.port).readState;
        int startPos = this.tokenBufferLength;
        ((InPort)this.port).readState = (char)32;
        try {
            int column;
            int line;
            int ch;
            Object value;
            ReadTable rtable = ReadTable.getCurrent();
            do {
                line = this.port.getLineNumber();
                column = this.port.getColumnNumber();
                ch = this.port.read();
                if (ch >= 0) continue;
                Object object2 = Sequence.eofValue;
                return object2;
            } while ((value = this.readValues(ch, rtable, sharingIndex)) == Values.empty);
            Object object3 = value = this.handlePostfix(value, rtable, line, column);
            return object3;
        }
        finally {
            this.tokenBufferLength = startPos;
            ((InPort)this.port).readState = saveReadState;
        }
    }

    protected boolean validPostfixLookupStart(int ch, ReadTable rtable) throws IOException {
        if (ch < 0 || ch == rtable.postfixLookupOperator) {
            return false;
        }
        if (ch == 44) {
            return true;
        }
        int kind = rtable.lookup(ch).getKind();
        return kind == 2 || kind == 6 || kind == 4 || kind == 3;
    }

    Object handlePostfix(Object value, ReadTable rtable, int line, int column) throws IOException, SyntaxException {
        if (value == QuoteExp.voidExp) {
            value = Values.empty;
        }
        while (true) {
            int ch;
            if ((ch = this.port.peek()) == 91) {
                if (ReadTable.defaultBracketMode == -2) {
                    this.port.read();
                    Object lst = ReaderParens.readList(this, null, ch, 1, 93, -1);
                    value = PairWithPosition.make(value, lst, this.port.getName(), line + 1, column + 1);
                    value = PairWithPosition.make(LispLanguage.bracket_apply_sym, value, this.port.getName(), line + 1, column + 1);
                    continue;
                }
            }
            if (ch != rtable.postfixLookupOperator) break;
            this.port.read();
            int ch2 = this.port.peek();
            if (!this.validPostfixLookupStart(ch2, rtable)) {
                this.unread();
                break;
            }
            ch = this.port.read();
            Object rightOperand = this.readValues(ch, rtable.lookup(ch), rtable, -1);
            value = LList.list2(value, LList.list2(ReadTable.makeSymbol("quasiquote"), rightOperand));
            value = PairWithPosition.make(LispLanguage.lookup_sym, value, this.port.getName(), line + 1, column + 1);
        }
        return value;
    }

    private boolean isPotentialNumber(char[] buffer, int start, int end) {
        int sawDigits = 0;
        for (int i = start; i < end; ++i) {
            char ch = buffer[i];
            if (Character.isDigit(ch)) {
                ++sawDigits;
                continue;
            }
            if (ch == '-' || ch == '+') {
                if (i + 1 != end) continue;
                return false;
            }
            if (ch == '#') {
                return true;
            }
            if (!(Character.isLetter(ch) || ch == '/' || ch == '_' || ch == '^' ? i == start : ch != '.')) continue;
            return false;
        }
        return sawDigits > 0;
    }

    public static Object parseNumber(CharSequence str, int radix) {
        char[] buf = str instanceof FString ? ((FString)str).data : str.toString().toCharArray();
        int len = str.length();
        return LispReader.parseNumber(buf, 0, len, '\u0000', radix, 1);
    }

    public static Object parseNumber(char[] buffer, int start, int count, char exactness, int radix, int flags) {
        double d;
        boolean sign_seen;
        boolean negative;
        char ch;
        int end;
        int pos;
        block96: {
            pos = start;
            end = start + count;
            if (pos >= end) {
                return "no digits";
            }
            ch = buffer[pos++];
            while (ch == '#') {
                if (pos >= end) {
                    return "no digits";
                }
                ch = buffer[pos++];
                switch (ch) {
                    case 'B': 
                    case 'b': {
                        if (radix != 0) {
                            return "duplicate radix specifier";
                        }
                        radix = 2;
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        if (radix != 0) {
                            return "duplicate radix specifier";
                        }
                        radix = 8;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (radix != 0) {
                            return "duplicate radix specifier";
                        }
                        radix = 10;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        if (radix != 0) {
                            return "duplicate radix specifier";
                        }
                        radix = 16;
                        break;
                    }
                    case 'E': 
                    case 'I': 
                    case 'e': 
                    case 'i': {
                        if (exactness != '\u0000') {
                            if (exactness == ' ') {
                                return "non-prefix exactness specifier";
                            }
                            return "duplicate exactness specifier";
                        }
                        exactness = ch;
                        break;
                    }
                    default: {
                        int dig;
                        int value = 0;
                        while ((dig = Character.digit(ch, 10)) >= 0) {
                            value = 10 * value + dig;
                            if (pos >= end) {
                                return "missing letter after '#'";
                            }
                            ch = buffer[pos++];
                        }
                        if (ch == 'R' || ch == 'r') {
                            if (radix != 0) {
                                return "duplicate radix specifier";
                            }
                            if (value < 2 || value > 35) {
                                return "invalid radix specifier";
                            }
                            radix = value;
                            break;
                        }
                        return "unknown modifier '#" + ch + '\'';
                    }
                }
                if (pos >= end) {
                    return "no digits";
                }
                ch = buffer[pos++];
            }
            if (exactness == '\u0000') {
                exactness = (char)32;
            }
            if (radix == 0) {
                int i = count;
                do {
                    if (--i >= 0) continue;
                    radix = 10;
                    break block96;
                } while (buffer[start + i] != '.');
                radix = 10;
            }
        }
        boolean numeratorNegative = negative = ch == '-';
        boolean bl = sign_seen = ch == '-' || ch == '+';
        if (sign_seen) {
            if (pos >= end) {
                return "no digits following sign";
            }
            ch = buffer[pos++];
        }
        if ((ch == 'i' || ch == 'I') && pos == end && start == pos - 2 && (flags & 1) != 0) {
            char sign = buffer[start];
            if (sign != '+' && sign != '-') {
                return "no digits";
            }
            if (exactness == 'i' || exactness == 'I') {
                return new DComplex(0.0, negative ? -1.0 : 1.0);
            }
            return negative ? Complex.imMinusOne() : Complex.imOne();
        }
        int realStart = pos - 1;
        boolean hash_seen = false;
        int exp_seen = -1;
        int digits_start = -1;
        int decimal_point = -1;
        boolean copy_needed = false;
        boolean underscore_seen = false;
        IntNum numerator = null;
        long lvalue = 0L;
        block20: while (true) {
            int digit;
            if ((digit = Character.digit(ch, radix)) >= 0) {
                if (hash_seen && decimal_point < 0) {
                    return "digit after '#' in number";
                }
                if (digits_start < 0) {
                    digits_start = pos - 1;
                }
                lvalue = (long)radix * lvalue + (long)digit;
            } else {
                switch (ch) {
                    case '.': {
                        if (decimal_point >= 0) {
                            return "duplicate '.' in number";
                        }
                        if (radix != 10) {
                            return "'.' in non-decimal number";
                        }
                        decimal_point = pos - 1;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'L': 
                    case 'S': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'l': 
                    case 's': {
                        if (pos == end || radix != 10) {
                            --pos;
                            break block20;
                        }
                        char next = buffer[pos];
                        int exp_pos = pos - 1;
                        if (next == '+' || next == '-') {
                            if (++pos >= end || Character.digit(buffer[pos], 10) < 0) {
                                return "missing exponent digits";
                            }
                        } else if (Character.digit(next, 10) < 0) {
                            --pos;
                            break block20;
                        }
                        if (exp_seen >= 0) {
                            return "duplicate exponent";
                        }
                        if (radix != 10) {
                            return "exponent in non-decimal number";
                        }
                        if (digits_start < 0) {
                            return "mantissa with no digits";
                        }
                        exp_seen = exp_pos;
                        while (++pos < end && Character.digit(buffer[pos], 10) >= 0) {
                        }
                        break block20;
                    }
                    case '/': {
                        if (numerator != null) {
                            return "multiple fraction symbol '/'";
                        }
                        if (digits_start < 0) {
                            return "no digits before fraction symbol '/'";
                        }
                        if (exp_seen >= 0 || decimal_point >= 0) {
                            return "fraction symbol '/' following exponent or '.'";
                        }
                        numerator = LispReader.valueOf(buffer, digits_start, pos - digits_start, radix, negative, lvalue);
                        digits_start = -1;
                        lvalue = 0L;
                        negative = false;
                        hash_seen = false;
                        underscore_seen = false;
                        break;
                    }
                    default: {
                        --pos;
                        break block20;
                    }
                }
            }
            if (pos == end) break;
            ch = buffer[pos++];
        }
        int infnan = 0;
        if (digits_start < 0) {
            if (sign_seen && pos + 4 < end && buffer[pos + 3] == '.' && buffer[pos + 4] == '0') {
                if (buffer[pos] == 'i' && buffer[pos + 1] == 'n' && buffer[pos + 2] == 'f') {
                    infnan = 105;
                } else if (buffer[pos] == 'n' && buffer[pos + 1] == 'a' && buffer[pos + 2] == 'n') {
                    infnan = 110;
                }
            }
            if (infnan == 0) {
                return "no digits";
            }
            pos += 5;
        }
        if (hash_seen || underscore_seen) {
            // empty if block
        }
        boolean inexact = exactness == 'i' || exactness == 'I' || exactness == ' ' && hash_seen;
        RealNum number = null;
        char exp_char = '\u0000';
        if (infnan != 0) {
            inexact = true;
            d = infnan == 105 ? Double.POSITIVE_INFINITY : Double.NaN;
            number = new DFloNum(negative ? -d : d);
        } else if (exp_seen >= 0 || decimal_point >= 0) {
            if (digits_start > decimal_point && decimal_point >= 0) {
                digits_start = decimal_point;
            }
            if (numerator != null) {
                return "floating-point number after fraction symbol '/'";
            }
            String str = new String(buffer, digits_start, pos - digits_start);
            if (exp_seen >= 0 && (exp_char = Character.toLowerCase(buffer[exp_seen])) != 'e') {
                int prefix = exp_seen - digits_start;
                str = str.substring(0, prefix) + 'e' + str.substring(prefix + 1);
            }
            double d2 = Convert.parseDouble(str);
            number = new DFloNum(negative ? -d2 : d2);
        } else {
            IntNum iresult = LispReader.valueOf(buffer, digits_start, pos - digits_start, radix, negative, lvalue);
            if (numerator == null) {
                number = iresult;
            } else if (iresult.isZero()) {
                boolean numeratorZero = numerator.isZero();
                if (inexact) {
                    number = new DFloNum(numeratorZero ? Double.NaN : (numeratorNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY));
                } else {
                    if (numeratorZero) {
                        return "0/0 is undefined";
                    }
                    number = RatNum.make(numerator, iresult);
                }
            } else {
                number = RatNum.make(numerator, iresult);
            }
            if (inexact && number.isExact()) {
                number = new DFloNum(numeratorNegative && number.isZero() ? -0.0 : number.doubleValue());
            }
        }
        if (exactness == 'e' || exactness == 'E') {
            number = number.toExact();
        }
        if (pos < end) {
            char prev;
            if ((ch = buffer[pos++]) == '@') {
                Object angle = LispReader.parseNumber(buffer, pos, end - pos, exactness, 10, flags);
                if (angle instanceof String) {
                    return angle;
                }
                if (!(angle instanceof RealNum)) {
                    return "invalid complex polar constant";
                }
                RealNum rangle = (RealNum)angle;
                if (number.isZero() && !rangle.isExact()) {
                    return new DFloNum(0.0);
                }
                return Complex.polar(number, rangle);
            }
            if (ch == '-' || ch == '+') {
                Object imag;
                if ((imag = LispReader.parseNumber(buffer, --pos, end - pos, exactness, 10, flags)) instanceof String) {
                    return imag;
                }
                if (!(imag instanceof Complex)) {
                    return "invalid numeric constant (" + imag + ")";
                }
                Complex cimag = (Complex)imag;
                RealNum re = cimag.re();
                if (!re.isZero()) {
                    return "invalid numeric constant";
                }
                return Complex.make(number, cimag.im());
            }
            int lcount = 0;
            while (true) {
                if (!Character.isLetter(ch)) {
                    --pos;
                    break;
                }
                ++lcount;
                if (pos == end) break;
                ch = buffer[pos++];
            }
            if (lcount == 1 && ((prev = buffer[pos - 1]) == 'i' || prev == 'I')) {
                if (pos < end) {
                    return "junk after imaginary suffix 'i'";
                }
                return Complex.make(IntNum.zero(), number);
            }
            return "excess junk after number";
        }
        if (number instanceof DFloNum && exp_char > '\u0000' && exp_char != 'e') {
            d = number.doubleValue();
            switch (exp_char) {
                case 'f': 
                case 's': {
                    return Float.valueOf((float)d);
                }
                case 'd': {
                    return d;
                }
                case 'l': {
                    return BigDecimal.valueOf(d);
                }
            }
        }
        return number;
    }

    private static IntNum valueOf(char[] buffer, int digits_start, int number_of_digits, int radix, boolean negative, long lvalue) {
        if (number_of_digits + radix <= 28) {
            return IntNum.make(negative ? -lvalue : lvalue);
        }
        return IntNum.valueOf(buffer, digits_start, number_of_digits, radix, negative);
    }

    public int readEscape() throws IOException, SyntaxException {
        int c = this.read();
        if (c < 0) {
            this.eofError("unexpected EOF in character literal");
            return -1;
        }
        return this.readEscape(c);
    }

    public final int readEscape(int c) throws IOException, SyntaxException {
        block0 : switch ((char)c) {
            case 'a': {
                c = 7;
                break;
            }
            case 'b': {
                c = 8;
                break;
            }
            case 't': {
                c = 9;
                break;
            }
            case 'n': {
                c = 10;
                break;
            }
            case 'v': {
                c = 11;
                break;
            }
            case 'f': {
                c = 12;
                break;
            }
            case 'r': {
                c = 13;
                break;
            }
            case 'e': {
                c = 27;
                break;
            }
            case '\"': {
                c = 34;
                break;
            }
            case '\\': {
                c = 92;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                while (true) {
                    if (c < 0) {
                        this.eofError("unexpected EOF in literal");
                        return -1;
                    }
                    if (c == 10) break;
                    if (c == 13) {
                        if (this.peek() == 10) {
                            this.skip();
                        }
                        c = 10;
                        break;
                    }
                    if (c != 32 && c != 9) {
                        this.unread(c);
                        break;
                    }
                    c = this.read();
                }
                if (c != 10) break;
                do {
                    if ((c = this.read()) >= 0) continue;
                    this.eofError("unexpected EOF in literal");
                    return -1;
                } while (c == 32 || c == 9);
                this.unread(c);
                return -2;
            }
            case 'M': {
                c = this.read();
                if (c != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
                c = this.read();
                if (c == 92) {
                    c = this.readEscape();
                }
                return c | 0x80;
            }
            case 'C': {
                c = this.read();
                if (c != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
            }
            case '^': {
                c = this.read();
                if (c == 92) {
                    c = this.readEscape();
                }
                if (c == 63) {
                    return 127;
                }
                return c & 0x9F;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                c -= 48;
                int count = 0;
                while (++count < 3) {
                    int d = this.read();
                    int v = Character.digit((char)d, 8);
                    if (v >= 0) {
                        c = (c << 3) + v;
                        continue;
                    }
                    if (d < 0) break block0;
                    this.unread(d);
                    break block0;
                }
                break;
            }
            case 'u': {
                c = 0;
                int i = 4;
                while (--i >= 0) {
                    int v;
                    int d = this.read();
                    if (d < 0) {
                        this.eofError("premature EOF in \\u escape");
                    }
                    if ((v = Character.digit((char)d, 16)) < 0) {
                        this.error("non-hex character following \\u");
                    }
                    c = 16 * c + v;
                }
                break;
            }
            case 'X': 
            case 'x': {
                return this.readHexEscape();
            }
        }
        return c;
    }

    public int readHexEscape() throws IOException, SyntaxException {
        int c;
        block1: {
            int d;
            int v;
            c = 0;
            while ((v = Character.digit((char)(d = this.read()), 16)) >= 0) {
                c = (c << 4) + v;
            }
            if (d == 59 || d < 0) break block1;
            this.unread(d);
        }
        return c;
    }

    public final Object readObject(int c) throws IOException, SyntaxException {
        this.unread(c);
        return this.readObject();
    }

    public Object readCommand() throws IOException, SyntaxException {
        return this.readObject();
    }

    protected Object makeNil() {
        return LList.Empty;
    }

    protected Pair makePair(Object car, int line, int column) {
        return this.makePair(car, LList.Empty, line, column);
    }

    protected Pair makePair(Object car, Object cdr, int line, int column) {
        String pname = this.port.getName();
        if (pname != null && line >= 0) {
            return PairWithPosition.make(car, cdr, pname, line + 1, column + 1);
        }
        return Pair.make(car, cdr);
    }

    protected void setCar(Object pair, Object car) {
        ((Pair)pair).setCarBackdoor(car);
    }

    protected void setCdr(Object pair, Object cdr) {
        ((Pair)pair).setCdrBackdoor(cdr);
    }

    public static Object readNumberWithRadix(int previous, LispReader reader, int radix) throws IOException, SyntaxException {
        int startPos = reader.tokenBufferLength - previous;
        reader.readToken(reader.read(), 'P', ReadTable.getCurrent());
        int endPos = reader.tokenBufferLength;
        if (startPos == endPos) {
            reader.error("missing numeric token");
            return IntNum.zero();
        }
        Object result = LispReader.parseNumber(reader.tokenBuffer, startPos, endPos - startPos, '\u0000', radix, 0);
        if (result instanceof String) {
            reader.error((String)result);
            return IntNum.zero();
        }
        if (result == null) {
            reader.error("invalid numeric constant");
            return IntNum.zero();
        }
        return result;
    }

    public static Object readCharacter(LispReader reader) throws IOException, SyntaxException {
        int i;
        int value;
        int ch = reader.read();
        if (ch < 0) {
            reader.eofError("unexpected EOF in character literal");
        }
        int startPos = reader.tokenBufferLength;
        reader.tokenBufferAppend(ch);
        reader.readToken(reader.read(), 'D', ReadTable.getCurrent());
        char[] tokenBuffer = reader.tokenBuffer;
        int length = reader.tokenBufferLength - startPos;
        if (length == 1) {
            return Char.make(tokenBuffer[startPos]);
        }
        String name = new String(tokenBuffer, startPos, length);
        ch = Char.nameToChar(name);
        if (ch >= 0) {
            return Char.make(ch);
        }
        ch = tokenBuffer[startPos];
        if (ch == 120 || ch == 88) {
            value = 0;
            i = 1;
            while (true) {
                if (i == length) {
                    return Char.make(value);
                }
                int v = Character.digit(tokenBuffer[startPos + i], 16);
                if (v < 0 || (value = 16 * value + v) > 0x10FFFF) break;
                ++i;
            }
        }
        if ((ch = Character.digit(ch, 8)) >= 0) {
            value = ch;
            i = 1;
            while (true) {
                if (i == length) {
                    return Char.make(value);
                }
                ch = Character.digit(tokenBuffer[startPos + i], 8);
                if (ch < 0) break;
                value = 8 * value + ch;
                ++i;
            }
        }
        reader.error("unknown character name: " + name);
        return Char.make(63);
    }

    public static Object readSpecial(LispReader reader) throws IOException, SyntaxException {
        int ch = reader.read();
        if (ch < 0) {
            reader.eofError("unexpected EOF in #! special form");
        }
        if (ch == 47 && reader.getLineNumber() == 0 && reader.getColumnNumber() == 3) {
            ReaderIgnoreRestOfLine.getInstance().read(reader, 35, 1);
            return Values.empty;
        }
        int startPos = reader.tokenBufferLength;
        reader.tokenBufferAppend(ch);
        reader.readToken(reader.read(), 'D', ReadTable.getCurrent());
        int length = reader.tokenBufferLength - startPos;
        String name = new String(reader.tokenBuffer, startPos, length);
        if (name.equals("optional")) {
            return Special.optional;
        }
        if (name.equals("rest")) {
            return Special.rest;
        }
        if (name.equals("key")) {
            return Special.key;
        }
        if (name.equals("eof")) {
            return Special.eof;
        }
        if (name.equals("void")) {
            return QuoteExp.voidExp;
        }
        if (name.equals("default")) {
            return Special.dfault;
        }
        if (name.equals("undefined")) {
            return Special.undefined;
        }
        if (name.equals("abstract")) {
            return Special.abstractSpecial;
        }
        if (name.equals("native")) {
            return Special.nativeSpecial;
        }
        if (name.equals("null")) {
            return null;
        }
        if (name.equals("fold-case")) {
            reader.readCase = (char)68;
            return Values.empty;
        }
        if (name.equals("no-fold-case")) {
            reader.readCase = (char)80;
            return Values.empty;
        }
        reader.error("unknown named constant #!" + name);
        return null;
    }

    public static SimpleVector readSimpleVector(LispReader reader, char kind) throws IOException, SyntaxException {
        int ch;
        int size = 0;
        while (true) {
            int digit;
            if ((ch = reader.read()) < 0) {
                reader.eofError("unexpected EOF reading uniform vector");
            }
            if ((digit = Character.digit((char)ch, 10)) < 0) break;
            size = size * 10 + digit;
        }
        if (size != 8 && size != 16 && size != 32 && size != 64 || kind == 'F' && size < 32 || ch != 40) {
            reader.error("invalid uniform vector syntax");
            return null;
        }
        Object list = ReaderParens.readList(reader, null, 40, -1, 41, -1);
        int len = LList.listLength(list, false);
        if (len < 0) {
            reader.error("invalid elements in uniform vector syntax");
            return null;
        }
        Sequence q = (Sequence)list;
        switch (kind) {
            case 'F': {
                switch (size) {
                    case 32: {
                        return new F32Vector(q);
                    }
                    case 64: {
                        return new F64Vector(q);
                    }
                }
            }
            case 'S': {
                switch (size) {
                    case 8: {
                        return new S8Vector(q);
                    }
                    case 16: {
                        return new S16Vector(q);
                    }
                    case 32: {
                        return new S32Vector(q);
                    }
                    case 64: {
                        return new S64Vector(q);
                    }
                }
            }
            case 'U': {
                switch (size) {
                    case 8: {
                        return new U8Vector(q);
                    }
                    case 16: {
                        return new U16Vector(q);
                    }
                    case 32: {
                        return new U32Vector(q);
                    }
                    case 64: {
                        return new U64Vector(q);
                    }
                }
            }
        }
        return null;
    }
}

