/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter;

import gnu.prolog.io.PrologStream;
import gnu.prolog.io.TermWriter;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.interpreter.TracerEvent;
import gnu.prolog.vm.interpreter.TracerEventListener;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tracer {
    public static final Set<CompoundTermTag> UNTRACEABLE = new HashSet<CompoundTermTag>();
    protected boolean tracingActive;
    protected Map<CompoundTermTag, EnumSet<TraceLevel>> tracePoints;
    protected PrologStream output;
    protected Set<TracerEventListener> listeners;
    protected static final int callStackGrow = 4096;
    protected CompoundTermTag[] callStack = new CompoundTermTag[4096];
    protected int callStackPointer = 0;
    protected int callStackMax = 4096;

    static {
        UNTRACEABLE.add(CompoundTermTag.get("trace", 0));
        UNTRACEABLE.add(CompoundTermTag.get("untrace", 0));
        UNTRACEABLE.add(CompoundTermTag.get("tracing", 0));
    }

    public Tracer(PrologStream stdout) {
        this.listeners = new HashSet<TracerEventListener>();
        this.tracePoints = new HashMap<CompoundTermTag, EnumSet<TraceLevel>>();
        this.output = stdout;
    }

    public void addTracerEventListener(TracerEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeTracerEventListener(TracerEventListener listener) {
        this.listeners.remove(listener);
    }

    public void setActive(boolean tracingActive) {
        this.tracingActive = tracingActive;
    }

    public boolean isActive() {
        return this.tracingActive;
    }

    public void setTrace(CompoundTermTag pred, EnumSet<TraceLevel> levels) {
        this.tracePoints.put(pred, EnumSet.copyOf(levels));
        this.println(String.format("%% Tracing %s for %s", pred, levels));
    }

    public void addTrace(CompoundTermTag pred, EnumSet<TraceLevel> levels) {
        if (UNTRACEABLE.contains(pred)) {
            return;
        }
        EnumSet<TraceLevel> set = this.tracePoints.get(pred);
        if (set == null) {
            set = EnumSet.copyOf(levels);
            this.tracePoints.put(pred, set);
        } else {
            set.addAll(levels);
        }
        this.println(String.format("%% Tracing %s for %s", pred, set));
    }

    public void addTrace(CompoundTermTag pred, TraceLevel level) {
        this.addTrace(pred, EnumSet.of(level));
    }

    public void removeTrace(CompoundTermTag pred) {
        this.tracePoints.remove(pred);
        this.println(String.format("%% Not tracing %s", pred));
    }

    public void removeTrace(CompoundTermTag pred, EnumSet<TraceLevel> levels) {
        EnumSet<TraceLevel> set = this.tracePoints.get(pred);
        if (set != null) {
            set.removeAll(levels);
            if (set.isEmpty()) {
                this.tracePoints.remove(pred);
                this.println(String.format("%% Not tracing %s", pred));
            } else {
                this.println(String.format("%% Tracing %s for %s", pred, set));
            }
        }
    }

    public void removeTrace(CompoundTermTag pred, TraceLevel level) {
        this.removeTrace(pred, EnumSet.of(level));
    }

    public void removeAllTraces() {
        this.tracePoints.clear();
    }

    public CompoundTermTag[] getCallStack() {
        CompoundTermTag[] res = new CompoundTermTag[this.callStackPointer];
        System.arraycopy(this.callStack, 0, res, 0, this.callStackPointer);
        return res;
    }

    public void decreaseDepth() {
        if (this.callStackPointer >= 0) {
            this.callStack[--this.callStackPointer] = null;
        }
    }

    public void traceEvent(TraceLevel level, Interpreter interpreter, CompoundTermTag tag, Term[] args) {
        int execDepth = this.callStackPointer;
        switch (level) {
            case CALL: 
            case REDO: {
                if (this.callStackPointer == this.callStackMax) {
                    CompoundTermTag[] tmp = new CompoundTermTag[this.callStackMax + 4096];
                    System.arraycopy(this.callStack, 0, tmp, 0, this.callStackPointer);
                    this.callStack = tmp;
                    this.callStackMax += 4096;
                }
                this.callStack[this.callStackPointer++] = tag;
            }
        }
        if (!this.tracingActive) {
            return;
        }
        EnumSet<TraceLevel> lvlset = this.tracePoints.get(tag);
        if (lvlset == null) {
            return;
        }
        if (lvlset.contains((Object)level)) {
            StringBuilder sb = new StringBuilder();
            Term[] termArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Term arg = termArray[n2];
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(TermWriter.toString(arg));
                ++n2;
            }
            this.println(String.format("%7s: (%d) %s(%s)", level.toString(), execDepth, tag.functor.value, sb.toString()));
            if (!this.listeners.isEmpty()) {
                this.sendEvent(level, interpreter, tag, args);
            }
        }
    }

    protected void sendEvent(TraceLevel level, Interpreter interpreter, CompoundTermTag tag, Term[] args) {
        TracerEvent event = new TracerEvent(this, level, tag, args);
        for (TracerEventListener listener : this.listeners) {
            listener.tracerEvent(event);
        }
    }

    protected void println(String string) {
        if (this.output != null) {
            try {
                this.output.putCodeSequence(null, null, String.valueOf(string) + "\n");
                this.output.flushOutput(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reportStatus() {
        this.println(String.format("%% Tracing enabled: %s", this.tracingActive));
        for (Map.Entry<CompoundTermTag, EnumSet<TraceLevel>> entry : this.tracePoints.entrySet()) {
            this.println(String.format("%% Trace point: %s = %s", entry.getKey(), entry.getValue()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraceLevel {
        CALL{

            public String toString() {
                return "Call";
            }
        }
        ,
        REDO{

            public String toString() {
                return "Redo";
            }
        }
        ,
        EXIT{

            public String toString() {
                return "Exit";
            }
        }
        ,
        FAIL{

            public String toString() {
                return "Fail";
            }
        };


        public static EnumSet<TraceLevel> fromString(String lvl) {
            if (lvl.equalsIgnoreCase("all")) {
                return EnumSet.allOf(TraceLevel.class);
            }
            if (lvl.equalsIgnoreCase(CALL.toString())) {
                return EnumSet.of(CALL);
            }
            if (lvl.equalsIgnoreCase(REDO.toString())) {
                return EnumSet.of(REDO);
            }
            if (lvl.equalsIgnoreCase(EXIT.toString())) {
                return EnumSet.of(EXIT);
            }
            if (lvl.equalsIgnoreCase(FAIL.toString())) {
                return EnumSet.of(FAIL);
            }
            return EnumSet.noneOf(TraceLevel.class);
        }
    }
}

