#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# Measurement.py
#
# DESCRIPTION:
# Class that contains a SAX-based xml processor for GNUe Reports'
# "Universal" markup.
#
# NOTES:
#

__all__ = ['Measurement']

import string

class Measurement:
  def __init__(self, value, allowAuto=0):
    self.__allowAuto = allowAuto

    value = string.lower(value)

    if value in ("",None,'auto'):
      if self.__allowAuto:
        self.__value = None
        self.auto = 1
      else:
        self.__value = 0
        self.auto = 0
    else:
      self.__value = value
      self.auto = 0

      text = str(value).replace(' ','')

      if text[-1] in ('0','1','2','3','4','5','6','7','8','9'):
        value = float(text) / 72
      else:
        unit = text[-2:]
        text = text[:-2]
        try:
          value = float(text) / _conversionToInches[unit.lower()]
        except KeyError:
          print "Unknown unit of measurement: %s" % unit
        except ValueError:
          print "Invalid measurement: %s (%s)" % (text, unit)

      self.__inches = value

  def __str__(self):
    if self.auto:
      return 'auto'
    else:
      return self.__value

  def points(self):
    if self.auto:
      return None
    else:
      return self.__inches * 72

  def inches(self):
    if self.auto:
      return None
    else:
      return self.__inches

_conversionToInches = {'pt':72, 'in':1, 'cm':2.54,
                       'mm': 25.4, 'pc': 864}
