#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: CHObject.py 6763 2004-11-30 23:36:21Z jcater $
#
# DESCRIPTION:
"""
Class that contains xml objects for GNUe Reports'
"Char" markup.
"""
# NOTES:
#

__all__ = ['CHObject', 'CHBand']

from gnue.common.definitions.GObjects import GObj
from gnue.reports.base.layout.GRPassThru import GRPassThru


class CHObject(GRPassThru):
  def __init__(self, parent=None, type='CHObject'):
    GRPassThru.__init__(self, parent, type=type)

  def getXmlTag(self, stripPrefixes=None):
    return GObj.getXmlTag(self)


class CHBand:
  splittable = False # This band is not splittable across pages
  def __init__(self):
    self._inits = [self.resetBand]

  def resetBand(self):
    self.x = 0
    self.y = -1
    self.buffer = []
    # Make sure buffer is big enough
    for i in xrange(self.height): 
      self.buffer.append([])


  def chProcess(self, writer):
    for child in self._children:
      child.chProcess(writer, self)

    writer.renderBand(self)
    self.resetBand()
