# GNU Enterprise Forms - QT 4 UI driver - Application object
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: QTApp.py 9956 2009-10-11 18:54:57Z reinhard $

import sys
from PyQt4 import Qt as qt

from gnue.common.apps import GDebug

__QtApp = None

# -----------------------------------------------------------------------------
# get the global application object
# -----------------------------------------------------------------------------

def getQtApp():
    """
    Get the global qt application instance or (if none has been created) build
    a new one
    """
    global __QtApp

    if not __QtApp:
        assert gDebug(6,"QtApp initializing")
        __QtApp = GFqtApp()

    return __QtApp


# =============================================================================
# QT Application
# =============================================================================

class GFqtApp(qt.QApplication):
    """
    The QT Application object as used by GNUe Forms
    """

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self):

        self.__started = False
        qt.QApplication.__init__(self, sys.argv)
        self.connect(self, qt.SIGNAL('lastWindowClosed()'), self.quit)


    # -------------------------------------------------------------------------
    # Start the main loop
    # -------------------------------------------------------------------------

    def start(self):
        """
        Start the applications main loop, but do it only once !
        """

        if not self.__started:
            self.__started = True
            self.exec_()
