/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gl4java.GLFunc;
import gnu.gleem.HitPoint;
import gnu.gleem.Manip;
import gnu.gleem.ManipPart;
import gnu.gleem.ManipPartGroup;
import gnu.gleem.ManipPartTransform;
import gnu.gleem.ManipPartTwoWayArrow;
import gnu.gleem.linalg.IntersectionPoint;
import gnu.gleem.linalg.Mat4f;
import gnu.gleem.linalg.MathUtil;
import gnu.gleem.linalg.Plane;
import gnu.gleem.linalg.Vec3f;
import java.util.List;

public class Translate2Manip
extends Manip {
    private ManipPart parts = this.createGeometry();
    private Vec3f translation = new Vec3f(0.0f, 0.0f, 0.0f);
    private Vec3f normal = new Vec3f(0.0f, 1.0f, 0.0f);
    private Vec3f scale = new Vec3f(1.0f, 1.0f, 1.0f);
    private Mat4f xform = new Mat4f();
    private Plane dragPlane = new Plane();
    private Vec3f dragOffset = new Vec3f();

    public Translate2Manip() {
        this.recalc();
    }

    public void setTranslation(Vec3f translation) {
        this.translation.set(translation);
        this.recalc();
    }

    public Vec3f getTranslation() {
        return new Vec3f(this.translation);
    }

    public void setNormal(Vec3f normal) {
        this.normal.set(normal);
        this.normal.normalize();
        this.recalc();
    }

    public Vec3f getNormal() {
        return new Vec3f(this.normal);
    }

    public void setScale(Vec3f scale) {
        this.scale.set(scale);
        this.recalc();
    }

    public Vec3f getScale() {
        return new Vec3f(this.scale);
    }

    public void replaceGeometry(ManipPart geom) {
        this.parts = geom;
    }

    public void intersectRay(Vec3f rayStart, Vec3f rayDirection, List results) {
        this.parts.intersectRay(rayStart, rayDirection, results, this);
    }

    public void highlight(HitPoint hit) {
        if (hit.manipPart != this.parts) {
            throw new RuntimeException("My old geometry disappeared; how did this happen?");
        }
        this.parts.highlight();
    }

    public void clearHighlight() {
        this.parts.clearHighlight();
    }

    public void makeActive(HitPoint hit) {
        this.parts.highlight();
        this.dragPlane.setNormal(this.normal);
        this.dragPlane.setPoint(hit.intPt.getIntersectionPoint());
        this.dragOffset.sub(this.translation, hit.intPt.getIntersectionPoint());
    }

    public void drag(Vec3f rayStart, Vec3f rayDirection) {
        IntersectionPoint intPt = new IntersectionPoint();
        if (!this.dragPlane.intersectRay(rayStart, rayDirection, intPt)) {
            return;
        }
        this.translation.set(intPt.getIntersectionPoint());
        this.translation.add(this.dragOffset);
        this.recalc();
        super.drag(rayStart, rayDirection);
    }

    public void makeInactive() {
        this.parts.clearHighlight();
    }

    public void render(GLFunc gl) {
        this.parts.render(gl);
    }

    private ManipPart createGeometry() {
        ManipPartGroup group = new ManipPartGroup();
        ManipPartTwoWayArrow arrow1 = new ManipPartTwoWayArrow();
        group.addChild(arrow1);
        ManipPartTransform xform = new ManipPartTransform();
        Mat4f rotMat = new Mat4f();
        rotMat.makeIdent();
        rotMat.set(0, 0, 0.0f);
        rotMat.set(1, 0, 0.0f);
        rotMat.set(2, 0, -1.0f);
        rotMat.set(0, 2, 1.0f);
        rotMat.set(1, 2, 0.0f);
        rotMat.set(2, 2, 0.0f);
        xform.setOffsetTransform(rotMat);
        ManipPartTwoWayArrow arrow2 = new ManipPartTwoWayArrow();
        xform.addChild(arrow2);
        group.addChild(xform);
        return group;
    }

    private void recalc() {
        Mat4f scaleMat = new Mat4f();
        Mat4f rotMat = new Mat4f();
        Mat4f xlateMat = new Mat4f();
        Mat4f tmpMat = new Mat4f();
        scaleMat.makeIdent();
        scaleMat.set(0, 0, this.scale.x());
        scaleMat.set(1, 1, this.scale.y());
        scaleMat.set(2, 2, this.scale.z());
        Vec3f p0 = new Vec3f();
        Vec3f p1 = new Vec3f();
        MathUtil.makePerpendicular(this.normal, p0);
        p1.cross(this.normal, p0);
        p0.normalize();
        p1.normalize();
        rotMat.makeIdent();
        rotMat.set(0, 0, p1.x());
        rotMat.set(1, 0, p1.y());
        rotMat.set(2, 0, p1.z());
        rotMat.set(0, 1, this.normal.x());
        rotMat.set(1, 1, this.normal.y());
        rotMat.set(2, 1, this.normal.z());
        rotMat.set(0, 2, p0.x());
        rotMat.set(1, 2, p0.y());
        rotMat.set(2, 2, p0.z());
        xlateMat.makeIdent();
        xlateMat.set(0, 3, this.translation.x());
        xlateMat.set(1, 3, this.translation.y());
        xlateMat.set(2, 3, this.translation.z());
        tmpMat.mul(xlateMat, rotMat);
        this.xform.mul(tmpMat, scaleMat);
        this.parts.setTransform(this.xform);
    }
}

