/*
 * Decompiled with CFR 0.152.
 */
package gnu.gleem;

import gnu.gleem.linalg.Vec3f;

public class CameraParameters {
    private Vec3f position = new Vec3f();
    private Vec3f forwardDirection = new Vec3f();
    private Vec3f upDirection = new Vec3f();
    float vertFOV;
    float imagePlaneAspectRatio;
    int xSize;
    int ySize;

    public CameraParameters() {
    }

    public CameraParameters(Vec3f position, Vec3f forwardDirection, Vec3f upDirection, float vertFOV, float imagePlaneAspectRatio, int xSize, int ySize) {
        this.setPosition(position);
        this.setForwardDirection(forwardDirection);
        this.setUpDirection(upDirection);
        this.setVertFOV(vertFOV);
        this.setImagePlaneAspectRatio(imagePlaneAspectRatio);
        this.setXSize(xSize);
        this.setYSize(ySize);
    }

    public void set(CameraParameters params) {
        this.setPosition(params.getPosition());
        this.setForwardDirection(params.getForwardDirection());
        this.setUpDirection(params.getUpDirection());
        this.setVertFOV(params.getVertFOV());
        this.setImagePlaneAspectRatio(params.getImagePlaneAspectRatio());
        this.setXSize(params.getXSize());
        this.setYSize(params.getYSize());
    }

    public void setPosition(Vec3f position) {
        this.position.set(position);
    }

    public Vec3f getPosition() {
        return this.position;
    }

    public void setForwardDirection(Vec3f fwd) {
        this.forwardDirection.set(fwd);
    }

    public Vec3f getForwardDirection() {
        return this.forwardDirection;
    }

    public void setUpDirection(Vec3f up) {
        this.upDirection.set(up);
    }

    public Vec3f getUpDirection() {
        return this.upDirection;
    }

    public void setVertFOV(float vertFOV) {
        this.vertFOV = vertFOV;
    }

    public float getVertFOV() {
        return this.vertFOV;
    }

    public void setImagePlaneAspectRatio(float ratio) {
        this.imagePlaneAspectRatio = ratio;
    }

    public float getImagePlaneAspectRatio() {
        return this.imagePlaneAspectRatio;
    }

    public void setXSize(int xSize) {
        this.xSize = xSize;
    }

    public int getXSize() {
        return this.xSize;
    }

    public void setYSize(int ySize) {
        this.ySize = ySize;
    }

    public int getYSize() {
        return this.ySize;
    }
}

