/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.Poly3D;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.ThreadPool;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.concurrent.ElectricWorkerStrategy;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;

public abstract class SeaOfGatesEngine {
    protected static final boolean DEBUGFAILURE = false;
    static final boolean DEBUGLOOPS = false;
    private static final boolean FULLGRAIN = true;
    private static final double PERCENTLIMIT = 7.0;
    private static final double GRANULARITY = 1.0;
    private static final double GRAINSIZE = 1.0;
    private static final int COSTALTERNATINGMETAL = 20;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    public static SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    public static SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    public static SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, null, 0, null);
    private static int numMetalLayers;
    protected static volatile boolean firstFailure;
    protected Cell cell;
    private Rectangle2D cellBounds;
    private Technology tech;
    private Map<Layer, RTNode> metalTrees;
    private Map<Layer, RTNode> viaTrees;
    private Map<ArcInst, Integer> netIDs;
    private Layer[] metalLayers;
    private Layer[] viaLayers;
    private ArcProto[] metalArcs;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private MetalVias[] metalVias;
    private double[] worstMetalSurround;
    private double[] viaSurround;
    private Map<Cell, Map<NodeInst, Network>> nodeExtractions;
    protected double totalWireLength;
    protected boolean parallelDij;
    protected ErrorLogger errorLogger;
    private SeaOfGates.SeaOfGatesOptions prefs;

    public int routeIt(Job job, Cell cell, List<ArcInst> arcsToRoute) {
        if (this.initializeDesignRules(cell, this.prefs)) {
            return 0;
        }
        EditingPreferences ep = cell.getEditingPreferences();
        this.prefs.theTimer = ElapseTimer.createInstance().start();
        if (!RoutingDebug.isActive()) {
            Job.getUserInterface().startProgressDialog("Routing " + arcsToRoute.size() + " nets", null);
            Job.getUserInterface().setProgressNote("Building blockage information...");
        }
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates)");
        this.metalTrees = new HashMap<Layer, RTNode>();
        this.viaTrees = new HashMap<Layer, RTNode>();
        this.netIDs = new HashMap<ArcInst, Integer>();
        this.nodeExtractions = new HashMap<Cell, Map<NodeInst, Network>>();
        BlockageVisitor visitor = new BlockageVisitor(arcsToRoute);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        this.addBlockagesAtPorts(arcsToRoute, this.prefs);
        ArrayList<NeededRoute> allRoutes = new ArrayList<NeededRoute>();
        int numBatches = arcsToRoute.size();
        RouteBatches[] routeBatches = new RouteBatches[numBatches];
        this.makeListOfRoutes(numBatches, routeBatches, allRoutes, arcsToRoute, ep);
        if (RoutingDebug.isDisplayEndBlockages()) {
            RoutingDebug.showGeometryAtRouteEnds((NeededRoute)allRoutes.get(0));
            return 0;
        }
        if (RoutingDebug.isActive()) {
            ElectricWorkerStrategy electricWorker = new ElectricWorkerStrategy(null);
            electricWorker.setUi(Job.getUserInterface());
            ThreadPool.PoolWorkerStrategyFactory.userDefinedStrategy = electricWorker;
            RoutingDebug.debugRoute((NeededRoute)allRoutes.get(0));
            return 0;
        }
        boolean parallel = this.prefs.useParallelRoutes;
        this.parallelDij = this.prefs.useParallelFromToRoutes;
        firstFailure = true;
        this.totalWireLength = 0.0;
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.prefs.forcedNumberOfThreads > 0) {
            System.out.println("Forcing use of " + this.prefs.forcedNumberOfThreads + " threads");
            numberOfThreads = this.prefs.forcedNumberOfThreads;
        }
        if (this.parallelDij && numberOfThreads > 1) {
            numberOfThreads /= 2;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
        }
        System.out.println("Sea-of-gates router finding " + allRoutes.size() + " paths on " + numBatches + " networks");
        if (parallel || this.parallelDij) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (parallel) {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            if (this.parallelDij) {
                if (parallel) {
                    message = message + " and";
                }
                message = message + " routing both directions of each path in parallel";
            }
            System.out.println(message);
        }
        Environment env = Environment.getThreadEnvironment();
        this.startRouting(numberOfThreads, allRoutes, routeBatches, env, ep, job);
        int numRoutedSegments = 0;
        int totalRoutes = allRoutes.size();
        for (int a = 0; a < totalRoutes; ++a) {
            NeededRoute nr = (NeededRoute)allRoutes.get(a);
            if (nr.winningWF != null && nr.winningWF.vertices != null) {
                ++routeBatches[nr.batchNumber].numRouted;
                ++numRoutedSegments;
                continue;
            }
            ++routeBatches[nr.batchNumber].numUnrouted;
        }
        int numFailedRoutes = 0;
        for (int b = 0; b < numBatches; ++b) {
            if (routeBatches[b] == null) continue;
            if (routeBatches[b].numUnrouted == 0) {
                for (ArcInst aiKill : routeBatches[b].unroutedArcs) {
                    if (!aiKill.isLinked()) continue;
                    aiKill.kill();
                }
                cell.killNodes(routeBatches[b].unroutedNodes);
                continue;
            }
            ++numFailedRoutes;
            List<PortInst> orderedPorts = routeBatches[b].orderedPorts;
            for (ArcInst aiKill : routeBatches[b].unroutedArcs) {
                int headPort = -1;
                int tailPort = -1;
                for (int i = 0; i < orderedPorts.size(); ++i) {
                    PortInst pi = orderedPorts.get(i);
                    if (aiKill.getHeadPortInst() == pi) {
                        headPort = i;
                        continue;
                    }
                    if (aiKill.getTailPortInst() != pi) continue;
                    tailPort = i;
                }
                if (headPort < 0 || tailPort < 0) continue;
                boolean allRouted = true;
                if (headPort > tailPort) {
                    int swap = headPort;
                    headPort = tailPort;
                    tailPort = swap;
                }
                for (NeededRoute nr : allRoutes) {
                    if (nr.batchNumber != b || nr.routeInBatch - 1 < headPort || nr.routeInBatch - 1 >= tailPort || nr.winningWF != null && nr.winningWF.vertices != null) continue;
                    allRouted = false;
                }
                if (!allRouted || !aiKill.isLinked()) continue;
                aiKill.kill();
            }
        }
        this.errorLogger.termLogging(true);
        this.prefs.theTimer.end();
        Job.getUserInterface().stopProgressDialog();
        System.out.println("Routed " + numRoutedSegments + " out of " + totalRoutes + " segments; total length of routed wires is " + TextUtils.formatDistance(this.totalWireLength) + "; took " + this.prefs.theTimer);
        if (numFailedRoutes > 0) {
            System.out.println("NOTE: " + numFailedRoutes + " nets were not routed");
        }
        return numRoutedSegments;
    }

    public void setPrefs(SeaOfGates.SeaOfGatesOptions p) {
        this.prefs = p;
    }

    public SeaOfGates.SeaOfGatesOptions getPrefs() {
        return this.prefs;
    }

    public int getNumMetals() {
        return numMetalLayers;
    }

    public Layer getMetalLayer(int layNum) {
        return this.metalLayers[layNum];
    }

    public RTNode getMetalTree(Layer lay) {
        return this.metalTrees.get(lay);
    }

    protected void startRouting(int numberOfThreads, List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Environment env, EditingPreferences ep, Job job) {
        ElectricWorkerStrategy electricWorker = new ElectricWorkerStrategy(null);
        electricWorker.setUi(Job.getUserInterface());
        ThreadPool.PoolWorkerStrategyFactory.userDefinedStrategy = electricWorker;
        if (numberOfThreads > 1) {
            this.doRoutingParallel(numberOfThreads, allRoutes, routeBatches, env, ep, job);
        } else {
            this.doRouting(allRoutes, routeBatches, job, env, ep);
        }
    }

    protected abstract void doRoutingParallel(int var1, List<NeededRoute> var2, RouteBatches[] var3, Environment var4, EditingPreferences var5, Job var6);

    protected void doRouting(List<NeededRoute> allRoutes, RouteBatches[] routeBatches, Job job, Environment env, EditingPreferences ep) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            if (job != null && job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            Job.getUserInterface().setProgressValue(r * 100 / totalRoutes);
            String routeName = nr.routeName;
            if (routeBatches[nr.batchNumber].segsInBatch > 1) {
                routeName = routeName + " (" + nr.routeInBatch + " of " + routeBatches[nr.batchNumber].segsInBatch + ")";
            }
            Job.getUserInterface().setProgressNote("Network " + routeName);
            System.out.println("Routing network " + routeName + "...");
            this.findPath(nr, env, ep, job);
            if (nr.winningWF == null || nr.winningWF.vertices == null) continue;
            nr.createRoute();
        }
    }

    private boolean initializeDesignRules(Cell c, SeaOfGates.SeaOfGatesOptions prefs) {
        int i;
        this.cell = c;
        this.tech = this.cell.getTechnology();
        numMetalLayers = this.tech.getNumMetals();
        this.metalLayers = new Layer[numMetalLayers];
        this.metalArcs = new ArcProto[numMetalLayers];
        this.favorArcs = new boolean[numMetalLayers];
        this.preventArcs = new boolean[numMetalLayers];
        this.viaLayers = new Layer[numMetalLayers - 1];
        this.metalVias = new MetalVias[numMetalLayers - 1];
        for (int i2 = 0; i2 < numMetalLayers - 1; ++i2) {
            this.metalVias[i2] = new MetalVias();
        }
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            int layerIndex;
            Layer lay = it.next();
            if (!lay.getFunction().isMetal() || lay.isPseudoLayer() || (layerIndex = lay.getFunction().getLevel() - 1) >= numMetalLayers) continue;
            this.metalLayers[layerIndex] = lay;
        }
        boolean hasFavorites = false;
        Iterator<ArcProto> it2 = this.tech.getArcs();
        block2: while (it2.hasNext()) {
            ArcProto ap = it2.next();
            for (int i3 = 0; i3 < numMetalLayers; ++i3) {
                if (ap.getLayer(0) != this.metalLayers[i3]) continue;
                this.metalArcs[i3] = ap;
                this.favorArcs[i3] = prefs.isPrevented(ap);
                if (this.favorArcs[i3]) {
                    hasFavorites = true;
                }
                this.preventArcs[i3] = prefs.isPrevented(ap);
                continue block2;
            }
        }
        if (!hasFavorites) {
            for (int i4 = 0; i4 < numMetalLayers; ++i4) {
                this.favorArcs[i4] = true;
            }
        }
        Iterator<PrimitiveNode> it22 = this.tech.getNodes();
        block5: while (it22.hasNext()) {
            PrimitiveNode np = it22.next();
            if (np.isNotUsed() || !np.getFunction().isContact()) continue;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i5 = 0; i5 < numMetalLayers - 1; ++i5) {
                if ((conns[0] != this.metalArcs[i5] || conns[1] != this.metalArcs[i5 + 1]) && (conns[1] != this.metalArcs[i5] || conns[0] != this.metalArcs[i5 + 1])) continue;
                this.metalVias[i5].addVia(np, 0);
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance(np);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        Rectangle2D conRect = conPoly.getBounds2D();
                        if (conRect.getWidth() != conRect.getHeight()) {
                            square = false;
                        }
                        if (conRect.getCenterX() == 0.0 && conRect.getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i5] = conLayer;
                }
                if (offCenter) {
                    this.metalVias[i5].addVia(np, 90);
                    this.metalVias[i5].addVia(np, 180);
                    this.metalVias[i5].addVia(np, 270);
                    continue block5;
                }
                if (square) continue block5;
                this.metalVias[i5].addVia(np, 90);
                continue block5;
            }
        }
        for (int i6 = 0; i6 < numMetalLayers; ++i6) {
            if (this.metalLayers[i6] == null) {
                System.out.println("ERROR: Cannot find layer for Metal " + (i6 + 1));
                return true;
            }
            if (this.metalArcs[i6] == null) {
                System.out.println("ERROR: Cannot find arc for Metal " + (i6 + 1));
                return true;
            }
            if (i6 >= numMetalLayers - 1) continue;
            if (this.metalVias[i6].getVias().size() == 0) {
                System.out.println("ERROR: Cannot find contact node between Metal " + (i6 + 1) + " and Metal " + (i6 + 2));
                return true;
            }
            if (this.viaLayers[i6] != null) continue;
            System.out.println("ERROR: Cannot find contact layer between Metal " + (i6 + 1) + " and Metal " + (i6 + 2));
            return true;
        }
        this.worstMetalSurround = new double[numMetalLayers];
        GenMath.MutableDouble mutableDist = new GenMath.MutableDouble(0.0);
        for (i = 0; i < numMetalLayers; ++i) {
            if (!DRC.getMaxSurround(this.metalLayers[i], Double.MAX_VALUE, mutableDist)) continue;
            this.worstMetalSurround[i] = mutableDist.doubleValue();
        }
        this.viaSurround = new double[numMetalLayers - 1];
        for (i = 0; i < numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            double spacing = 2.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth();
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            List<MetalVia> nps = this.metalVias[i].getVias();
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance(mv.via);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    Rectangle2D bounds = conPoly.getBounds2D();
                    width = Math.max(width, bounds.getWidth());
                    width = Math.max(width, bounds.getHeight());
                }
            }
            this.viaSurround[i] = spacing + width;
        }
        return false;
    }

    protected void makeListOfRoutes(int numBatches, RouteBatches[] routeBatches, List<NeededRoute> allRoutes, List<ArcInst> arcsToRoute, EditingPreferences ep) {
        this.doMakeListOfRoutes(0, numBatches, routeBatches, allRoutes, arcsToRoute);
    }

    protected void doMakeListOfRoutes(int start, int end, RouteBatches[] routeBatches, List<NeededRoute> allRoutes, List<ArcInst> arcsToRoute) {
        for (int b = start; b < end; ++b) {
            ArrayList<PortInst> orderedPorts;
            ArcInst ai = arcsToRoute.get(b);
            Netlist netList = this.cell.getNetlist();
            Network net = netList.getNetwork(ai, 0);
            if (net == null) {
                System.out.println("Arc " + ai.describe(false) + " has no network!");
                continue;
            }
            HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            if (RoutingDebug.isActive()) {
                orderedPorts = new ArrayList<PortInst>();
                orderedPorts.add(ai.getHeadPortInst());
                orderedPorts.add(ai.getTailPortInst());
                arcsToDelete.add(ai);
            } else {
                Map<Network, ArcInst[]> arcMap = null;
                if (this.cell.getView() != View.SCHEMATIC) {
                    arcMap = netList.getArcInstsByNetwork();
                }
                List<Connection> netEnds = Routing.findNetEnds(net, arcMap, arcsToDelete, nodesToDelete, netList, true);
                orderedPorts = this.makeOrderedPorts(net, netEnds);
            }
            if (orderedPorts == null) {
                System.out.println("ERROR: No valid routes points found on the network " + net.describe(false));
                ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                for (ArcInst delAi : arcsToDelete) {
                    lineList.add(delAi.getHeadLocation());
                    lineList.add(delAi.getTailLocation());
                }
                this.errorLogger.logMessageWithLines("Arcs in " + net.getName() + " not make valid connection: deleted", null, lineList, this.cell, 0, true);
                routeBatches[b] = new RouteBatches();
                routeBatches[b].unroutedArcs = arcsToDelete;
                routeBatches[b].unroutedNodes = nodesToDelete;
                routeBatches[b].numUnrouted = 0;
                continue;
            }
            routeBatches[b] = new RouteBatches();
            routeBatches[b].unroutedArcs = arcsToDelete;
            routeBatches[b].unroutedNodes = nodesToDelete;
            routeBatches[b].orderedPorts = orderedPorts;
            routeBatches[b].segsInBatch = 0;
            double minWidth = this.getMinWidth(orderedPorts, this.prefs);
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null) {
                netID = netIDI - 1;
            }
            int batchNumber = 1;
            for (int i = 0; i < orderedPorts.size() - 1; ++i) {
                SOGBound block;
                Export e;
                Variable var;
                Export e2;
                Variable var2;
                PortInst fromPi = (PortInst)orderedPorts.get(i);
                PortInst toPi = (PortInst)orderedPorts.get(i + 1);
                if (this.inValidPort(fromPi) || this.inValidPort(toPi)) continue;
                ArcProto fromArc = null;
                ArcProto[] fromArcs = fromPi.getPortProto().getBasePort().getConnections();
                if (fromPi.getPortProto() instanceof Export && (var2 = (e2 = (Export)fromPi.getPortProto()).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
                    String[] arcNames = (String[])var2.getObject();
                    ArcProto[] arcs = new ArcProto[arcNames.length];
                    boolean allFound = true;
                    for (int j = 0; j < arcNames.length; ++j) {
                        arcs[j] = ArcProto.findArcProto(arcNames[j]);
                        if (arcs[j] != null) continue;
                        allFound = false;
                    }
                    if (allFound) {
                        fromArcs = arcs;
                    }
                }
                for (int j = 0; j < fromArcs.length; ++j) {
                    if (fromArcs[j].getTechnology() != this.tech || !fromArcs[j].getFunction().isMetal()) continue;
                    fromArc = fromArcs[j];
                    break;
                }
                if (fromArc == null) {
                    String errorMsg = "Cannot connect port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " because it has no metal connection in " + this.tech.getTechName() + " technology";
                    System.out.println("ERROR: " + errorMsg);
                    ArrayList<Poly> polyList = new ArrayList<Poly>();
                    polyList.add(fromPi.getPoly());
                    this.errorLogger.logMessage(errorMsg, polyList, this.cell, 0, true);
                    continue;
                }
                ArcProto toArc = null;
                ArcProto[] toArcs = toPi.getPortProto().getBasePort().getConnections();
                if (toPi.getPortProto() instanceof Export && (var = (e = (Export)toPi.getPortProto()).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
                    String[] arcNames = (String[])var.getObject();
                    ArcProto[] arcs = new ArcProto[arcNames.length];
                    boolean allFound = true;
                    for (int j = 0; j < arcNames.length; ++j) {
                        arcs[j] = ArcProto.findArcProto(arcNames[j]);
                        if (arcs[j] != null) continue;
                        allFound = false;
                    }
                    if (allFound) {
                        toArcs = arcs;
                    }
                }
                for (int j = 0; j < toArcs.length; ++j) {
                    if (toArcs[j].getTechnology() != this.tech || !toArcs[j].getFunction().isMetal()) continue;
                    toArc = toArcs[j];
                    break;
                }
                if (toArc == null) {
                    String errorMsg = "Cannot connect port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because it has no metal connection in " + this.tech.getTechName() + " technology";
                    System.out.println("ERROR: " + errorMsg);
                    ArrayList<Poly> polyList = new ArrayList<Poly>();
                    polyList.add(toPi.getPoly());
                    this.errorLogger.logMessage(errorMsg, polyList, this.cell, 0, true);
                    continue;
                }
                Poly fromPoly = fromPi.getPoly();
                EPoint fromLoc = fromPoly.getCenter();
                Poly toPoly = toPi.getPoly();
                EPoint toLoc = toPoly.getCenter();
                double fromX = fromLoc.getX();
                double fromY = fromLoc.getY();
                double toX = toLoc.getX();
                double toY = toLoc.getY();
                if (toLoc.getX() < fromLoc.getX()) {
                    toX = this.upToGrain(toLoc.getX());
                    fromX = this.downToGrain(fromLoc.getX());
                } else if (toLoc.getX() > fromLoc.getX()) {
                    toX = this.downToGrain(toLoc.getX());
                    fromX = this.upToGrain(fromLoc.getX());
                } else {
                    toX = fromX = this.upToGrain(fromLoc.getX());
                }
                if (toLoc.getY() < fromLoc.getY()) {
                    toY = this.upToGrain(toLoc.getY());
                    fromY = this.downToGrain(fromLoc.getY());
                } else if (toLoc.getY() > fromLoc.getY()) {
                    toY = this.downToGrain(toLoc.getY());
                    fromY = this.upToGrain(fromLoc.getY());
                } else {
                    toY = fromY = this.upToGrain(fromLoc.getY());
                }
                int fromZ = fromArc.getFunction().getLevel() - 1;
                int toZ = toArc.getFunction().getLevel() - 1;
                double fromMetalSpacing = Math.max(this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
                Layer lay = this.metalLayers[fromZ];
                DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), -1.0);
                double fromSurround = 0.0;
                if (rule != null) {
                    fromSurround = rule.getValue(0);
                }
                if ((block = this.getMetalBlockage(netID, fromZ, fromMetalSpacing, fromMetalSpacing, fromSurround, fromX, fromY)) != null && (block = this.getMetalBlockage(netID, fromZ, fromMetalSpacing, fromMetalSpacing, fromSurround, fromX = fromLoc.getX(), fromY = fromLoc.getY())) != null) {
                    Rectangle2D fromRect = fromPoly.getBounds2D();
                    double stepSize = fromMetalSpacing + fromSurround;
                    if (stepSize > 0.0 && (fromRect.getWidth() > 0.0 || fromRect.getHeight() > 0.0)) {
                        for (double x2 = fromRect.getMinX(); x2 <= fromRect.getMaxX(); x2 += stepSize) {
                            for (double y = fromRect.getMinY(); y <= fromRect.getMaxY(); y += stepSize) {
                                SOGBound stepBlock = this.getMetalBlockage(netID, fromZ, fromMetalSpacing, fromMetalSpacing, fromSurround, x2, y);
                                if (stepBlock != null) continue;
                                fromX = x2;
                                fromY = y;
                                block = null;
                                break;
                            }
                            if (block == null) break;
                        }
                    }
                    if (block != null) {
                        String errorMsg = "Cannot Route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " at (" + TextUtils.formatDistance(fromX) + "," + TextUtils.formatDistance(fromY) + ") because it is blocked on layer " + this.metalLayers[fromZ].getName() + " [needs " + TextUtils.formatDistance(fromMetalSpacing + fromSurround) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + "]";
                        System.out.println("ERROR: " + errorMsg);
                        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                        polyList.add(new PolyBase(fromX, fromY, (fromMetalSpacing + fromSurround) * 2.0, (fromMetalSpacing + fromSurround) * 2.0));
                        polyList.add(new PolyBase(block.getBounds()));
                        ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                        lineList.add(new EPoint(block.getBounds().getMinX(), block.getBounds().getMinY()));
                        lineList.add(new EPoint(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                        lineList.add(new EPoint(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                        lineList.add(new EPoint(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                        this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                        continue;
                    }
                }
                double toMetalSpacing = Math.max(this.metalArcs[toZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
                lay = this.metalLayers[toZ];
                rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.metalArcs[toZ].getDefaultLambdaBaseWidth(), -1.0);
                double toSurround = 0.0;
                if (rule != null) {
                    toSurround = rule.getValue(0);
                }
                if ((block = this.getMetalBlockage(netID, toZ, toMetalSpacing, toMetalSpacing, toSurround, toX, toY)) != null && (block = this.getMetalBlockage(netID, toZ, toMetalSpacing, toMetalSpacing, toSurround, toX = toLoc.getX(), toY = toLoc.getY())) != null) {
                    Rectangle2D toRect = toPoly.getBounds2D();
                    double stepSize = toMetalSpacing + toSurround;
                    if (stepSize > 0.0 && (toRect.getWidth() > 0.0 || toRect.getHeight() > 0.0)) {
                        for (double x3 = toRect.getMinX(); x3 <= toRect.getMaxX(); x3 += stepSize) {
                            for (double y = toRect.getMinY(); y <= toRect.getMaxY(); y += stepSize) {
                                SOGBound stepBlock = this.getMetalBlockage(netID, toZ, toMetalSpacing, toMetalSpacing, toSurround, x3, y);
                                if (stepBlock != null) continue;
                                toX = x3;
                                toY = y;
                                block = null;
                                break;
                            }
                            if (block == null) break;
                        }
                    }
                    if (block != null) {
                        String errorMsg = "Cannot route to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " at (" + TextUtils.formatDistance(toX) + "," + TextUtils.formatDistance(toY) + ") because it is blocked on layer " + this.metalLayers[toZ].getName() + " [needs " + TextUtils.formatDistance(toMetalSpacing + toSurround) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + "]";
                        System.out.println("ERROR: " + errorMsg);
                        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                        polyList.add(new PolyBase(toX, toY, (toMetalSpacing + toSurround) * 2.0, (toMetalSpacing + toSurround) * 2.0));
                        polyList.add(new PolyBase(block.getBounds()));
                        ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                        lineList.add(new EPoint(block.getBounds().getMinX(), block.getBounds().getMinY()));
                        lineList.add(new EPoint(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                        lineList.add(new EPoint(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                        lineList.add(new EPoint(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                        this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, this.cell, 0, true);
                        continue;
                    }
                }
                NeededRoute nr = new NeededRoute(net.getName(), fromPi, fromX, fromY, fromZ, toPi, toX, toY, toZ, netID, minWidth, b, batchNumber++, this.prefs);
                ++routeBatches[b].segsInBatch;
                allRoutes.add(nr);
            }
        }
    }

    protected void findPath(NeededRoute nr, Environment env, EditingPreferences ep, Job job) {
        Wavefront d1 = nr.dir1;
        if (DBMath.areEquals(d1.toX, d1.fromX) && DBMath.areEquals(d1.toY, d1.fromY) && d1.toZ == d1.fromZ) {
            nr.winningWF = d1;
            nr.winningWF.vertices = new ArrayList<SearchVertex>();
            SearchVertex sv = new SearchVertex(d1.toX, d1.toY, d1.toZ, 0, null, 0, nr.winningWF);
            nr.winningWF.vertices.add(sv);
            nr.cleanSearchMemory();
            return;
        }
        if (this.parallelDij) {
            Semaphore outSem = new Semaphore(0);
            new DijkstraInThread("Route a->b", nr.dir1, nr.dir2, outSem, env, ep);
            new DijkstraInThread("Route b->a", nr.dir2, nr.dir1, outSem, env, ep);
            outSem.acquireUninterruptibly(2);
        } else {
            this.doTwoWayDijkstra(nr);
        }
        Wavefront wf = nr.winningWF;
        double verLength = Double.MAX_VALUE;
        if (wf != null) {
            verLength = SeaOfGatesEngine.getVertexLength(wf.vertices);
        }
        if (verLength == Double.MAX_VALUE) {
            if (wf == null) {
                wf = nr.dir1;
            }
            String errorMsg = wf.vertices == null ? "Search for '" + nr.routeName + "' too complex (exceeds complexity limit of " + this.prefs.complexityLimit + " steps)" : "Failed in '" + nr.routeName + "' to route from port " + wf.from.getPortProto().getName() + " of node " + wf.from.getNodeInst().describe(false) + " to port " + wf.to.getPortProto().getName() + " of node " + wf.to.getNodeInst().describe(false);
            System.out.println("ERROR: " + errorMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(wf.toX, wf.toY));
            lineList.add(new EPoint(wf.fromX, wf.fromY));
            this.errorLogger.logMessageWithLines(errorMsg, null, lineList, this.cell, 0, true);
        }
        nr.cleanSearchMemory();
    }

    protected void doTwoWayDijkstra(NeededRoute nr) {
        SearchVertex result2 = null;
        while (result2 == null) {
            SearchVertex resultA = nr.dir1.advanceWavefront();
            SearchVertex resultB = nr.dir2.advanceWavefront();
            if (resultA == null && resultB == null) continue;
            if (resultA == svExhausted && resultB == svExhausted) {
                result2 = svExhausted;
                break;
            }
            if (resultA == svExhausted) {
                resultA = null;
            }
            if (resultB == svExhausted) {
                resultB = null;
            }
            result2 = resultA;
            nr.winningWF = nr.dir1;
            if (result2 != null) continue;
            result2 = resultB;
            nr.winningWF = nr.dir2;
        }
        if (result2 == svAborted || result2 == svExhausted) {
            nr.winningWF = null;
            return;
        }
        List<SearchVertex> realVertices = this.getOptimizedList(result2);
        nr.winningWF.vertices = realVertices;
    }

    private double getMinWidth(List<PortInst> orderedPorts, SeaOfGates.SeaOfGatesOptions prefs) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > prefs.maxArcWidth) {
            minWidth = prefs.maxArcWidth;
        }
        return minWidth;
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    private boolean inValidPort(PortInst pi) {
        ArcProto[] conns = pi.getPortProto().getBasePort().getConnections();
        boolean valid = false;
        for (int j = 0; j < conns.length; ++j) {
            ArcProto ap = conns[j];
            if (ap.getTechnology() != this.tech || !ap.getFunction().isMetal() || this.preventArcs[conns[j].getFunction().getLevel() - 1]) continue;
            valid = true;
            break;
        }
        if (!valid) {
            System.out.println("Cannot connect to port " + pi.getPortProto().getName() + " on node " + pi.getNodeInst().describe(false) + " because all connecting layers have been prevented by Routing Preferences");
            return true;
        }
        return false;
    }

    private List<PortInst> makeOrderedPorts(Network net, List<Connection> netEnds) {
        ArrayList<PortInst> portEndList = new ArrayList<PortInst>();
        for (int i = 0; i < netEnds.size(); ++i) {
            PortInst pi = netEnds.get(i).getPortInst();
            if (!pi.getNodeInst().isCellInstance() && ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() == Generic.tech() || portEndList.contains(pi)) continue;
            portEndList.add(pi);
        }
        int count2 = portEndList.size();
        if (count2 <= 1) {
            return null;
        }
        PortInst[] portEnds = new PortInst[count2];
        int k = 0;
        for (PortInst pi : portEndList) {
            portEnds[k++] = pi;
        }
        int closest1 = 0;
        int closest2 = 0;
        double closestDist = Double.MAX_VALUE;
        for (int i = 0; i < count2; ++i) {
            Poly poly1 = portEnds[i].getPoly();
            for (int j = i + 1; j < count2; ++j) {
                Poly poly2 = portEnds[j].getPoly();
                double dist = poly1.getCenter().distance(poly2.getCenter());
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest1 = i;
                closest2 = j;
            }
        }
        ArrayList<PortInst> orderedPorts = new ArrayList<PortInst>();
        orderedPorts.add(portEnds[closest1]);
        orderedPorts.add(portEnds[closest2]);
        portEnds[closest1] = null;
        portEnds[closest2] = null;
        while (true) {
            boolean foundsome = false;
            double closestDist1 = Double.MAX_VALUE;
            double closestDist2 = Double.MAX_VALUE;
            for (int i = 0; i < count2; ++i) {
                if (portEnds[i] == null) continue;
                Poly poly = portEnds[i].getPoly();
                Poly poly1 = ((PortInst)orderedPorts.get(0)).getPoly();
                double dist1 = poly.getCenter().distance(poly1.getCenter());
                if (dist1 < closestDist1) {
                    closestDist1 = dist1;
                    closest1 = i;
                    foundsome = true;
                }
                Poly poly2 = ((PortInst)orderedPorts.get(orderedPorts.size() - 1)).getPoly();
                double dist2 = poly.getCenter().distance(poly2.getCenter());
                if (!(dist2 < closestDist2)) continue;
                closestDist2 = dist2;
                closest2 = i;
                foundsome = true;
            }
            if (!foundsome) break;
            if (closestDist1 < closestDist2) {
                orderedPorts.add(0, portEnds[closest1]);
                portEnds[closest1] = null;
                continue;
            }
            orderedPorts.add(portEnds[closest2]);
            portEnds[closest2] = null;
        }
        return orderedPorts;
    }

    protected static double getVertexLength(List<SearchVertex> vertices) {
        if (vertices == null) {
            return Double.MAX_VALUE;
        }
        if (vertices.size() == 0) {
            return Double.MAX_VALUE;
        }
        double sum2 = 0.0;
        SearchVertex last2 = null;
        for (SearchVertex sv : vertices) {
            if (last2 != null) {
                sum2 += Math.abs(sv.getX() - last2.getX()) + Math.abs(sv.getY() - last2.getY()) + (double)(Math.abs(sv.getZ() - last2.getZ()) * 10);
            }
            last2 = sv;
        }
        return sum2;
    }

    List<SearchVertex> getOptimizedList(SearchVertex initialThread) {
        ArrayList<SearchVertex> realVertices = new ArrayList<SearchVertex>();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || thread.getX() - lastVertex.getX() != 0.0 && dx == 0.0 || thread.getY() - lastVertex.getY() != 0.0 && dy == 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
        return realVertices;
    }

    private double upToGrain(double v) {
        return v;
    }

    private double upToGrainAlways(double v) {
        return Math.ceil(v * 1.0) * 1.0;
    }

    private double downToGrain(double v) {
        return v;
    }

    private double downToGrainAlways(double v) {
        return Math.floor(v * 1.0) * 1.0;
    }

    private void addBlockagesAtPorts(List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesOptions prefs) {
        Netlist netList = this.cell.getNetlist();
        Map<Network, ArcInst[]> arcMap = null;
        if (this.cell.getView() != View.SCHEMATIC) {
            arcMap = netList.getArcInstsByNetwork();
        }
        for (ArcInst ai : arcsToRoute) {
            HashSet<NodeInst> nodesToDelete;
            HashSet<ArcInst> arcsToDelete;
            List<Connection> netEnds;
            Network net;
            List<PortInst> orderedPorts;
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null && (netID = -(netIDI - 1)) > 0) {
                System.out.println("INTERNAL ERROR! net=" + netID + " but should be negative");
            }
            if ((orderedPorts = this.makeOrderedPorts(net = netList.getNetwork(ai, 0), netEnds = Routing.findNetEnds(net, arcMap, arcsToDelete = new HashSet<ArcInst>(), nodesToDelete = new HashSet<NodeInst>(), netList, true))) == null) continue;
            double minWidth = this.getMinWidth(orderedPorts, prefs);
            for (PortInst pi : orderedPorts) {
                Poly poly = pi.getPoly();
                Rectangle2D portBounds = poly.getBounds2D();
                ArcProto[] poss = pi.getPortProto().getBasePort().getConnections();
                int lowMetal = -1;
                int highMetal = -1;
                for (int i = 0; i < poss.length; ++i) {
                    if (poss[i].getTechnology() != this.tech || !poss[i].getFunction().isMetal()) continue;
                    int level = poss[i].getFunction().getLevel();
                    if (lowMetal < 0) {
                        lowMetal = highMetal = level;
                        continue;
                    }
                    lowMetal = Math.min(lowMetal, level);
                    highMetal = Math.max(highMetal, level);
                }
                if (lowMetal < 0) continue;
                for (int via = lowMetal - 2; via < highMetal; ++via) {
                    if (via < 0 || via >= numMetalLayers - 1) continue;
                    MetalVia mv = this.metalVias[via].getVias().get(0);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly metalPoly = polys[i];
                        Layer layer = metalPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        Rectangle2D metalBounds = metalPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(metalBounds.getMinX() + portBounds.getCenterX(), metalBounds.getMinY() + portBounds.getCenterY(), metalBounds.getWidth(), metalBounds.getHeight());
                        boolean free = true;
                        RTNode rtree = this.metalTrees.get(layer);
                        if (rtree != null) {
                            RTNode.Search sea = new RTNode.Search(bounds, rtree, true);
                            while (sea.hasNext()) {
                                SOGBound sBound = (SOGBound)sea.next();
                                if (sBound.getBounds().getMinX() > bounds.getMaxX() || sBound.getBounds().getMaxX() < bounds.getMinX() || sBound.getBounds().getMinY() > bounds.getMaxY() || sBound.getBounds().getMaxY() < bounds.getMinY() || Math.abs(sBound.getNetID()) == netID) continue;
                                free = false;
                                break;
                            }
                        }
                        if (!free) continue;
                        this.addRectangle(bounds, layer, netID);
                    }
                }
            }
        }
    }

    private SOGBound getMetalBlockage(int netID, int metNo, double halfWidth, double halfHeight, double surround, double x2, double y) {
        Layer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x2 - halfWidth - surround;
        double hX = x2 + halfWidth + surround;
        double lY = y - halfHeight - surround;
        double hY = y + halfHeight + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            PolyBase poly;
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || Math.abs(sBound.getNetID()) == netID || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
            return sBound;
        }
        return null;
    }

    private SOGVia getViaBlockage(int netID, Layer layer, double halfWidth, double halfHeight, double x2, double y) {
        RTNode rtree = this.viaTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x2 - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGVia sLoc = (SOGVia)sea.next();
            if (sLoc.getNetID() == netID && sLoc.loc.getX() == x2 && sLoc.loc.getY() == y) continue;
            return sLoc;
        }
        return null;
    }

    private NodeInst makeNodeInst(NodeProto np, EPoint loc, double wid, double hei, Orientation orient, Cell cell, int netID) {
        NodeInst ni = NodeInst.makeInstance(np, loc, wid, hei, cell, orient, null);
        if (ni != null) {
            AffineTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = this.tech.getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                ((PolyBase)poly).transform(trans);
                this.addLayer(poly, GenMath.MATID, netID, false);
            }
        }
        return ni;
    }

    private ArcInst makeArcInst(ArcProto type, double wid, PortInst from2, PortInst to2, int netID) {
        ArcInst ai = ArcInst.makeInstanceBase(type, wid, from2, to2);
        if (ai != null) {
            Poly[] polys = this.tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                this.addLayer(polys[i], GenMath.MATID, netID, false);
            }
            Poly fromPoly = from2.getPoly();
            Poly toPoly = to2.getPoly();
            double length = fromPoly.getCenter().distance(toPoly.getCenter());
            this.totalWireLength += length;
        }
        return ai;
    }

    private void addLayer(PolyBase poly, AffineTransform trans, int netID, boolean canPlacePseudo) {
        if (!canPlacePseudo && poly.isPseudoLayer()) {
            return;
        }
        Layer layer = poly.getLayer();
        if (canPlacePseudo) {
            layer = layer.getNonPseudoLayer();
        } else if (layer.isPseudoLayer()) {
            return;
        }
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            poly.transform(trans);
            Rectangle2D bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID);
            } else {
                this.addRectangle(bounds, layer, netID);
            }
        } else if (fun.isContact()) {
            Rectangle2D bounds = poly.getBounds2D();
            DBMath.transformRect(bounds, trans);
            this.addVia(new EPoint(bounds.getCenterX(), bounds.getCenterY()), layer, netID);
        }
    }

    private void addRectangle(Rectangle2D bounds, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.metalTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGBound(ERectangle.fromLambda(bounds), netID))) != root2) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addPolygon(PolyBase poly, Layer layer, int netID) {
        Rectangle2D bounds;
        RTNode newRoot;
        RTNode root2 = this.metalTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGPoly(ERectangle.fromLambda(bounds = poly.getBounds2D()), netID, poly))) != root2) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addVia(EPoint loc, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root2 = this.viaTrees.get(layer);
        if (root2 == null) {
            root2 = RTNode.makeTopLevel();
            this.viaTrees.put(layer, root2);
        }
        if ((newRoot = RTNode.linkGeom(null, root2, new SOGVia(loc, netID))) != root2) {
            this.viaTrees.put(layer, newRoot);
        }
    }

    private void showSearchVertices(Set<SearchVertex> active, List<SearchVertex> inactive, Cell cell, double fromX, double fromY, double toX, double toY, Map<Layer, RTNode> trees, Rectangle2D bounds) {
        SwingUtilities.invokeLater(new Show3DRoute(active, inactive, this.viaTrees, this.metalLayers, this.viaLayers, cell, fromX, fromY, toX, toY, trees, bounds));
    }

    private static class Show3DRoute
    implements Runnable {
        private Set<SearchVertex> active;
        private List<SearchVertex> inactive;
        private Map<Layer, RTNode> vias;
        private Layer[] metalLayers;
        private Layer[] viaLayers;
        private Cell cell;
        private double fromX;
        private double fromY;
        private double toX;
        private double toY;
        private Map<Layer, RTNode> trees;
        private Rectangle2D bounds;

        Show3DRoute(Set<SearchVertex> active, List<SearchVertex> inactive, Map<Layer, RTNode> vias, Layer[] metalLayers, Layer[] viaLayers, Cell cell, double fromX, double fromY, double toX, double toY, Map<Layer, RTNode> trees, Rectangle2D bounds) {
            this.active = active;
            this.inactive = inactive;
            this.vias = vias;
            this.metalLayers = metalLayers;
            this.viaLayers = viaLayers;
            this.cell = cell;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
            this.trees = trees;
            this.bounds = bounds;
        }

        @Override
        public void run() {
            Poly3D poly;
            Layer layer;
            Method showPolysMethod = null;
            try {
                Class<?> threeDClass = Class.forName("com.sun.electric.plugins.j3d.View3DWindow");
                showPolysMethod = threeDClass.getMethod("show3DPolygons", ArrayList.class);
            }
            catch (Exception e) {
                System.out.println("Problem with 3D view: " + e.getMessage());
            }
            if (showPolysMethod == null) {
                EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
                Cell drawCell = wnd.getCell();
                wnd.clearHighlighting();
                for (SearchVertex sv : this.active) {
                    this.showSV(sv, wnd, drawCell);
                }
                for (SearchVertex sv : this.inactive) {
                    this.showSV(sv, wnd, drawCell);
                }
                wnd.finishedHighlighting();
                return;
            }
            ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
            for (SearchVertex sv : this.active) {
                this.displaySearchVertex(sv, polys);
            }
            for (SearchVertex sv : this.inactive) {
                this.displaySearchVertex(sv, polys);
            }
            int highestUsedLayer = 0;
            for (int lay = 0; lay < this.metalLayers.length; ++lay) {
                layer = this.metalLayers[lay];
                RTNode rtree = this.trees.get(layer);
                if (rtree == null) continue;
                RTNode.Search sea = new RTNode.Search(this.bounds, rtree, true);
                while (sea.hasNext()) {
                    SOGBound sBound = (SOGBound)sea.next();
                    double lX = sBound.getBounds().getMinX();
                    double hX = sBound.getBounds().getMaxX();
                    double lY = sBound.getBounds().getMinY();
                    double hY = sBound.getBounds().getMaxY();
                    if (hX <= this.bounds.getMinX() || lX >= this.bounds.getMaxX() || hY <= this.bounds.getMinY() || lY >= this.bounds.getMaxY()) continue;
                    if (lX < this.bounds.getMinX()) {
                        lX = this.bounds.getMinX();
                    }
                    if (hX > this.bounds.getMaxX()) {
                        hX = this.bounds.getMaxX();
                    }
                    if (lY < this.bounds.getMinY()) {
                        lY = this.bounds.getMinY();
                    }
                    if (hY > this.bounds.getMaxY()) {
                        hY = this.bounds.getMaxY();
                    }
                    double lowZ = layer.getDistance();
                    poly = new Poly3D((lX + hX) / 2.0, (lY + hY) / 2.0, hX - lX, hY - lY, lowZ, lowZ);
                    poly.setStyle(Poly.Type.FILLED);
                    EGraphics graphics = layer.getGraphics();
                    poly.setColor(graphics.getColor());
                    poly.setTransparency(0.1f);
                    polys.add(poly);
                    if (lay <= highestUsedLayer) continue;
                    highestUsedLayer = lay;
                }
            }
            for (int i = 0; i < highestUsedLayer; ++i) {
                layer = this.viaLayers[i];
                Layer m1Layer = this.metalLayers[i];
                Layer m2Layer = this.metalLayers[i + 1];
                RTNode rtree = this.vias.get(layer);
                if (rtree == null) continue;
                RTNode.Search sea = new RTNode.Search(this.bounds, rtree, true);
                while (sea.hasNext()) {
                    SOGVia sBound = (SOGVia)sea.next();
                    double cX = sBound.getBounds().getCenterX();
                    double cY = sBound.getBounds().getCenterY();
                    if (cX <= this.bounds.getMinX() || cX >= this.bounds.getMaxX() || cY <= this.bounds.getMinY() || cY >= this.bounds.getMaxY()) continue;
                    double lowZ = m1Layer.getDistance();
                    double highZ = m2Layer.getDistance();
                    poly = new Poly3D(cX, cY, 1.0, 1.0, lowZ, highZ);
                    poly.setStyle(Poly.Type.FILLED);
                    poly.setColor(Color.BLACK);
                    poly.setTransparency(0.1f);
                    polys.add(poly);
                }
            }
            this.showRoutingPath(polys, highestUsedLayer);
            try {
                showPolysMethod.invoke(null, polys);
            }
            catch (Exception e) {
                System.out.println("3D rendering error: " + e.getMessage());
            }
        }

        private void showSV(SearchVertex sv, EditWindow_ wnd, Cell cellToUse) {
            String message = "M" + (sv.getZ() + 1) + "=" + sv.cost;
            Point2D.Double loc = new Point2D.Double(sv.getX(), sv.getY());
            wnd.addHighlightMessage(cellToUse, message, loc);
        }

        private void showRoutingPath(List<PolyBase> polys, int highestUsedLayer) {
            double overallDepth = 20.0;
            Technology tech = this.cell.getTechnology();
            Point2D.Double fromPT = new Point2D.Double(this.fromX, this.fromY);
            Point2D.Double toPT = new Point2D.Double(this.toX, this.toY);
            Point2D[] twoPT = new Point2D[]{fromPT, toPT};
            double lowZ = this.metalLayers[0].getDistance() - overallDepth;
            double highZ = this.metalLayers[highestUsedLayer].getDistance() + this.metalLayers[highestUsedLayer].getThickness() + overallDepth;
            Poly3D routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            double cX = (this.fromX + this.toX) / 2.0;
            double cY = (this.fromY + this.toY) / 2.0;
            Point2D.Double ctr = new Point2D.Double(cX, cY);
            int angle = DBMath.figureAngle(toPT, fromPT);
            int arrowAngle = (angle + 300) % 3600;
            double arrowHeadLength = GenMath.distBetweenPoints(fromPT, toPT) / 10.0;
            double endX = DBMath.cos(arrowAngle) * arrowHeadLength + cX;
            double endY = DBMath.sin(arrowAngle) * arrowHeadLength + cY;
            twoPT = new Point2D[]{ctr, new Point2D.Double(endX, endY)};
            routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            arrowAngle = (angle + 3300) % 3600;
            endX = DBMath.cos(arrowAngle) * arrowHeadLength + cX;
            endY = DBMath.sin(arrowAngle) * arrowHeadLength + cY;
            twoPT = new Point2D[]{ctr, new Point2D.Double(endX, endY)};
            routePoly = new Poly3D(twoPT, lowZ, lowZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            Point2D[] onePT = new Point2D[]{fromPT};
            routePoly = new Poly3D(onePT, lowZ, highZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
            onePT = new Point2D[]{toPT};
            routePoly = new Poly3D(onePT, lowZ, highZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setStyle(Poly.Type.OPENED);
            routePoly.setColor(Color.WHITE);
            polys.add(routePoly);
        }

        private void displaySearchVertex(SearchVertex sv, List<PolyBase> polys) {
            if (sv.last == null) {
                return;
            }
            Technology tech = this.cell.getTechnology();
            double pathSize = 0.75;
            if (sv.getZ() == sv.last.getZ()) {
                double z = this.metalLayers[sv.getZ()].getDistance() - 5.0;
                Point2D[] pts = new Point2D[4];
                double lX = Math.min(sv.xv, sv.last.xv);
                double hX = Math.max(sv.xv, sv.last.xv);
                double lY = Math.min(sv.yv, sv.last.yv);
                double hY = Math.max(sv.yv, sv.last.yv);
                pts[0] = new Point2D.Double(lX - pathSize, lY - pathSize);
                pts[1] = new Point2D.Double(lX - pathSize, hY + pathSize);
                pts[2] = new Point2D.Double(hX + pathSize, hY + pathSize);
                pts[3] = new Point2D.Double(hX + pathSize, lY - pathSize);
                Poly3D routePoly = new Poly3D(pts, z, z);
                routePoly.setLayer(tech.findLayer("Metal-1"));
                routePoly.setColor(Color.RED);
                routePoly.setStyle(Poly.Type.CLOSED);
                polys.add(routePoly);
                return;
            }
            double fromZ = this.metalLayers[sv.getZ()].getDistance() - 5.0;
            double toZ = this.metalLayers[sv.last.getZ()].getDistance() - 5.0;
            Point2D[] pts = new Point2D[]{new Point2D.Double(sv.xv - pathSize, sv.yv - pathSize), new Point2D.Double(sv.xv - pathSize, sv.yv + pathSize), new Point2D.Double(sv.xv + pathSize, sv.yv + pathSize), new Point2D.Double(sv.xv + pathSize, sv.yv - pathSize)};
            Poly3D routePoly = new Poly3D(pts, fromZ, toZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setColor(Color.GREEN);
            routePoly.setStyle(Poly.Type.CLOSED);
            polys.add(routePoly);
            Point2D[] pts1 = new Point2D[]{new Point2D.Double(sv.xv, sv.yv)};
            routePoly = new Poly3D(pts1, fromZ, fromZ);
            routePoly.setLayer(tech.findLayer("Metal-1"));
            routePoly.setColor(Color.BLACK);
            routePoly.setStyle(Poly.Type.TEXTCENT);
            routePoly.setText(sv.cost + "");
            polys.add(routePoly);
        }
    }

    private static class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth() * pn1.getDefHeight();
            if (sz1 < (sz2 = pn2.getDefWidth() * pn2.getDefHeight())) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o) {
            this.vias.add(new MetalVia(pn, o));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;

        MetalVia(PrimitiveNode v, int o) {
            this.via = v;
            this.orientation = o;
        }
    }

    private class BlockageVisitor
    extends HierarchyEnumerator.Visitor {
        private List<ArcInst> arcsToRoute;
        private boolean didTopLevel;

        public BlockageVisitor(List<ArcInst> arcsToRoute) {
            this.arcsToRoute = arcsToRoute;
            this.didTopLevel = false;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            AffineTransform trans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                int netID = -1;
                Network net = nl.getNetwork(ai, 0);
                if (net != null) {
                    netID = info.getNetID(net);
                }
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    SeaOfGatesEngine.this.addLayer(polys[i], trans, netID, false);
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni;
            Network net;
            if (info.isRootCell() && !this.didTopLevel) {
                this.didTopLevel = true;
                if (this.arcsToRoute != null) {
                    Netlist nl = info.getNetlist();
                    for (ArcInst ai : this.arcsToRoute) {
                        net = nl.getNetwork(ai, 0);
                        int netID = info.getNetID(net);
                        SeaOfGatesEngine.this.netIDs.put(ai, new Integer(netID + 1));
                    }
                }
            }
            Cell cell = info.getCell();
            HashMap<NodeInst, Network> nodeExtraction = (HashMap<NodeInst, Network>)SeaOfGatesEngine.this.nodeExtractions.get(cell);
            if (nodeExtraction == null) {
                Network net2;
                NodeInst ni2;
                nodeExtraction = new HashMap<NodeInst, Network>();
                SeaOfGatesEngine.this.nodeExtractions.put(cell, nodeExtraction);
                Iterator<NodeInst> it = cell.getNodes();
                while (it.hasNext()) {
                    ni2 = it.next();
                    if (!ni2.hasExports() || ni2.getFunction() != PrimitiveNode.Function.NODE || nodeExtraction.containsKey(ni2)) continue;
                    Netlist nl = info.getNetlist();
                    net2 = nl.getNetwork(ni2, ni2.getOnlyPortInst().getPortProto(), 0);
                    nodeExtraction.put(ni2, net2);
                    this.recursivelyExtract(ni2, net2, nodeExtraction);
                }
                it = cell.getNodes();
                while (it.hasNext()) {
                    ni2 = it.next();
                    if (ni2.getFunction() != PrimitiveNode.Function.NODE || nodeExtraction.containsKey(ni2)) continue;
                    Netlist nl = info.getNetlist();
                    net2 = nl.getNetwork(ni2, ni2.getOnlyPortInst().getPortProto(), 0);
                    nodeExtraction.put(ni2, net2);
                    this.recursivelyExtract(ni2, net2, nodeExtraction);
                }
            }
            if (!(ni = no.getNodeInst()).isCellInstance()) {
                net = (Network)nodeExtraction.get(ni);
                Netlist nl = info.getNetlist();
                AffineTransform trans = info.getTransformToRoot();
                AffineTransform nodeTrans = ni.rotateOut(trans);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                boolean canPlacePseudo = info.isRootCell();
                if (!ni.hasExports()) {
                    canPlacePseudo = false;
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Poly poly = nodeInstPolyList[i];
                    if (net == null && poly.getPort() != null) {
                        net = nl.getNetwork(no, poly.getPort(), 0);
                    }
                    int netID = -1;
                    if (net != null) {
                        netID = info.getNetID(net);
                    }
                    SeaOfGatesEngine.this.addLayer(poly, nodeTrans, netID, canPlacePseudo);
                }
            }
            return true;
        }

        private void recursivelyExtract(NodeInst ni, Network net, Map<NodeInst, Network> nodeExtraction) {
            Rectangle2D bounds = ni.getBounds();
            Rectangle2D.Double bound = new Rectangle2D.Double(bounds.getMinX() - 1.0, bounds.getMinY() - 1.0, bounds.getWidth() + 2.0, bounds.getHeight() + 2.0);
            Cell cell = ni.getParent();
            Iterator<RTBounds> it = cell.searchIterator(bound);
            while (it.hasNext()) {
                Rectangle2D oBounds;
                NodeInst oNi;
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom).getProto() != ni.getProto() || !DBMath.rectsIntersect(bounds, oBounds = oNi.getBounds())) continue;
                Network oNet = nodeExtraction.get(oNi);
                if (oNet != null) {
                    if (net == oNet) continue;
                    ArrayList<NodeInst> switchEm = new ArrayList<NodeInst>();
                    for (NodeInst testNI : nodeExtraction.keySet()) {
                        if (nodeExtraction.get(testNI) != net) continue;
                        switchEm.add(testNI);
                    }
                    for (NodeInst testNI : switchEm) {
                        nodeExtraction.put(testNI, oNet);
                    }
                    continue;
                }
                nodeExtraction.put(oNi, net);
                this.recursivelyExtract(oNi, net, nodeExtraction);
            }
        }
    }

    private static class SOGVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        SOGVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGVia on net " + this.netID;
        }
    }

    private static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(Rectangle2D bound, int netID, PolyBase poly) {
            super(bound, netID);
            this.poly = poly;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    public static class SOGBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        SOGBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        @Override
        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGBound on net " + this.netID;
        }
    }

    protected static class RouteBatches {
        Set<ArcInst> unroutedArcs;
        Set<NodeInst> unroutedNodes;
        List<PortInst> orderedPorts;
        int segsInBatch;
        int numRouted;
        int numUnrouted;

        protected RouteBatches() {
        }
    }

    class DijkstraInThread
    extends Thread {
        private Wavefront wf;
        private Wavefront otherWf;
        private Semaphore whenDone;
        private Environment env;
        private EditingPreferences ep;

        public DijkstraInThread(String name, Wavefront wf, Wavefront otherWf, Semaphore whenDone, Environment env, EditingPreferences ep) {
            super(name);
            this.wf = wf;
            this.otherWf = otherWf;
            this.whenDone = whenDone;
            this.env = env;
            this.ep = ep;
            this.start();
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(this.env);
            EditingPreferences.setThreadEditingPreferences(this.ep);
            SearchVertex result2 = null;
            while (result2 == null) {
                if (this.wf.abort) {
                    result2 = svAborted;
                    continue;
                }
                result2 = this.wf.advanceWavefront();
            }
            if (result2 != svAborted && result2 != svExhausted && result2 != svLimited) {
                this.wf.vertices = SeaOfGatesEngine.this.getOptimizedList(result2);
                this.wf.nr.winningWF = this.wf;
                this.otherWf.abort = true;
            }
            this.whenDone.release();
        }
    }

    public static class SearchVertex
    implements Comparable<SearchVertex> {
        private double xv;
        private double yv;
        private int zv;
        private int cost;
        private int cutLayer;
        private boolean autoGen;
        private Point2D[] cuts;
        private SearchVertex last;
        private Wavefront wf;

        SearchVertex(double x2, double y, int z, int whichContact, Point2D[] cuts, int cl, Wavefront w) {
            this.xv = x2;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cuts = cuts;
            this.cutLayer = cl;
            this.autoGen = false;
            this.wf = w;
        }

        public double getX() {
            return this.xv;
        }

        public double getY() {
            return this.yv;
        }

        public int getZ() {
            return this.zv >> 8;
        }

        public SearchVertex getLast() {
            return this.last;
        }

        public int getCost() {
            return this.cost;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Point2D[] getCuts() {
            return this.cuts;
        }

        void clearCuts() {
            this.cuts = null;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        boolean isAutoGen() {
            return this.autoGen;
        }

        void setAutoGen(boolean a) {
            this.autoGen = a;
        }

        @Override
        public int compareTo(SearchVertex svo) {
            int diff2 = this.cost - svo.cost;
            if (diff2 != 0) {
                return diff2;
            }
            if (this.wf != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.wf.toX) + Math.abs(this.yv - this.wf.toY) + (double)Math.abs(this.zv - this.wf.toZ);
                if (thisDist < (otherDist = Math.abs(svo.xv - this.wf.toX) + Math.abs(svo.yv - this.wf.toY) + (double)Math.abs(svo.zv - this.wf.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }

        private void generateIntermediateVertex() {
            SearchVertex prevSV = this.last;
            double dX = 0.0;
            double dY = 0.0;
            if (this.getX() > prevSV.getX()) {
                dX = -1.0;
            } else if (this.getX() < prevSV.getX()) {
                dX = 1.0;
            } else if (this.getY() > prevSV.getY()) {
                dY = -1.0;
            } else if (this.getY() < prevSV.getY()) {
                dY = 1.0;
            }
            if (dX == 0.0 && dY == 0.0) {
                return;
            }
            double newX = this.getX() + dX;
            int z = this.getZ();
            for (double newY = this.getY() + dY; !(dX < 0.0 && newX < prevSV.getX() || dX > 0.0 && newX > prevSV.getX() || dY < 0.0 && newY < prevSV.getY() || dY > 0.0 && newY > prevSV.getY()); newX += dX, newY += dY) {
                if (this.wf.isVertex(newX, newY, z)) continue;
                SearchVertex svIntermediate = new SearchVertex(newX, newY, z, this.getContactNo(), this.getCuts(), z, this.wf);
                svIntermediate.setAutoGen(true);
                svIntermediate.last = prevSV;
                svIntermediate.cost = this.cost + 1;
                if (RoutingDebug.isActive()) {
                    RoutingDebug.identifyNewDebugPoint(svIntermediate);
                }
                this.wf.setVertex(newX, newY, z);
                this.wf.active.add(svIntermediate);
                break;
            }
        }
    }

    public class Wavefront {
        NeededRoute nr;
        String name;
        private TreeSet<SearchVertex> active;
        private List<SearchVertex> inactive;
        List<SearchVertex> vertices;
        boolean abort;
        PortInst from;
        PortInst to;
        double fromX;
        double fromY;
        int fromZ;
        double toX;
        double toY;
        int toZ;
        int numStepsMade;
        Map<Integer, Set<Integer>>[] searchVertexPlanes;
        Map<Double, Set<Double>>[] searchVertexPlanesDBL;
        private Map<Double, Map<Double, Double>>[] layerSurround;

        Wavefront(NeededRoute nr, PortInst from2, double fromX, double fromY, int fromZ, PortInst to2, double toX, double toY, int toZ, String name) {
            this.nr = nr;
            this.from = from2;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.to = to2;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
            this.name = name;
            this.numStepsMade = 0;
            this.active = new TreeSet();
            this.inactive = new ArrayList<SearchVertex>();
            this.vertices = null;
            this.abort = false;
            this.searchVertexPlanes = new Map[numMetalLayers];
            this.searchVertexPlanesDBL = new Map[numMetalLayers];
            this.layerSurround = new Map[numMetalLayers];
            for (int i = 0; i < numMetalLayers; ++i) {
                this.layerSurround[i] = new HashMap<Double, Map<Double, Double>>();
            }
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0, null, 0, this);
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ);
            if (RoutingDebug.isActive()) {
                RoutingDebug.identifyNewDebugPoint(svStart);
            }
            this.active.add(svStart);
        }

        public PortInst getFromPortInst() {
            return this.from;
        }

        public PortInst getToPortInst() {
            return this.to;
        }

        public double getFromX() {
            return this.fromX;
        }

        public double getFromY() {
            return this.fromY;
        }

        public int getFromZ() {
            return this.fromZ;
        }

        public double getToX() {
            return this.toX;
        }

        public double getToY() {
            return this.toY;
        }

        public int getToZ() {
            return this.toZ;
        }

        public SearchVertex getNextSearchVertex() {
            if (this.active.size() == 0) {
                return svExhausted;
            }
            return this.active.first();
        }

        public boolean isVertex(double x2, double y, int z) {
            Map<Integer, Set<Integer>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                return false;
            }
            Set<Integer> row = plane.get(new Integer((int)Math.round(y * 400.0)));
            if (row == null) {
                return false;
            }
            boolean found = row.contains(new Integer((int)Math.round(x2 * 400.0)));
            return found;
        }

        public void setVertex(double x2, double y, int z) {
            Integer iY;
            Set<Integer> row;
            Map<Integer, Set<Integer>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                this.searchVertexPlanes[z] = plane = new HashMap<Integer, Set<Integer>>();
            }
            if ((row = plane.get(iY = new Integer((int)Math.round(y * 400.0)))) == null) {
                row = new HashSet<Integer>();
                plane.put(iY, row);
            }
            row.add(new Integer((int)Math.round(x2 * 400.0)));
        }

        public double getSpacingRule(int layer, double width, double length) {
            Double value2;
            if (width < 0.0) {
                width = SeaOfGatesEngine.this.metalArcs[layer].getDefaultLambdaBaseWidth();
            }
            if (length < 0.0) {
                length = 50.0;
            }
            Double wid = new Double(SeaOfGatesEngine.this.upToGrain(width));
            Double len = new Double(SeaOfGatesEngine.this.upToGrain(length));
            Map<Double, Double> widMap = this.layerSurround[layer].get(wid);
            if (widMap == null) {
                widMap = new HashMap<Double, Double>();
                this.layerSurround[layer].put(wid, widMap);
            }
            if ((value2 = widMap.get(len)) == null) {
                Layer lay = SeaOfGatesEngine.this.metalLayers[layer];
                DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
                double v = 0.0;
                if (rule != null) {
                    v = rule.getValue(0);
                }
                value2 = new Double(v);
                widMap.put(len, value2);
            }
            return value2;
        }

        public SearchVertex advanceWavefront() {
            ++this.numStepsMade;
            if (this.numStepsMade > ((SeaOfGatesEngine)SeaOfGatesEngine.this).prefs.complexityLimit) {
                return svLimited;
            }
            SearchVertex svCurrent = this.getNextSearchVertex();
            if (svCurrent == svExhausted) {
                return svCurrent;
            }
            this.active.remove(svCurrent);
            this.inactive.add(svCurrent);
            double curX = svCurrent.getX();
            double curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            String debStr = null;
            if (RoutingDebug.isActive()) {
                debStr = "AT (" + TextUtils.formatDouble(curX) + "," + TextUtils.formatDouble(curY) + ",M" + (curZ + 1) + "), Cost=" + svCurrent.cost;
            }
            if (svCurrent.isAutoGen()) {
                svCurrent.generateIntermediateVertex();
            }
            SearchVertex destinationSV = null;
            for (int i = 0; i < 6; ++i) {
                boolean foundDest;
                double dx = 0.0;
                double dy = 0.0;
                int dz = 0;
                switch (i) {
                    case 0: {
                        dx = -1.0;
                        double intermediate = SeaOfGatesEngine.this.upToGrainAlways(curX + dx);
                        if (intermediate == curX + dx) break;
                        dx = intermediate - curX;
                        break;
                    }
                    case 1: {
                        dx = 1.0;
                        double intermediate = SeaOfGatesEngine.this.downToGrainAlways(curX + dx);
                        if (intermediate == curX + dx) break;
                        dx = intermediate - curX;
                        break;
                    }
                    case 2: {
                        dy = -1.0;
                        double intermediate = SeaOfGatesEngine.this.upToGrainAlways(curY + dy);
                        if (intermediate == curY + dy) break;
                        dy = intermediate - curY;
                        break;
                    }
                    case 3: {
                        dy = 1.0;
                        double intermediate = SeaOfGatesEngine.this.downToGrainAlways(curY + dy);
                        if (intermediate == curY + dy) break;
                        dy = intermediate - curY;
                        break;
                    }
                    case 4: {
                        dz = -1;
                        break;
                    }
                    case 5: {
                        dz = 1;
                    }
                }
                boolean stuck = false;
                if (dz == 0) {
                    boolean goFarther = false;
                    if (dx != 0.0) {
                        if ((this.toX - curX) * dx > 0.0) {
                            goFarther = true;
                        }
                    } else if ((this.toY - curY) * dy > 0.0) {
                        goFarther = true;
                    }
                    if (goFarther) {
                        double jumpSize = this.getJumpSize(curX, curY, curZ, dx, dy);
                        if (dx > 0.0) {
                            if (jumpSize <= 0.0) {
                                stuck = true;
                            }
                            dx = jumpSize;
                        }
                        if (dx < 0.0) {
                            if (jumpSize >= 0.0) {
                                stuck = true;
                            }
                            dx = jumpSize;
                        }
                        if (dy > 0.0) {
                            if (jumpSize <= 0.0) {
                                stuck = true;
                            }
                            dy = jumpSize;
                        }
                        if (dy < 0.0) {
                            if (jumpSize >= 0.0) {
                                stuck = true;
                            }
                            dy = jumpSize;
                        }
                    }
                }
                double nX = curX + dx;
                double nY = curY + dy;
                int nZ = curZ + dz;
                if (RoutingDebug.isActive()) {
                    switch (i) {
                        case 0: {
                            debStr = debStr + "/Move X -" + TextUtils.formatDouble(Math.abs(dx));
                            break;
                        }
                        case 1: {
                            debStr = debStr + "/Move X +" + TextUtils.formatDouble(dx);
                            break;
                        }
                        case 2: {
                            debStr = debStr + "/Move Y -" + TextUtils.formatDouble(Math.abs(dy));
                            break;
                        }
                        case 3: {
                            debStr = debStr + "/Move Y +" + TextUtils.formatDouble(dy);
                            break;
                        }
                        case 4: {
                            debStr = debStr + "/Move down layer";
                            break;
                        }
                        case 5: {
                            debStr = debStr + "/Move up layer";
                        }
                    }
                }
                if (stuck) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Cannot Move";
                    continue;
                }
                if (nX < this.nr.minimumSearchBoundX && (dx = (nX = this.nr.minimumSearchBoundX) - curX) == 0.0) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Out Of Bounds";
                    continue;
                }
                if (nX > this.nr.maximumSearchBoundX && (dx = (nX = this.nr.maximumSearchBoundX) - curX) == 0.0) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Out Of Bounds";
                    continue;
                }
                if (nY < this.nr.minimumSearchBoundY && (dy = (nY = this.nr.minimumSearchBoundY) - curY) == 0.0) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Out Of Bounds";
                    continue;
                }
                if (nY > this.nr.maximumSearchBoundY && (dy = (nY = this.nr.maximumSearchBoundY) - curY) == 0.0) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Out Of Bounds";
                    continue;
                }
                if (nZ < 0 || nZ >= numMetalLayers) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Out Of Bounds";
                    continue;
                }
                if (SeaOfGatesEngine.this.preventArcs[nZ]) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Illegal Arc";
                    continue;
                }
                if (this.isVertex(nX, nY, nZ)) {
                    if (!RoutingDebug.isActive()) continue;
                    debStr = debStr + ": Already Visited";
                    continue;
                }
                int whichContact = 0;
                Point2D[] cuts = null;
                if (dz == 0) {
                    double width = Math.max(SeaOfGatesEngine.this.metalArcs[nZ].getDefaultLambdaBaseWidth(), this.nr.minWidth);
                    double metalSpacing = width / 2.0;
                    boolean allClear = false;
                    double initNX = nX;
                    double initNY = nY;
                    while (true) {
                        double newNY;
                        double newNX;
                        SOGBound sb;
                        SearchVertex prevPath = svCurrent;
                        double checkX = (curX + nX) / 2.0;
                        double checkY = (curY + nY) / 2.0;
                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                        while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                            if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                                checkY = (prevPath.last.yv + nY) / 2.0;
                                halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                                prevPath = prevPath.last;
                                continue;
                            }
                            if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                            checkX = (prevPath.last.xv + nX) / 2.0;
                            halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                            prevPath = prevPath.last;
                        }
                        if ((sb = this.getMetalBlockageAndNotch(nZ, halfWid, halfHei, checkX, checkY, prevPath)) == null) {
                            allClear = true;
                            break;
                        }
                        if (RoutingDebug.isActive()) {
                            debStr = debStr + ": Blocked on M" + (nZ + 1) + " because proposed " + TextUtils.formatDouble(checkX - halfWid) + "<=X<=" + TextUtils.formatDouble(checkX + halfWid) + " and " + TextUtils.formatDouble(checkY - halfHei) + "<=Y<=" + TextUtils.formatDouble(checkY + halfHei) + " conflicts with " + TextUtils.formatDouble(sb.bound.getMinX()) + "<=X<=" + TextUtils.formatDouble(sb.bound.getMaxX()) + " and " + TextUtils.formatDouble(sb.bound.getMinY()) + "<=Y<=" + TextUtils.formatDouble(sb.bound.getMaxY());
                        }
                        if (i == 0 ? (newNX = SeaOfGatesEngine.this.downToGrainAlways(nX + 1.0)) >= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0 : (i == 1 ? (newNX = SeaOfGatesEngine.this.upToGrainAlways(nX - 1.0)) <= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0 : (i == 2 ? (newNY = SeaOfGatesEngine.this.downToGrainAlways(nY + 1.0)) >= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0 : i == 3 && ((newNY = SeaOfGatesEngine.this.upToGrainAlways(nY - 1.0)) <= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0)))) break;
                        nX = curX + dx;
                        nY = curY + dy;
                    }
                    if (!allClear) {
                        double surround;
                        double halfHei;
                        if (!RoutingDebug.isActive()) continue;
                        double checkX = (curX + nX) / 2.0;
                        double checkY = (curY + nY) / 2.0;
                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                        SOGBound sb = SeaOfGatesEngine.this.getMetalBlockage(this.nr.netID, nZ, halfWid, halfHei = metalSpacing + Math.abs(dy) / 2.0, surround = SeaOfGatesEngine.this.worstMetalSurround[nZ], checkX, checkY);
                        if (sb != null) {
                            debStr = debStr + ": Blocked";
                            continue;
                        }
                        debStr = debStr + ": Blocked, Notch";
                        continue;
                    }
                    if (RoutingDebug.isActive() && (initNX != nX || initNY != nY)) {
                        debStr = debStr + " so move only ";
                        switch (i) {
                            case 0: {
                                debStr = debStr + TextUtils.formatDouble(Math.abs(dx));
                                break;
                            }
                            case 1: {
                                debStr = debStr + TextUtils.formatDouble(dx);
                                break;
                            }
                            case 2: {
                                debStr = debStr + TextUtils.formatDouble(Math.abs(dy));
                                break;
                            }
                            case 3: {
                                debStr = debStr + TextUtils.formatDouble(dy);
                            }
                        }
                    }
                } else {
                    int contactNo;
                    int lowMetal = Math.min(curZ, nZ);
                    int highMetal = Math.max(curZ, nZ);
                    List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[lowMetal].getVias();
                    whichContact = -1;
                    String[] failureReasons = null;
                    if (RoutingDebug.isActive()) {
                        failureReasons = new String[nps.size()];
                    }
                    for (contactNo = 0; contactNo < nps.size(); ++contactNo) {
                        MetalVia mv = nps.get(contactNo);
                        PrimitiveNode np = mv.via;
                        Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                        SizeOffset so = np.getProtoSizeOffset();
                        double conWid = Math.max(np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset(), this.nr.minWidth) + so.getLowXOffset() + so.getHighXOffset();
                        double conHei = Math.max(np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset(), this.nr.minWidth) + so.getLowYOffset() + so.getHighYOffset();
                        NodeInst dummyNi = NodeInst.makeDummyInstance(np, new EPoint(nX, nY), conWid, conHei, orient);
                        Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                        AffineTransform trans = null;
                        if (orient != Orientation.IDENT) {
                            trans = dummyNi.rotateOut();
                        }
                        int cutCount = 0;
                        for (int p = 0; p < conPolys.length; ++p) {
                            if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                            ++cutCount;
                        }
                        Point2D[] curCuts = new Point2D[cutCount];
                        cutCount = 0;
                        String failedReason = null;
                        for (int p = 0; p < conPolys.length; ++p) {
                            SearchVertex lastSv;
                            Rectangle2D conRect;
                            Layer conLayer;
                            Layer.Function lFun;
                            Poly conPoly = conPolys[p];
                            if (trans != null) {
                                conPoly.transform(trans);
                            }
                            if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                                double halfHei;
                                double halfWid;
                                conRect = conPoly.getBounds2D();
                                int metalNo = lFun.getLevel() - 1;
                                if (this.getMetalBlockageAndNotch(metalNo, halfWid = conRect.getWidth() / 2.0, halfHei = conRect.getHeight() / 2.0, conRect.getCenterX(), conRect.getCenterY(), svCurrent) == null) continue;
                                if (failureReasons == null) {
                                    failedReason = "";
                                    break;
                                }
                                failedReason = "layer " + conLayer.getName() + " at " + TextUtils.formatDouble(conRect.getMinX()) + "<=X<=" + TextUtils.formatDouble(conRect.getMaxX()) + " and " + TextUtils.formatDouble(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDouble(conRect.getMaxY());
                                break;
                            }
                            if (!lFun.isContact()) continue;
                            conRect = conPoly.getBounds2D();
                            double conCX = conRect.getCenterX();
                            double conCY = conRect.getCenterY();
                            double surround = SeaOfGatesEngine.this.viaSurround[lowMetal];
                            if (SeaOfGatesEngine.this.getViaBlockage(this.nr.netID, conLayer, surround, surround, conCX, conCY) != null) {
                                if (failureReasons == null) {
                                    failedReason = "";
                                    break;
                                }
                                failedReason = "cut " + conLayer.getName() + " at " + TextUtils.formatDouble(conRect.getMinX()) + "<=X<=" + TextUtils.formatDouble(conRect.getMaxX()) + " and " + TextUtils.formatDouble(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDouble(conRect.getMaxY());
                                break;
                            }
                            curCuts[cutCount++] = new Point2D.Double(conCX, conCY);
                            SearchVertex sv = svCurrent;
                            while (sv != null && (lastSv = sv.last) != null) {
                                if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                    Point2D[] svCuts = sv.getCutLayer() == lowMetal ? sv.getCuts() : lastSv.getCuts();
                                    if (svCuts != null) {
                                        for (Point2D cutPt : svCuts) {
                                            if (Math.abs(cutPt.getX() - conCX) >= surround || Math.abs(cutPt.getY() - conCY) >= surround) continue;
                                            if (failureReasons == null) {
                                                failedReason = "";
                                                break;
                                            }
                                            failedReason = "path cut " + conLayer.getName() + " at " + TextUtils.formatDouble(conRect.getMinX()) + "<=X<=" + TextUtils.formatDouble(conRect.getMaxX()) + " and " + TextUtils.formatDouble(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDouble(conRect.getMaxY());
                                            break;
                                        }
                                    }
                                    if (failedReason != null) break;
                                }
                                sv = sv.last;
                            }
                            if (failedReason != null) break;
                        }
                        if (failedReason != null) {
                            if (!RoutingDebug.isActive()) continue;
                            failureReasons[contactNo] = failedReason;
                            continue;
                        }
                        whichContact = contactNo;
                        cuts = curCuts;
                        break;
                    }
                    if (whichContact < 0) {
                        if (!RoutingDebug.isActive()) continue;
                        debStr = debStr + ": Blocked because";
                        for (contactNo = 0; contactNo < failureReasons.length; ++contactNo) {
                            MetalVia mv = nps.get(contactNo);
                            debStr = debStr + "|In " + mv.via.describe(false) + " (rotated " + mv.orientation + ") cannot place " + failureReasons[contactNo];
                        }
                        continue;
                    }
                }
                boolean bl = foundDest = DBMath.areEquals(nX, this.toX) && DBMath.areEquals(nY, this.toY) && nZ == this.toZ;
                if (foundDest && (Math.abs(dx) > 10.0 && nZ % 2 == 0 || Math.abs(dy) > 10.0 && nZ % 2 != 0)) continue;
                SearchVertex svNext = new SearchVertex(nX, nY, nZ, whichContact, cuts, Math.min(curZ, nZ), this);
                if (dz == 0 && (Math.abs(dx) >= 2.0 || Math.abs(dy) >= 2.0)) {
                    svNext.setAutoGen(true);
                }
                svNext.last = svCurrent;
                if (foundDest) {
                    if (RoutingDebug.isActive()) {
                        debStr = debStr + ": Found Destination!";
                    }
                    destinationSV = svNext;
                    continue;
                }
                svNext.cost = svCurrent.cost;
                String costExplanation = "";
                boolean penaltyOffGridX = SeaOfGatesEngine.this.downToGrainAlways(nX) != nX && nX != this.toX;
                boolean penaltyOffGridY = SeaOfGatesEngine.this.downToGrainAlways(nY) != nY && nY != this.toY;
                double distBefore = Math.sqrt((curX - this.toX) * (curX - this.toX) + (curY - this.toY) * (curY - this.toY));
                double distAfter = Math.sqrt((nX - this.toX) * (nX - this.toX) + (nY - this.toY) * (nY - this.toY));
                int c = (int)((distAfter - distBefore) / 5.0);
                svNext.cost += c;
                if (RoutingDebug.isActive()) {
                    costExplanation = " [Dist-to-target=" + c;
                }
                if (dx != 0.0) {
                    if (this.toX == curX) {
                        c = 7;
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Zero-X-progress=" + c;
                        }
                    } else if ((this.toX - curX) * dx < 0.0) {
                        if (this.toY == curY) {
                            c = 1;
                            svNext.cost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Backward-X-progress-at-dest-Y=" + c;
                            }
                        } else {
                            c = 15;
                            svNext.cost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Backward-X-progress=" + c;
                            }
                        }
                    }
                    if (nZ % 2 == 0) {
                        c = 20 * (int)Math.abs(dx);
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Not-alternating-metal=" + c;
                        }
                    }
                }
                if (dy != 0.0) {
                    if (this.toY == curY) {
                        c = 7;
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Zero-Y-progress=" + c;
                        }
                    } else if ((this.toY - curY) * dy < 0.0) {
                        if (this.toX == curX) {
                            c = 1;
                            svNext.cost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Backward-Y-progress-at-dest-X=" + c;
                            }
                        } else {
                            c = 15;
                            svNext.cost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Backward-Y-progress=" + c;
                            }
                        }
                    }
                    if (nZ % 2 != 0) {
                        c = 20 * (int)Math.abs(dy);
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Not-alternating-metal=" + c;
                        }
                    }
                }
                if (dz != 0) {
                    if (this.toZ == curZ) {
                        c = 8;
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Layer-change=" + c;
                        }
                    } else if ((this.toZ - curZ) * dz < 0) {
                        c = 9;
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Layer-change-wrong-direction=" + c;
                        }
                    }
                } else {
                    double jumpSize1 = Math.abs(this.getJumpSize(nX, nY, nZ, dx, dy));
                    double jumpSize2 = Math.abs(this.getJumpSize(curX, curY, curZ, -dx, -dy));
                    if (jumpSize1 > 1.0 && jumpSize2 > 1.0) {
                        c = (int)(jumpSize1 * jumpSize2 / 10.0);
                        svNext.cost += c;
                        if (RoutingDebug.isActive()) {
                            costExplanation = costExplanation + " Fragments-track=" + c;
                        }
                    }
                    if (svCurrent.last != null) {
                        boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                        boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                        if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                            c = 1;
                            svNext.cost += c;
                            if (RoutingDebug.isActive()) {
                                costExplanation = costExplanation + " Turning=" + c;
                            }
                        }
                    }
                }
                if (!SeaOfGatesEngine.this.favorArcs[nZ]) {
                    c = (int)((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy));
                    svNext.cost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Layer-unfavored=" + c;
                    }
                }
                if (penaltyOffGridX) {
                    c = 15;
                    svNext.cost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Off-X-grid=" + c;
                    }
                }
                if (penaltyOffGridY) {
                    c = 15;
                    svNext.cost += c;
                    if (RoutingDebug.isActive()) {
                        costExplanation = costExplanation + " Off-Y-grid=" + c;
                    }
                }
                this.setVertex(nX, nY, nZ);
                this.active.add(svNext);
                if (RoutingDebug.isActive()) {
                    debStr = debStr + ": To (" + TextUtils.formatDouble(svNext.getX()) + "," + TextUtils.formatDouble(svNext.getY()) + ",M" + (svNext.getZ() + 1) + "), Cost=" + svNext.cost + costExplanation + "]";
                }
                if (!RoutingDebug.isActive()) continue;
                RoutingDebug.identifyNewDebugPoint(svNext);
            }
            if (RoutingDebug.isActive()) {
                RoutingDebug.endProcessingSV(svCurrent, debStr);
            }
            return destinationSV;
        }

        private double getJumpSize(double curX, double curY, int curZ, double dx, double dy) {
            Rectangle2D jumpBound = this.nr.jumpBound;
            double width = Math.max(SeaOfGatesEngine.this.metalArcs[curZ].getDefaultLambdaBaseWidth(), this.nr.minWidth);
            double metalToMetal = this.getSpacingRule(curZ, width, -1.0);
            double metalSpacing = width / 2.0 + metalToMetal;
            double lX = curX - metalSpacing;
            double hX = curX + metalSpacing;
            double lY = curY - metalSpacing;
            double hY = curY + metalSpacing;
            if (dx > 0.0) {
                hX = jumpBound.getMaxX() + metalSpacing;
            } else if (dx < 0.0) {
                lX = jumpBound.getMinX() - metalSpacing;
            } else if (dy > 0.0) {
                hY = jumpBound.getMaxY() + metalSpacing;
            } else if (dy < 0.0) {
                lY = jumpBound.getMinY() - metalSpacing;
            }
            RTNode rtree = (RTNode)SeaOfGatesEngine.this.metalTrees.get(SeaOfGatesEngine.this.metalLayers[curZ]);
            if (rtree != null) {
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
                while (sea.hasNext()) {
                    Rectangle2D bound;
                    SOGBound sBound = (SOGBound)sea.next();
                    if (Math.abs(sBound.getNetID()) == this.nr.netID || (bound = sBound.getBounds()).getMinX() >= hX || bound.getMaxX() <= lX || bound.getMinY() >= hY || bound.getMaxY() <= lY) continue;
                    if (dx > 0.0 && bound.getMinX() < hX) {
                        hX = bound.getMinX();
                    }
                    if (dx < 0.0 && bound.getMaxX() > lX) {
                        lX = bound.getMaxX();
                    }
                    if (dy > 0.0 && bound.getMinY() < hY) {
                        hY = bound.getMinY();
                    }
                    if (!(dy < 0.0) || !(bound.getMaxY() > lY)) continue;
                    lY = bound.getMaxY();
                }
            }
            if (dx > 0.0) {
                dx = SeaOfGatesEngine.this.downToGrain(hX - metalSpacing) - curX;
                if (curX + dx > this.toX && curY == this.toY && curZ == this.toZ) {
                    dx = this.toX - curX;
                }
                if (curX + dx != this.toX) {
                    dx = SeaOfGatesEngine.this.downToGrainAlways(hX - metalSpacing) - curX;
                }
                return dx;
            }
            if (dx < 0.0) {
                dx = SeaOfGatesEngine.this.upToGrain(lX + metalSpacing) - curX;
                if (curX + dx < this.toX && curY == this.toY && curZ == this.toZ) {
                    dx = this.toX - curX;
                }
                if (curX + dx != this.toX) {
                    dx = SeaOfGatesEngine.this.upToGrainAlways(lX + metalSpacing) - curX;
                }
                return dx;
            }
            if (dy > 0.0) {
                dy = SeaOfGatesEngine.this.downToGrain(hY - metalSpacing) - curY;
                if (curX == this.toX && curY + dy > this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                }
                if (curY + dy != this.toY) {
                    dy = SeaOfGatesEngine.this.downToGrainAlways(hY - metalSpacing) - curY;
                }
                return dy;
            }
            if (dy < 0.0) {
                dy = SeaOfGatesEngine.this.upToGrain(lY + metalSpacing) - curY;
                if (curX == this.toX && curY + dy < this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                }
                if (curY + dy != this.toY) {
                    dy = SeaOfGatesEngine.this.upToGrainAlways(lY + metalSpacing) - curY;
                }
                return dy;
            }
            return 0.0;
        }

        private SOGBound getMetalBlockageAndNotch(int metNo, double halfWidth, double halfHeight, double x2, double y, SearchVertex svCurrent) {
            Layer layer = SeaOfGatesEngine.this.metalLayers[metNo];
            RTNode rtree = (RTNode)SeaOfGatesEngine.this.metalTrees.get(layer);
            if (rtree == null) {
                return null;
            }
            int netID = this.nr.netID;
            double minWidth = this.nr.minWidth;
            double metLX = x2 - halfWidth;
            double metHX = x2 + halfWidth;
            double metLY = y - halfHeight;
            double metHY = y + halfHeight;
            Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
            double metWid = Math.min(halfWidth, halfHeight) * 2.0;
            double metLen = Math.max(halfWidth, halfHeight) * 2.0;
            double surround = SeaOfGatesEngine.this.worstMetalSurround[metNo];
            double lX = metLX - surround;
            double hX = metHX + surround;
            double lY = metLY - surround;
            double hY = metHY + surround;
            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
            if (svCurrent != null) {
                List<SearchVertex> svList = SeaOfGatesEngine.this.getOptimizedList(svCurrent);
                for (int ind = 1; ind < svList.size(); ++ind) {
                    Poly poly;
                    Rectangle2D bound;
                    SearchVertex sv = svList.get(ind);
                    SearchVertex lastSv = svList.get(ind - 1);
                    if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                    if (sv.getZ() != lastSv.getZ()) {
                        List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                        int whichContact = lastSv.getContactNo();
                        MetalVia mv = nps.get(whichContact);
                        PrimitiveNode np = mv.via;
                        Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                        SizeOffset so = np.getProtoSizeOffset();
                        double xOffset = so.getLowXOffset() + so.getHighXOffset();
                        double yOffset = so.getLowYOffset() + so.getHighYOffset();
                        double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                        double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                        NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient);
                        AffineTransform trans = null;
                        if (orient != Orientation.IDENT) {
                            trans = ni.rotateOut();
                        }
                        Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                        for (int i = 0; i < polys.length; ++i) {
                            Rectangle2D bound2;
                            Poly poly2 = polys[i];
                            if (poly2.getLayer() != layer) continue;
                            if (trans != null) {
                                poly2.transform(trans);
                            }
                            if ((bound2 = poly2.getBounds2D()).getMaxX() <= lX || bound2.getMinX() >= hX || bound2.getMaxY() <= lY || bound2.getMinY() >= hY) continue;
                            recsOnPath.add(bound2);
                        }
                        continue;
                    }
                    ArcProto type = SeaOfGatesEngine.this.metalArcs[metNo];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                    Point2D.Double head2 = new Point2D.Double(sv.getX(), sv.getY());
                    Point2D.Double tail = new Point2D.Double(lastSv.getX(), lastSv.getY());
                    int ang = 0;
                    if (((Point2D)head2).getX() != ((Point2D)tail).getX() || ((Point2D)head2).getY() != ((Point2D)tail).getY()) {
                        ang = GenMath.figureAngle(tail, head2);
                    }
                    if ((bound = (poly = Poly.makeEndPointPoly(head2.distance(tail), width, ang, head2, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                    recsOnPath.add(bound);
                }
            }
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                Rectangle2D.Double drcArea;
                PolyBase poly;
                SOGBound sBound = (SOGBound)sea.next();
                Rectangle2D bound = sBound.getBounds();
                if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                double drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), metWid);
                double drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), metLen);
                double spacing = this.getSpacingRule(metNo, drWid, drLen);
                double lXAllow = metLX - spacing;
                double hXAllow = metHX + spacing;
                double lYAllow = metLY - spacing;
                double hYAllow = metHY + spacing;
                if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hYAllow)) continue;
                if (Math.abs(sBound.getNetID()) == netID) {
                    boolean notch;
                    if (sBound.getNetID() < 0 || !(notch = this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing))) continue;
                    return sBound;
                }
                if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
                return sBound;
            }
            double spacing = this.getSpacingRule(metNo, metWid, metLen);
            for (Rectangle2D bound : recsOnPath) {
                if (!this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing)) continue;
                return new SOGBound(bound, netID);
            }
            return null;
        }

        private boolean foundANotch(RTNode rtree, Rectangle2D metBound, Rectangle2D bound, int netID, List<Rectangle2D> recsOnPath, double dist) {
            boolean vOverlap;
            boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
            boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
            if (hOverlap && vOverlap) {
                return false;
            }
            if (hOverlap) {
                double ptY;
                if (metBound.getCenterY() > bound.getCenterY()) {
                    if (metBound.getMinY() - bound.getMaxY() > dist) {
                        return false;
                    }
                    ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
                } else {
                    if (bound.getMinY() - metBound.getMaxY() > dist) {
                        return false;
                    }
                    ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
                }
                double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
                double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
                double pt3X = (pt1X + pt2X) / 2.0;
                if (!this.pointInRTree(rtree, pt1X, ptY, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(rtree, pt2X, ptY, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(rtree, pt3X, ptY, netID, recsOnPath);
            }
            if (vOverlap) {
                double ptX;
                if (metBound.getCenterX() > bound.getCenterX()) {
                    if (metBound.getMinX() - bound.getMaxX() > dist) {
                        return false;
                    }
                    ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
                } else {
                    if (bound.getMinX() - metBound.getMaxX() > dist) {
                        return false;
                    }
                    ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
                }
                double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
                double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
                double pt3Y = (pt1Y + pt2Y) / 2.0;
                if (!this.pointInRTree(rtree, ptX, pt1Y, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(rtree, ptX, pt2Y, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(rtree, ptX, pt3Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                    return false;
                }
                if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                    return false;
                }
                if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                    return false;
                }
                if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                    return false;
                }
                if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
            }
            return false;
        }

        private boolean pointInRTree(RTNode rtree, double x2, double y, int netID, List<Rectangle2D> recsOnPath) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(x2 - 0.5, y - 0.5, 1.0, 1.0);
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound.getNetID() != netID || DBMath.isGreaterThan(sBound.getBounds().getMinX(), x2) || DBMath.isLessThan(sBound.getBounds().getMaxX(), x2) || DBMath.isGreaterThan(sBound.getBounds().getMinY(), y) || DBMath.isLessThan(sBound.getBounds().getMaxY(), y)) continue;
                return true;
            }
            for (Rectangle2D bound : recsOnPath) {
                if (DBMath.isGreaterThan(bound.getMinX(), x2) || DBMath.isLessThan(bound.getMaxX(), x2) || DBMath.isGreaterThan(bound.getMinY(), y) || DBMath.isLessThan(bound.getMaxY(), y)) continue;
                return true;
            }
            return false;
        }
    }

    public class NeededRoute {
        String routeName;
        int netID;
        double minWidth;
        int batchNumber;
        int routeInBatch;
        Rectangle2D routeBounds;
        double minimumSearchBoundX;
        double maximumSearchBoundX;
        double minimumSearchBoundY;
        double maximumSearchBoundY;
        Rectangle2D jumpBound;
        Wavefront dir1;
        Wavefront dir2;
        PortInst fromPi;
        PortInst toPi;
        protected Wavefront winningWF;
        SeaOfGates.SeaOfGatesOptions prefs;

        NeededRoute(String routeName, PortInst from2, double fromX, double fromY, int fromZ, PortInst to2, double toX, double toY, int toZ, int netID, double minWidth, int batchNumber, int routeInBatch, SeaOfGates.SeaOfGatesOptions prefs) {
            this.routeName = routeName;
            this.netID = netID;
            this.minWidth = minWidth;
            this.batchNumber = batchNumber;
            this.routeInBatch = routeInBatch;
            this.fromPi = from2;
            this.toPi = to2;
            this.prefs = prefs;
            SeaOfGatesEngine.this.cellBounds = SeaOfGatesEngine.this.cell.getBounds();
            this.minimumSearchBoundX = SeaOfGatesEngine.this.downToGrain(SeaOfGatesEngine.this.cellBounds.getMinX());
            this.maximumSearchBoundX = SeaOfGatesEngine.this.upToGrain(SeaOfGatesEngine.this.cellBounds.getMaxX());
            this.minimumSearchBoundY = SeaOfGatesEngine.this.downToGrain(SeaOfGatesEngine.this.cellBounds.getMinY());
            this.maximumSearchBoundY = SeaOfGatesEngine.this.upToGrain(SeaOfGatesEngine.this.cellBounds.getMaxY());
            double maxStrayFromRouteBounds = Math.min(SeaOfGatesEngine.this.cellBounds.getWidth(), SeaOfGatesEngine.this.cellBounds.getHeight()) * 7.0 / 100.0;
            this.routeBounds = new Rectangle2D.Double(Math.min(fromX, toX) - maxStrayFromRouteBounds, Math.min(fromY, toY) - maxStrayFromRouteBounds, Math.abs(fromX - toX) + maxStrayFromRouteBounds * 2.0, Math.abs(fromY - toY) + maxStrayFromRouteBounds * 2.0);
            this.minimumSearchBoundX = this.routeBounds.getMinX();
            this.maximumSearchBoundX = this.routeBounds.getMaxX();
            this.minimumSearchBoundY = this.routeBounds.getMinY();
            this.maximumSearchBoundY = this.routeBounds.getMaxY();
            this.jumpBound = new Rectangle2D.Double(Math.min(fromX, toX), Math.min(fromY, toY), Math.abs(fromX - toX), Math.abs(fromY - toY));
            if (RoutingDebug.isActive()) {
                RoutingDebug.setRouteDescription("Debugging search from (" + TextUtils.formatDouble(fromX) + "," + TextUtils.formatDouble(fromY) + ",M" + (fromZ + 1) + ") to (" + TextUtils.formatDouble(toX) + "," + TextUtils.formatDouble(toY) + ",M" + (toZ + 1) + ")");
            }
            this.dir1 = new Wavefront(this, from2, fromX, fromY, fromZ, to2, toX, toY, toZ, "a->b");
            this.dir2 = new Wavefront(this, to2, toX, toY, toZ, from2, fromX, fromY, fromZ, "b->a");
        }

        public Wavefront getAtoBDirection() {
            return this.dir1;
        }

        public Wavefront getBtoADirection() {
            return this.dir2;
        }

        public RTNode getMetalTree(Layer lay) {
            return (RTNode)SeaOfGatesEngine.this.metalTrees.get(lay);
        }

        protected void createRoute() {
            Wavefront wf = this.winningWF;
            PortInst lastPort = wf.to;
            Poly toPoly = wf.to.getPoly();
            if ((toPoly.getCenterX() != wf.toX || toPoly.getCenterY() != wf.toY) && wf.vertices.size() >= 2) {
                NodeInst ni;
                SearchVertex v1 = wf.vertices.get(0);
                SearchVertex v2 = wf.vertices.get(1);
                ArcProto type = SeaOfGatesEngine.this.metalArcs[wf.toZ];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), this.minWidth);
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[wf.toZ].findPinProto();
                if (v1.getX() == v2.getX()) {
                    ni = SeaOfGatesEngine.this.makeNodeInst(np, new EPoint(v1.getX(), toPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, SeaOfGatesEngine.this.cell, this.netID);
                    SeaOfGatesEngine.this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.to, this.netID);
                    lastPort = ni.getOnlyPortInst();
                } else if (v1.getY() == v2.getY()) {
                    ni = SeaOfGatesEngine.this.makeNodeInst(np, new EPoint(toPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, SeaOfGatesEngine.this.cell, this.netID);
                    SeaOfGatesEngine.this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.to, this.netID);
                    lastPort = ni.getOnlyPortInst();
                }
            }
            for (int i = 0; i < wf.vertices.size(); ++i) {
                SearchVertex sv = wf.vertices.get(i);
                boolean madeContacts = false;
                while (i < wf.vertices.size() - 1) {
                    SearchVertex svNext = wf.vertices.get(i + 1);
                    if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                    List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, this.minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, this.minWidth) + yOffset;
                    NodeInst ni = SeaOfGatesEngine.this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient, SeaOfGatesEngine.this.cell, this.netID);
                    ArcProto type = SeaOfGatesEngine.this.metalArcs[sv.getZ()];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), this.minWidth);
                    SeaOfGatesEngine.this.makeArcInst(type, width, lastPort, ni.getOnlyPortInst(), this.netID);
                    lastPort = ni.getOnlyPortInst();
                    madeContacts = true;
                    sv = svNext;
                    ++i;
                }
                if (madeContacts && i != wf.vertices.size() - 1) continue;
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[sv.getZ()].findPinProto();
                PortInst pi = null;
                if (i == wf.vertices.size() - 1) {
                    pi = wf.from;
                    Poly fromPoly = wf.from.getPoly();
                    if ((fromPoly.getCenterX() != sv.getX() || fromPoly.getCenterY() != sv.getY()) && wf.vertices.size() >= 2) {
                        PrimitiveNode pNp;
                        SearchVertex v1 = wf.vertices.get(wf.vertices.size() - 2);
                        SearchVertex v2 = wf.vertices.get(wf.vertices.size() - 1);
                        ArcProto type = SeaOfGatesEngine.this.metalArcs[wf.fromZ];
                        double width = Math.max(type.getDefaultLambdaBaseWidth(), this.minWidth);
                        if (v1.getX() == v2.getX()) {
                            pNp = SeaOfGatesEngine.this.metalArcs[wf.fromZ].findPinProto();
                            NodeInst ni = SeaOfGatesEngine.this.makeNodeInst(pNp, new EPoint(v1.getX(), fromPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, SeaOfGatesEngine.this.cell, this.netID);
                            SeaOfGatesEngine.this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.from, this.netID);
                            pi = ni.getOnlyPortInst();
                        } else if (v1.getY() == v2.getY()) {
                            pNp = SeaOfGatesEngine.this.metalArcs[wf.fromZ].findPinProto();
                            NodeInst ni = SeaOfGatesEngine.this.makeNodeInst(pNp, new EPoint(fromPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, SeaOfGatesEngine.this.cell, this.netID);
                            SeaOfGatesEngine.this.makeArcInst(type, width, ni.getOnlyPortInst(), wf.from, this.netID);
                            pi = ni.getOnlyPortInst();
                        }
                    }
                } else {
                    NodeInst ni = SeaOfGatesEngine.this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, SeaOfGatesEngine.this.cell, this.netID);
                    pi = ni.getOnlyPortInst();
                }
                if (lastPort != null) {
                    ArcProto type = SeaOfGatesEngine.this.metalArcs[sv.getZ()];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), this.minWidth);
                    SeaOfGatesEngine.this.makeArcInst(type, width, lastPort, pi, this.netID);
                }
                lastPort = pi;
            }
            Rectangle2D.Double routeBounds = new Rectangle2D.Double(Math.min(wf.fromX, wf.toX), Math.min(wf.fromY, wf.toY), Math.abs(wf.fromX - wf.toX), Math.abs(wf.fromY - wf.toY));
            double lowX = routeBounds.getMinX();
            double highX = routeBounds.getMaxX();
            double lowY = routeBounds.getMinY();
            double highY = routeBounds.getMaxY();
            for (int i = 0; i < wf.vertices.size(); ++i) {
                SearchVertex sv = wf.vertices.get(i);
                if (i == 0) {
                    lowX = highX = sv.getX();
                    lowY = highY = sv.getY();
                    continue;
                }
                if (sv.getX() < lowX) {
                    lowX = sv.getX();
                }
                if (sv.getX() > highX) {
                    highX = sv.getX();
                }
                if (sv.getY() < lowY) {
                    lowY = sv.getY();
                }
                if (!(sv.getY() > highY)) continue;
                highY = sv.getY();
            }
        }

        public void cleanSearchMemory() {
            this.dir1.searchVertexPlanes = null;
            this.dir1.searchVertexPlanesDBL = null;
            this.dir1.active = null;
            this.dir1.inactive = null;
            if (this.dir1.vertices != null) {
                for (SearchVertex sv : this.dir1.vertices) {
                    sv.clearCuts();
                }
            }
            this.dir2.searchVertexPlanes = null;
            this.dir2.searchVertexPlanesDBL = null;
            this.dir2.active = null;
            this.dir2.inactive = null;
            if (this.dir2.vertices != null) {
                for (SearchVertex sv : this.dir2.vertices) {
                    sv.clearCuts();
                }
            }
        }
    }
}

