/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellId;
import com.sun.electric.database.CellUsage;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.RTNode;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends ElectricObject
implements NodeProto,
Comparable<Cell> {
    public static final Variable.Key CHARACTERISTIC_SPACING = Variable.newKey("FACET_characteristic_spacing");
    public static final Variable.Key CELL_TEXT_KEY = Variable.newKey("FACET_message");
    public static final Variable.Key MULTIPAGE_COUNT_KEY = Variable.newKey("CELL_page_count");
    public static final Variable.Key TEXT_CELL_FONT_NAME = Variable.newKey("CELL_text_font");
    public static final Variable.Key TEXT_CELL_FONT_SIZE = Variable.newKey("CELL_text_size");
    private static final int[] NULL_INT_ARRAY = new int[0];
    private static final Export[] NULL_EXPORT_ARRAY = new Export[0];
    public static final int WANTNEXPAND = 2;
    public static final int NPLOCKED = 0x100000;
    public static final int NPILOCKED = 0x200000;
    public static final int INCELLLIBRARY = 0x400000;
    public static final int TECEDITCELL = 0x800000;
    private static final int MULTIPAGE = 0x7E000000;
    private static final int ABBREVLEN = 8;
    private static final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private static final byte BOUNDS_CORRECT = 0;
    private static final byte BOUNDS_CORRECT_SUB = 1;
    private static final byte BOUNDS_RECOMPUTE = 2;
    private final EDatabase database;
    private ImmutableCell d;
    private CellGroup cellGroup;
    private Library lib;
    Cell newestVersion;
    private Export[] chronExports = new Export[2];
    private Export[] exports = NULL_EXPORT_ARRAY;
    private final ArrayList<NodeInst> essenBounds = new ArrayList();
    private final ArrayList<NodeInst> chronNodes = new ArrayList();
    private final ArrayList<NodeInst> nodes = new ArrayList();
    private int[] cellUsages = NULL_INT_ARRAY;
    private final HashMap<String, MaxSuffix> maxSuffix = new HashMap();
    private int maxArcSuffix = -1;
    private final ArrayList<ArcInst> chronArcs = new ArrayList();
    private final ArrayList<ArcInst> arcs = new ArrayList();
    private ERectangle cellBounds;
    private byte boundsDirty = (byte)2;
    private RTNode rTree = RTNode.makeTopLevel();
    private long revisionDate;
    private boolean modified;
    private int tempInt;
    private boolean expandStatusModified;
    CellBackup backup;
    boolean cellBackupFresh;
    private boolean cellContentsFresh;
    private static boolean allowCirDep = false;

    Cell(EDatabase database, ImmutableCell d) {
        this.database = database;
        this.d = d;
        this.lib = database.getLib(d.libId);
        assert (this.lib != null);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new CellKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Cell");
    }

    public static Cell makeInstance(Library lib, String name) {
        PrimitiveNode cellCenterProto;
        NodeInst cellCenter;
        Cell cell = Cell.newInstance(lib, name);
        if (User.isPlaceCellCenter() && (cellCenter = NodeInst.newInstance(cellCenterProto = Generic.tech.cellCenterNode, new Point2D.Double(0.0, 0.0), cellCenterProto.getDefWidth(), cellCenterProto.getDefHeight(), cell)) != null) {
            cellCenter.setVisInside();
            cellCenter.setHardSelect();
        }
        return cell;
    }

    public static Cell newInstance(Library lib, String name) {
        lib.checkChanging();
        Cell cell = Cell.lowLevelAllocate(lib, name);
        if (cell.lowLevelLink()) {
            return null;
        }
        return cell;
    }

    public void kill() {
        if (!this.isLinked()) {
            System.out.println("Cell already killed");
            return;
        }
        this.checkChanging();
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        this.database.removeCell(this.getId());
        this.database.unfreshSnapshot();
        Constraints.getCurrent().killObject(this);
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting) {
        if (fromCell == null) {
            return null;
        }
        if (toLib == null) {
            return null;
        }
        for (int i = 0; i < toName.length(); ++i) {
            char ch = toName.charAt(i);
            if (ch > ' ' && ch != ':' && ch < '\u007f') continue;
            System.out.println("invalid name of new cell");
            return null;
        }
        Library destLib = toLib;
        if (toLib == fromCell.getLibrary()) {
            destLib = null;
        }
        HashMap<NodeInst, NodeProto> nodePrototypes = new HashMap<NodeInst, NodeProto>();
        if (destLib != null) {
            Iterator<NodeInst> it = fromCell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell niProto = (Cell)ni.getProto();
                boolean maySubstitute = useExisting;
                if (!maySubstitute && niProto.isIcon() && niProto.isIconOf(fromCell)) {
                    maySubstitute = true;
                }
                if (!maySubstitute) continue;
                Cell lnt = null;
                Iterator<Cell> cIt = toLib.getCells();
                while (cIt.hasNext() && (!(lnt = cIt.next()).getName().equalsIgnoreCase(niProto.getName()) || lnt.getView() != niProto.getView())) {
                    lnt = null;
                }
                if (lnt == null) continue;
                boolean validPorts = true;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    PortProto pp = pi.getPortProto();
                    PortProto ppt = lnt.findPortProto(pp.getName());
                    if (ppt != null) {
                        // empty if block
                    }
                    if (ppt != null) continue;
                    System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in " + destLib + ": exports don't match");
                    validPorts = false;
                    break;
                }
                if (!validPorts) continue;
                nodePrototypes.put(ni, lnt);
            }
        }
        return Cell.copyNodeProtoUsingMapping(fromCell, toLib, toName, nodePrototypes);
    }

    public static Cell copyNodeProtoUsingMapping(Cell fromCell, Library toLib, String toName, HashMap<NodeInst, NodeProto> nodePrototypes) {
        NodeInst ni;
        Cell newCell;
        String cellName = toName;
        if (toName.indexOf(123) < 0 && fromCell.getView() != View.UNKNOWN) {
            cellName = toName + "{" + fromCell.getView().getAbbreviation() + "}";
        }
        if ((newCell = Cell.newInstance(toLib, cellName)) == null) {
            return null;
        }
        newCell.lowLevelSetUserbits(fromCell.lowLevelGetUserbits());
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator<ElectricObject> it = fromCell.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            NodeProto lnt = nodePrototypes.get(ni);
            if (lnt == null) {
                lnt = ni.getProto();
            }
            double scaleX = ni.getXSize();
            double scaleY = ni.getYSize();
            NodeInst toNi = NodeInst.newInstance(lnt, new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), scaleX, scaleY, newCell, ni.getOrient(), ni.getName(), 0);
            if (toNi == null) {
                return null;
            }
            newNodes.put(ni, toNi);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
            toNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
            toNi.copyStateBits(ni);
        }
        it = fromCell.getNodes();
        while (it.hasNext()) {
            String name;
            Variable var;
            ni = it.next();
            NodeInst toNi = (NodeInst)newNodes.get(ni);
            toNi.copyVarsFrom(ni);
            if (!newCell.isIcon() || (var = toNi.getVar(Schematics.SCHEM_FUNCTION, String.class)) == null || !(name = (String)var.getObject()).equals(fromCell.getName())) continue;
            toNi.updateVar(var.getKey(), newCell.getName());
        }
        it = fromCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            PortInst[] opi = new PortInst[2];
            for (int i = 0; i < 2; ++i) {
                opi[i] = null;
                NodeInst ono = (NodeInst)newNodes.get(ai.getPortInst(i).getNodeInst());
                PortProto pp = ai.getPortInst(i).getPortProto();
                if (!ono.isCellInstance()) {
                    opi[i] = ono.findPortInstFromProto(pp);
                } else {
                    PortProto ppt = ono.getProto().findPortProto(pp.getName());
                    if (ppt != null) {
                        opi[i] = ono.findPortInstFromProto(ppt);
                    }
                }
                if (opi[i] != null) continue;
                System.out.println("Error: no port for " + ai.getProto() + " arc on " + ono.getProto());
            }
            if (opi[0] == null || opi[1] == null) {
                return null;
            }
            ArcInst toAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), opi[1], opi[0], ai.getHeadLocation(), ai.getTailLocation(), ai.getName(), ai.getAngle());
            if (toAi == null) {
                return null;
            }
            toAi.copyPropertiesFrom(ai);
        }
        it = fromCell.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            NodeInst ni2 = (NodeInst)newNodes.get(pp.getOriginalPort().getNodeInst());
            PortInst pi = ni2.findPortInst(pp.getOriginalPort().getPortProto().getName());
            if (pi == null) {
                System.out.println("Error: no port on " + pp.getOriginalPort().getNodeInst().getProto());
                return null;
            }
            Export ppt = Export.newInstance(newCell, pi, pp.getName());
            if (ppt == null) {
                return null;
            }
            ppt.copyVarsFrom(pp);
            ppt.copyStateBits(pp);
            ppt.copyTextDescriptorFrom(pp, Export.EXPORT_NAME);
        }
        newCell.copyVarsFrom(fromCell);
        newCell.lowLevelSetCreationDate(fromCell.getCreationDate());
        newCell.lowLevelSetRevisionDate(fromCell.getRevisionDate());
        return newCell;
    }

    public void replaceSubcellsByExisting() {
        HashMap<NodeInst, Cell> nodePrototypes = new HashMap<NodeInst, Cell>();
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            Cell niProto = (Cell)ni.getProto();
            if (niProto.lib == this.lib) continue;
            Cell lnt = null;
            Iterator<Cell> cIt = this.lib.getCells();
            while (cIt.hasNext() && (!(lnt = cIt.next()).getName().equalsIgnoreCase(niProto.getName()) || lnt.getView() != niProto.getView())) {
                lnt = null;
            }
            if (lnt == null) continue;
            boolean validPorts = true;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                PortProto pp = pi.getPortProto();
                PortProto ppt = lnt.findPortProto(pp.getName());
                if (ppt != null) {
                    // empty if block
                }
                if (ppt != null) continue;
                System.out.println("Cannot use subcell " + lnt.noLibDescribe() + " in " + this.lib + ": exports don't match");
                validPorts = false;
                break;
            }
            if (!validPorts) continue;
            nodePrototypes.put(ni, lnt);
        }
        for (Map.Entry e : nodePrototypes.entrySet()) {
            NodeInst ni = (NodeInst)e.getKey();
            Cell newProto = (Cell)e.getValue();
            ni.replace(newProto, false, false);
        }
    }

    public void rename(String newName) {
        this.rename(CellName.parseName(newName + ";" + this.getVersion() + "{" + this.getView().getAbbreviation() + "}"));
    }

    private void rename(CellName cellName) {
        this.checkChanging();
        assert (this.isLinked());
        if (cellName == null) {
            return;
        }
        if (this.getCellName().equals(cellName)) {
            return;
        }
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        this.setD(this.getD().withCellName(cellName));
        this.lowLevelLinkCellName(true);
        this.notifyRename();
    }

    public void move(Library newLib) {
        this.checkChanging();
        if (!this.isLinked()) {
            throw new IllegalArgumentException();
        }
        if (!newLib.isLinked()) {
            throw new IllegalArgumentException("newLib");
        }
        if (newLib == this.lib) {
            return;
        }
        this.lib.removeCell(this);
        this.cellGroup.remove(this);
        this.cellGroup = null;
        this.setD(this.getD().withLibrary(newLib.getId()));
        this.lib = newLib;
        this.lowLevelLinkCellName(true);
        this.notifyRename();
    }

    void notifyRename() {
        Iterator<CellUsage> it = this.getUsagesOf();
        while (it.hasNext()) {
            CellUsage u = it.next();
            Cell parent = u.parentId.inDatabase(this.getDatabase());
            parent.setModified();
        }
    }

    public static Cell lowLevelAllocate(Library lib, String name) {
        lib.checkChanging();
        CellName n = CellName.parseName(name);
        if (n == null) {
            return null;
        }
        String cellName = n.getName();
        String original = null;
        for (int i = 0; i < cellName.length(); ++i) {
            char chr = cellName.charAt(i);
            if (!Character.isWhitespace(chr) && chr != ':' && chr != ';' && chr != '{' && chr != '}') continue;
            if (original == null) {
                original = cellName;
            }
            cellName = cellName.substring(0, i) + '_' + cellName.substring(i + 1);
        }
        if (original != null) {
            System.out.println("Cell name changed from '" + original + "' to '" + cellName + "'");
            n = CellName.newName(cellName, n.getView(), n.getVersion());
        }
        Date creationDate = new Date();
        CellId cellId = lib.getId().newCellId(n);
        Cell c = new Cell(lib.getDatabase(), ImmutableCell.newInstance(cellId, lib.getId(), n, creationDate.getTime()));
        return c;
    }

    public boolean lowLevelLink() {
        this.lib.checkChanging();
        assert (!this.isLinked());
        if (this.getCellName() == null) {
            System.out.println(this + " has bad name");
            return true;
        }
        this.lowLevelLinkCellName(true);
        this.database.addCell(this);
        this.database.unfreshSnapshot();
        Constraints.getCurrent().newObject(this);
        return false;
    }

    private void lowLevelLinkCellName(boolean canResolveConflict) {
        Cell c;
        String protoName = this.getName();
        View view = this.getView();
        int version = this.getVersion();
        int greatestVersion = 0;
        boolean conflict = version <= 0;
        Iterator<Cell> it = this.lib.getCells();
        while (it.hasNext()) {
            c = it.next();
            if (!c.getName().equalsIgnoreCase(protoName) || c.getView() != view) continue;
            if (c.getVersion() == this.getVersion()) {
                conflict = true;
            }
            if (c.getVersion() <= greatestVersion) continue;
            greatestVersion = c.getVersion();
        }
        if (conflict) {
            assert (canResolveConflict);
            if (this.getVersion() > 0) {
                System.out.println("Already have cell " + this.getCellName() + " with version " + this.getVersion() + ", generating a new version");
            }
            CellName cn = CellName.newName(this.getName(), this.getView(), greatestVersion + 1);
            this.setD(this.getD().withCellName(cn));
        }
        it = this.getViewsTail();
        while (it.hasNext()) {
            c = it.next();
            if (!c.getName().equals(this.getName())) continue;
            this.cellGroup = c.cellGroup;
        }
        if (this.cellGroup == null) {
            this.cellGroup = new CellGroup(this.lib);
        }
        this.lib.addCell(this);
        this.cellGroup.add(this);
    }

    public int lowLevelGetUserbits() {
        return this.getD().flags;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.setD(this.getD().withFlags(userBits));
    }

    public CellBackup backup() {
        if (this.cellBackupFresh) {
            return this.backup;
        }
        return this.doBackup();
    }

    private CellBackup doBackup() {
        if (this.backup == null) {
            this.getTechnology();
            this.backup = new CellBackup(this.getD().withoutVariables());
            assert (!this.cellBackupFresh && !this.cellContentsFresh);
        }
        ImmutableNodeInst[] nodes = null;
        ImmutableArcInst[] arcs = null;
        ImmutableExport[] exports = null;
        if (!this.cellContentsFresh) {
            nodes = this.backupNodes();
            arcs = this.backupArcs();
            exports = this.backupExports();
        }
        this.backup = this.backup.with(this.getD(), this.revisionDate, this.modified, nodes, arcs, exports);
        this.cellBackupFresh = true;
        this.cellContentsFresh = true;
        return this.backup;
    }

    private ImmutableNodeInst[] backupNodes() {
        ImmutableNodeInst[] newNodes = new ImmutableNodeInst[this.nodes.size()];
        boolean changed = this.nodes.size() != this.backup.nodes.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            ImmutableNodeInst d = ni.getD();
            changed = changed || this.backup.nodes.get(i) != d;
            newNodes[i] = d;
        }
        return changed ? newNodes : null;
    }

    private ImmutableArcInst[] backupArcs() {
        ImmutableArcInst[] newArcs = new ImmutableArcInst[this.arcs.size()];
        boolean changed = this.arcs.size() != this.backup.arcs.size();
        for (int i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ImmutableArcInst d = ai.getD();
            changed = changed || this.backup.arcs.get(i) != d;
            newArcs[i] = d;
        }
        return changed ? newArcs : null;
    }

    private ImmutableExport[] backupExports() {
        ImmutableExport[] newExports = new ImmutableExport[this.exports.length];
        boolean changed = this.exports.length != this.backup.exports.size();
        for (int i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            ImmutableExport d = e.getD();
            changed = changed || this.backup.exports.get(i) != d;
            newExports[i] = d;
        }
        return changed ? newExports : null;
    }

    void recover(CellBackup newBackup, ERectangle cellBounds) {
        this.update(true, newBackup, null);
        assert (cellBounds != null);
        this.cellBounds = cellBounds;
        this.boundsDirty = 0;
    }

    void undo(CellBackup newBackup, ERectangle cellBounds, BitSet exportsModified, BitSet boundsModified) {
        if (this.backup == null) {
            this.recover(newBackup, cellBounds);
            return;
        }
        assert (this.cellBackupFresh);
        assert (this.boundsDirty == 0);
        if (this.backup != newBackup) {
            this.update(false, newBackup, exportsModified);
        } else if (exportsModified != null || boundsModified != null) {
            this.updateSubCells(exportsModified, boundsModified);
        }
        this.cellBounds = cellBounds;
    }

    private void update(boolean full, CellBackup newBackup, BitSet exportsModified) {
        int i;
        int i2;
        int i3;
        NodeInst ni;
        this.checkUndoing();
        this.d = newBackup.d;
        this.lib = this.database.getLib(newBackup.d.libId);
        this.revisionDate = newBackup.revisionDate;
        this.modified = newBackup.modified;
        this.nodes.clear();
        this.essenBounds.clear();
        this.maxSuffix.clear();
        this.cellUsages = newBackup.getInstCounts();
        this.rTree = RTNode.makeTopLevel();
        for (int i4 = 0; i4 < newBackup.nodes.size(); ++i4) {
            ImmutableNodeInst d = (ImmutableNodeInst)newBackup.nodes.get(i4);
            while (d.nodeId >= this.chronNodes.size()) {
                this.chronNodes.add(null);
            }
            ni = this.chronNodes.get(d.nodeId);
            if (ni != null && ni.getProto().getId() == d.protoId) {
                ni.setDInUndo(d);
                if (ni.isCellInstance()) {
                    int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
                    if (full || exportsModified != null && exportsModified.get(subCellIndex)) {
                        ni.updatePortInsts(full);
                    }
                }
                ni.lowLevelClearConnections();
            } else {
                ni = new NodeInst(d, this);
                this.chronNodes.set(d.nodeId, ni);
            }
            ni.setNodeIndex(i4);
            this.nodes.add(ni);
            this.updateMaxSuffix(ni);
            NodeProto np = ni.getProto();
            if (np != Generic.tech.essentialBoundsNode) continue;
            this.essenBounds.add(ni);
        }
        assert (this.nodes.size() == newBackup.nodes.size());
        int nodeCount = 0;
        for (i3 = 0; i3 < this.chronNodes.size(); ++i3) {
            ni = this.chronNodes.get(i3);
            if (ni == null) continue;
            int nodeIndex = ni.getNodeIndex();
            if (nodeIndex >= this.nodes.size() || ni != this.nodes.get(nodeIndex)) {
                ni.setNodeIndex(-1);
                this.chronNodes.set(i3, null);
                continue;
            }
            ++nodeCount;
        }
        assert (nodeCount == this.nodes.size());
        this.arcs.clear();
        this.maxArcSuffix = -1;
        for (i3 = 0; i3 < newBackup.arcs.size(); ++i3) {
            ImmutableArcInst d = (ImmutableArcInst)newBackup.arcs.get(i3);
            while (d.arcId >= this.chronArcs.size()) {
                this.chronArcs.add(null);
            }
            ArcInst ai = this.chronArcs.get(d.arcId);
            PortInst headPi = this.getPortInst(d.headNodeId, d.headPortId);
            PortInst tailPi = this.getPortInst(d.tailNodeId, d.tailPortId);
            if (ai != null && ai.getHeadPortInst() == headPi && ai.getTailPortInst() == tailPi) {
                ai.setDInUndo(d);
            } else {
                ai = new ArcInst(this, d, headPi, tailPi);
                this.chronArcs.set(d.arcId, ai);
            }
            ai.setArcIndex(i3);
            this.arcs.add(ai);
            tailPi.getNodeInst().lowLevelAddConnection(ai.getTail());
            headPi.getNodeInst().lowLevelAddConnection(ai.getHead());
            if (ai.isUsernamed()) continue;
            Name name = ai.getNameKey();
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        int arcCount = 0;
        for (i2 = 0; i2 < this.chronArcs.size(); ++i2) {
            ArcInst ai = this.chronArcs.get(i2);
            if (ai == null) continue;
            int arcIndex = ai.getArcIndex();
            if (arcIndex >= this.arcs.size() || ai != this.arcs.get(arcIndex)) {
                ai.setArcIndex(-1);
                this.chronArcs.set(i2, null);
                continue;
            }
            ++arcCount;
        }
        assert (arcCount == this.arcs.size());
        for (i2 = 0; i2 < this.nodes.size(); ++i2) {
            NodeInst ni2 = this.nodes.get(i2);
            ni2.sortConnections();
        }
        this.exports = new Export[newBackup.exports.size()];
        for (i2 = 0; i2 < newBackup.exports.size(); ++i2) {
            Export e;
            ImmutableExport d = (ImmutableExport)newBackup.exports.get(i2);
            int chronIndex = d.exportId.getChronIndex();
            if (this.chronExports.length <= chronIndex) {
                Export[] newChronExports = new Export[Math.max(chronIndex + 1, this.chronExports.length * 2)];
                System.arraycopy(this.chronExports, 0, newChronExports, 0, this.chronExports.length);
                this.chronExports = newChronExports;
            }
            if ((e = this.chronExports[chronIndex]) != null) {
                e.setDInUndo(d);
            } else {
                this.chronExports[chronIndex] = e = new Export(d, this);
            }
            e.setPortIndex(i2);
            this.exports[i2] = e;
        }
        int exportCount = 0;
        for (int i5 = 0; i5 < this.chronExports.length; ++i5) {
            Export e = this.chronExports[i5];
            if (e == null) continue;
            int portIndex = e.getPortIndex();
            if (portIndex >= this.exports.length || e != this.exports[portIndex]) {
                e.setPortIndex(-1);
                this.chronExports[i5] = null;
                continue;
            }
            ++exportCount;
        }
        assert (exportCount == this.exports.length);
        int[] exportsCounts = new int[this.nodes.size()];
        for (i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            int n = e.getOriginalPort().getNodeInst().getNodeIndex();
            exportsCounts[n] = exportsCounts[n] + 1;
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            this.nodes.get(i).lowLevelAllocExports(exportsCounts[i]);
            exportsCounts[i] = 0;
        }
        for (i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            int nodeIndex = e.getOriginalPort().getNodeInst().getNodeIndex();
            NodeInst ni3 = this.nodes.get(nodeIndex);
            int n = nodeIndex;
            int n2 = exportsCounts[n];
            exportsCounts[n] = n2 + 1;
            ni3.lowLevelSetExport(n2, e);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni4 = this.nodes.get(i);
            if (ni4.isCellInstance() && (full || exportsModified != null && exportsModified.get(((Cell)ni4.getProto()).getCellIndex()))) {
                ni4.sortConnections();
            }
            ni4.computeWipeState();
            ni4.updateShrinkage();
            ni4.redoGeometric();
            RTNode.linkGeom(this, ni4);
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ai.updateGeometricInUndo();
            RTNode.linkGeom(this, ai);
        }
        this.backup = newBackup;
        this.cellBackupFresh = true;
        this.cellContentsFresh = true;
    }

    private void updateSubCells(BitSet exportsModified, BitSet boundsModified) {
        this.checkUndoing();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            if (!ni.isCellInstance()) continue;
            int subCellIndex = ((Cell)ni.getProto()).getCellIndex();
            if (exportsModified != null && exportsModified.get(subCellIndex)) {
                ni.updatePortInsts(false);
                ni.sortConnections();
            }
            if (boundsModified == null || !boundsModified.get(subCellIndex)) continue;
            RTNode.unLinkGeom(this, ni);
            ni.redoGeometric();
            RTNode.linkGeom(this, ni);
        }
    }

    @Override
    public double getDefWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public double getDefHeight() {
        return this.getBounds().getHeight();
    }

    @Override
    public SizeOffset getProtoSizeOffset() {
        return SizeOffset.ZERO_OFFSET;
    }

    public Dimension2D getCharacteristicSpacing() {
        Variable var = this.getVar(CHARACTERISTIC_SPACING);
        if (var != null) {
            Object obj = var.getObject();
            if (obj instanceof Integer[]) {
                Integer[] iSpac = (Integer[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(iSpac[0].intValue(), iSpac[1].intValue());
                return spacing;
            }
            if (obj instanceof Double[]) {
                Double[] dSpac = (Double[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(dSpac[0], dSpac[1]);
                return spacing;
            }
        }
        return null;
    }

    public void setCharacteristicSpacing(double x, double y) {
        Double[] newVals = new Double[]{new Double(x), new Double(y)};
        this.newVar(CHARACTERISTIC_SPACING, (Object)newVals);
    }

    public void setDirty() {
        this.setDirty((byte)2);
    }

    private void setDirty(byte boundsLevel) {
        if (this.boundsDirty == 0) {
            this.boundsDirty = boundsLevel;
            Iterator<CellUsage> it = this.getUsagesOf();
            while (it.hasNext()) {
                CellUsage u = it.next();
                u.getParent().setDirty((byte)1);
            }
        } else if (this.boundsDirty < boundsLevel) {
            this.boundsDirty = boundsLevel;
        }
    }

    public Iterator<Geometric> searchIterator(Rectangle2D bounds) {
        return new RTNode.Search(bounds, this, true);
    }

    public Iterator<Geometric> searchIterator(Rectangle2D bounds, boolean includeEdges) {
        return new RTNode.Search(bounds, this, includeEdges);
    }

    public ERectangle getBounds() {
        Iterator<Serializable> it;
        int i;
        if (this.boundsDirty == 0 || !this.database.canComputeBounds()) {
            return this.cellBounds;
        }
        this.checkChanging();
        boolean wasCorrectSub = this.boundsDirty == 1;
        this.boundsDirty = 0;
        Iterator<CellUsage> it2 = this.getUsagesIn();
        while (it2.hasNext()) {
            CellUsage u = it2.next();
            u.getProto().getBounds();
        }
        if (wasCorrectSub && this.boundsDirty == 0) {
            return this.cellBounds;
        }
        boolean boundsEmpty = true;
        double cellHighY = 0.0;
        double cellLowY = 0.0;
        double cellHighX = 0.0;
        double cellLowX = 0.0;
        for (i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            NodeProto np = ni.getProto();
            if (np == Generic.tech.cellCenterNode) continue;
            if (np == Generic.tech.invisiblePinNode) {
                boolean found = false;
                it = ni.getVariables();
                while (it.hasNext()) {
                    TextDescriptor td;
                    Variable var = it.next();
                    if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            Rectangle2D bounds = ni.getBounds();
            double lowx = bounds.getMinX();
            double highx = bounds.getMaxX();
            double lowy = bounds.getMinY();
            double highy = bounds.getMaxY();
            if (boundsEmpty) {
                boundsEmpty = false;
                cellLowX = lowx;
                cellHighX = highx;
                cellLowY = lowy;
                cellHighY = highy;
                continue;
            }
            if (lowx < cellLowX) {
                cellLowX = lowx;
            }
            if (highx > cellHighX) {
                cellHighX = highx;
            }
            if (lowy < cellLowY) {
                cellLowY = lowy;
            }
            if (!(highy > cellHighY)) continue;
            cellHighY = highy;
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            Rectangle2D bounds = ai.getBounds();
            double lowx = bounds.getMinX();
            double highx = bounds.getMaxX();
            double lowy = bounds.getMinY();
            double highy = bounds.getMaxY();
            if (lowx < cellLowX) {
                cellLowX = lowx;
            }
            if (highx > cellHighX) {
                cellHighX = highx;
            }
            if (lowy < cellLowY) {
                cellLowY = lowy;
            }
            if (!(highy > cellHighY)) continue;
            cellHighY = highy;
        }
        cellLowX = DBMath.round(cellLowX);
        cellLowY = DBMath.round(cellLowY);
        double width = DBMath.round(cellHighX - cellLowX);
        double height = DBMath.round(cellHighY - cellLowY);
        if (this.cellBounds == null || cellLowX != this.cellBounds.getMinX() || cellLowY != this.cellBounds.getMinY() || width != this.cellBounds.getWidth() || height != this.cellBounds.getHeight()) {
            this.cellBounds = new ERectangle(cellLowX, cellLowY, width, height);
            it = this.getInstancesOf();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                ni.lowLevelModify(ni.getD());
            }
        }
        this.boundsDirty = 0;
        return this.cellBounds;
    }

    void undoCellBounds(ERectangle cellBounds) {
        assert (cellBounds != null);
        this.cellBounds = cellBounds;
        this.boundsDirty = 0;
    }

    RTNode getRTree() {
        return this.rTree;
    }

    void setRTree(RTNode rTree) {
        this.rTree = rTree;
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public boolean alreadyCellCenter() {
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech.cellCenterNode) continue;
            return true;
        }
        return false;
    }

    public void adjustReferencePoint(double cX, double cY) {
        NodeInst ni;
        this.checkChanging();
        if (cX == 0.0 && cY == 0.0) {
            return;
        }
        Iterator<Geometric> it = this.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (ni.getProto() == Generic.tech.cellCenterNode) continue;
            ni.move(-cX, -cY);
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.modify(0.0, -cX, -cY, -cX, -cY);
        }
        it = this.getInstancesOf();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            AffineTransform trans = ni.getOrient().pureRotate();
            Point2D.Double in = new Point2D.Double(cX, cY);
            trans.transform(in, in);
            ni.move(((Point2D)in).getX(), ((Point2D)in).getY());
        }
        Job.getUserInterface().adjustReferencePoint(this, cX, cY);
    }

    public synchronized Iterator<NodeInst> getNodes() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public synchronized Iterator<Nodable> getNodables() {
        ArrayList<NodeInst> nodesCopy = new ArrayList<NodeInst>(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return this.nodes.get(nodeIndex);
    }

    public NodeInst getNodeById(int nodeId) {
        return nodeId < this.chronNodes.size() ? this.chronNodes.get(nodeId) : null;
    }

    public PortInst getPortInst(int nodeId, PortProtoId portProtoId) {
        NodeInst ni = this.chronNodes.get(nodeId);
        assert (ni.getD().protoId == portProtoId.getParentId());
        NodeProto np = ni.getProto();
        PortProto pp = np.getPort(portProtoId);
        PortInst pi = ni.getPortInst(pp.getPortIndex());
        assert (pi.getNodeInst().getD().nodeId == nodeId);
        assert (pi.getPortProto().getId() == portProtoId);
        return pi;
    }

    public synchronized Iterator<CellUsage> getUsagesIn() {
        return new Iterator<CellUsage>(){
            private int i = 0;
            CellUsage nextU = this.findNext();

            @Override
            public boolean hasNext() {
                return this.nextU != null;
            }

            @Override
            public CellUsage next() {
                if (this.nextU == null) {
                    throw new NoSuchElementException();
                }
                CellUsage u = this.nextU;
                this.nextU = this.findNext();
                return u;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private CellUsage findNext() {
                while (this.i < Cell.this.cellUsages.length) {
                    if (Cell.this.cellUsages[this.i] != 0) {
                        return Cell.this.getId().getUsageIn(this.i++);
                    }
                    ++this.i;
                }
                return null;
            }
        };
    }

    public int getNumUsagesIn() {
        int numUsages = 0;
        for (int i = 0; i < this.cellUsages.length; ++i) {
            if (this.cellUsages[i] == 0) continue;
            ++numUsages;
        }
        return numUsages;
    }

    public NodeInst findNode(String name) {
        int nodeIndex = this.searchNode(name);
        return nodeIndex >= 0 ? this.nodes.get(nodeIndex) : null;
    }

    public static void setAllowCircularLibraryDependences(boolean val) {
        allowCirDep = val;
    }

    public boolean addNode(NodeInst ni) {
        Library.LibraryDependency libDep;
        Cell instProto;
        this.checkChanging();
        if (ni.isCellInstance() && (instProto = (Cell)ni.getProto()).getLibrary() != this.getLibrary() && (libDep = this.getLibrary().addReferencedLib(instProto.getLibrary())) != null) {
            if (!allowCirDep) {
                System.out.println("ERROR: " + this.libDescribe() + " cannot instantiate " + instProto.libDescribe() + " because it would create a circular library dependence: ");
                System.out.println(libDep.toString());
                return true;
            }
            System.out.println("WARNING: " + this.libDescribe() + " instantiates " + instProto.libDescribe() + " which causes a circular library dependence: ");
            System.out.println(libDep.toString());
        }
        this.addNodeName(ni);
        int nodeId = ni.getD().nodeId;
        while (this.chronNodes.size() <= nodeId) {
            this.chronNodes.add(null);
        }
        assert (this.chronNodes.get(nodeId) == null);
        this.chronNodes.set(nodeId, ni);
        this.setContentsModified();
        if (ni.isCellInstance()) {
            Cell subCell = (Cell)ni.getProto();
            CellUsage u = this.getId().getUsageIn(subCell.getId());
            if (this.cellUsages.length <= u.indexInParent) {
                int[] newCellUsages = new int[u.indexInParent + 1];
                System.arraycopy(this.cellUsages, 0, newCellUsages, 0, this.cellUsages.length);
                this.cellUsages = newCellUsages;
            }
            int n = u.indexInParent;
            this.cellUsages[n] = this.cellUsages[n] + 1;
        }
        return false;
    }

    public void addNodeName(NodeInst ni) {
        int nodeIndex = this.searchNode(ni.getName());
        assert (nodeIndex < 0);
        this.nodes.add(nodeIndex, ni);
        for (nodeIndex = -nodeIndex - 1; nodeIndex < this.nodes.size(); ++nodeIndex) {
            NodeInst n = this.nodes.get(nodeIndex);
            n.setNodeIndex(nodeIndex);
        }
        this.updateMaxSuffix(ni);
    }

    private void updateMaxSuffix(NodeInst ni) {
        int numSuffix;
        Name name = ni.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        Name basename = name.getBasename();
        String basenameString = basename.canonicString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
        }
        if ((numSuffix = name.getNumSuffix()) > ms.v) {
            ms.v = numSuffix;
        }
    }

    public Name getNodeAutoname(Name basename) {
        Name name;
        String basenameString = basename.canonicString();
        MaxSuffix ms = this.maxSuffix.get(basenameString);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basenameString, ms);
            name = basename.findSuffixed(0);
        } else {
            ++ms.v;
            name = basename.findSuffixed(ms.v);
        }
        assert (this.searchNode(name.toString()) < 0);
        return name;
    }

    public void removeNode(NodeInst ni) {
        this.checkChanging();
        assert (ni.isLinked());
        if (ni.isCellInstance()) {
            Cell subCell = (Cell)ni.getProto();
            CellUsage u = this.getId().getUsageIn(subCell.getId());
            int n = u.indexInParent;
            this.cellUsages[n] = this.cellUsages[n] - 1;
            if (this.cellUsages[u.indexInParent] <= 0) {
                assert (this.cellUsages[u.indexInParent] == 0);
                this.getLibrary().removeReferencedLib(((Cell)ni.getProto()).getLibrary());
            }
        }
        this.removeNodeName(ni);
        int nodeId = ni.getD().nodeId;
        assert (this.chronNodes.get(nodeId) == ni);
        this.chronNodes.set(nodeId, null);
        this.setContentsModified();
    }

    public void removeNodeName(NodeInst ni) {
        int nodeIndex = ni.getNodeIndex();
        NodeInst removedNi = this.nodes.remove(nodeIndex);
        assert (removedNi == ni);
        for (int i = nodeIndex; i < this.nodes.size(); ++i) {
            NodeInst n = this.nodes.get(i);
            n.setNodeIndex(i);
        }
        ni.setNodeIndex(-1);
    }

    private int searchNode(String name) {
        int high;
        int low = 0;
        int pick = high = this.nodes.size() - 1;
        while (low <= high) {
            NodeInst ni = this.nodes.get(pick);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ni.getName(), name);
            if (cmp < 0) {
                low = pick + 1;
            } else if (cmp > 0) {
                high = pick - 1;
            } else {
                return pick;
            }
            pick = low + high >> 1;
        }
        return -(low + 1);
    }

    public void linkNode(NodeInst ni) {
        this.setDirty();
        RTNode.linkGeom(this, ni);
        NodeProto np = ni.getProto();
        if (np == Generic.tech.essentialBoundsNode) {
            this.essenBounds.add(ni);
        }
    }

    public void unLinkNode(NodeInst ni) {
        this.setDirty();
        RTNode.unLinkGeom(this, ni);
        this.essenBounds.remove(ni);
    }

    public synchronized Iterator<ArcInst> getArcs() {
        ArrayList<ArcInst> arcsCopy = new ArrayList<ArcInst>(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return this.arcs.get(arcIndex);
    }

    public ArcInst getArcById(int arcId) {
        return arcId < this.chronArcs.size() ? this.chronArcs.get(arcId) : null;
    }

    public ArcInst findArc(String name) {
        ArcInst ai;
        int arcIndex = this.searchArc(name, 0);
        if (arcIndex >= 0) {
            return this.arcs.get(arcIndex);
        }
        if ((arcIndex = -arcIndex - 1) < this.arcs.size() && (ai = this.arcs.get(arcIndex)).getName().equals(name)) {
            return ai;
        }
        return null;
    }

    public void addArc(ArcInst ai) {
        int arcIndex = this.searchArc(ai.getName(), ai.getD().arcId);
        assert (arcIndex < 0);
        this.arcs.add(arcIndex, ai);
        for (arcIndex = -arcIndex - 1; arcIndex < this.arcs.size(); ++arcIndex) {
            ArcInst a = this.arcs.get(arcIndex);
            a.setArcIndex(arcIndex);
        }
        int arcId = ai.getD().arcId;
        while (this.chronArcs.size() <= arcId) {
            this.chronArcs.add(null);
        }
        assert (this.chronArcs.get(arcId) == null);
        this.chronArcs.set(arcId, ai);
        this.setContentsModified();
        if (ai.isUsernamed()) {
            return;
        }
        Name name = ai.getNameKey();
        assert (name.getBasename() == ImmutableArcInst.BASENAME);
        this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
    }

    public Name getArcAutoname() {
        if (this.maxArcSuffix < Integer.MAX_VALUE) {
            return ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
        }
        int i = 0;
        Name name;
        while (this.hasTempArcName(name = ImmutableArcInst.BASENAME.findSuffixed(i))) {
            ++i;
        }
        return name;
    }

    public boolean hasTempArcName(Name name) {
        return name.isTempname() && this.findArc(name.toString()) != null;
    }

    public void removeArc(ArcInst ai) {
        this.checkChanging();
        assert (ai.isLinked());
        int arcIndex = ai.getArcIndex();
        ArcInst removedAi = this.arcs.remove(arcIndex);
        assert (removedAi == ai);
        for (int i = arcIndex; i < this.arcs.size(); ++i) {
            ArcInst a = this.arcs.get(i);
            a.setArcIndex(i);
        }
        ai.setArcIndex(-1);
        int arcId = ai.getD().arcId;
        assert (this.chronArcs.get(arcId) == ai);
        this.chronArcs.set(arcId, null);
        this.setContentsModified();
    }

    private int searchArc(String name, int arcId) {
        int low = 0;
        int high = this.arcs.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ArcInst ai = this.arcs.get(mid);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(ai.getName(), name);
            if (cmp == 0) {
                cmp = ai.getD().arcId - arcId;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void linkArc(ArcInst ai) {
        this.setDirty();
        RTNode.linkGeom(this, ai);
    }

    public void unLinkArc(ArcInst ai) {
        this.setDirty();
        RTNode.unLinkGeom(this, ai);
    }

    void addExport(Export export) {
        int i;
        this.checkChanging();
        int portIndex = -this.searchExport(export.getName()) - 1;
        assert (portIndex >= 0);
        export.setPortIndex(portIndex);
        int chronIndex = export.getId().getChronIndex();
        if (this.chronExports.length <= chronIndex) {
            Export[] newChronExports = new Export[Math.max(chronIndex + 1, this.chronExports.length * 2)];
            System.arraycopy(this.chronExports, 0, newChronExports, 0, this.chronExports.length);
            this.chronExports = newChronExports;
        }
        this.chronExports[chronIndex] = export;
        Export[] newExports = new Export[this.exports.length + 1];
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        newExports[portIndex] = export;
        for (int i2 = portIndex; i2 < this.exports.length; ++i2) {
            Export e = this.exports[i2];
            e.setPortIndex(i2 + 1);
            newExports[i2 + 1] = e;
        }
        this.exports = newExports;
        this.setContentsModified();
        if (this.getId().numUsagesOf() == 0) {
            return;
        }
        int[] pattern = new int[this.exports.length];
        for (i = 0; i < portIndex; ++i) {
            pattern[i] = i;
        }
        pattern[portIndex] = -1;
        for (i = portIndex + 1; i < this.exports.length; ++i) {
            pattern[i] = i - 1;
        }
        this.updatePortInsts(pattern);
    }

    void removeExport(Export export) {
        int i;
        this.checkChanging();
        int portIndex = export.getPortIndex();
        Export[] newExports = this.exports.length > 1 ? new Export[this.exports.length - 1] : NULL_EXPORT_ARRAY;
        System.arraycopy(this.exports, 0, newExports, 0, portIndex);
        for (int i2 = portIndex; i2 < newExports.length; ++i2) {
            Export e = this.exports[i2 + 1];
            e.setPortIndex(i2);
            newExports[i2] = e;
        }
        this.exports = newExports;
        this.chronExports[export.getId().getChronIndex()] = null;
        this.setContentsModified();
        export.setPortIndex(-1);
        if (this.getId().numUsagesOf() == 0) {
            return;
        }
        int[] pattern = new int[this.exports.length];
        for (i = 0; i < portIndex; ++i) {
            pattern[i] = i;
        }
        for (i = portIndex; i < this.exports.length; ++i) {
            pattern[i] = i + 1;
        }
        this.updatePortInsts(pattern);
    }

    void moveExport(int oldPortIndex, String newName) {
        int i;
        Export e;
        int i2;
        Export export = this.exports[oldPortIndex];
        int newPortIndex = -this.searchExport(newName) - 1;
        if (newPortIndex < 0) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            --newPortIndex;
        }
        if (newPortIndex == oldPortIndex) {
            return;
        }
        if (newPortIndex > oldPortIndex) {
            for (i2 = oldPortIndex; i2 < newPortIndex; ++i2) {
                e = this.exports[i2 + 1];
                e.setPortIndex(i2);
                this.exports[i2] = e;
            }
        } else {
            for (i2 = oldPortIndex; i2 > newPortIndex; --i2) {
                e = this.exports[i2 - 1];
                e.setPortIndex(i2);
                this.exports[i2] = e;
            }
        }
        export.setPortIndex(newPortIndex);
        this.exports[newPortIndex] = export;
        if (this.getId().numUsagesOf() == 0) {
            return;
        }
        int[] pattern = new int[this.exports.length];
        for (i = 0; i < pattern.length; ++i) {
            pattern[i] = i;
        }
        pattern[newPortIndex] = oldPortIndex;
        if (newPortIndex > oldPortIndex) {
            for (i = oldPortIndex; i < newPortIndex; ++i) {
                pattern[i] = i + 1;
            }
        } else {
            for (i = oldPortIndex; i > newPortIndex; --i) {
                pattern[i] = i - 1;
            }
        }
        this.updatePortInsts(pattern);
        Iterator<NodeInst> it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            ni.moveConnections(export);
        }
    }

    public void updatePortInsts(int[] pattern) {
        Iterator<NodeInst> it = this.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            ni.updatePortInsts(pattern);
        }
    }

    @Override
    public PortProto findPortProto(String name) {
        if (name == null) {
            return null;
        }
        return this.findPortProto(Name.findName(name));
    }

    @Override
    public PortProto findPortProto(Name name) {
        if (name == null) {
            return null;
        }
        int portIndex = this.searchExport(name.toString());
        if (portIndex >= 0) {
            return this.exports[portIndex];
        }
        String nameString = name.canonicString();
        for (int i = 0; i < this.exports.length; ++i) {
            Export e = this.exports[i];
            if (e.getNameKey().canonicString() != nameString) continue;
            return e;
        }
        return null;
    }

    @Override
    public Iterator<PortProto> getPorts() {
        return ArrayIterator.iterator((PortProto[])this.exports);
    }

    public Iterator<Export> getExports() {
        return ArrayIterator.iterator(this.exports);
    }

    @Override
    public int getNumPorts() {
        return this.exports.length;
    }

    @Override
    public Export getPort(int portIndex) {
        return this.exports[portIndex];
    }

    @Override
    public Export getPort(PortProtoId portProtoId) {
        if (portProtoId.getParentId() != this.getId()) {
            throw new IllegalArgumentException();
        }
        return this.chronExports[portProtoId.getChronIndex()];
    }

    public Export getExportChron(int chronIndex) {
        try {
            return this.chronExports[chronIndex];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Export findExport(String name) {
        return (Export)this.findPortProto(name);
    }

    public Export findExport(Name name) {
        return (Export)this.findPortProto(name);
    }

    private int searchExport(String name) {
        int low = 0;
        int high = this.exports.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Export e = this.exports[mid];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(e.getName(), name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public CellName getCellName() {
        return this.getD().cellName;
    }

    @Override
    public String getName() {
        return this.getCellName().getName();
    }

    @Override
    public String describe(boolean withQuotes) {
        String name = "";
        if (this.lib != Library.getCurrent()) {
            name = name + this.lib.getName() + ":";
        }
        name = name + this.noLibDescribe();
        return withQuotes ? "'" + name + "'" : name;
    }

    public String libDescribe() {
        return this.lib.getName() + ":" + this.noLibDescribe();
    }

    public String noLibDescribe() {
        String name = this.getName();
        if (this.getNewestVersion() != this) {
            name = name + ";" + this.getVersion();
        }
        name = name + "{" + this.getView().getAbbreviation() + "}";
        return name;
    }

    public static NodeProto findNodeProto(String line) {
        Comparable<PrimitiveNode> np;
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        Library lib = Library.getCurrent();
        boolean saidtech = false;
        boolean saidlib = false;
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            Library l;
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
                saidtech = true;
            }
            if ((l = Library.findLibrary(prefix)) != null) {
                lib = l;
                saidlib = true;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        if (!saidlib && (np = tech.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        if (!saidtech && (np = lib.findNodeProto(withoutPrefix)) != null) {
            return np;
        }
        return null;
    }

    public String[] getTextViewContents() {
        Variable var = this.getVar(CELL_TEXT_KEY);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (!(obj instanceof String[])) {
            return null;
        }
        return (String[])obj;
    }

    public void setTextViewContents(String[] strings) {
        this.checkChanging();
        this.newVar(CELL_TEXT_KEY, (Object)strings);
    }

    public Variable getParameter(Variable.Key key) {
        Variable var = this.getVar(key);
        return var != null && var.getTextDescriptor().isParam() ? var : null;
    }

    public Iterator<Variable> getParameters() {
        TreeMap<Variable.Key, Variable> keysToVars = new TreeMap<Variable.Key, Variable>();
        Iterator<Variable> it = this.getVariables();
        while (it.hasNext()) {
            Variable v = it.next();
            if (!v.getTextDescriptor().isParam()) continue;
            keysToVars.put(v.getKey(), v);
        }
        return keysToVars.values().iterator();
    }

    @Override
    public boolean isParam(Variable.Key varKey) {
        Variable var = this.getVar(varKey);
        return var != null && var.getTextDescriptor().isParam();
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow0 wnd) {
        int dispVars = this.numDisplayableVariables(false);
        if (dispVars == 0) {
            return null;
        }
        Poly[] polys = new Poly[dispVars];
        this.addDisplayableVariables(CENTERRECT, polys, 0, wnd, false);
        return polys;
    }

    public Rectangle2D getRelativeTextBounds(EditWindow0 wnd) {
        Rectangle2D bounds = null;
        Iterator<ElectricObject> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            bounds = this.accumulateTextBoundsOnObject(ni, bounds, wnd);
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                bounds = this.accumulateTextBoundsOnObject(pi, bounds, wnd);
            }
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ai, bounds, wnd);
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            bounds = this.accumulateTextBoundsOnObject(pp, bounds, wnd);
        }
        bounds = this.accumulateTextBoundsOnObject(this, bounds, wnd);
        return bounds;
    }

    private Rectangle2D accumulateTextBoundsOnObject(ElectricObject eObj, Rectangle2D bounds, EditWindow0 wnd) {
        Rectangle2D objBounds = eObj.getTextBounds(wnd);
        if (objBounds == null) {
            return bounds;
        }
        if (bounds == null) {
            return objBounds;
        }
        Rectangle2D.union(bounds, objBounds, bounds);
        return bounds;
    }

    public Name getBasename() {
        String protoName = this.getName();
        Name basename = Name.findName(protoName.substring(0, Math.min(8, protoName.length())) + "@0").getBasename();
        if (basename == null) {
            basename = PrimitiveNode.Function.UNKNOWN.getBasename();
        }
        return basename;
    }

    public int getUniqueNameIndex(String prefix, Class cls, int startingIndex) {
        int uniqueIndex;
        block4: {
            int len;
            block5: {
                block3: {
                    len = prefix.length();
                    uniqueIndex = startingIndex;
                    if (cls != PortProto.class) break block3;
                    Iterator<PortProto> it = this.getPorts();
                    while (it.hasNext()) {
                        int indexVal;
                        String restOfName;
                        PortProto pp = it.next();
                        if (!TextUtils.startsWithIgnoreCase(pp.getName(), prefix) || !TextUtils.isANumber(restOfName = pp.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                        uniqueIndex = indexVal + 1;
                    }
                    break block4;
                }
                if (cls != NodeInst.class) break block5;
                Iterator<NodeInst> it = this.getNodes();
                while (it.hasNext()) {
                    int indexVal;
                    String restOfName;
                    NodeInst ni = it.next();
                    if (!TextUtils.startsWithIgnoreCase(ni.getName(), prefix) || !TextUtils.isANumber(restOfName = ni.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                    uniqueIndex = indexVal + 1;
                }
                break block4;
            }
            if (cls != ArcInst.class) break block4;
            Iterator<ArcInst> it = this.getArcs();
            while (it.hasNext()) {
                int indexVal;
                String restOfName;
                ArcInst ai = it.next();
                if (!TextUtils.startsWithIgnoreCase(ai.getName(), prefix) || !TextUtils.isANumber(restOfName = ai.getName().substring(len)) || (indexVal = TextUtils.atoi(restOfName)) < uniqueIndex) continue;
                uniqueIndex = indexVal + 1;
            }
        }
        return uniqueIndex;
    }

    public boolean isUniqueName(String name, Class cls, ElectricObject exclude) {
        return this.isUniqueName(Name.findName(name), cls, exclude);
    }

    public boolean isUniqueName(Name name, Class cls, ElectricObject exclude) {
        if (cls == PortProto.class) {
            Export pp = this.findExport(name);
            return pp == null || exclude == pp;
        }
        if (cls == NodeInst.class) {
            NodeInst ni = this.findNode(name.toString());
            return ni == null || exclude == ni;
        }
        if (cls == ArcInst.class) {
            String nameString = name.canonicString();
            if (name.isTempname()) {
                ArcInst ai = this.findArc(nameString);
                return ai == null || exclude == ai;
            }
            Iterator<ArcInst> it = this.getArcs();
            while (it.hasNext()) {
                Name arcName;
                ArcInst ai = it.next();
                if (exclude == ai || nameString != (arcName = ai.getNameKey()).canonicString()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean isDeprecatedVariable(Variable.Key key) {
        String name = key.getName();
        if (name.equals("NET_last_good_ncc") || name.equals("NET_last_good_ncc_facet") || name.equals("SIM_window_signal_order") || name.equals("SIM_window_signalorder")) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    @Override
    public String toString() {
        return "cell " + this.describe(true);
    }

    public ImmutableCell getD() {
        return this.d;
    }

    private void setD(ImmutableCell newD) {
        if (this.isLinked()) {
            this.checkChanging();
            ImmutableCell oldD = this.getD();
            if (newD == oldD) {
                return;
            }
            this.d = newD;
            this.unfreshBackup();
            Constraints.getCurrent().modifyCell(this, oldD);
        } else {
            assert (!this.cellBackupFresh && !this.cellContentsFresh);
            this.d = newD;
        }
    }

    @Override
    public ImmutableElectricObject getImmutable() {
        return this.d;
    }

    @Override
    public void addVar(Variable var) {
        this.setD(this.getD().withVariable(var));
    }

    @Override
    public void delVar(Variable.Key key) {
        this.setD(this.getD().withoutVariable(key));
    }

    @Override
    public CellId getId() {
        return this.d.cellId;
    }

    public static Cell inCurrentThread(CellId cellId) {
        return EDatabase.theDatabase.getCell(cellId);
    }

    public Iterator<CellUsage> getUsagesOf() {
        return new Iterator<CellUsage>(){
            int i;
            CellUsage nextU = this.findNext();

            @Override
            public boolean hasNext() {
                return this.nextU != null;
            }

            @Override
            public CellUsage next() {
                if (this.nextU == null) {
                    throw new NoSuchElementException();
                }
                CellUsage u = this.nextU;
                this.nextU = this.findNext();
                return u;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private CellUsage findNext() {
                CellId cellId = Cell.this.getId();
                while (this.i < cellId.numUsagesOf()) {
                    CellUsage u;
                    Cell parent;
                    if ((parent = (u = cellId.getUsageOf(this.i++)).getParent()) == null || u.indexInParent >= parent.cellUsages.length || parent.cellUsages[u.indexInParent] <= 0) continue;
                    return u;
                }
                return null;
            }
        };
    }

    public Iterator<NodeInst> getInstancesOf() {
        return new NodeInstsIterator();
    }

    public static boolean isInstantiationRecursive(Cell toInstantiate, Cell parent) {
        if (toInstantiate == parent) {
            return true;
        }
        if (toInstantiate.isIconOf(parent) && toInstantiate.isIcon() && !parent.isIcon()) {
            return false;
        }
        return parent.isAChildOf(toInstantiate);
    }

    public boolean isAChildOf(Cell parent) {
        return this.getIsAChildOf(parent, new HashMap<Cell, Cell>());
    }

    private boolean getIsAChildOf(Cell parent, Map<Cell, Cell> checkedParents) {
        Cell c;
        if (parent.isIcon() && (c = parent.contentsView()) != null && c != parent && this.getIsAChildOf(c, checkedParents)) {
            return true;
        }
        if (checkedParents.get(parent) != null) {
            return false;
        }
        checkedParents.put(parent, parent);
        Cell contentView = this.contentsView();
        if (contentView == null) {
            contentView = this;
        }
        Cell iconView = this.iconView();
        Iterator<NodeInst> it = parent.getNodes();
        while (it.hasNext()) {
            Cell c2;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (c2 = (Cell)ni.getProto()).isIconOf(parent)) continue;
            if (c2 == contentView) {
                return true;
            }
            if (c2 == iconView) {
                return true;
            }
            if (!this.getIsAChildOf(c2, checkedParents)) continue;
            return true;
        }
        return false;
    }

    public boolean isInUse(String action, boolean quiet) {
        String parents = null;
        Iterator<CellUsage> it = this.getUsagesOf();
        while (it.hasNext()) {
            CellUsage u = it.next();
            Cell parent = u.getParent();
            if (parents == null) {
                parents = parent.describe(true);
                continue;
            }
            parents = parents + ", " + parent.describe(true);
        }
        if (parents != null) {
            if (!quiet) {
                Job.getUserInterface().showErrorMessage("Cannot " + action + " " + this + " because it is used in " + parents, action + " failed");
            }
            return true;
        }
        return false;
    }

    public Cell makeNewVersion() {
        Cell newVersion = Cell.copyNodeProto(this, this.lib, this.noLibDescribe(), false);
        return newVersion;
    }

    public int getVersion() {
        return this.getCellName().getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumVersions() {
        int count = 0;
        String protoName = this.getName();
        View view = this.getView();
        TreeMap<CellName, Cell> treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator<Cell> it = this.getVersionsTail();
            while (it.hasNext() && (c = it.next()).getName().equals(protoName) && c.getView() == view) {
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Cell> getVersions() {
        ArrayList<Cell> versions = new ArrayList<Cell>();
        String protoName = this.getName();
        View view = this.getView();
        TreeMap<CellName, Cell> treeMap = this.lib.cells;
        synchronized (treeMap) {
            Cell c;
            Iterator<Cell> it = this.getVersionsTail();
            while (it.hasNext() && (c = it.next()).getName().equals(protoName) && c.getView() == view) {
                versions.add(c);
            }
        }
        return versions.iterator();
    }

    public Cell getNewestVersion() {
        return this.newestVersion;
    }

    private Iterator<Cell> getVersionsTail() {
        return this.lib.getCellsTail(this.newestVersion.getCellName());
    }

    private Iterator<Cell> getViewsTail() {
        CellName cn = CellName.parseName(this.getName());
        return this.lib.getCellsTail(cn);
    }

    public CellGroup getCellGroup() {
        return this.cellGroup;
    }

    public void joinGroup(Cell otherCell) {
        this.setCellGroup(otherCell.getCellGroup());
    }

    public void putInOwnCellGroup() {
        this.setCellGroup(null);
    }

    public void setCellGroup(CellGroup cellGroup) {
        Cell cell;
        if (!this.isLinked()) {
            return;
        }
        if (cellGroup == null) {
            cellGroup = new CellGroup(this.lib);
        }
        this.checkChanging();
        if (cellGroup == this.cellGroup) {
            return;
        }
        this.database.unfreshSnapshot();
        this.lib.setChanged();
        String protoName = this.getName();
        Iterator<Cell> it = this.getViewsTail();
        while (it.hasNext() && (cell = it.next()).getName().equals(protoName)) {
            cell.cellGroup.remove(cell);
            cellGroup.add(cell);
        }
    }

    public View getView() {
        return this.getCellName().getView();
    }

    public void setView(View newView) {
        this.rename(CellName.newName(this.getName(), newView, this.getVersion()));
    }

    public boolean isIcon() {
        return this.getView() == View.ICON;
    }

    public boolean isIconOf(Cell cell) {
        return this.getView() == View.ICON && this.cellGroup == cell.cellGroup && cell.isSchematic();
    }

    public boolean isSchematic() {
        return this.getView() == View.SCHEMATIC;
    }

    public int getNumMultiPages() {
        Integer storedCount;
        if (!this.isMultiPage()) {
            return 1;
        }
        ERectangle bounds = this.getBounds();
        int numPages = (int)(((RectangularShape)bounds).getHeight() / 1000.0) + 1;
        Variable var = this.getVar(MULTIPAGE_COUNT_KEY, Integer.class);
        if (var != null && (storedCount = (Integer)var.getObject()) > numPages) {
            numPages = storedCount;
        }
        return numPages;
    }

    public Cell contentsView() {
        Cell cellInGroup;
        if (!this.isIcon() && this.getView() != View.LAYOUTSKEL) {
            return null;
        }
        Iterator<Cell> it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = it.next();
            if (!cellInGroup.isSchematic()) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell iconView() {
        if (!this.isSchematic()) {
            return null;
        }
        Iterator<Cell> it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = it.next();
            if (!cellInGroup.isIcon()) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell otherView(View view) {
        Cell otherViewCell = null;
        Iterator<Cell> it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = it.next();
            if (cellInGroup.getView() != view) continue;
            otherViewCell = cellInGroup.getNewestVersion();
            if (!cellInGroup.getName().equals(this.getName())) continue;
            return otherViewCell;
        }
        return otherViewCell;
    }

    public Netlist getNetlist(boolean shortResistors) {
        return NetworkTool.getNetlist(this, shortResistors);
    }

    public Netlist getUserNetlist() {
        return NetworkTool.getUserNetlist(this);
    }

    public Netlist acquireUserNetlist() {
        return NetworkTool.acquireUserNetlist(this);
    }

    public Date getCreationDate() {
        return new Date(this.getD().creationDate);
    }

    public void lowLevelSetCreationDate(Date creationDate) {
        this.setD(this.getD().withCreationDate(creationDate.getTime()));
    }

    public Date getRevisionDate() {
        return new Date(this.revisionDate);
    }

    public void lowLevelSetRevisionDate(Date revisionDate) {
        this.checkChanging();
        this.revisionDate = revisionDate.getTime();
        this.unfreshBackup();
    }

    public void madeRevision(long revisionDate, String userName) {
        this.setModified();
        this.revisionDate = revisionDate;
        this.unfreshBackup();
    }

    public void checkCellDates() {
        HashSet<Cell> cellsChecked = new HashSet<Cell>();
        this.checkCellDate(this.getRevisionDate(), cellsChecked);
    }

    private void checkCellDate(Date rev_time, HashSet<Cell> cellsChecked) {
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            Cell contentsCell;
            Cell subCell;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || (subCell = (Cell)ni.getProto()).isIconOf(this)) continue;
            if (!cellsChecked.contains(subCell)) {
                subCell.checkCellDate(rev_time, cellsChecked);
            }
            if ((contentsCell = subCell.contentsView()) == null || cellsChecked.contains(contentsCell)) continue;
            contentsCell.checkCellDate(rev_time, cellsChecked);
        }
        cellsChecked.add(this);
        if (!this.getRevisionDate().after(rev_time)) {
            return;
        }
        System.out.println("WARNING: sub-cell " + this + " has been edited since the last revision to the current cell");
    }

    private int getFlags() {
        return this.d.flags;
    }

    private boolean isFlag(int mask) {
        return (this.getFlags() & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        this.lowLevelSetUserbits(value ? this.getFlags() | mask : this.getFlags() & ~mask);
    }

    public void setWantExpanded() {
        this.setFlag(2, true);
    }

    public void clearWantExpanded() {
        this.setFlag(2, false);
    }

    public boolean isWantExpanded() {
        return this.isFlag(2) || this.isIcon();
    }

    @Override
    public PrimitiveNode.Function getFunction() {
        return PrimitiveNode.Function.UNKNOWN;
    }

    public void setAllLocked() {
        this.setFlag(0x100000, true);
    }

    public void clearAllLocked() {
        this.setFlag(0x100000, false);
    }

    public boolean isAllLocked() {
        return this.isFlag(0x100000);
    }

    public void setInstancesLocked() {
        this.setFlag(0x200000, true);
    }

    public void clearInstancesLocked() {
        this.setFlag(0x200000, false);
    }

    public boolean isInstancesLocked() {
        return this.isFlag(0x200000);
    }

    public void setInCellLibrary() {
        this.setFlag(0x400000, true);
    }

    public void clearInCellLibrary() {
        this.setFlag(0x400000, false);
    }

    public boolean isInCellLibrary() {
        return this.isFlag(0x400000);
    }

    public void setInTechnologyLibrary() {
        this.setFlag(0x800000, true);
    }

    public void clearInTechnologyLibrary() {
        this.setFlag(0x800000, false);
    }

    public boolean isInTechnologyLibrary() {
        return this.isFlag(0x800000);
    }

    private void setModified() {
        this.checkChanging();
        if (!this.modified) {
            this.unfreshBackup();
        }
        this.modified = true;
    }

    void clearModified() {
        this.checkChanging();
        if (this.modified) {
            this.unfreshBackup();
        }
        this.modified = false;
    }

    public boolean isModified(boolean majorChange) {
        return this.modified;
    }

    public void setContentsModified() {
        this.cellContentsFresh = false;
        this.unfreshBackup();
    }

    private void unfreshBackup() {
        this.cellBackupFresh = false;
        this.database.unfreshSnapshot();
    }

    public void loadExpandStatus() {
        String cellName = this.noLibDescribe().replace('/', ':');
        String cellKey = "E" + cellName;
        boolean useWantExpanded = false;
        boolean mostExpanded = false;
        if (this.lib.prefs.get(cellKey, null) == null) {
            useWantExpanded = true;
        } else {
            mostExpanded = this.lib.prefs.getBoolean(cellKey, false);
        }
        Preferences cellPrefs = null;
        try {
            if (this.lib.prefs.nodeExists(cellName)) {
                cellPrefs = this.lib.prefs.node(cellName);
            }
        }
        catch (BackingStoreException e) {
            ActivityLogger.logException(e);
        }
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            boolean expanded;
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            boolean bl = expanded = useWantExpanded ? ((Cell)ni.getProto()).isWantExpanded() : mostExpanded;
            if (cellPrefs != null) {
                String nodeName = "E" + ni.getName();
                expanded = cellPrefs.getBoolean(nodeName, expanded);
            }
            ni.setExpanded(expanded);
        }
        this.expandStatusModified = false;
    }

    void saveExpandStatus() throws BackingStoreException {
        if (!this.expandStatusModified) {
            return;
        }
        if (Job.getDebug()) {
            System.err.println("Save expanded status of " + this);
        }
        int num = 0;
        int expanded = 0;
        int diff = 0;
        Iterator<NodeInst> it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            ++num;
            if (ni.isExpanded()) {
                ++expanded;
            }
            if (ni.isExpanded() == ((Cell)ni.getProto()).isWantExpanded()) continue;
            ++diff;
        }
        String cellName = this.noLibDescribe().replace('/', ':');
        String cellKey = "E" + cellName;
        boolean useWantExpanded = false;
        boolean mostExpanded = false;
        if (diff <= expanded && diff <= num - expanded) {
            useWantExpanded = true;
            this.lib.prefs.remove(cellKey);
        } else {
            if (num - expanded < expanded) {
                diff = num - expanded;
                mostExpanded = true;
            } else {
                diff = expanded;
            }
            this.lib.prefs.putBoolean(cellKey, mostExpanded);
        }
        if (diff == 0) {
            if (this.lib.prefs.nodeExists(cellName)) {
                this.lib.prefs.node(cellName).removeNode();
            }
        } else {
            Preferences cellPrefs = this.lib.prefs.node(cellName);
            cellPrefs.clear();
            cellPrefs.put("CELL", cellName);
            Iterator<NodeInst> it2 = this.getNodes();
            while (it2.hasNext()) {
                boolean defaultExpanded;
                NodeInst ni = it2.next();
                if (!ni.isCellInstance()) continue;
                boolean bl = defaultExpanded = useWantExpanded ? ((Cell)ni.getProto()).isWantExpanded() : mostExpanded;
                if (ni.isExpanded() == defaultExpanded) continue;
                String nodeName = "E" + ni.getName();
                cellPrefs.putBoolean(nodeName, ni.isExpanded());
            }
            cellPrefs.flush();
        }
        this.expandStatusModified = false;
    }

    public void expandStatusChanged() {
        this.expandStatusModified = true;
    }

    public void setMultiPage(boolean multi) {
        this.setFlag(0x7E000000, multi);
    }

    public boolean isMultiPage() {
        return this.isFlag(0x7E000000);
    }

    @Override
    public boolean isLinked() {
        return Cell.inCurrentThread(this.getId()) == this;
    }

    @Override
    public EDatabase getDatabase() {
        return this.database;
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        Variable var;
        int errorCount = 0;
        ArrayList<Geometric> list = new ArrayList<Geometric>();
        Iterator<Geometric> it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            errorCount += ai.checkAndRepair(repair, list, errorLogger);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            errorCount += ni.checkAndRepair(repair, list, errorLogger);
        }
        if (repair && list.size() > 0) {
            CircuitChangeJobs.eraseObjectsInList(this, list, false);
        }
        if ((var = this.getVar(NccCellAnnotations.NCC_ANNOTATION_KEY)) != null && var.isInherit()) {
            String nccMsg = "Cleaned up NCC annotations in cell " + this.describe(false);
            if (repair) {
                this.addVar(var.withInherit(false).withParam(false).withInterior(true));
                nccMsg = nccMsg + " (REPAIRED)";
            }
            System.out.println(nccMsg);
            if (errorLogger != null) {
                errorLogger.logWarning(nccMsg, this, 1);
            }
        }
        return errorCount;
    }

    @Override
    protected void check() {
        int i;
        NodeInst ni;
        ArcInst ai;
        Export e;
        CellId cellId = this.getD().cellId;
        super.check();
        assert (this.database.getCell(cellId) == this);
        assert (this.database.getLib(this.getD().libId) == this.lib);
        assert (this.getCellName() != null);
        assert (this.getVersion() > 0);
        if (this.cellBackupFresh) {
            assert (this.backup.d == this.getD());
            assert (this.backup.revisionDate == this.revisionDate);
            assert (this.backup.modified == this.modified);
            assert (this.cellContentsFresh);
        }
        if (this.cellContentsFresh) {
            assert (this.backup.nodes.size() == this.nodes.size());
            assert (this.backup.arcs.size() == this.arcs.size());
            assert (this.backup.exports.size() == this.exports.length);
        }
        for (int portIndex = 0; portIndex < this.exports.length; ++portIndex) {
            e = this.exports[portIndex];
            assert (e.getParent() == this);
            assert (e.getPortIndex() == portIndex);
            assert (this.chronExports[e.getId().getChronIndex()] == e);
            if (this.cellContentsFresh) assert (this.backup.exports.get(portIndex) == e.getD());
            if (portIndex > 0) assert (TextUtils.STRING_NUMBER_ORDER.compare(this.exports[portIndex - 1].getName(), e.getName()) < 0);
            assert (e.getOriginalPort() == this.getPortInst(e.getD().originalNodeId, e.getD().originalPortId));
        }
        for (int chronIndex = 0; chronIndex < this.chronExports.length; ++chronIndex) {
            e = this.chronExports[chronIndex];
            if (e == null) continue;
            assert (e.getId() == cellId.getPortId(chronIndex));
            assert (e == this.exports[e.getPortIndex()]);
        }
        ArcInst prevAi = null;
        for (int arcIndex = 0; arcIndex < this.arcs.size(); ++arcIndex) {
            ai = this.arcs.get(arcIndex);
            ImmutableArcInst a = ai.getD();
            assert (ai.getParent() == this);
            assert (ai.getArcIndex() == arcIndex);
            assert (this.chronArcs.get(a.arcId) == ai);
            if (this.cellContentsFresh) assert (this.backup.arcs.get(arcIndex) == a);
            if (prevAi != null) {
                int cmp = TextUtils.STRING_NUMBER_ORDER.compare(prevAi.getName(), ai.getName());
                assert (cmp <= 0);
                if (cmp == 0) assert (prevAi.getD().arcId < a.arcId);
            }
            assert (ai.getHeadPortInst() == this.getPortInst(a.headNodeId, a.headPortId));
            assert (ai.getTailPortInst() == this.getPortInst(a.tailNodeId, a.tailPortId));
            prevAi = ai;
        }
        for (int arcId = 0; arcId < this.chronArcs.size(); ++arcId) {
            ai = this.chronArcs.get(arcId);
            if (ai == null) continue;
            assert (ai.getD().arcId == arcId);
            assert (ai == this.arcs.get(ai.getArcIndex()));
        }
        BitSet exportSet = new BitSet();
        if (this.exports.length > 0) {
            exportSet.set(0, this.exports.length);
        }
        BitSet tailSet = new BitSet();
        BitSet headSet = new BitSet();
        if (this.arcs.size() > 0) {
            tailSet.set(0, this.arcs.size());
            headSet.set(0, this.arcs.size());
        }
        boolean connectionCount = false;
        NodeInst prevNi = null;
        int[] usages = new int[cellId.numUsagesIn()];
        for (int nodeIndex = 0; nodeIndex < this.nodes.size(); ++nodeIndex) {
            ni = this.nodes.get(nodeIndex);
            ImmutableNodeInst n = ni.getD();
            assert (ni.getParent() == this);
            assert (ni.getNodeIndex() == nodeIndex);
            assert (this.chronNodes.get(n.nodeId) == ni);
            if (this.cellContentsFresh) assert (this.backup.nodes.get(nodeIndex) == n);
            if (prevNi != null) assert (TextUtils.STRING_NUMBER_ORDER.compare(prevNi.getName(), ni.getName()) < 0);
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                assert (subCell.isLinked());
                assert (subCell.database == this.database);
                CellUsage u = cellId.getUsageIn(subCell.getId());
                int n2 = u.indexInParent;
                usages[n2] = usages[n2] + 1;
            }
            ni.check(exportSet, tailSet, headSet);
            prevNi = ni;
        }
        assert (exportSet.isEmpty());
        assert (tailSet.isEmpty() && headSet.isEmpty());
        for (int nodeId = 0; nodeId < this.chronNodes.size(); ++nodeId) {
            ni = this.chronNodes.get(nodeId);
            if (ni == null) continue;
            assert (ni.getD().nodeId == nodeId);
            assert (ni == this.nodes.get(ni.getNodeIndex()));
        }
        for (i = 0; i < this.cellUsages.length; ++i) {
            assert (this.cellUsages[i] == usages[i]);
        }
        for (i = this.cellUsages.length; i < usages.length; ++i) {
            assert (usages[i] == 0);
        }
        assert (this.cellGroup.containsCell(this));
    }

    public boolean objInCell(ElectricObject eObj) {
        block4: {
            block5: {
                block3: {
                    if (!(eObj instanceof NodeInst)) break block3;
                    Iterator<NodeInst> it = this.getNodes();
                    while (it.hasNext()) {
                        if ((ElectricObject)it.next() != eObj) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(eObj instanceof ArcInst)) break block5;
                Iterator<ArcInst> it = this.getArcs();
                while (it.hasNext()) {
                    if ((ElectricObject)it.next() != eObj) continue;
                    return true;
                }
                break block4;
            }
            if (!(eObj instanceof PortInst)) break block4;
            NodeInst ni = ((PortInst)eObj).getNodeInst();
            Iterator<NodeInst> it = this.getNodes();
            while (it.hasNext()) {
                if ((ElectricObject)it.next() != ni) continue;
                return true;
            }
        }
        return false;
    }

    public final int getCellIndex() {
        return this.getId().cellIndex;
    }

    public void setTempInt(int tempInt) {
        this.checkChanging();
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    @Override
    public Cell whichCell() {
        return this;
    }

    public Library getLibrary() {
        return this.lib;
    }

    @Override
    public Technology getTechnology() {
        Technology tech = this.getD().tech;
        if (tech == null) {
            tech = Technology.whatTechnology(this, null, 0, 0, null, 0, 0);
            this.setTechnology(tech);
        }
        return tech;
    }

    public void setTechnology(Technology tech) {
        this.setD(this.getD().withTech(tech));
    }

    public Cell getEquivalent() {
        return this.isIcon() ? this.getCellGroup().getMainSchematics() : this;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Iterator<Serializable> i;
        boolean found;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cell toCompare = (Cell)obj;
        HashSet<Serializable> noCheckAgain = new HashSet<Serializable>();
        Iterator<Serializable> it = this.getNodes();
        while (it.hasNext()) {
            found = false;
            NodeInst node = it.next();
            i = toCompare.getNodes();
            while (i.hasNext()) {
                NodeInst n = i.next();
                if (noCheckAgain.contains(n) || !node.compare(n, buffer)) continue;
                found = true;
                noCheckAgain.add(n);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding node '" + node + "' found in '" + toCompare + "'\n");
            }
            return false;
        }
        if (this.getNumNodes() != toCompare.getNumNodes()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more nodes than '" + this + "'\n");
            }
            return false;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            found = false;
            ArcInst arc = (ArcInst)it.next();
            i = toCompare.getArcs();
            while (i.hasNext()) {
                ArcInst a = (ArcInst)i.next();
                if (noCheckAgain.contains(a) || !arc.compare(a, buffer)) continue;
                found = true;
                noCheckAgain.add(a);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding arc '" + arc + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumArcs() != toCompare.getNumArcs()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more arcs than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getExports();
        while (it.hasNext()) {
            found = false;
            Export port = (Export)it.next();
            i = toCompare.getExports();
            while (i.hasNext()) {
                Export p = (Export)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            return false;
        }
        if (this.getNumPorts() != toCompare.getNumPorts()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare.libDescribe() + "' has more pors than '" + this + "'\n");
            }
            return false;
        }
        noCheckAgain.clear();
        it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            boolean found2 = false;
            i = toCompare.getVariables();
            while (i.hasNext()) {
                Variable v = (Variable)i.next();
                if (noCheckAgain.contains(v) || !var.compare(v, buffer)) continue;
                found2 = true;
                noCheckAgain.add(v);
                break;
            }
            if (found2) continue;
            if (buffer != null) {
                buffer.append("No corresponding variable '" + var + "' found in other cell" + "\n");
            }
            return false;
        }
        if (this.getNumVariables() != toCompare.getNumVariables()) {
            if (buffer != null) {
                buffer.append("Cell '" + toCompare + "' has more variables than '" + this + "'\n");
            }
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Cell that) {
        int cmp;
        if (this.lib != that.lib && (cmp = this.lib.compareTo(that.lib)) != 0) {
            return cmp;
        }
        return this.getCellName().compareTo(that.getCellName());
    }

    public void getZValues(double[] array) {
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            if (ni.isCellInstance()) {
                Cell nCell = (Cell)ni.getProto();
                nCell.getZValues(array);
                continue;
            }
            PrimitiveNode np = (PrimitiveNode)ni.getProto();
            np.getZValues(array);
        }
        for (i = 0; i < this.arcs.size(); ++i) {
            ArcInst ai = this.arcs.get(i);
            ArcProto ap = ai.getProto();
            ap.getZValues(array);
        }
    }

    public boolean findReferenceInCell(Library elib, Set<Cell> set) {
        if (this.lib == elib) {
            return true;
        }
        int initial = set.size();
        for (int i = 0; i < this.nodes.size(); ++i) {
            NodeInst ni = this.nodes.get(i);
            if (!ni.isCellInstance()) continue;
            Cell nCell = (Cell)ni.getProto();
            if (nCell.getLibrary() == elib) {
                set.add(this);
                continue;
            }
            nCell.findReferenceInCell(elib, set);
        }
        return set.size() != initial;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeInstsIterator
    implements Iterator<NodeInst> {
        private Iterator<CellUsage> uit;
        private Cell cell;
        private int i;
        private int n;
        private NodeInst ni;

        NodeInstsIterator() {
            this.uit = Cell.this.getUsagesOf();
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.ni != null;
        }

        @Override
        public NodeInst next() {
            NodeInst ni = this.ni;
            if (ni == null) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return ni;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("NodeInstsIterator.remove()");
        }

        private void findNext() {
            while (true) {
                if (this.i < this.n) {
                    this.ni = this.cell.getNode(this.i++);
                    if (this.ni.getProto() != Cell.this) continue;
                    return;
                }
                if (!this.uit.hasNext()) {
                    this.ni = null;
                    return;
                }
                CellUsage u = this.uit.next();
                this.cell = u.getParent();
                if (this.cell == null) continue;
                this.i = 0;
                this.n = this.cell.getNumNodes();
            }
        }
    }

    public static class FrameDescription {
        public static final double MULTIPAGESEPARATION = 1000.0;
        private static final double FRAMESCALE = 18.0;
        private static final double HASCHXSIZE = 153.0;
        private static final double HASCHYSIZE = 99.0;
        private static final double ASCHXSIZE = 198.0;
        private static final double ASCHYSIZE = 153.0;
        private static final double BSCHXSIZE = 306.0;
        private static final double BSCHYSIZE = 198.0;
        private static final double CSCHXSIZE = 432.0;
        private static final double CSCHYSIZE = 306.0;
        private static final double DSCHXSIZE = 648.0;
        private static final double DSCHYSIZE = 432.0;
        private static final double ESCHXSIZE = 864.0;
        private static final double ESCHYSIZE = 648.0;
        private static final double FRAMEWID = 2.6999999999999997;
        private static final double XLOGOBOX = 36.0;
        private static final double YLOGOBOX = 18.0;
        private Cell cell;
        private List<Point2D> lineFromEnd;
        private List<Point2D> lineToEnd;
        private List<Point2D> textPoint;
        private List<Double> textSize;
        private List<Point2D> textBox;
        private List<String> textMessage;
        private int pageNo;

        public FrameDescription(Cell cell, int pageNo) {
            this.cell = cell;
            this.pageNo = pageNo;
            this.lineFromEnd = new ArrayList<Point2D>();
            this.lineToEnd = new ArrayList<Point2D>();
            this.textPoint = new ArrayList<Point2D>();
            this.textSize = new ArrayList<Double>();
            this.textBox = new ArrayList<Point2D>();
            this.textMessage = new ArrayList<String>();
            this.loadFrame();
        }

        public void showFrameLine(Point2D from, Point2D to) {
        }

        public void showFrameText(Point2D ctr, double size, double maxWid, double maxHei, String string) {
        }

        public void renderFrame() {
            int i;
            double offY = 0.0;
            if (this.cell.isMultiPage()) {
                offY = (double)this.pageNo * 1000.0;
            }
            for (i = 0; i < this.lineFromEnd.size(); ++i) {
                Point2D from = this.lineFromEnd.get(i);
                Point2D to = this.lineToEnd.get(i);
                if (offY != 0.0) {
                    from = new Point2D.Double(from.getX(), from.getY() + offY);
                    to = new Point2D.Double(to.getX(), to.getY() + offY);
                }
                this.showFrameLine(from, to);
            }
            for (i = 0; i < this.textPoint.size(); ++i) {
                Point2D at = this.textPoint.get(i);
                if (offY != 0.0) {
                    at = new Point2D.Double(at.getX(), at.getY() + offY);
                }
                double size = this.textSize.get(i);
                Point2D box = this.textBox.get(i);
                double width = box.getX();
                double height = box.getY();
                String msg = this.textMessage.get(i);
                this.showFrameText(at, size, width, height, msg);
            }
        }

        public static int getCellFrameInfo(Cell cell, Dimension d) {
            Variable var = cell.getVar(User.FRAME_SIZE, String.class);
            if (var == null) {
                return 2;
            }
            String frameInfo = (String)var.getObject();
            if (frameInfo.length() == 0) {
                return 2;
            }
            int retval = 0;
            char chr = frameInfo.charAt(0);
            double wid = 0.0;
            double hei = 0.0;
            if (chr == 'x') {
                wid = 38.7;
                hei = 20.7;
                retval = 1;
            } else {
                switch (chr) {
                    case 'h': {
                        wid = 153.0;
                        hei = 99.0;
                        break;
                    }
                    case 'a': {
                        wid = 198.0;
                        hei = 153.0;
                        break;
                    }
                    case 'b': {
                        wid = 306.0;
                        hei = 198.0;
                        break;
                    }
                    case 'c': {
                        wid = 432.0;
                        hei = 306.0;
                        break;
                    }
                    case 'd': {
                        wid = 648.0;
                        hei = 432.0;
                        break;
                    }
                    case 'e': {
                        wid = 864.0;
                        hei = 648.0;
                    }
                }
            }
            if (frameInfo.indexOf("v") >= 0) {
                d.setSize(hei, wid);
            } else {
                d.setSize(wid, hei);
            }
            return retval;
        }

        private void loadFrame() {
            Dimension d = new Dimension();
            int frameFactor = FrameDescription.getCellFrameInfo(this.cell, d);
            if (frameFactor == 2) {
                return;
            }
            Variable var = this.cell.getVar(User.FRAME_SIZE, String.class);
            if (var == null) {
                return;
            }
            String frameInfo = (String)var.getObject();
            double schXSize = d.getWidth();
            double schYSize = d.getHeight();
            boolean drawTitleBox = true;
            int xSections = 8;
            int ySections = 4;
            if (frameFactor == 1) {
                ySections = 0;
                xSections = 0;
            } else {
                if (frameInfo.indexOf("v") >= 0) {
                    xSections = 4;
                    ySections = 8;
                }
                if (frameInfo.indexOf("n") >= 0) {
                    drawTitleBox = false;
                }
            }
            double xLogoBox = 36.0;
            double yLogoBox = 18.0;
            double frameWid = 2.6999999999999997;
            if (xSections > 0) {
                char chr;
                int i;
                double xSecSize = (schXSize - frameWid * 2.0) / (double)xSections;
                double ySecSize = (schYSize - frameWid * 2.0) / (double)ySections;
                Point2D.Double point0 = new Point2D.Double(-schXSize / 2.0, -schYSize / 2.0);
                Point2D.Double point1 = new Point2D.Double(-schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0, schYSize / 2.0);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0, -schYSize / 2.0);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, -schYSize / 2.0 + frameWid);
                point1 = new Point2D.Double(-schXSize / 2.0 + frameWid, schYSize / 2.0 - frameWid);
                point2 = new Point2D.Double(schXSize / 2.0 - frameWid, schYSize / 2.0 - frameWid);
                point3 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                for (i = 0; i < xSections; ++i) {
                    double x = (double)i * xSecSize - (schXSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(x, schYSize / 2.0 - frameWid);
                        point1 = new Point2D.Double(x, schYSize / 2.0 - frameWid / 2.0);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(x, -schYSize / 2.0 + frameWid);
                        point1 = new Point2D.Double(x, -schYSize / 2.0 + frameWid / 2.0);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(49 + xSections - i - 1);
                    point0 = new Point2D.Double(x + xSecSize / 2.0, schYSize / 2.0 - frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(x + xSecSize / 2.0, -schYSize / 2.0 + frameWid / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
                for (i = 0; i < ySections; ++i) {
                    double y = (double)i * ySecSize - (schYSize / 2.0 - frameWid);
                    if (i > 0) {
                        point0 = new Point2D.Double(schXSize / 2.0 - frameWid, y);
                        point1 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y);
                        this.addLine(point0, point1);
                        point0 = new Point2D.Double(-schXSize / 2.0 + frameWid, y);
                        point1 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y);
                        this.addLine(point0, point1);
                    }
                    chr = (char)(65 + i);
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                    point0 = new Point2D.Double(-schXSize / 2.0 + frameWid / 2.0, y + ySecSize / 2.0);
                    this.addText(point0, frameWid, 0.0, 0.0, String.valueOf(chr));
                }
            }
            if (drawTitleBox) {
                Variable lVar;
                Point2D.Double point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox);
                Point2D.Double point2 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid);
                Point2D.Double point3 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid);
                this.addLine(point0, point1);
                this.addLine(point1, point2);
                this.addLine(point2, point3);
                this.addLine(point3, point0);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 2.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 4.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 6.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 8.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 8.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 10.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 10.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                point1 = new Point2D.Double(schXSize / 2.0 - frameWid, -schYSize / 2.0 + frameWid + yLogoBox * 12.0 / 15.0);
                this.addLine(point0, point1);
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 13.5 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 3.0 / 15.0, "Cell: " + this.cell.describe(false) + (this.cell.isMultiPage() ? " Page " + (this.pageNo + 1) : ""));
                String projectName = User.getFrameProjectName();
                Variable pVar = this.cell.getLibrary().getVar(User.FRAME_PROJECT_NAME, String.class);
                if (pVar != null) {
                    projectName = (String)pVar.getObject();
                }
                if (projectName.length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 11.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Project: " + projectName);
                }
                String designerName = User.getFrameDesignerName();
                Variable dVar = this.cell.getLibrary().getVar(User.FRAME_DESIGNER_NAME, String.class);
                if (dVar != null) {
                    designerName = (String)dVar.getObject();
                }
                if ((dVar = this.cell.getVar(User.FRAME_DESIGNER_NAME, String.class)) != null) {
                    designerName = (String)dVar.getObject();
                }
                if (designerName.length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 9.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Designer: " + designerName);
                }
                if ((lVar = this.cell.getVar(User.FRAME_LAST_CHANGED_BY, String.class)) != null) {
                    String lastChangeByName = (String)lVar.getObject();
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 7.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Last Changed By: " + lastChangeByName);
                }
                String companyName = User.getFrameCompanyName();
                Variable cVar = this.cell.getLibrary().getVar(User.FRAME_COMPANY_NAME, String.class);
                if (cVar != null) {
                    companyName = (String)cVar.getObject();
                }
                if (companyName.length() > 0) {
                    point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 5.0 / 15.0);
                    this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Company: " + companyName);
                }
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 3.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Created: " + TextUtils.formatDate(this.cell.getCreationDate()));
                point0 = new Point2D.Double(schXSize / 2.0 - frameWid - xLogoBox / 2.0, -schYSize / 2.0 + frameWid + yLogoBox * 1.0 / 15.0);
                this.addText(point0, yLogoBox * 2.0 / 15.0, xLogoBox, yLogoBox * 2.0 / 15.0, "Revised: " + TextUtils.formatDate(this.cell.getRevisionDate()));
            }
        }

        private void addLine(Point2D from, Point2D to) {
            this.lineFromEnd.add(from);
            this.lineToEnd.add(to);
        }

        private void addText(Point2D at, double size, double width, double height, String msg) {
            this.textPoint.add(at);
            this.textSize.add(new Double(size));
            this.textBox.add(new Point2D.Double(width, height));
            this.textMessage.add(msg);
        }
    }

    private static class CellKey
    extends EObjectInputStream.Key {
        CellId cellId;

        private CellKey(Cell cell) throws NotSerializableException {
            if (!cell.isLinked()) {
                throw new NotSerializableException(cell.toString());
            }
            this.cellId = cell.getId();
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            Cell cell = database.getCell(this.cellId);
            if (cell == null) {
                throw new InvalidObjectException("Cell");
            }
            return cell;
        }
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CellGroup {
        private final Library lib;
        private TreeSet<Cell> cells;
        private Cell mainSchematic;
        private CellName groupName;

        private CellGroup(Library lib) {
            this.lib = lib;
            this.cells = new TreeSet();
        }

        CellGroup(TreeSet<Cell> cells) {
            this.lib = cells.first().getLibrary();
            this.cells = cells;
            this.setMainSchematics(true);
            for (Cell cell : cells) {
                assert (cell.getLibrary() == this.lib);
                cell.cellGroup = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Cell cell) {
            this.lib.checkChanging();
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                if (!this.cells.contains(cell)) {
                    this.cells.add(cell);
                }
                this.setMainSchematics(false);
            }
            cell.cellGroup = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(Cell f) {
            this.lib.checkChanging();
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                this.cells.remove(f);
                this.setMainSchematics(false);
            }
            f.cellGroup = null;
        }

        public Iterator<Cell> getCells() {
            return this.cells.iterator();
        }

        public int getNumCells() {
            return this.cells.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Cell> getCellsSortedByView() {
            TreeSet<Cell> treeSet = this.cells;
            synchronized (treeSet) {
                ArrayList<Cell> sortedList = new ArrayList<Cell>(this.cells);
                Collections.sort(sortedList, new TextUtils.CellsByView());
                return sortedList;
            }
        }

        public Cell getMainSchematics() {
            return this.mainSchematic;
        }

        public boolean containsCell(Cell cell) {
            return this.cells.contains(cell);
        }

        public String toString() {
            return "CellGroup " + this.getName();
        }

        public String getName() {
            return this.groupName.getName();
        }

        public EDatabase getDatabase() {
            return this.lib.getDatabase();
        }

        void check() {
            for (Cell cell : this.cells) {
                assert (this.lib.cells.get(cell.getCellName()) == cell);
                assert (cell.cellGroup == this);
                assert (((Cell)cell).d.groupName.equals(this.groupName));
            }
            if (this.mainSchematic != null) {
                assert (this.containsCell(this.mainSchematic));
                assert (this.mainSchematic.getNewestVersion() == this.mainSchematic);
            }
        }

        private void setMainSchematics(boolean undo) {
            String bestName = null;
            Cell mainSchematic = null;
            for (Cell cell : this.cells) {
                if (cell.isSchematic()) {
                    mainSchematic = cell;
                    bestName = cell.getName();
                    break;
                }
                String name = cell.getName();
                if (bestName != null && name.length() >= bestName.length()) continue;
                bestName = name;
            }
            this.mainSchematic = mainSchematic;
            this.groupName = CellName.parseName(bestName + "{sch}");
            for (Cell cell : this.cells) {
                if (undo) {
                    ((Cell)cell).d.groupName.equals(this.groupName);
                    continue;
                }
                cell.setD(cell.d.withGroupName(this.groupName));
            }
        }
    }
}

