/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nms3_sy3 {
    private static final double nmosTop = -9.0;
    private static final double incY = -4.0;
    private static final double outY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        double totWid;
        sz = stdCell.roundSize(sz);
        String nm = "nms3_sy3";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        int nbStackedN = 3;
        double spaceAvail = -9.0 - (stdCell.getCellBot() + 2.0 + 3.0 + 5.0 + 3.0 + 5.0 + 1.5);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * (double)nbStackedN, 3);
        Nms3_sy3.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double inbX = inaX + 2.0 + 3.0 + 2.0;
        double jogaX = inbX + 2.0 + 3.0 + 2.0;
        double nmosX = jogaX + 2.0 + 3.0 + 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, -9.0 - fwN.physWid / 2.0, fwN.nbFolds, nbStackedN, fwN.gateWid, nand, stdCell);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        double inaHiY = -11.0;
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, Tech.m1, 4.0, inaX, inaHiY);
        TrackRouterH inaHi = new TrackRouterH(Tech.m2, 3.0, inaHiY, nand);
        inaHi.connect(nand.findExport("ina"));
        PortInst joga = LayoutLib.newNodeInst(Tech.m1pin, jogaX, inaHiY, 3.0, 3.0, 0.0, nand).getOnlyPortInst();
        inaHi.connect(joga);
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double spFromGnd = gndBot - 3.0 - 2.0;
        double nmosBot = -9.0 - fwN.physWid;
        double inaLoY = Math.min(spFromGnd, nmosBot - 2.0 - 3.0 - 2.5);
        TrackRouterH inaLo = new TrackRouterH(Tech.m1, 3.0, inaLoY, nand);
        inaLo.connect(joga);
        block24: for (int i = 0; i < fwN.nbFolds; ++i) {
            switch (i % 6) {
                case 0: {
                    ((TrackRouter)inaLo).connect(nmos.getGate(i * 3 + 0, 'B'), -4.0, Tech.getPolyLShapeOffset());
                    continue block24;
                }
                case 1: {
                    inaLo.connect(nmos.getGate(i * 3 + 1, 'B'), Tech.getPolyLShapeOffset());
                    continue block24;
                }
                case 2: {
                    inaLo.connect(nmos.getGate(i * 3 + 2, 'B'));
                    continue block24;
                }
                case 3: {
                    inaLo.connect(nmos.getGate(i * 3 + 0, 'B'));
                    continue block24;
                }
                case 4: {
                    inaLo.connect(nmos.getGate(i * 3 + 1, 'B'), -Tech.getPolyLShapeOffset());
                    continue block24;
                }
                case 5: {
                    ((TrackRouter)inaLo).connect(nmos.getGate(i * 3 + 2, 'B'), 4.0, Tech.getPolyLShapeOffset());
                }
            }
        }
        double inbY = inaLoY - 8.0;
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, Tech.m1, 4.0, inbX, inbY);
        TrackRouterH inbLo = new TrackRouterH(Tech.m1, 3.0, inbY, nand);
        inbLo.connect(nand.findExport("inb"));
        block25: for (int i = 0; i < fwN.nbFolds; ++i) {
            switch (i % 6) {
                case 0: {
                    inbLo.connect(nmos.getGate(i * 3 + 1, 'B'));
                    continue block25;
                }
                case 1: {
                    inbLo.connect(nmos.getGate(i * 3 + 0, 'B'));
                    continue block25;
                }
                case 2: {
                    inbLo.connect(nmos.getGate(i * 3 + 0, 'B'));
                    continue block25;
                }
                case 3: {
                    inbLo.connect(nmos.getGate(i * 3 + 2, 'B'));
                    continue block25;
                }
                case 4: {
                    inbLo.connect(nmos.getGate(i * 3 + 2, 'B'));
                    continue block25;
                }
                case 5: {
                    inbLo.connect(nmos.getGate(i * 3 + 1, 'B'));
                }
            }
        }
        TrackRouterH inc = new TrackRouterH(Tech.m1, 3.0, -4.0, nand);
        block26: for (int i = 0; i < fwN.nbFolds; ++i) {
            switch (i % 6) {
                case 0: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block26;
                }
                case 1: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block26;
                }
                case 2: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), -11.5, 1.0);
                    continue block26;
                }
                case 3: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), 11.5, 1.0);
                    continue block26;
                }
                case 4: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                    continue block26;
                }
                case 5: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                }
            }
        }
        double incX = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inc", PortCharacteristic.IN, Tech.m1, 4.0, incX, -4.0);
        inc.connect(nand.findExport("inc"));
        double outX = incX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, -11.0);
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nand);
        outLo.connect(nand.findExport("out"));
        for (int i = 1; i < nmos.nbSrcDrns(); i += 2) {
            outLo.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addNstackEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

