/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.WaveformZoom;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;

public class WaveformWindow
implements WindowContent {
    private static int panelSizeDigital = 25;
    private static int panelSizeAnalog = 75;
    private static Color[] colorArray = new Color[]{new Color(255, 0, 0), new Color(255, 127, 0), new Color(255, 255, 0), new Color(127, 255, 0), new Color(0, 235, 0), new Color(0, 255, 102), new Color(0, 255, 255), new Color(0, 127, 255), new Color(80, 80, 255), new Color(127, 0, 255), new Color(255, 0, 255), new Color(255, 0, 127)};
    private WindowFrame wf;
    private Stimuli sd;
    private Engine se;
    private JPanel overall;
    private JPanel left;
    private JPanel right;
    private JButton timeLock;
    private JButton refresh;
    private JButton showPoints;
    private JButton growPanel;
    private JButton shrinkPanel;
    private JComboBox signalNameList;
    private boolean rebuildingSignalNameList = false;
    private JScrollPane scrollAll;
    private JSplitPane split;
    private JLabel mainPos;
    private JLabel extPos;
    private JLabel delta;
    private JButton centerMain;
    private JButton centerExt;
    private List wavePanels;
    private List sweepSignals;
    private TimeTickPanel mainTimePanel;
    private boolean mainTimePanelNeedsRepaint;
    private Timer vcrTimer;
    private boolean vcrPlayingBackwards = false;
    private long vcrLastAdvance;
    private int vcrAdvanceSpeed = 3;
    private double mainTime;
    private double extTime;
    private double minTime;
    private double maxTime;
    private boolean timeLocked;
    private int highlightedSweep = -1;
    private boolean showVertexPoints;
    private boolean showGrid;
    private int screenLowX;
    private int screenHighX;
    public static final Variable.Key WINDOW_SIGNAL_ORDER = ElectricObject.newKey("SIM_window_signalorder");
    private Highlighter highlighter;
    private static boolean freezeWaveformHighlighting = false;
    private static WaveformWindowHighlightListener waveHighlighter = new WaveformWindowHighlightListener();
    private static Color gridColor = new Color(0x808080);
    private static final BasicStroke farDottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 12.0f}, 0.0f);
    private static WaveFormDropTarget waveformDropTarget = new WaveFormDropTarget();
    private static final ImageIcon iconAddPanel = Resources.getResource(WaveformWindow.class, "ButtonSimAddPanel.gif");
    private static final ImageIcon iconLockTime = Resources.getResource(WaveformWindow.class, "ButtonSimLockTime.gif");
    private static final ImageIcon iconUnLockTime = Resources.getResource(WaveformWindow.class, "ButtonSimUnLockTime.gif");
    private static final ImageIcon iconRefresh = Resources.getResource(WaveformWindow.class, "ButtonSimRefresh.gif");
    private static final ImageIcon iconPointsOn = Resources.getResource(WaveformWindow.class, "ButtonSimPointsOn.gif");
    private static final ImageIcon iconPointsOff = Resources.getResource(WaveformWindow.class, "ButtonSimPointsOff.gif");
    private static final ImageIcon iconToggleGrid = Resources.getResource(WaveformWindow.class, "ButtonSimGrid.gif");
    private static final ImageIcon iconGrowPanel = Resources.getResource(WaveformWindow.class, "ButtonSimGrow.gif");
    private static final ImageIcon iconShrinkPanel = Resources.getResource(WaveformWindow.class, "ButtonSimShrink.gif");
    private static final ImageIcon iconVCRRewind = Resources.getResource(WaveformWindow.class, "ButtonVCRRewind.gif");
    private static final ImageIcon iconVCRPlayBackward = Resources.getResource(WaveformWindow.class, "ButtonVCRPlayBackward.gif");
    private static final ImageIcon iconVCRStop = Resources.getResource(WaveformWindow.class, "ButtonVCRStop.gif");
    private static final ImageIcon iconVCRPlay = Resources.getResource(WaveformWindow.class, "ButtonVCRPlay.gif");
    private static final ImageIcon iconVCRToEnd = Resources.getResource(WaveformWindow.class, "ButtonVCRToEnd.gif");
    private static final ImageIcon iconVCRFaster = Resources.getResource(WaveformWindow.class, "ButtonVCRFaster.gif");
    private static final ImageIcon iconVCRSlower = Resources.getResource(WaveformWindow.class, "ButtonVCRSlower.gif");
    private static final Cursor dragTimeCursor = ToolBar.readCursor("CursorDragTime.gif", 8, 8);
    private HashMap netValues;

    public WaveformWindow(Stimuli sd, WindowFrame wf) {
        this.wf = wf;
        this.sd = sd;
        sd.setWaveformWindow(this);
        this.resetSweeps();
        this.wavePanels = new ArrayList();
        this.timeLocked = true;
        this.showVertexPoints = false;
        this.showGrid = false;
        this.highlighter = new Highlighter(0, wf);
        this.overall = new OnePanel(null, this);
        this.overall.setLayout(new GridBagLayout());
        WaveComponentListener wcl = new WaveComponentListener(this.overall);
        this.overall.addComponentListener(wcl);
        this.left = new JPanel();
        this.left.setLayout(new BoxLayout(this.left, 1));
        this.right = new JPanel();
        this.right.setLayout(new BoxLayout(this.right, 1));
        this.split = new JSplitPane(1, this.left, this.right);
        this.split.setResizeWeight(0.1);
        this.scrollAll = new JScrollPane(this.split);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 13;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        this.overall.add((Component)this.scrollAll, gbc);
        if (sd.isAnalog()) {
            JButton addPanel = new JButton(iconAddPanel);
            addPanel.setBorderPainted(false);
            addPanel.setDefaultCapable(false);
            addPanel.setToolTipText("Create new waveform panel");
            Dimension minWid = new Dimension(iconAddPanel.getIconWidth() + 4, iconAddPanel.getIconHeight() + 4);
            addPanel.setMinimumSize(minWid);
            addPanel.setPreferredSize(minWid);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            this.overall.add((Component)addPanel, gbc);
            addPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.addNewPanel();
                }
            });
            this.showPoints = new JButton(iconPointsOff);
            this.showPoints.setBorderPainted(false);
            this.showPoints.setDefaultCapable(false);
            this.showPoints.setToolTipText("Toggle display of vertex points");
            minWid = new Dimension(iconPointsOff.getIconWidth() + 4, iconPointsOff.getIconHeight() + 4);
            this.showPoints.setMinimumSize(minWid);
            this.showPoints.setPreferredSize(minWid);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            this.overall.add((Component)this.showPoints, gbc);
            this.showPoints.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.toggleShowPoints();
                }
            });
            JButton toggleGrid = new JButton(iconToggleGrid);
            toggleGrid.setBorderPainted(false);
            toggleGrid.setDefaultCapable(false);
            toggleGrid.setToolTipText("Toggle display of a grid");
            minWid = new Dimension(iconToggleGrid.getIconWidth() + 4, iconToggleGrid.getIconHeight() + 4);
            toggleGrid.setMinimumSize(minWid);
            toggleGrid.setPreferredSize(minWid);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            this.overall.add((Component)toggleGrid, gbc);
            toggleGrid.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.toggleGridPoints();
                }
            });
        }
        this.refresh = new JButton(iconRefresh);
        this.refresh.setBorderPainted(false);
        this.refresh.setDefaultCapable(false);
        this.refresh.setToolTipText("Reread stimuli data file and update waveforms");
        Dimension minWid = new Dimension(iconRefresh.getIconWidth() + 4, iconRefresh.getIconHeight() + 4);
        this.refresh.setMinimumSize(minWid);
        this.refresh.setPreferredSize(minWid);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)this.refresh, gbc);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.refreshData();
            }
        });
        this.timeLock = new JButton(iconLockTime);
        this.timeLock.setBorderPainted(false);
        this.timeLock.setDefaultCapable(false);
        this.timeLock.setToolTipText("Lock all panels in time");
        minWid = new Dimension(iconLockTime.getIconWidth() + 4, iconLockTime.getIconHeight() + 4);
        this.timeLock.setMinimumSize(minWid);
        this.timeLock.setPreferredSize(minWid);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)this.timeLock, gbc);
        this.timeLock.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelTimeLock();
            }
        });
        this.signalNameList = new JComboBox();
        this.signalNameList.setToolTipText("Show or hide waveform panels");
        this.signalNameList.setLightWeightPopupEnabled(false);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.overall.add((Component)this.signalNameList, gbc);
        this.signalNameList.addItem("Panel 1");
        this.signalNameList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.togglePanelName();
            }
        });
        this.growPanel = new JButton(iconGrowPanel);
        this.growPanel.setBorderPainted(false);
        this.growPanel.setDefaultCapable(false);
        this.growPanel.setToolTipText("Increase minimum panel height");
        minWid = new Dimension(iconGrowPanel.getIconWidth() + 4, iconGrowPanel.getIconHeight() + 4);
        this.growPanel.setMinimumSize(minWid);
        this.growPanel.setPreferredSize(minWid);
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)this.growPanel, gbc);
        this.growPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(1.25);
            }
        });
        this.shrinkPanel = new JButton(iconShrinkPanel);
        this.shrinkPanel.setBorderPainted(false);
        this.shrinkPanel.setDefaultCapable(false);
        this.shrinkPanel.setToolTipText("Decrease minimum panel height");
        minWid = new Dimension(iconShrinkPanel.getIconWidth() + 4, iconShrinkPanel.getIconHeight() + 4);
        this.shrinkPanel.setMinimumSize(minWid);
        this.shrinkPanel.setPreferredSize(minWid);
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)this.shrinkPanel, gbc);
        this.shrinkPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.growPanels(0.8);
            }
        });
        JPanel timeLabelPanel = new JPanel();
        timeLabelPanel.setLayout(new GridBagLayout());
        gbc.gridx = 10;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 4, 0, 4);
        this.overall.add((Component)timeLabelPanel, gbc);
        this.mainPos = new JLabel("Main:", 4);
        this.mainPos.setToolTipText("The main (dashed) time cursor");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        timeLabelPanel.add((Component)this.mainPos, gbc);
        this.centerMain = new JButton("Center");
        this.centerMain.setToolTipText("Center the main (dashed) time cursor");
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 4, 2, 0);
        timeLabelPanel.add((Component)this.centerMain, gbc);
        this.centerMain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(true);
            }
        });
        this.extPos = new JLabel("Ext:", 4);
        this.extPos.setToolTipText("The extension (dotted) time cursor");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        timeLabelPanel.add((Component)this.extPos, gbc);
        this.centerExt = new JButton("Center");
        this.centerExt.setToolTipText("Center the extension (dotted) time cursor");
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 4, 2, 0);
        timeLabelPanel.add((Component)this.centerExt, gbc);
        this.centerExt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.centerCursor(false);
            }
        });
        this.delta = new JLabel("Delta:", 0);
        this.delta.setToolTipText("Time distance between cursors");
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.3;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        timeLabelPanel.add((Component)this.delta, gbc);
        JButton vcrButtonRewind = new JButton(iconVCRRewind);
        vcrButtonRewind.setBorderPainted(false);
        vcrButtonRewind.setDefaultCapable(false);
        vcrButtonRewind.setToolTipText("Rewind main time cursor to start");
        minWid = new Dimension(iconVCRRewind.getIconWidth() + 4, iconVCRRewind.getIconHeight() + 4);
        vcrButtonRewind.setMinimumSize(minWid);
        vcrButtonRewind.setPreferredSize(minWid);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonRewind, gbc);
        vcrButtonRewind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickRewind();
            }
        });
        JButton vcrButtonPlayBackwards = new JButton(iconVCRPlayBackward);
        vcrButtonPlayBackwards.setBorderPainted(false);
        vcrButtonPlayBackwards.setDefaultCapable(false);
        vcrButtonPlayBackwards.setToolTipText("Play main time cursor backwards");
        minWid = new Dimension(iconVCRPlayBackward.getIconWidth() + 4, iconVCRPlayBackward.getIconHeight() + 4);
        vcrButtonPlayBackwards.setMinimumSize(minWid);
        vcrButtonPlayBackwards.setPreferredSize(minWid);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonPlayBackwards, gbc);
        vcrButtonPlayBackwards.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlayBackwards();
            }
        });
        JButton vcrButtonStop = new JButton(iconVCRStop);
        vcrButtonStop.setBorderPainted(false);
        vcrButtonStop.setDefaultCapable(false);
        vcrButtonStop.setToolTipText("Stop moving main time cursor");
        minWid = new Dimension(iconVCRStop.getIconWidth() + 4, iconVCRStop.getIconHeight() + 4);
        vcrButtonStop.setMinimumSize(minWid);
        vcrButtonStop.setPreferredSize(minWid);
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonStop, gbc);
        vcrButtonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickStop();
            }
        });
        JButton vcrButtonPlay = new JButton(iconVCRPlay);
        vcrButtonPlay.setBorderPainted(false);
        vcrButtonPlay.setDefaultCapable(false);
        vcrButtonPlay.setToolTipText("Play main time cursor");
        minWid = new Dimension(iconVCRPlay.getIconWidth() + 4, iconVCRPlay.getIconHeight() + 4);
        vcrButtonPlay.setMinimumSize(minWid);
        vcrButtonPlay.setPreferredSize(minWid);
        gbc.gridx = 6;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonPlay, gbc);
        vcrButtonPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickPlay();
            }
        });
        JButton vcrButtonToEnd = new JButton(iconVCRToEnd);
        vcrButtonToEnd.setBorderPainted(false);
        vcrButtonToEnd.setDefaultCapable(false);
        vcrButtonToEnd.setToolTipText("Move main time cursor to end");
        minWid = new Dimension(iconVCRToEnd.getIconWidth() + 4, iconVCRToEnd.getIconHeight() + 4);
        vcrButtonToEnd.setMinimumSize(minWid);
        vcrButtonToEnd.setPreferredSize(minWid);
        gbc.gridx = 7;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonToEnd, gbc);
        vcrButtonToEnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickToEnd();
            }
        });
        JButton vcrButtonFaster = new JButton(iconVCRFaster);
        vcrButtonFaster.setBorderPainted(false);
        vcrButtonFaster.setDefaultCapable(false);
        vcrButtonFaster.setToolTipText("Move main time cursor faster");
        minWid = new Dimension(iconVCRFaster.getIconWidth() + 4, iconVCRFaster.getIconHeight() + 4);
        vcrButtonFaster.setMinimumSize(minWid);
        vcrButtonFaster.setPreferredSize(minWid);
        gbc.gridx = 8;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonFaster, gbc);
        vcrButtonFaster.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickFaster();
            }
        });
        JButton vcrButtonSlower = new JButton(iconVCRSlower);
        vcrButtonSlower.setBorderPainted(false);
        vcrButtonSlower.setDefaultCapable(false);
        vcrButtonSlower.setToolTipText("Move main time cursor slower");
        minWid = new Dimension(iconVCRSlower.getIconWidth() + 4, iconVCRSlower.getIconHeight() + 4);
        vcrButtonSlower.setMinimumSize(minWid);
        vcrButtonSlower.setPreferredSize(minWid);
        gbc.gridx = 9;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.overall.add((Component)vcrButtonSlower, gbc);
        vcrButtonSlower.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WaveformWindow.this.vcrClickSlower();
            }
        });
        if (this.timeLocked) {
            this.addMainTimePanel();
        }
        DropTarget dropTarget = new DropTarget(this.overall, 0x40000000, waveformDropTarget, true);
    }

    private WindowFrame findSchematicsWindow() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof EditWindow)) continue;
            return wf;
        }
        return null;
    }

    public static WaveformWindow findWaveformWindow(Cell cell) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            if (wf.getContent().getCell() != cell || !(wf.getContent() instanceof WaveformWindow)) continue;
            return (WaveformWindow)wf.getContent();
        }
        return null;
    }

    public Iterator getPanels() {
        return this.wavePanels.iterator();
    }

    private Panel getPanelFromNumber(int panelNumber) {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (wp.panelNumber != panelNumber) continue;
            return wp;
        }
        return null;
    }

    public Engine getSimEngine() {
        return this.se;
    }

    public void setSimEngine(Engine se) {
        this.se = se;
    }

    public void showSelectedNetworksInSchematic() {
        freezeWaveformHighlighting = true;
        Iterator wIt = WindowFrame.getWindows();
        while (wIt.hasNext()) {
            EditWindow wnd;
            Cell cell;
            WindowFrame wf = (WindowFrame)wIt.next();
            if (!(wf.getContent() instanceof EditWindow) || (cell = (wnd = (EditWindow)wf.getContent()).getCell()) == null) continue;
            Highlighter hl = wnd.getHighlighter();
            Locator loc = new Locator(wnd, this);
            if (loc.getWaveformWindow() != this) continue;
            VarContext context = loc.getContext();
            hl.clear();
            Iterator it = this.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                Iterator pIt = wp.waveSignals.values().iterator();
                while (pIt.hasNext()) {
                    WaveSignal ws = (WaveSignal)pIt.next();
                    if (!ws.highlighted) continue;
                    String want = ws.sSig.getFullName();
                    Stack<Nodable> upNodables = new Stack<Nodable>();
                    Network net = null;
                    while (true) {
                        Netlist netlist;
                        String contextStr;
                        if ((contextStr = WaveformWindow.getSpiceNetName(context, null)).length() > 0) {
                            boolean matches = false;
                            if (want.startsWith(contextStr = contextStr + ".")) {
                                matches = true;
                            } else if (want.startsWith(contextStr = contextStr.replace('@', '_'))) {
                                matches = true;
                            }
                            if (!matches) {
                                if (context == VarContext.globalContext) break;
                                cell = context.getNodable().getParent();
                                upNodables.push(context.getNodable());
                                context = context.pop();
                                continue;
                            }
                        }
                        if ((netlist = cell.acquireUserNetlist()) == null) {
                            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
                            return;
                        }
                        net = WaveformWindow.findNetwork(netlist, want.substring(contextStr.length()));
                        if (net != null || context == VarContext.globalContext) break;
                        cell = context.getNodable().getParent();
                        upNodables.push(context.getNodable());
                        context = context.pop();
                    }
                    if (net != null) {
                        Nodable no;
                        while (!upNodables.isEmpty() && (net = HierarchyEnumerator.getNetworkInChild(net, no = (Nodable)upNodables.pop())) != null) {
                        }
                    }
                    if (net == null) continue;
                    hl.addNetwork(net, cell);
                }
            }
            hl.finished();
        }
        freezeWaveformHighlighting = false;
    }

    private void addMainTimePanel() {
        this.mainTimePanel = new TimeTickPanel(null, this);
        this.mainTimePanel.setToolTipText("One time scale applies to all signals when time is locked");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.overall.add((Component)this.mainTimePanel, gbc);
    }

    private void resetSweeps() {
        this.sweepSignals = new ArrayList();
        List sweeps = this.sd.getSweepList();
        Iterator it = sweeps.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            SweepSignal ss = new SweepSignal(obj, this);
        }
    }

    public List getSweepSignals() {
        return this.sweepSignals;
    }

    private void removeMainTimePanel() {
        this.overall.remove(this.mainTimePanel);
        this.mainTimePanel = null;
    }

    private void togglePanelName() {
        if (this.rebuildingSignalNameList) {
            return;
        }
        String panelName = (String)this.signalNameList.getSelectedItem();
        int spacePos = panelName.indexOf(32);
        if (spacePos >= 0) {
            panelName = panelName.substring(spacePos + 1);
        }
        int index = TextUtils.atoi(panelName);
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (wp.panelNumber != index) continue;
            if (wp.hidden) {
                this.showPanel(wp);
                break;
            }
            this.hidePanel(wp);
            break;
        }
    }

    private void tick() {
        long curtime = System.currentTimeMillis();
        if (curtime - this.vcrLastAdvance < 100L) {
            return;
        }
        this.vcrLastAdvance = curtime;
        if (this.wavePanels.size() == 0) {
            return;
        }
        Panel wp = (Panel)this.wavePanels.iterator().next();
        double dTime = wp.scaleDeltaXToTime(this.vcrAdvanceSpeed);
        double newTime = this.mainTime;
        Rectangle2D bounds = this.sd.getBounds();
        if (this.vcrPlayingBackwards) {
            double lowTime = bounds.getMinX();
            if ((newTime -= dTime) <= lowTime) {
                newTime = lowTime;
                this.vcrClickStop();
            }
        } else {
            double highTime = bounds.getMaxX();
            if ((newTime += dTime) >= highTime) {
                newTime = highTime;
                this.vcrClickStop();
            }
        }
        this.setMainTimeCursor(newTime);
        this.redrawAllPanels();
    }

    private void vcrClickRewind() {
        this.vcrClickStop();
        Rectangle2D bounds = this.sd.getBounds();
        double lowTime = bounds.getMinX();
        this.setMainTimeCursor(lowTime);
        this.redrawAllPanels();
    }

    private void vcrClickPlayBackwards() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = true;
    }

    private void vcrClickStop() {
        if (this.vcrTimer == null) {
            return;
        }
        this.vcrTimer.stop();
        this.vcrTimer = null;
    }

    private void vcrClickPlay() {
        if (this.vcrTimer == null) {
            ActionListener taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WaveformWindow.this.tick();
                }
            };
            this.vcrTimer = new Timer(100, taskPerformer);
            this.vcrLastAdvance = System.currentTimeMillis();
            this.vcrTimer.start();
        }
        this.vcrPlayingBackwards = false;
    }

    private void vcrClickToEnd() {
        this.vcrClickStop();
        Rectangle2D bounds = this.sd.getBounds();
        double highTime = bounds.getMaxX();
        this.setMainTimeCursor(highTime);
        this.redrawAllPanels();
    }

    private void vcrClickFaster() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed += j;
    }

    private void vcrClickSlower() {
        int j = this.vcrAdvanceSpeed / 4;
        if (j <= 0) {
            j = 1;
        }
        this.vcrAdvanceSpeed -= j;
        if (this.vcrAdvanceSpeed <= 0) {
            this.vcrAdvanceSpeed = 1;
        }
    }

    public void setSimData(Stimuli sd) {
        this.sd = sd;
        this.resetSweeps();
        ArrayList panelList = new ArrayList();
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            panelList.add(it.next());
        }
        it = panelList.iterator();
        while (it.hasNext()) {
            WaveSignal ws;
            Panel wp = (Panel)it.next();
            boolean redoPanel = false;
            Iterator pIt = wp.waveSignals.values().iterator();
            while (pIt.hasNext()) {
                ws = (WaveSignal)pIt.next();
                Signal ss = ws.sSig;
                if (ss.getBussedSignals() != null) {
                    List inBus = ss.getBussedSignals();
                    for (int b = 0; b < inBus.size(); ++b) {
                        Signal subDS = (Signal)inBus.get(b);
                        String oldSigName = subDS.getFullName();
                        Signal newBus = null;
                        Iterator sIt = sd.getSignals().iterator();
                        while (sIt.hasNext()) {
                            Signal newSs = (Signal)sIt.next();
                            String newSigName = newSs.getFullName();
                            if (!newSigName.equals(oldSigName)) continue;
                            newBus = newSs;
                            break;
                        }
                        if (newBus == null) {
                            inBus.remove(b);
                            --b;
                            System.out.println("Could not find signal " + oldSigName + " in the new data");
                            redoPanel = true;
                            continue;
                        }
                        inBus.set(b, newBus);
                    }
                    continue;
                }
                String oldSigName = ss.getFullName();
                ws.sSig = null;
                Iterator sIt = sd.getSignals().iterator();
                while (sIt.hasNext()) {
                    Signal newSs = (Signal)sIt.next();
                    String newSigName = newSs.getFullName();
                    if (!newSigName.equals(oldSigName)) continue;
                    ws.sSig = newSs;
                    break;
                }
                if (ws.sSig != null) continue;
                System.out.println("Could not find signal " + oldSigName + " in the new data");
                redoPanel = true;
            }
            block6: while (redoPanel) {
                redoPanel = false;
                pIt = wp.waveSignals.values().iterator();
                while (pIt.hasNext()) {
                    ws = (WaveSignal)pIt.next();
                    if (ws.sSig != null && (ws.sSig.getBussedSignals() == null || ws.sSig.getBussedSignals().size() != 0)) continue;
                    redoPanel = true;
                    if (wp.signalButtons != null) {
                        wp.signalButtons.remove(ws.sigButton);
                    }
                    wp.waveSignals.remove(ws.sigButton);
                    continue block6;
                }
            }
            if (wp.waveSignals.size() == 0) {
                wp.waveWindow.closePanel(wp);
                continue;
            }
            if (wp.signalButtons != null) {
                wp.signalButtons.validate();
                wp.signalButtons.repaint();
            }
            wp.repaint();
        }
        this.wf.wantToRedoSignalTree();
        System.out.println("Simulation data refreshed from disk");
    }

    public Stimuli getSimData() {
        return this.sd;
    }

    public JPanel getPanel() {
        return this.overall;
    }

    public void setCell(Cell cell, VarContext context) {
        this.sd.setCell(cell);
        this.setWindowTitle();
    }

    public Cell getCell() {
        return this.sd.getCell();
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public static HighlightListener getStaticHighlightListener() {
        return waveHighlighter;
    }

    private void rebuildPanelList() {
        this.rebuildingSignalNameList = true;
        this.signalNameList.removeAllItems();
        boolean hasSignals = false;
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            this.signalNameList.addItem("Panel " + Integer.toString(wp.panelNumber) + (wp.hidden ? " (HIDDEN)" : ""));
            hasSignals = true;
        }
        if (hasSignals) {
            this.signalNameList.setSelectedIndex(0);
        }
        this.rebuildingSignalNameList = false;
    }

    public void loadExplorerTree(DefaultMutableTreeNode rootNode) {
        this.wf.libraryExplorerNode = null;
        this.wf.jobExplorerNode = Job.getExplorerTree();
        this.wf.errorExplorerNode = ErrorLogger.getExplorerTree();
        this.wf.signalExplorerNode = this.getSignalsForExplorer();
        this.wf.sweepExplorerNode = this.getSweepsForExplorer();
        rootNode.add(this.wf.signalExplorerNode);
        if (this.wf.sweepExplorerNode != null) {
            rootNode.add(this.wf.sweepExplorerNode);
        }
        rootNode.add(this.wf.jobExplorerNode);
        rootNode.add(this.wf.errorExplorerNode);
    }

    public void bottomScrollChanged(int e) {
    }

    public void rightScrollChanged(int e) {
    }

    public boolean cellHistoryCanGoBack() {
        return false;
    }

    public boolean cellHistoryCanGoForward() {
        return false;
    }

    public void cellHistoryGoBack() {
    }

    public void cellHistoryGoForward() {
    }

    private DefaultMutableTreeNode getSignalsForExplorer() {
        Signal sSig;
        DefaultMutableTreeNode signalsExplorerTree = new DefaultMutableTreeNode("SIGNALS");
        HashMap<String, DefaultMutableTreeNode> contextMap = new HashMap<String, DefaultMutableTreeNode>();
        contextMap.put("", signalsExplorerTree);
        List signals = this.sd.getSignals();
        Collections.sort(signals, new SignalsByName());
        char separatorChar = this.sd.getSeparatorChar();
        Iterator it = signals.iterator();
        while (it.hasNext()) {
            sSig = (Signal)it.next();
            if (sSig.getSignalContext() == null) continue;
            this.makeContext(sSig.getSignalContext(), contextMap, separatorChar);
        }
        it = signals.iterator();
        while (it.hasNext()) {
            sSig = (Signal)it.next();
            DefaultMutableTreeNode thisTree = signalsExplorerTree;
            if (sSig.getSignalContext() != null) {
                thisTree = this.makeContext(sSig.getSignalContext(), contextMap, separatorChar);
            }
            thisTree.add(new DefaultMutableTreeNode(sSig));
        }
        return signalsExplorerTree;
    }

    private DefaultMutableTreeNode makeContext(String branchName, HashMap contextMap, char separatorChar) {
        DefaultMutableTreeNode branchTree = (DefaultMutableTreeNode)contextMap.get(branchName);
        if (branchTree != null) {
            return branchTree;
        }
        String parent = "";
        String leaf = branchName;
        int dotPos = leaf.lastIndexOf(separatorChar);
        if (dotPos >= 0) {
            parent = leaf.substring(0, dotPos);
            leaf = leaf.substring(dotPos + 1);
        }
        DefaultMutableTreeNode parentBranch = this.makeContext(parent, contextMap, separatorChar);
        DefaultMutableTreeNode thisTree = new DefaultMutableTreeNode(leaf);
        parentBranch.add(thisTree);
        contextMap.put(branchName, thisTree);
        return thisTree;
    }

    private DefaultMutableTreeNode getSweepsForExplorer() {
        if (this.sweepSignals.size() <= 0) {
            return null;
        }
        DefaultMutableTreeNode sweepsExplorerTree = new DefaultMutableTreeNode("SWEEPS");
        Iterator it = this.sweepSignals.iterator();
        while (it.hasNext()) {
            SweepSignal ss = (SweepSignal)it.next();
            sweepsExplorerTree.add(new DefaultMutableTreeNode(ss));
        }
        return sweepsExplorerTree;
    }

    private Signal findSignal(String name) {
        Iterator it = this.sd.getSignals().iterator();
        while (it.hasNext()) {
            Signal sSig = (Signal)it.next();
            String sigName = sSig.getFullName();
            if (!sigName.equals(name)) continue;
            return sSig;
        }
        return null;
    }

    private static Network findNetwork(Netlist netlist, String name) {
        Network net;
        Iterator nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = (Network)nIt.next();
            if (!WaveformWindow.getSpiceNetName(net).equalsIgnoreCase(name)) continue;
            return net;
        }
        nIt = netlist.getNetworks();
        while (nIt.hasNext()) {
            net = (Network)nIt.next();
            String convertedName = WaveformWindow.getSpiceNetName(net).replace('@', '_');
            if (!convertedName.equalsIgnoreCase(name)) continue;
            return net;
        }
        return null;
    }

    public void showSignals(Set nets, VarContext context, boolean newPanel) {
        Panel wp = null;
        Iterator pIt = this.wavePanels.iterator();
        while (pIt.hasNext()) {
            Panel oWp = (Panel)pIt.next();
            if (!oWp.selected) continue;
            wp = oWp;
            break;
        }
        if (!this.sd.isAnalog()) {
            newPanel = true;
        }
        if (!newPanel && wp == null) {
            System.out.println("No current waveform panel to add signals");
            return;
        }
        boolean added = false;
        Iterator it = nets.iterator();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            String netName = WaveformWindow.getSpiceNetName(context, net);
            Signal sSig = this.sd.findSignalForNetwork(netName);
            if (sSig == null && (sSig = this.sd.findSignalForNetwork(netName = netName.replace('@', '_'))) == null) {
                System.out.println("Unable to find a signal named " + netName);
                continue;
            }
            if (newPanel) {
                boolean isAnalog = false;
                if (sSig instanceof AnalogSignal) {
                    isAnalog = true;
                }
                wp = this.makeNewPanel(isAnalog);
                if (isAnalog) {
                    AnalogSignal as = (AnalogSignal)sSig;
                    Rectangle2D rangeBounds = as.getBounds();
                    double lowValue = rangeBounds.getMinY();
                    double highValue = rangeBounds.getMaxY();
                    double range = highValue - lowValue;
                    if (range == 0.0) {
                        range = 2.0;
                    }
                    double rangeExtra = range / 10.0;
                    wp.setValueRange(lowValue - rangeExtra, highValue + rangeExtra);
                    wp.makeSelectedPanel();
                }
            }
            boolean alreadyPlotted = false;
            Iterator pIt2 = wp.waveSignals.values().iterator();
            while (pIt2.hasNext()) {
                WaveSignal ws = (WaveSignal)pIt2.next();
                String name = ws.sSig.getFullName();
                if (!name.equals(sSig.getFullName())) continue;
                alreadyPlotted = true;
                wp.addSignalToPanel(ws.sSig);
            }
            if (!alreadyPlotted) {
                WaveSignal wsig = new WaveSignal(wp, sSig);
            }
            added = true;
            wp.repaint();
        }
        if (added) {
            this.overall.validate();
            this.saveSignalOrder();
        }
    }

    public static String getSpiceNetName(Network net) {
        String name = "";
        if (net.hasNames()) {
            name = net.getExportedNames().hasNext() ? (String)net.getExportedNames().next() : (String)net.getNames().next();
        } else {
            name = net.describe(false);
            if (name.equals("")) {
                name = "UNCONNECTED";
            }
        }
        return name;
    }

    public static String getSpiceNetName(VarContext context, Network net) {
        if (net != null) {
            while (net.isExported() && context != VarContext.globalContext && (net = WaveformWindow.getNetworkInParent(net, context.getNodable())) != null) {
                context = context.pop();
            }
        }
        String contextStr = context.getInstPath(".");
        contextStr = contextStr.toLowerCase();
        if (net == null) {
            return contextStr;
        }
        if (context == VarContext.globalContext) {
            return WaveformWindow.getSpiceNetName(net);
        }
        return contextStr + "." + WaveformWindow.getSpiceNetName(net);
    }

    public static Network getNetworkInParent(Network childNetwork, Nodable childNodable) {
        if (childNodable == null || childNetwork == null) {
            return null;
        }
        if (!(childNodable.getProto() instanceof Cell)) {
            return null;
        }
        Cell childCell = (Cell)childNodable.getProto();
        if (childCell.contentsView() != null) {
            childCell = childCell.contentsView();
        }
        boolean found = false;
        Export export = null;
        int i = 0;
        Iterator it = childCell.getPorts();
        while (it.hasNext()) {
            export = (Export)it.next();
            for (i = 0; i < export.getNameKey().busWidth(); ++i) {
                Netlist netlist = childCell.acquireUserNetlist();
                if (netlist == null) {
                    System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
                    return null;
                }
                Network net = netlist.getNetwork(export, i);
                if (net != childNetwork) continue;
                found = true;
                break;
            }
            if (!found) continue;
        }
        if (!found) {
            return null;
        }
        Export pp = (Export)childNodable.getProto().findPortProto(export.getNameKey());
        Cell parentCell = childNodable.getParent();
        Netlist netlist = parentCell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return null;
        }
        Network parentNet = netlist.getNetwork(childNodable, pp, i);
        return parentNet;
    }

    public WaveSignal findDisplayedSignal(Signal sSig) {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                if (ws.sSig != sSig) continue;
                return ws;
            }
        }
        return null;
    }

    public void clearHighlighting() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            boolean changed = false;
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                if (ws.highlighted) {
                    changed = true;
                }
                ws.highlighted = false;
            }
            if (!changed) continue;
            wp.repaint();
        }
    }

    public List getHighlightedNetworkNames() {
        ArrayList<Signal> highlightedSignals = new ArrayList<Signal>();
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                if (!ws.highlighted) continue;
                highlightedSignals.add(ws.sSig);
            }
        }
        return highlightedSignals;
    }

    public Set getHighlightedNetworks() {
        HashSet<Network> nets = new HashSet<Network>();
        Cell cell = this.sd.getCell();
        if (cell == null) {
            return nets;
        }
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return nets;
        }
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                Network net = WaveformWindow.findNetwork(netlist, ws.sSig.getSignalName());
                if (net == null) continue;
                nets.add(net);
            }
        }
        return nets;
    }

    public double getMainTimeCursor() {
        return this.mainTime;
    }

    public void setMainTimeCursor(double time) {
        this.mainTime = time;
        String amount = TextUtils.convertToEngineeringNotation(this.mainTime, "s");
        this.mainPos.setText("Main: " + amount);
        String diff = TextUtils.convertToEngineeringNotation(Math.abs(this.mainTime - this.extTime), "s");
        this.delta.setText("Delta: " + diff);
        this.updateAssociatedLayoutWindow();
    }

    public double getExtensionTimeCursor() {
        return this.extTime;
    }

    public void setExtensionTimeCursor(double time) {
        this.extTime = time;
        String amount = TextUtils.convertToEngineeringNotation(this.extTime, "s");
        this.extPos.setText("Ext: " + amount);
        String diff = TextUtils.convertToEngineeringNotation(Math.abs(this.mainTime - this.extTime), "s");
        this.delta.setText("Delta: " + diff);
    }

    private Panel makeNewPanel(boolean isAnalog) {
        Panel oPanel = null;
        Iterator pIt = this.getPanels();
        if (pIt.hasNext()) {
            oPanel = (Panel)pIt.next();
        }
        Panel panel = new Panel(this, isAnalog);
        if (oPanel != null) {
            panel.setTimeRange(oPanel.minTime, oPanel.maxTime);
        }
        return panel;
    }

    public void setDefaultTimeRange(double minTime, double maxTime) {
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public void setZoomExtents(double lowVert, double highVert, double lowHoriz, double highHoriz, Panel thePanel) {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            boolean changed = false;
            if (wp == thePanel) {
                wp.setValueRange(lowVert, highVert);
                changed = true;
            }
            if (this.timeLocked || wp == thePanel) {
                wp.minTime = lowHoriz;
                wp.maxTime = highHoriz;
                changed = true;
            }
            if (!changed) continue;
            wp.repaintWithTime();
        }
    }

    private void redrawAllPanels() {
        this.left.repaint();
        this.right.repaint();
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            wp.repaint();
        }
    }

    public void setWindowTitle() {
        if (this.wf == null) {
            return;
        }
        String title = "";
        title = this.sd.getEngine() != null ? "Simulation of" : "Waveforms of ";
        if (this.sd != null && this.sd.getDataType() != null) {
            title = this.sd.getEngine() != null ? this.sd.getDataType().getName() + " simulation of " : this.sd.getDataType().getName() + " of ";
        }
        this.wf.setTitle(this.wf.composeTitle(this.sd.getCell(), title, 0));
    }

    private static StepSize getSensibleValues(double h, double l, int n) {
        StepSize ss = new StepSize();
        ss.low = l;
        ss.high = h;
        ss.stepScale = 0;
        ss.rangeScale = 0;
        double range = Math.max(Math.abs(l), Math.abs(h));
        if (range == 0.0) {
            ss.separation = 0.0;
            return ss;
        }
        while (range >= 10.0) {
            range /= 10.0;
            ++ss.rangeScale;
        }
        while (range <= 1.0) {
            range *= 10.0;
            --ss.rangeScale;
        }
        double d = Math.abs(h - l) / (double)n;
        if (Math.abs(d / (h + l)) < 1.0E-7) {
            d = 0.1f;
        }
        int mp = 0;
        while (d >= 10.0) {
            d /= 10.0;
            ++mp;
            ++ss.stepScale;
        }
        while (d <= 1.0) {
            d *= 10.0;
            --mp;
            --ss.stepScale;
        }
        double m = Math.pow(10.0, mp);
        int di = (int)d;
        if (di > 2 && di <= 5) {
            di = 5;
        } else if (di > 5) {
            di = 10;
        }
        int li = (int)(l / m);
        int hi = (int)(h / m);
        li = li / di * di;
        hi = hi / di * di;
        if (li < 0) {
            li -= di;
        }
        if (hi > 0) {
            hi += di;
        }
        ss.low = (double)li * m;
        ss.high = (double)hi * m;
        ss.separation = (double)di * m;
        return ss;
    }

    private static String prettyPrint(double v, int i1, int i2) {
        int i;
        double d = 1.0;
        if (i2 > 0) {
            for (i = 0; i < i2; ++i) {
                d *= 10.0;
            }
        }
        if (i2 < 0) {
            for (i = 0; i > i2; --i) {
                d /= 10.0;
            }
        }
        if (Math.abs(v) * 100.0 < d) {
            return "0";
        }
        if (i1 <= 4 && i1 >= 0 && i2 >= 0) {
            String s = TextUtils.formatDouble(v, 1);
            return s;
        }
        if (i1 <= 4 && i1 >= -2 && i2 < 0) {
            String s = TextUtils.formatDouble(v, -i2);
            return s;
        }
        int p = i1 - 12 - 1;
        if (p <= 0) {
            p = 1;
        }
        String s = TextUtils.formatDouble(v / d, p);
        return s + "e" + i2;
    }

    private void updateAssociatedLayoutWindow() {
        if (this.sd.isAnalog()) {
            return;
        }
        WindowFrame oWf = this.findSchematicsWindow();
        if (oWf == null) {
            return;
        }
        EditWindow schemWnd = (EditWindow)oWf.getContent();
        boolean crossProbeChanged = schemWnd.hasCrossProbeData();
        schemWnd.clearCrossProbeLevels();
        Cell cell = this.getCell();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted crossprobing (network information unavailable).  Please try again");
            return;
        }
        this.netValues = new HashMap();
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (wp.hidden) continue;
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                DigitalSignal ds = (DigitalSignal)ws.sSig;
                List bussedSignals = ds.getBussedSignals();
                if (bussedSignals != null) {
                    int busWidth = bussedSignals.size();
                    Iterator bIt = bussedSignals.iterator();
                    while (bIt.hasNext()) {
                        DigitalSignal subDS = (DigitalSignal)bIt.next();
                        this.putValueOnTrace(subDS, cell, this.netValues, netlist);
                    }
                    continue;
                }
                this.putValueOnTrace(ds, cell, this.netValues, netlist);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            Integer state;
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() != Generic.tech.simProbeNode) continue;
            Network net = null;
            Iterator cIt = ni.getConnections();
            if (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                net = netlist.getNetwork(con.getArc(), 0);
            }
            if (net == null || (state = (Integer)this.netValues.get(net)) == null) continue;
            Color col = this.getHighlightColor(state);
            schemWnd.addCrossProbeBox(ni.getBounds(), col);
            crossProbeChanged = true;
            this.netValues.remove(net);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            int width = netlist.getBusWidth(ai);
            for (int i = 0; i < width; ++i) {
                Network net = netlist.getNetwork(ai, i);
                Integer state = (Integer)this.netValues.get(net);
                if (state == null) continue;
                Color col = this.getHighlightColor(state);
                schemWnd.addCrossProbeLine(ai.getHeadLocation(), ai.getTailLocation(), col);
                crossProbeChanged = true;
            }
        }
        if (crossProbeChanged) {
            schemWnd.repaint();
        }
    }

    private Color getHighlightColor(int state) {
        switch (state & 3) {
            case 0: {
                return new Color(User.getColorWaveformCrossProbeLow());
            }
            case 2: {
                return new Color(User.getColorWaveformCrossProbeHigh());
            }
            case 1: {
                return new Color(User.getColorWaveformCrossProbeX());
            }
            case 3: {
                return new Color(User.getColorWaveformCrossProbeZ());
            }
        }
        return Color.RED;
    }

    private void putValueOnTrace(DigitalSignal ds, Cell cell, HashMap netValues, Netlist netlist) {
        Network net = WaveformWindow.findNetwork(netlist, ds.getSignalName());
        if (net == null) {
            return;
        }
        int numEvents = ds.getNumEvents();
        int state = 1;
        for (int i = numEvents - 1; i >= 0; --i) {
            double time = ds.getTime(i);
            if (!(time <= this.mainTime)) continue;
            state = ds.getState(i) & 3;
            break;
        }
        netValues.put(net, new Integer(state));
    }

    public void closePanel(Panel wp) {
        this.left.remove(wp.leftHalf);
        this.right.remove(wp.rightHalf);
        this.wavePanels.remove(wp);
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void hidePanel(Panel wp) {
        if (wp.hidden) {
            return;
        }
        wp.hidden = true;
        this.left.remove(wp.leftHalf);
        this.right.remove(wp.rightHalf);
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void showPanel(Panel wp) {
        if (!wp.hidden) {
            return;
        }
        wp.hidden = false;
        this.left.add(wp.leftHalf);
        this.right.add(wp.rightHalf);
        this.rebuildPanelList();
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void growPanels(double scale) {
        panelSizeDigital = (int)((double)panelSizeDigital * scale);
        panelSizeAnalog = (int)((double)panelSizeAnalog * scale);
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            Dimension sz = wp.getSize();
            sz.height = (int)((double)sz.height * scale);
            wp.setSize(sz.width, sz.height);
            wp.setMinimumSize(sz);
            wp.setPreferredSize(sz);
            if (wp.signalButtonsPane != null) {
                sz = wp.signalButtonsPane.getSize();
                sz.height = (int)((double)sz.height * scale);
                wp.signalButtonsPane.setPreferredSize(sz);
                wp.signalButtonsPane.setSize(sz.width, sz.height);
                continue;
            }
            sz = wp.leftHalf.getSize();
            sz.height = (int)((double)sz.height * scale);
            wp.leftHalf.setPreferredSize(sz);
            wp.leftHalf.setMinimumSize(sz);
            wp.leftHalf.setSize(sz.width, sz.height);
        }
        this.overall.validate();
        this.redrawAllPanels();
    }

    public void centerCursor(boolean main) {
        boolean havePanel = false;
        double lowTime = 0.0;
        double highTime = 0.0;
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            double low = wp.getMinTimeRange();
            double high = wp.getMaxTimeRange();
            if (havePanel) {
                lowTime = Math.max(lowTime, low);
                highTime = Math.min(highTime, high);
                continue;
            }
            lowTime = low;
            highTime = high;
            havePanel = true;
        }
        if (!havePanel) {
            return;
        }
        double center = (lowTime + highTime) / 2.0;
        if (main) {
            this.setMainTimeCursor(center);
        } else {
            this.setExtensionTimeCursor(center);
        }
        Iterator it2 = this.wavePanels.iterator();
        while (it2.hasNext()) {
            Panel wp = (Panel)it2.next();
            wp.repaintWithTime();
        }
    }

    public void togglePanelTimeLock() {
        boolean bl = this.timeLocked = !this.timeLocked;
        if (this.timeLocked) {
            Panel wp;
            this.timeLock.setIcon(iconLockTime);
            this.addMainTimePanel();
            double minTime = 0.0;
            double maxTime = 0.0;
            int vertAxis = 0;
            boolean first = true;
            Iterator it = this.wavePanels.iterator();
            while (it.hasNext()) {
                wp = (Panel)it.next();
                wp.removeTimePanel();
                if (first) {
                    first = false;
                    minTime = wp.minTime;
                    maxTime = wp.maxTime;
                    vertAxis = wp.vertAxisPos;
                    continue;
                }
                if (wp.minTime < minTime) {
                    minTime = wp.minTime;
                    maxTime = wp.maxTime;
                }
                wp.vertAxisPos = vertAxis;
            }
            it = this.wavePanels.iterator();
            while (it.hasNext()) {
                wp = (Panel)it.next();
                wp.minTime = minTime;
                wp.maxTime = maxTime;
            }
        } else {
            this.timeLock.setIcon(iconUnLockTime);
            Iterator it = this.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                wp.addTimePanel();
            }
            this.removeMainTimePanel();
        }
        this.overall.validate();
        this.overall.repaint();
    }

    public void refreshData() {
        if (this.se != null) {
            this.se.refresh();
            return;
        }
        if (this.sd.getDataType() == null) {
            System.out.println("This simulation data did not come from disk...cannot refresh");
            return;
        }
        Simulate.plotSimulationResults(this.sd.getDataType(), this.sd.getCell(), this.sd.getFileURL(), this);
    }

    private void saveSignalOrder() {
        Cell cell = this.getCell();
        if (cell == null) {
            return;
        }
        ArrayList<String> signalList = new ArrayList<String>();
        int total = this.right.getComponentCount();
        block0: for (int i = 0; i < total; ++i) {
            JPanel rightPart = (JPanel)this.right.getComponent(i);
            Iterator it = this.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (wp.rightHalf != rightPart) continue;
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                Iterator sIt = wp.waveSignals.values().iterator();
                while (sIt.hasNext()) {
                    WaveSignal ws = (WaveSignal)sIt.next();
                    String sigName = ws.sSig.getFullName();
                    if (first) {
                        first = false;
                    } else {
                        sb.append("\t");
                    }
                    sb.append(sigName);
                }
                if (first) continue block0;
                signalList.add(sb.toString());
                continue block0;
            }
        }
        new SaveSignalOrder(cell, signalList);
    }

    private void addNewPanel() {
        boolean isAnalog = this.sd.isAnalog();
        if (isAnalog) {
            Rectangle2D bounds = this.sd.getBounds();
            double lowValue = bounds.getMinY();
            double highValue = bounds.getMaxY();
            double lowTime = bounds.getMinX();
            double highTime = bounds.getMaxX();
            if (this.timeLocked && this.wavePanels.size() > 0) {
                Panel aPanel = (Panel)this.wavePanels.get(0);
                lowTime = aPanel.minTime;
                highTime = aPanel.maxTime;
            }
            Panel wp = new Panel(this, isAnalog);
            wp.setValueRange(lowValue, highValue);
            wp.setTimeRange(lowTime, highTime);
            wp.makeSelectedPanel();
        }
        this.getPanel().validate();
    }

    private void toggleShowPoints() {
        boolean bl = this.showVertexPoints = !this.showVertexPoints;
        if (this.showVertexPoints) {
            this.showPoints.setIcon(iconPointsOn);
        } else {
            this.showPoints.setIcon(iconPointsOff);
        }
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            wp.repaintWithTime();
        }
    }

    public void toggleGridPoints() {
        this.showGrid = !this.showGrid;
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            wp.repaintWithTime();
        }
    }

    public void addSignal(Signal sig) {
        if (sig instanceof AnalogSignal) {
            Iterator it = this.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (!wp.selected) continue;
                wp.addSignalToPanel(sig);
                break;
            }
        } else {
            Panel wp = this.makeNewPanel(false);
            WaveSignal wsig = new WaveSignal(wp, sig);
            this.overall.validate();
            wp.repaint();
        }
        this.saveSignalOrder();
    }

    public void deleteSelectedSignals() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (!wp.selected) continue;
            Iterator sIt = wp.getSignals().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                if (ws.controlPointsSelected == null || this.se == null) continue;
                this.se.removeSelectedStimuli();
            }
            if (!wp.isAnalog) break;
            this.deleteSignalFromPanel(wp);
            break;
        }
    }

    public void deleteSignalFromPanel(Panel wp) {
        boolean found = true;
        block0: while (found) {
            found = false;
            Iterator it = wp.waveSignals.values().iterator();
            while (it.hasNext()) {
                WaveSignal ws = (WaveSignal)it.next();
                if (!ws.highlighted) continue;
                wp.removeHighlightedSignal(ws);
                wp.signalButtons.remove(ws.sigButton);
                wp.waveSignals.remove(ws.sigButton);
                found = true;
                continue block0;
            }
        }
        wp.signalButtons.validate();
        wp.signalButtons.repaint();
        wp.repaint();
        this.saveSignalOrder();
    }

    public void deleteAllSignalsFromPanel(Panel wp) {
        wp.clearHighlightedSignals();
        wp.signalButtons.removeAll();
        wp.signalButtons.validate();
        wp.signalButtons.repaint();
        wp.waveSignals.clear();
        wp.repaint();
        this.saveSignalOrder();
    }

    public void fillScreen() {
        Rectangle2D timeBounds = this.sd.getBounds();
        double lowTime = timeBounds.getMinX();
        double highTime = timeBounds.getMaxX();
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (!this.timeLocked && !wp.selected) continue;
            Rectangle2D bounds = new Rectangle2D.Double();
            boolean first = true;
            Iterator sIt = wp.waveSignals.values().iterator();
            while (sIt.hasNext()) {
                WaveSignal ws = (WaveSignal)sIt.next();
                Rectangle2D sigBounds = ws.sSig.getBounds();
                if (first) {
                    bounds = sigBounds;
                    first = false;
                    continue;
                }
                Rectangle2D.union(bounds, sigBounds, bounds);
            }
            double lowValue = bounds.getMinY();
            double highValue = bounds.getMaxY();
            double valueRange = (highValue - lowValue) / 8.0;
            if (valueRange == 0.0) {
                valueRange = 0.5;
            }
            lowValue -= valueRange;
            highValue += valueRange;
            boolean repaint = false;
            if (wp.minTime != lowTime || wp.maxTime != highTime) {
                wp.minTime = lowTime;
                wp.maxTime = highTime;
                repaint = true;
            }
            if (wp.isAnalog && (wp.analogLowValue != lowValue || wp.analogHighValue != highValue)) {
                wp.setValueRange(lowValue, highValue);
                repaint = true;
            }
            if (!repaint) continue;
            wp.repaintWithTime();
        }
    }

    public void zoomOutContents() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (!this.timeLocked && !wp.selected) continue;
            boolean repaint = false;
            double range = wp.maxTime - wp.minTime;
            wp.minTime -= range / 2.0;
            wp.maxTime += range / 2.0;
            if (wp.minTime < 0.0) {
                wp.maxTime -= wp.minTime;
                wp.minTime = 0.0;
            }
            wp.repaintWithTime();
        }
    }

    public void zoomInContents() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (!this.timeLocked && !wp.selected) continue;
            boolean repaint = false;
            double range = wp.maxTime - wp.minTime;
            wp.minTime += range / 4.0;
            wp.maxTime -= range / 4.0;
            wp.repaintWithTime();
        }
    }

    public void focusOnHighlighted() {
        double minTime;
        double maxTime;
        double size;
        if (this.mainTime == this.extTime) {
            return;
        }
        if (this.mainTime > this.extTime) {
            size = (this.mainTime - this.extTime) / 20.0;
            maxTime = this.mainTime + size;
            minTime = this.extTime - size;
        } else {
            size = (this.extTime - this.mainTime) / 20.0;
            maxTime = this.extTime + size;
            minTime = this.mainTime - size;
        }
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            if (!this.timeLocked && !wp.selected || wp.minTime == minTime && wp.maxTime == maxTime) continue;
            wp.minTime = minTime;
            wp.maxTime = maxTime;
            wp.repaintWithTime();
        }
    }

    public void finished() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            wp.finished();
        }
    }

    public void fullRepaint() {
        this.repaint();
    }

    public void repaint() {
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            wp.repaint();
        }
        if (this.mainTimePanel != null) {
            this.mainTimePanel.repaint();
        }
    }

    public void fireCellHistoryStatus() {
    }

    public void initTextSearch(String search, boolean caseSensitive, boolean regExp, Set whatToSearch) {
        System.out.println("Text search not implemented for waveform windows");
    }

    public boolean findNextText(boolean reverse) {
        return false;
    }

    public void replaceText(String replace) {
    }

    public void replaceAllText(String replace) {
    }

    public void writeImage(ElectricPrinter ep, String filePath) {
        BufferedImage img = this.getOffScreenImage(ep);
        PNG.writeImage(img, filePath);
    }

    public BufferedImage getOffScreenImage(ElectricPrinter ep) {
        Graphics2D g2d = (Graphics2D)ep.getGraphics();
        JPanel printArea = this.wf.getContent().getPanel();
        int iw = (int)ep.getPageFormat().getImageableWidth() * ep.getDesiredDPI() / 72;
        int ih = (int)ep.getPageFormat().getImageableHeight() * ep.getDesiredDPI() / 72;
        BufferedImage bImage = (BufferedImage)printArea.createImage(iw, ih);
        if (g2d == null) {
            g2d = bImage.createGraphics();
        }
        g2d.translate(ep.getPageFormat().getImageableX(), ep.getPageFormat().getImageableY());
        printArea.paint(g2d);
        return bImage;
    }

    public void panXOrY(int direction, double[] panningAmounts, int ticks) {
        double hRange = this.maxTime - this.minTime;
        double vRange = -1.0;
        double vRangeAny = -1.0;
        Iterator it = this.wavePanels.iterator();
        while (it.hasNext()) {
            Panel wp = (Panel)it.next();
            vRangeAny = wp.analogRange;
            if (!wp.selected) continue;
            hRange = wp.maxTime - wp.minTime;
            vRange = wp.analogRange;
            break;
        }
        if (vRange < 0.0) {
            vRange = vRangeAny;
        }
        double distance = (double)ticks * panningAmounts[User.getPanningDistance()];
        Iterator it2 = this.wavePanels.iterator();
        while (it2.hasNext()) {
            Panel wp = (Panel)it2.next();
            if (direction == 0) {
                if (!this.timeLocked && !wp.selected) continue;
                wp.minTime -= hRange * distance;
                wp.maxTime -= hRange * distance;
            } else {
                if (!wp.selected) continue;
                wp.analogLowValue -= vRange * distance;
                wp.analogHighValue -= vRange * distance;
            }
            wp.repaintWithTime();
        }
    }

    private static class SaveSignalOrder
    extends Job {
        private Cell cell;
        private List list;

        private SaveSignalOrder(Cell cell, List list) {
            super("Save Signal Order", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.list = list;
            this.startJob();
        }

        public boolean doIt() {
            if (this.list.size() == 0) {
                if (this.cell.getVar(WINDOW_SIGNAL_ORDER) != null) {
                    this.cell.delVar(WINDOW_SIGNAL_ORDER);
                }
            } else {
                String[] strings = new String[this.list.size()];
                int i = 0;
                Iterator it = this.list.iterator();
                while (it.hasNext()) {
                    strings[i] = (String)it.next();
                    ++i;
                }
                this.cell.newVar(WINDOW_SIGNAL_ORDER, (Object)strings);
            }
            return true;
        }
    }

    private static class StepSize {
        double separation;
        double low;
        double high;
        int rangeScale;
        int stepScale;

        private StepSize() {
        }
    }

    private static class SignalsByName
    implements Comparator {
        private SignalsByName() {
        }

        public int compare(Object o1, Object o2) {
            Signal s1 = (Signal)o1;
            Signal s2 = (Signal)o2;
            return TextUtils.nameSameNumeric(s1.getFullName(), s2.getFullName());
        }
    }

    private static class WaveComponentListener
    implements ComponentListener {
        private JPanel panel;

        public WaveComponentListener(JPanel panel) {
            this.panel = panel;
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.panel.repaint();
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    private static class WaveformWindowHighlightListener
    implements HighlightListener {
        private WaveformWindowHighlightListener() {
        }

        public void highlightChanged(Highlighter which) {
            if (freezeWaveformHighlighting) {
                return;
            }
            EditWindow wnd = null;
            WindowFrame highWF = which.getWindowFrame();
            if (highWF != null && highWF.getContent() instanceof EditWindow) {
                wnd = (EditWindow)highWF.getContent();
            }
            if (wnd == null) {
                return;
            }
            Iterator wIt = WindowFrame.getWindows();
            while (wIt.hasNext()) {
                Locator loc;
                WindowFrame wf = (WindowFrame)wIt.next();
                if (!(wf.getContent() instanceof WaveformWindow)) continue;
                WaveformWindow ww = (WaveformWindow)wf.getContent();
                Iterator it = ww.wavePanels.iterator();
                while (it.hasNext()) {
                    Panel wp = (Panel)it.next();
                    wp.clearHighlightedSignals();
                }
                Set highSet = which.getHighlightedNetworks();
                if (highSet.size() != 1 || (loc = new Locator(wnd, ww)).getWaveformWindow() != ww) continue;
                Network net = (Network)highSet.iterator().next();
                String netName = WaveformWindow.getSpiceNetName(loc.getContext(), net);
                Signal sSig = ww.sd.findSignalForNetwork(netName);
                if (sSig == null) {
                    netName = netName.replace('@', '_');
                    sSig = ww.sd.findSignalForNetwork(netName);
                    if (sSig == null) {
                        return;
                    }
                }
                boolean foundSignal = false;
                Iterator it2 = ww.wavePanels.iterator();
                while (it2.hasNext()) {
                    Panel wp = (Panel)it2.next();
                    Iterator sIt = wp.waveSignals.values().iterator();
                    while (sIt.hasNext()) {
                        WaveSignal ws = (WaveSignal)sIt.next();
                        if (ws.sSig != sSig) continue;
                        wp.addHighlightedSignal(ws);
                        foundSignal = true;
                    }
                }
                if (!foundSignal) continue;
                ww.repaint();
            }
        }

        public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        }
    }

    public static class Locator {
        private WaveformWindow ww;
        private VarContext context;

        public Locator(EditWindow wnd) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                Nodable no;
                this.ww = WaveformWindow.findWaveformWindow(cellInWindow);
                if (this.ww != null || (no = curContext.getNodable()) == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public Locator(EditWindow wnd, WaveformWindow wantWW) {
            Cell cellInWindow = wnd.getCell();
            VarContext curContext = wnd.getVarContext();
            this.ww = null;
            Stack<Nodable> contextStack = new Stack<Nodable>();
            while (true) {
                if (wantWW.getCell() == cellInWindow) {
                    this.ww = wantWW;
                    break;
                }
                Nodable no = curContext.getNodable();
                if (no == null) break;
                contextStack.push(no);
                cellInWindow = no.getParent();
                curContext = curContext.pop();
            }
            this.context = VarContext.globalContext;
            while (!contextStack.isEmpty()) {
                this.context = this.context.push((Nodable)contextStack.pop());
            }
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }

        public VarContext getContext() {
            return this.context;
        }
    }

    public static class SweepSignal {
        private Object obj;
        private WaveformWindow ww;
        private boolean included;
        private int sweepIndex;

        public SweepSignal(Object obj, WaveformWindow ww) {
            this.obj = obj;
            this.ww = ww;
            this.included = true;
            this.sweepIndex = ww.sweepSignals.size();
            ww.sweepSignals.add(this);
        }

        public String toString() {
            String name = null;
            name = this.obj instanceof Double ? TextUtils.formatDouble((Double)this.obj) : this.obj.toString();
            name = name + (this.included ? " - INCLUDED" : " - EXCLUDED");
            return name;
        }

        public void setIncluded(boolean included) {
            if (this.included == included) {
                return;
            }
            this.included = included;
            Iterator it = this.ww.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                wp.repaintWithTime();
            }
        }

        public void highlight() {
            this.ww.highlightedSweep = this.sweepIndex;
            Iterator it = this.ww.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                wp.repaintWithTime();
            }
        }

        public boolean isIncluded() {
            return this.included;
        }
    }

    public static class WaveSignal {
        private Panel wavePanel;
        private Signal sSig;
        private Color color;
        private double[] controlPointsSelected;
        private boolean highlighted;
        private JButton sigButton;

        public WaveSignal(Panel wavePanel, Signal sSig) {
            int sigNo = wavePanel.waveSignals.size();
            this.wavePanel = wavePanel;
            this.sSig = sSig;
            this.controlPointsSelected = null;
            this.highlighted = false;
            String sigName = sSig.getFullName();
            if (wavePanel.isAnalog) {
                this.color = colorArray[sigNo % colorArray.length];
                this.sigButton = new DragButton(sigName, wavePanel.panelNumber);
                this.sigButton.setBorderPainted(false);
                this.sigButton.setDefaultCapable(false);
                this.sigButton.setForeground(this.color);
                wavePanel.signalButtons.add(this.sigButton);
                wavePanel.waveSignals.put(this.sigButton, this);
                this.sigButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        WaveSignal.this.signalNameClicked(evt);
                    }
                });
                this.sigButton.addMouseListener(new SignalButton(this));
            } else {
                this.color = new Color(User.getColorWaveformStimuli());
                wavePanel.digitalSignalButton.setText(sigName);
                wavePanel.waveSignals.put(wavePanel.digitalSignalButton, this);
                this.sigButton = wavePanel.digitalSignalButton;
                this.sigButton.setForeground(this.color);
            }
        }

        public Signal getSignal() {
            return this.sSig;
        }

        public double[] getSelectedControlPoints() {
            return this.controlPointsSelected;
        }

        public boolean isSelected() {
            return this.highlighted;
        }

        private void addSelectedControlPoint(double controlTime) {
            if (this.controlPointsSelected == null) {
                this.controlPointsSelected = new double[1];
                this.controlPointsSelected[0] = controlTime;
                return;
            }
            for (int i = 0; i < this.controlPointsSelected.length; ++i) {
                if (this.controlPointsSelected[i] != controlTime) continue;
                return;
            }
            double[] newPoints = new double[this.controlPointsSelected.length + 1];
            for (int i = 0; i < this.controlPointsSelected.length; ++i) {
                newPoints[i] = this.controlPointsSelected[i];
            }
            newPoints[this.controlPointsSelected.length] = controlTime;
            this.controlPointsSelected = newPoints;
        }

        private void removeSelectedControlPoint(double controlTime) {
            if (this.controlPointsSelected == null) {
                return;
            }
            boolean found = false;
            for (int i = 0; i < this.controlPointsSelected.length; ++i) {
                if (this.controlPointsSelected[i] != controlTime) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            double[] newPoints = new double[this.controlPointsSelected.length - 1];
            int j = 0;
            for (int i = 0; i < this.controlPointsSelected.length; ++i) {
                if (this.controlPointsSelected[i] == controlTime) continue;
                newPoints[j++] = this.controlPointsSelected[i];
            }
            this.controlPointsSelected = newPoints;
        }

        private void signalNameClicked(ActionEvent evt) {
            JButton signal = (JButton)evt.getSource();
            WaveSignal ws = (WaveSignal)this.wavePanel.waveSignals.get(signal);
            if ((evt.getModifiers() & 1) == 0) {
                ws.wavePanel.clearHighlightedSignals();
                ws.wavePanel.addHighlightedSignal(ws);
                ws.wavePanel.makeSelectedPanel();
            } else if (ws.highlighted) {
                ws.wavePanel.removeHighlightedSignal(ws);
            } else {
                ws.wavePanel.addHighlightedSignal(ws);
            }
            ws.wavePanel.waveWindow.showSelectedNetworksInSchematic();
        }

        static /* synthetic */ double[] access$3902(WaveSignal x0, double[] x1) {
            x0.controlPointsSelected = x1;
            return x1;
        }

        static class ChangeSignalColorListener
        implements ActionListener {
            WaveSignal signal;
            Color col;

            ChangeSignalColorListener(WaveSignal signal, Color col) {
                this.signal = signal;
                this.col = col;
            }

            public void actionPerformed(ActionEvent evt) {
                this.signal.color = this.col;
                this.signal.sigButton.setForeground(this.col);
                this.signal.wavePanel.repaint();
            }
        }

        private static class SignalButton
        extends MouseAdapter {
            private static final int BUTTON_SIZE = 15;
            private WaveSignal signal;

            SignalButton(WaveSignal signal) {
                this.signal = signal;
            }

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    if (!this.signal.highlighted) {
                        this.signal.wavePanel.clearHighlightedSignals();
                        this.signal.wavePanel.addHighlightedSignal(this.signal);
                        this.signal.wavePanel.makeSelectedPanel();
                    }
                    JPopupMenu menu = new JPopupMenu("Color");
                    for (int i = 0; i < colorArray.length; ++i) {
                        this.addColoredButton(menu, colorArray[i]);
                    }
                    menu.show(this.signal.sigButton, e.getX(), e.getY());
                }
            }

            private void addColoredButton(JPopupMenu menu, Color color) {
                BufferedImage bi = new BufferedImage(15, 15, 1);
                for (int y = 0; y < 15; ++y) {
                    for (int x = 0; x < 15; ++x) {
                        bi.setRGB(x, y, color.getRGB());
                    }
                }
                ImageIcon redIcon = new ImageIcon(bi);
                JMenuItem menuItem = new JMenuItem(redIcon);
                menu.add(menuItem);
                menuItem.addActionListener(new ChangeSignalColorListener(this.signal, color));
            }
        }
    }

    private static class TimeTickPanel
    extends JPanel {
        Panel wavePanel;
        WaveformWindow waveWindow;

        TimeTickPanel(Panel wavePanel, WaveformWindow waveWindow) {
            this.wavePanel = wavePanel;
            this.waveWindow = waveWindow;
            Dimension sz = new Dimension(16, 20);
            this.setMinimumSize(sz);
            this.setPreferredSize(sz);
        }

        public void paint(Graphics g) {
            Dimension sz = this.getSize();
            int wid = sz.width;
            int hei = sz.height;
            int offX = 0;
            Panel drawHere = this.wavePanel;
            if (drawHere == null) {
                Point screenLoc = this.getLocationOnScreen();
                offX = this.waveWindow.screenLowX - screenLoc.x;
                int newWid = this.waveWindow.screenHighX - this.waveWindow.screenLowX;
                if (newWid == 0 || this.waveWindow.wavePanels.size() == 0) {
                    if (this.waveWindow.mainTimePanelNeedsRepaint) {
                        this.repaint();
                    }
                    return;
                }
                if (offX + newWid > wid) {
                    newWid = wid - offX;
                }
                wid = newWid;
                drawHere = (Panel)this.waveWindow.wavePanels.get(0);
                this.waveWindow.mainTimePanelNeedsRepaint = false;
                g.setClip(offX, 0, wid, hei);
            }
            g.setColor(new Color(User.getColorWaveformBackground()));
            g.fillRect(offX, 0, wid, hei);
            g.setColor(new Color(User.getColorWaveformForeground()));
            if (this.wavePanel != null) {
                g.drawLine(drawHere.vertAxisPos + offX, hei - 1, wid + offX, hei - 1);
            }
            double displayedLow = drawHere.scaleXToTime(drawHere.vertAxisPos);
            double displayedHigh = drawHere.scaleXToTime(wid);
            StepSize ss = WaveformWindow.getSensibleValues(displayedHigh, displayedLow, 10);
            if (ss.separation == 0.0) {
                return;
            }
            int lastX = -1;
            for (double time = ss.low; !(time > ss.high); time += ss.separation) {
                if (!(time >= displayedLow)) continue;
                int x = drawHere.scaleTimeToX(time) + offX;
                g.drawLine(x, 0, x, hei);
                if (lastX >= 0) {
                    if (x - lastX > 100) {
                        for (int i = 1; i < 5; ++i) {
                            int intX = (x - lastX) / 5 * i + lastX;
                            g.drawLine(intX, hei / 2, intX, hei);
                        }
                    } else if (x - lastX > 25) {
                        int intX = (x - lastX) / 2 + lastX;
                        g.drawLine(intX, hei / 2, intX, hei);
                    }
                }
                String timeVal = TextUtils.convertToEngineeringNotation(time, "s", ss.stepScale);
                g.drawString(timeVal, x + 2, hei - 2);
                lastX = x;
            }
        }
    }

    private static class WaveFormDropTarget
    implements DropTargetListener {
        private WaveFormDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(e.getDropAction());
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Object data = null;
            try {
                dtde.acceptDrop(0x40000000);
                data = dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                if (data == null) {
                    dtde.dropComplete(false);
                    return;
                }
            }
            catch (Throwable t) {
                ActivityLogger.logException(t);
                dtde.dropComplete(false);
                return;
            }
            if (!(data instanceof String)) {
                dtde.dropComplete(false);
                return;
            }
            String sigName = (String)data;
            DropTarget dt = (DropTarget)dtde.getSource();
            if (!(dt.getComponent() instanceof OnePanel)) {
                dtde.dropComplete(false);
                return;
            }
            OnePanel op = (OnePanel)dt.getComponent();
            WaveformWindow ww = op.getWaveformWindow();
            Panel panel = op.getPanel();
            if (sigName.startsWith("PANEL ")) {
                int panelNumber = TextUtils.atoi(sigName.substring(6));
                Panel sourcePanel = ww.getPanelFromNumber(panelNumber);
                if (sourcePanel == panel) {
                    dtde.dropComplete(false);
                    return;
                }
                int sigPos = sigName.indexOf("BUTTON ");
                if (!panel.isAnalog) {
                    sigPos = -1;
                }
                if (sigPos < 0) {
                    ww.left.remove(sourcePanel.leftHalf);
                    ww.right.remove(sourcePanel.rightHalf);
                    int destIndex = 0;
                    Component[] lefts = ww.left.getComponents();
                    for (destIndex = 0; destIndex < lefts.length && lefts[destIndex] != panel.leftHalf; ++destIndex) {
                    }
                    ww.left.add((Component)sourcePanel.leftHalf, destIndex);
                    ww.right.add((Component)sourcePanel.rightHalf, destIndex);
                    ww.getPanel().validate();
                    dtde.dropComplete(true);
                    ww.saveSignalOrder();
                    return;
                }
                String signalName = sigName.substring(sigPos + 7);
                Signal sSig = null;
                Color oldColor = null;
                Iterator it = sourcePanel.waveSignals.values().iterator();
                while (it.hasNext()) {
                    WaveSignal ws = (WaveSignal)it.next();
                    if (!ws.sSig.getFullName().equals(signalName)) continue;
                    sSig = ws.sSig;
                    oldColor = ws.color;
                    sourcePanel.removeHighlightedSignal(ws);
                    sourcePanel.signalButtons.remove(ws.sigButton);
                    sourcePanel.waveSignals.remove(ws.sigButton);
                    break;
                }
                if (sSig != null) {
                    sourcePanel.signalButtons.validate();
                    sourcePanel.signalButtons.repaint();
                    sourcePanel.repaint();
                    WaveSignal newSig = panel.addSignalToPanel(sSig);
                    if (newSig != null) {
                        newSig.color = oldColor;
                        newSig.sigButton.setForeground(oldColor);
                    }
                }
                ww.saveSignalOrder();
                dtde.dropComplete(true);
                return;
            }
            Signal sSig = ww.findSignal(sigName);
            if (sSig == null) {
                dtde.dropComplete(false);
                return;
            }
            if (sSig instanceof DigitalSignal) {
                panel = null;
            }
            if (panel != null) {
                panel.addSignalToPanel(sSig);
                panel.waveWindow.saveSignalOrder();
                panel.makeSelectedPanel();
                dtde.dropComplete(true);
                return;
            }
            boolean isAnalog = false;
            if (sSig instanceof AnalogSignal) {
                isAnalog = true;
            }
            panel = ww.makeNewPanel(isAnalog);
            if (isAnalog) {
                AnalogSignal as = (AnalogSignal)sSig;
                Rectangle2D rangeBounds = as.getBounds();
                double lowValue = rangeBounds.getMinY();
                double highValue = rangeBounds.getMaxY();
                double range = highValue - lowValue;
                if (range == 0.0) {
                    range = 2.0;
                }
                double rangeExtra = range / 10.0;
                panel.setValueRange(lowValue - rangeExtra, highValue + rangeExtra);
            }
            WaveSignal wsig = new WaveSignal(panel, sSig);
            ww.overall.validate();
            panel.repaint();
            dtde.dropComplete(true);
        }
    }

    private static class OnePanel
    extends JPanel {
        Panel panel;
        WaveformWindow ww;

        public OnePanel(Panel panel, WaveformWindow ww) {
            this.panel = panel;
            this.ww = ww;
        }

        public Panel getPanel() {
            return this.panel;
        }

        public WaveformWindow getWaveformWindow() {
            return this.ww;
        }
    }

    private static class DragButton
    extends JButton
    implements DragGestureListener,
    DragSourceListener {
        private DragSource dragSource;
        private int panelNumber;

        public DragButton(String s, int panelNumber) {
            this.setText(s);
            this.panelNumber = panelNumber;
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            StringSelection transferable = new StringSelection("PANEL " + this.panelNumber + " BUTTON " + this.getText());
            this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    private static class DragLabel
    extends JLabel
    implements DragGestureListener,
    DragSourceListener {
        private DragSource dragSource;

        public DragLabel(String s) {
            this.setText(s);
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            StringSelection transferable = new StringSelection("PANEL " + this.getText());
            this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    public static class Panel
    extends JPanel
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private WaveformWindow waveWindow;
        private HashMap waveSignals;
        private JPanel signalButtons;
        private JScrollPane signalButtonsPane;
        private JPanel leftHalf;
        private JPanel rightHalf;
        private JButton close;
        private JButton hide;
        private JButton deleteSignal;
        private JButton deleteAllSignals;
        private JButton toggleBusSignals;
        private JButton digitalSignalButton;
        private double minTime;
        private double maxTime;
        private double analogLowValue;
        private double analogHighValue;
        private double analogRange;
        private Dimension sz;
        private boolean draggingMain;
        private boolean draggingExt;
        private boolean draggingVertAxis;
        private boolean draggingArea;
        private boolean selected;
        private boolean hidden;
        private boolean isAnalog;
        private TimeTickPanel timePanel;
        private int panelNumber;
        private HashSet measureWindows;
        private int dragStartX;
        private int dragStartY;
        private int dragEndX;
        private int dragEndY;
        private int vertAxisPos;
        private static final int VERTLABELWIDTH = 60;
        private static Color background = null;
        private static int nextPanelNumber = 1;
        private static final ImageIcon iconHidePanel = Resources.getResource(class$com$sun$electric$tool$user$ui$WaveformWindow == null ? (class$com$sun$electric$tool$user$ui$WaveformWindow = WaveformWindow.class$("com.sun.electric.tool.user.ui.WaveformWindow")) : class$com$sun$electric$tool$user$ui$WaveformWindow, "ButtonSimHide.gif");
        private static final ImageIcon iconClosePanel = Resources.getResource(class$com$sun$electric$tool$user$ui$WaveformWindow == null ? (class$com$sun$electric$tool$user$ui$WaveformWindow = WaveformWindow.class$("com.sun.electric.tool.user.ui.WaveformWindow")) : class$com$sun$electric$tool$user$ui$WaveformWindow, "ButtonSimClose.gif");
        private static final ImageIcon iconDeleteSignal = Resources.getResource(class$com$sun$electric$tool$user$ui$WaveformWindow == null ? (class$com$sun$electric$tool$user$ui$WaveformWindow = WaveformWindow.class$("com.sun.electric.tool.user.ui.WaveformWindow")) : class$com$sun$electric$tool$user$ui$WaveformWindow, "ButtonSimDelete.gif");
        private static final ImageIcon iconDeleteAllSignals = Resources.getResource(class$com$sun$electric$tool$user$ui$WaveformWindow == null ? (class$com$sun$electric$tool$user$ui$WaveformWindow = WaveformWindow.class$("com.sun.electric.tool.user.ui.WaveformWindow")) : class$com$sun$electric$tool$user$ui$WaveformWindow, "ButtonSimDeleteAll.gif");
        static long lastClick = 0L;
        private Font waveWindowFont;
        private FontRenderContext waveWindowFRC = new FontRenderContext(null, false, false);
        private Color offStrengthColor;
        private Color nodeStrengthColor;
        private Color gateStrengthColor;
        private Color powerStrengthColor;
        private static final int CONTROLPOINTSIZE = 6;

        public Panel(WaveformWindow waveWindow, boolean isAnalog) {
            this.waveWindow = waveWindow;
            this.isAnalog = isAnalog;
            this.selected = false;
            this.panelNumber = nextPanelNumber++;
            this.vertAxisPos = 60;
            int height = panelSizeDigital;
            if (isAnalog) {
                height = panelSizeAnalog;
            }
            this.sz = new Dimension(50, height);
            this.setSize(this.sz.width, this.sz.height);
            this.setPreferredSize(this.sz);
            this.setLayout(new FlowLayout());
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.waveSignals = new HashMap();
            this.setTimeRange(waveWindow.minTime, waveWindow.maxTime);
            this.leftHalf = new OnePanel(this, waveWindow);
            this.leftHalf.setLayout(new GridBagLayout());
            DropTarget dropTargetLeft = new DropTarget(this.leftHalf, 0x40000000, waveformDropTarget, true);
            JSeparator sep = new JSeparator(0);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 0, 4, 0);
            this.leftHalf.add((Component)sep, gbc);
            if (isAnalog) {
                DragLabel label = new DragLabel(Integer.toString(this.panelNumber));
                label.setToolTipText("Identification number of this waveform panel");
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.2;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = new Insets(4, 4, 4, 4);
                this.leftHalf.add((Component)label, gbc);
            } else {
                this.digitalSignalButton = new DragButton(Integer.toString(this.panelNumber), this.panelNumber);
                this.digitalSignalButton.setBorderPainted(false);
                this.digitalSignalButton.setForeground(Color.BLACK);
                this.digitalSignalButton.setToolTipText("Name of this waveform panel");
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 10;
                gbc.fill = 0;
                gbc.insets = new Insets(0, 4, 0, 4);
                this.leftHalf.add((Component)this.digitalSignalButton, gbc);
                this.digitalSignalButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Panel.this.digitalSignalNameClicked(evt);
                    }
                });
            }
            this.close = new JButton(iconClosePanel);
            this.close.setBorderPainted(false);
            this.close.setDefaultCapable(false);
            this.close.setToolTipText("Close this waveform panel");
            Dimension minWid = new Dimension(iconClosePanel.getIconWidth() + 4, iconClosePanel.getIconHeight() + 4);
            this.close.setMinimumSize(minWid);
            this.close.setPreferredSize(minWid);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = isAnalog ? 11 : 10;
            gbc.fill = 0;
            this.leftHalf.add((Component)this.close, gbc);
            this.close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Panel.this.closePanel();
                }
            });
            this.hide = new JButton(iconHidePanel);
            this.hide.setBorderPainted(false);
            this.hide.setDefaultCapable(false);
            this.hide.setToolTipText("Hide this waveform panel");
            minWid = new Dimension(iconHidePanel.getIconWidth() + 4, iconHidePanel.getIconHeight() + 4);
            this.hide.setMinimumSize(minWid);
            this.hide.setPreferredSize(minWid);
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = isAnalog ? 11 : 10;
            gbc.fill = 0;
            this.leftHalf.add((Component)this.hide, gbc);
            this.hide.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Panel.this.hidePanel();
                }
            });
            if (isAnalog) {
                this.deleteSignal = new JButton(iconDeleteSignal);
                this.deleteSignal.setBorderPainted(false);
                this.deleteSignal.setDefaultCapable(false);
                this.deleteSignal.setToolTipText("Remove selected signals from waveform panel");
                minWid = new Dimension(iconDeleteSignal.getIconWidth() + 4, iconDeleteSignal.getIconHeight() + 4);
                this.deleteSignal.setMinimumSize(minWid);
                this.deleteSignal.setPreferredSize(minWid);
                gbc.gridx = 3;
                gbc.gridy = 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.2;
                gbc.weighty = 0.0;
                gbc.anchor = 11;
                gbc.fill = 0;
                this.leftHalf.add((Component)this.deleteSignal, gbc);
                this.deleteSignal.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Panel.this.deleteSignalFromPanel();
                    }
                });
                this.deleteAllSignals = new JButton(iconDeleteAllSignals);
                this.deleteAllSignals.setBorderPainted(false);
                this.deleteAllSignals.setDefaultCapable(false);
                this.deleteAllSignals.setToolTipText("Remove all signals from waveform panel");
                minWid = new Dimension(iconDeleteAllSignals.getIconWidth() + 4, iconDeleteAllSignals.getIconHeight() + 4);
                this.deleteAllSignals.setMinimumSize(minWid);
                this.deleteAllSignals.setPreferredSize(minWid);
                gbc.gridx = 4;
                gbc.gridy = 1;
                gbc.gridwidth = 1;
                gbc.gridheight = 1;
                gbc.weightx = 0.2;
                gbc.weighty = 0.0;
                gbc.anchor = 11;
                gbc.fill = 0;
                this.leftHalf.add((Component)this.deleteAllSignals, gbc);
                this.deleteAllSignals.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Panel.this.deleteAllSignalsFromPanel();
                    }
                });
            }
            if (isAnalog) {
                this.signalButtons = new JPanel();
                this.signalButtons.setLayout(new BoxLayout(this.signalButtons, 1));
                this.signalButtonsPane = new JScrollPane(this.signalButtons);
                this.signalButtonsPane.setPreferredSize(new Dimension(100, height));
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.gridwidth = 5;
                gbc.gridheight = 1;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 10;
                gbc.fill = 1;
                gbc.insets = new Insets(0, 0, 0, 0);
                this.leftHalf.add((Component)this.signalButtonsPane, gbc);
            }
            this.rightHalf = new OnePanel(this, waveWindow);
            this.rightHalf.setLayout(new GridBagLayout());
            DropTarget dropTargetRight = new DropTarget(this.rightHalf, 0x40000000, waveformDropTarget, true);
            sep = new JSeparator(0);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 0, 4, 0);
            this.rightHalf.add((Component)sep, gbc);
            if (!waveWindow.timeLocked) {
                this.addTimePanel();
            }
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.rightHalf.add((Component)this, gbc);
            waveWindow.left.add(this.leftHalf);
            waveWindow.right.add(this.rightHalf);
            waveWindow.wavePanels.add(this);
            if (waveWindow.wavePanels.size() == 1 && waveWindow.mainTimePanel != null) {
                waveWindow.mainTimePanel.repaint();
                waveWindow.mainTimePanelNeedsRepaint = true;
            }
            waveWindow.rebuildPanelList();
            waveWindow.redrawAllPanels();
        }

        public List getSignals() {
            ArrayList<WaveSignal> signals = new ArrayList<WaveSignal>();
            Iterator it = this.waveSignals.keySet().iterator();
            while (it.hasNext()) {
                JButton but = (JButton)it.next();
                WaveSignal ws = (WaveSignal)this.waveSignals.get(but);
                signals.add(ws);
            }
            return signals;
        }

        private void digitalSignalNameClicked(ActionEvent evt) {
            long delay = evt.getWhen() - lastClick;
            lastClick = evt.getWhen();
            if (delay < (long)TopLevel.getDoubleClickSpeed()) {
                this.toggleBusContents();
                return;
            }
            Set set = this.waveSignals.keySet();
            if (set.size() == 0) {
                return;
            }
            JButton but = (JButton)set.iterator().next();
            WaveSignal ws = (WaveSignal)this.waveSignals.get(but);
            if ((evt.getModifiers() & 1) == 0) {
                Iterator it = this.waveWindow.wavePanels.iterator();
                while (it.hasNext()) {
                    Panel wp = (Panel)it.next();
                    wp.clearHighlightedSignals();
                }
                this.addHighlightedSignal(ws);
                this.makeSelectedPanel();
            } else if (ws.highlighted) {
                this.removeHighlightedSignal(ws);
            } else {
                this.addHighlightedSignal(ws);
            }
            this.waveWindow.showSelectedNetworksInSchematic();
        }

        private void addTimePanel() {
            this.timePanel = new TimeTickPanel(this, this.waveWindow);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.rightHalf.add((Component)this.timePanel, gbc);
        }

        private void removeTimePanel() {
            this.rightHalf.remove(this.timePanel);
            this.timePanel = null;
        }

        public void hidePanel() {
            this.waveWindow.hidePanel(this);
        }

        public void closePanel() {
            this.waveWindow.closePanel(this);
            this.waveWindow.saveSignalOrder();
        }

        private WaveSignal addSignalToPanel(Signal sSig) {
            Iterator it = this.waveSignals.keySet().iterator();
            while (it.hasNext()) {
                int index;
                JButton but = (JButton)it.next();
                WaveSignal ws = (WaveSignal)this.waveSignals.get(but);
                if (ws.sSig != sSig) continue;
                Color color = ws.color;
                for (index = 0; index < colorArray.length; ++index) {
                    if (!color.equals(colorArray[index])) continue;
                    ++index;
                    break;
                }
                if (index >= colorArray.length) {
                    index = 0;
                }
                ws.color = colorArray[index];
                but.setForeground(colorArray[index]);
                this.signalButtons.repaint();
                this.repaint();
                return null;
            }
            int sigNo = this.waveSignals.size();
            WaveSignal wsig = new WaveSignal(this, sSig);
            wsig.color = colorArray[sigNo % colorArray.length];
            this.signalButtons.validate();
            this.signalButtons.repaint();
            if (this.signalButtonsPane != null) {
                this.signalButtonsPane.validate();
            }
            this.repaint();
            return wsig;
        }

        private void deleteSignalFromPanel() {
            this.waveWindow.deleteSignalFromPanel(this);
        }

        private void deleteAllSignalsFromPanel() {
            this.waveWindow.deleteAllSignalsFromPanel(this);
        }

        private void toggleBusContents() {
            DigitalSignal subDS;
            Iterator bIt;
            Collection theSignals = this.waveSignals.values();
            if (theSignals.size() != 1) {
                return;
            }
            WaveSignal ws = (WaveSignal)theSignals.iterator().next();
            if (!(ws.sSig instanceof DigitalSignal)) {
                return;
            }
            DigitalSignal sDSig = (DigitalSignal)ws.sSig;
            List bussedSignals = sDSig.getBussedSignals();
            if (bussedSignals == null) {
                return;
            }
            boolean opened = false;
            Iterator bIt2 = bussedSignals.iterator();
            while (bIt2.hasNext()) {
                DigitalSignal subDS2 = (DigitalSignal)bIt2.next();
                WaveSignal subWs = this.waveWindow.findDisplayedSignal(subDS2);
                if (subWs == null) continue;
                opened = true;
                break;
            }
            if (opened) {
                ArrayList allPanels = new ArrayList();
                Iterator it = this.waveWindow.wavePanels.iterator();
                while (it.hasNext()) {
                    allPanels.add(it.next());
                }
                bIt = bussedSignals.iterator();
                while (bIt.hasNext()) {
                    subDS = (DigitalSignal)bIt.next();
                    WaveSignal subWs = this.waveWindow.findDisplayedSignal(subDS);
                    if (subWs == null) continue;
                    Panel wp = subWs.wavePanel;
                    this.waveWindow.closePanel(wp);
                    allPanels.remove(wp);
                }
            } else {
                int increment = 1;
                bIt = bussedSignals.iterator();
                while (bIt.hasNext()) {
                    int destIndex;
                    subDS = (DigitalSignal)bIt.next();
                    Panel wp = this.waveWindow.makeNewPanel(false);
                    WaveSignal wsig = new WaveSignal(wp, subDS);
                    this.waveWindow.left.remove(((WaveSignal)wsig).wavePanel.leftHalf);
                    this.waveWindow.right.remove(((WaveSignal)wsig).wavePanel.rightHalf);
                    Component[] lefts = this.waveWindow.left.getComponents();
                    for (destIndex = 0; destIndex < lefts.length && lefts[destIndex] != this.leftHalf; ++destIndex) {
                    }
                    this.waveWindow.left.add((Component)((WaveSignal)wsig).wavePanel.leftHalf, destIndex + increment);
                    this.waveWindow.right.add((Component)((WaveSignal)wsig).wavePanel.rightHalf, destIndex + increment);
                    ++increment;
                }
            }
            this.waveWindow.overall.validate();
            this.waveWindow.saveSignalOrder();
        }

        public void setTimeRange(double minTime, double maxTime) {
            this.minTime = minTime;
            this.maxTime = maxTime;
        }

        public double getMinTimeRange() {
            return this.minTime;
        }

        public double getMaxTimeRange() {
            return this.maxTime;
        }

        public void setValueRange(double low, double high) {
            if (low == high) {
                low -= 0.5;
                high += 0.5;
            }
            this.analogLowValue = low;
            this.analogHighValue = high;
            this.analogRange = this.analogHighValue - this.analogLowValue;
        }

        public void finished() {
            this.removeKeyListener(this);
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeMouseWheelListener(this);
        }

        public void repaintWithTime() {
            if (this.timePanel != null) {
                this.timePanel.repaint();
            } else {
                this.waveWindow.mainTimePanel.repaint();
            }
            this.repaint();
        }

        public void paint(Graphics g) {
            Graphics2D g2;
            if (this.waveWindow.wf == WindowFrame.getCurrentWindowFrame()) {
                this.requestFocus();
            }
            this.sz = this.getSize();
            int wid = this.sz.width;
            int hei = this.sz.height;
            Point screenLoc = this.getLocationOnScreen();
            if (this.waveWindow.screenLowX != screenLoc.x || this.waveWindow.screenHighX - this.waveWindow.screenLowX != wid) {
                this.waveWindow.mainTimePanelNeedsRepaint = true;
            }
            this.waveWindow.screenLowX = screenLoc.x;
            this.waveWindow.screenHighX = this.waveWindow.screenLowX + wid;
            g.setColor(new Color(User.getColorWaveformBackground()));
            g.fillRect(0, 0, wid, hei);
            this.waveWindowFont = new Font(User.getDefaultFont(), 0, 12);
            if (this.isAnalog && this.waveWindow.showGrid) {
                g2 = (Graphics2D)g;
                g2.setStroke(Highlight.dottedLine);
                g.setColor(gridColor);
                double displayedXLow = this.scaleXToTime(this.vertAxisPos);
                double displayedXHigh = this.scaleXToTime(wid);
                StepSize ss = WaveformWindow.getSensibleValues(displayedXHigh, displayedXLow, 10);
                if (ss.separation != 0.0) {
                    double time = ss.low;
                    while (true) {
                        if (time >= displayedXLow) {
                            if (time > ss.high) break;
                            int x = this.scaleTimeToX(time);
                            g.drawLine(x, 0, x, hei);
                        }
                        time += ss.separation;
                    }
                }
                double displayedLow = this.scaleYToValue(hei);
                double displayedHigh = this.scaleYToValue(0);
                double lowYData = 0.0;
                double highYData = 0.0;
                boolean first = true;
                Iterator it = this.waveSignals.values().iterator();
                while (it.hasNext()) {
                    WaveSignal ws = (WaveSignal)it.next();
                    if (!(ws.sSig instanceof AnalogSignal)) continue;
                    Rectangle2D bounds = ws.sSig.getBounds();
                    if (first) {
                        lowYData = bounds.getMinY();
                        highYData = bounds.getMaxY();
                        first = false;
                        continue;
                    }
                    if (bounds.getMinY() < lowYData) {
                        lowYData = bounds.getMinY();
                    }
                    if (!(bounds.getMaxY() > highYData)) continue;
                    highYData = bounds.getMaxY();
                }
                ss.separation = (highYData - lowYData) / 5.0;
                ss.low = (highYData - lowYData) / 10.0 + lowYData;
                ss.high = highYData - (highYData - lowYData) / 10.0;
                if (ss.separation != 0.0) {
                    double value = ss.low;
                    while (true) {
                        if (value >= displayedLow) {
                            if (value > displayedHigh || value > ss.high) break;
                            int y = this.scaleValueToY(value);
                            g.drawLine(this.vertAxisPos, y, wid, y);
                        }
                        value += ss.separation;
                    }
                }
                g2.setStroke(Highlight.solidLine);
            }
            this.offStrengthColor = new Color(User.getColorWaveformStrengthOff());
            this.nodeStrengthColor = new Color(User.getColorWaveformStrengthNode());
            this.gateStrengthColor = new Color(User.getColorWaveformStrengthGate());
            this.powerStrengthColor = new Color(User.getColorWaveformStrengthPower());
            this.processSignals(g, null);
            this.processControlPoints(g, null);
            g.setColor(new Color(User.getColorWaveformForeground()));
            g.drawLine(this.vertAxisPos, 0, this.vertAxisPos, hei);
            if (this.selected) {
                g.drawLine(this.vertAxisPos - 1, 0, this.vertAxisPos - 1, hei);
                g.drawLine(this.vertAxisPos - 2, 0, this.vertAxisPos - 2, hei - 1);
                g.drawLine(this.vertAxisPos - 3, 0, this.vertAxisPos - 3, hei - 2);
            }
            if (this.isAnalog) {
                double displayedLow = this.scaleYToValue(hei);
                double displayedHigh = this.scaleYToValue(0);
                StepSize ss = WaveformWindow.getSensibleValues(displayedHigh, displayedLow, 5);
                if (ss.separation != 0.0) {
                    double value = ss.low;
                    g.setFont(this.waveWindowFont);
                    Graphics2D g22 = (Graphics2D)g;
                    int lastY = -1;
                    int i = 0;
                    while (!(value > displayedHigh)) {
                        if (value >= displayedLow) {
                            int y = this.scaleValueToY(value);
                            if (lastY >= 0) {
                                if (lastY - y > 100) {
                                    for (int j = 1; j < 5; ++j) {
                                        int intY = (lastY - y) / 5 * j + y;
                                        g.drawLine(this.vertAxisPos - 5, intY, this.vertAxisPos, intY);
                                    }
                                } else if (lastY - y > 25) {
                                    int intY = (lastY - y) / 2 + y;
                                    g.drawLine(this.vertAxisPos - 5, intY, this.vertAxisPos, intY);
                                }
                            }
                            g.drawLine(this.vertAxisPos - 10, y, this.vertAxisPos, y);
                            String yValue = WaveformWindow.prettyPrint(value, ss.rangeScale, ss.stepScale);
                            GlyphVector gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, yValue);
                            Rectangle2D glyphBounds = gv.getLogicalBounds();
                            int height = (int)glyphBounds.getHeight();
                            int yPos = y + height / 2;
                            if (yPos - height <= 0) {
                                yPos = height + 1;
                            }
                            if (yPos >= hei) {
                                yPos = hei;
                            }
                            g.drawString(yValue, this.vertAxisPos - 10 - (int)glyphBounds.getWidth() - 2, yPos);
                            lastY = y;
                        }
                        value += ss.separation;
                        ++i;
                    }
                }
            }
            g2 = (Graphics2D)g;
            g2.setStroke(Highlight.dashedLine);
            int x = this.scaleTimeToX(this.waveWindow.mainTime);
            if (x >= this.vertAxisPos) {
                g.drawLine(x, 0, x, hei);
            }
            g2.setStroke(farDottedLine);
            x = this.scaleTimeToX(this.waveWindow.extTime);
            if (x >= this.vertAxisPos) {
                g.drawLine(x, 0, x, hei);
            }
            g2.setStroke(Highlight.solidLine);
            if (this.draggingArea) {
                g.setColor(new Color(User.getColorWaveformForeground()));
                int lowX = Math.min(this.dragStartX, this.dragEndX);
                int highX = Math.max(this.dragStartX, this.dragEndX);
                int lowY = Math.min(this.dragStartY, this.dragEndY);
                int highY = Math.max(this.dragStartY, this.dragEndY);
                g.drawLine(lowX, lowY, lowX, highY);
                g.drawLine(lowX, highY, highX, highY);
                g.drawLine(highX, highY, highX, lowY);
                g.drawLine(highX, lowY, lowX, lowY);
                if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
                    int xCtr;
                    int yPos;
                    int yPosText;
                    double lowTime = this.scaleXToTime(lowX);
                    double highTime = this.scaleXToTime(highX);
                    double lowValue = this.scaleYToValue(highY);
                    double highValue = this.scaleYToValue(lowY);
                    g.setFont(this.waveWindowFont);
                    String lowTimeString = TextUtils.convertToEngineeringNotation(lowTime, "s");
                    GlyphVector gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, lowTimeString);
                    Rectangle2D glyphBounds = gv.getLogicalBounds();
                    int textWid = (int)glyphBounds.getWidth();
                    int textHei = (int)glyphBounds.getHeight();
                    int textY = (lowY + highY) / 2;
                    g.drawString(lowTimeString, lowX - textWid - 6, textY + textHei / 2 - 10);
                    g.drawLine(lowX - 1, textY, lowX - textWid, textY);
                    g.drawLine(lowX - 1, textY, lowX - 6, textY + 4);
                    g.drawLine(lowX - 1, textY, lowX - 6, textY - 4);
                    String highTimeString = TextUtils.convertToEngineeringNotation(highTime, "s");
                    gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, highTimeString);
                    glyphBounds = gv.getLogicalBounds();
                    textWid = (int)glyphBounds.getWidth();
                    textHei = (int)glyphBounds.getHeight();
                    int highTimeTextWid = textWid;
                    g.drawString(highTimeString, highX + 6, textY + textHei / 2 - 10);
                    g.drawLine(highX + 1, textY, highX + textWid, textY);
                    g.drawLine(highX + 1, textY, highX + 6, textY + 4);
                    g.drawLine(highX + 1, textY, highX + 6, textY - 4);
                    String timeDiffString = TextUtils.convertToEngineeringNotation(highTime - lowTime, "s");
                    gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, timeDiffString);
                    glyphBounds = gv.getLogicalBounds();
                    textWid = (int)glyphBounds.getWidth();
                    textHei = (int)glyphBounds.getHeight();
                    if (textWid + 24 < highX - lowX) {
                        yPosText = highY + textHei * 5;
                        yPos = yPosText - textHei / 2;
                        xCtr = (highX + lowX) / 2;
                        g.drawString(timeDiffString, xCtr - textWid / 2, yPosText);
                        g.drawLine(lowX, yPos, xCtr - textWid / 2 - 2, yPos);
                        g.drawLine(highX, yPos, xCtr + textWid / 2 + 2, yPos);
                        g.drawLine(lowX, yPos, lowX + 5, yPos + 4);
                        g.drawLine(lowX, yPos, lowX + 5, yPos - 4);
                        g.drawLine(highX, yPos, highX - 5, yPos + 4);
                        g.drawLine(highX, yPos, highX - 5, yPos - 4);
                    } else {
                        yPosText = highY + textHei * 5;
                        yPos = yPosText - textHei / 2;
                        xCtr = (highX + lowX) / 2;
                        g.drawString(timeDiffString, highX + 12, yPosText);
                        g.drawLine(lowX, yPos, lowX - 10, yPos);
                        g.drawLine(highX, yPos, highX + 10, yPos);
                        g.drawLine(lowX, yPos, lowX - 5, yPos + 4);
                        g.drawLine(lowX, yPos, lowX - 5, yPos - 4);
                        g.drawLine(highX, yPos, highX + 5, yPos + 4);
                        g.drawLine(highX, yPos, highX + 5, yPos - 4);
                    }
                    if (this.isAnalog) {
                        String lowValueString = TextUtils.formatDouble(highValue);
                        gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, lowValueString);
                        glyphBounds = gv.getLogicalBounds();
                        textWid = (int)glyphBounds.getWidth();
                        textHei = (int)glyphBounds.getHeight();
                        int xP = (lowX + highX) / 2;
                        int yText = lowY - 10 - textHei;
                        g.drawString(lowValueString, xP, yText - 2);
                        g.drawLine(xP, lowY - 1, xP, yText);
                        g.drawLine(xP, lowY - 1, xP + 4, lowY - 5);
                        g.drawLine(xP, lowY - 1, xP - 4, lowY - 5);
                        String highValueString = TextUtils.formatDouble(lowValue);
                        gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, highValueString);
                        glyphBounds = gv.getLogicalBounds();
                        textWid = (int)glyphBounds.getWidth();
                        textHei = (int)glyphBounds.getHeight();
                        yText = highY + 10 + textHei;
                        g.drawString(highValueString, xP, yText + textHei + 2);
                        g.drawLine(xP, highY + 1, xP, yText);
                        g.drawLine(xP, highY + 1, xP + 4, highY + 5);
                        g.drawLine(xP, highY + 1, xP - 4, highY + 5);
                        String valueDiffString = TextUtils.formatDouble(highValue - lowValue);
                        gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, valueDiffString);
                        glyphBounds = gv.getLogicalBounds();
                        textWid = (int)glyphBounds.getWidth();
                        textHei = (int)glyphBounds.getHeight();
                        if (textHei + 12 < highY - lowY) {
                            int xPos = highX + highTimeTextWid + 30;
                            int yCtr = (highY + lowY) / 2;
                            g.drawString(valueDiffString, xPos + 2, yCtr + textHei / 2);
                            g.drawLine(xPos, lowY, xPos, highY);
                            g.drawLine(xPos, lowY, xPos + 4, lowY + 5);
                            g.drawLine(xPos, lowY, xPos - 4, lowY + 5);
                            g.drawLine(xPos, highY, xPos + 4, highY - 5);
                            g.drawLine(xPos, highY, xPos - 4, highY - 5);
                        } else {
                            int xPos = highX + highTimeTextWid + 30;
                            int yCtr = (highY + lowY) / 2;
                            g.drawString(valueDiffString, xPos + 4, lowY - textHei / 2 - 4);
                            g.drawLine(xPos, lowY, xPos, lowY - 10);
                            g.drawLine(xPos, highY, xPos, highY + 10);
                            g.drawLine(xPos, lowY, xPos + 4, lowY - 5);
                            g.drawLine(xPos, lowY, xPos - 4, lowY - 5);
                            g.drawLine(xPos, highY, xPos + 4, highY + 5);
                            g.drawLine(xPos, highY, xPos - 4, highY + 5);
                        }
                    }
                }
            }
        }

        private List processSignals(Graphics g, Rectangle2D bounds) {
            ArrayList selectedObjects = null;
            if (bounds != null) {
                selectedObjects = new ArrayList();
            }
            this.sz = this.getSize();
            int wid = this.sz.width;
            int hei = this.sz.height;
            Iterator it = this.waveSignals.values().iterator();
            block17: while (it.hasNext()) {
                int x;
                int i;
                WaveSignal ws = (WaveSignal)it.next();
                if (g != null) {
                    g.setColor(ws.color);
                }
                if (ws.sSig instanceof AnalogSignal) {
                    int lastX;
                    AnalogSignal as = (AnalogSignal)ws.sSig;
                    int numEvents = as.getNumEvents();
                    if (as.isBasic()) {
                        lastX = 0;
                        int lastY = 0;
                        for (int i2 = 0; i2 < numEvents; ++i2) {
                            double time = ws.sSig.getTime(i2);
                            int x2 = this.scaleTimeToX(time);
                            int y = this.scaleValueToY(as.getValue(i2));
                            if (i2 != 0 && (this.processALine(g, lastX, lastY, x2, y, bounds, selectedObjects, ws, -1) || this.waveWindow.showVertexPoints && i2 < numEvents - 1 && this.processABox(g, x2 - 2, y - 2, x2 + 2, y + 2, bounds, selectedObjects, ws, false, 0.0))) continue block17;
                            lastX = x2;
                            lastY = y;
                        }
                        continue;
                    }
                    if (as.isSweep()) {
                        List sweepSignals = this.waveWindow.sweepSignals;
                        block19: for (int s = 0; s < as.getNumSweeps(); ++s) {
                            SweepSignal ss = (SweepSignal)sweepSignals.get(s);
                            if (ss != null && !ss.included) continue;
                            int lastX2 = 0;
                            int lastY = 0;
                            numEvents = as.getNumEvents(s);
                            for (i = 0; i < numEvents; ++i) {
                                double time = ws.sSig.getTime(i, s);
                                x = this.scaleTimeToX(time);
                                int y = this.scaleValueToY(as.getSweepValue(s, i));
                                if (i != 0 && (this.processALine(g, lastX2, lastY, x, y, bounds, selectedObjects, ws, s) || this.waveWindow.showVertexPoints && i < numEvents - 1 && this.processABox(g, x - 2, y - 2, x + 2, y + 2, bounds, selectedObjects, ws, false, 0.0))) continue block19;
                                lastX2 = x;
                                lastY = y;
                            }
                        }
                        continue;
                    }
                    if (!as.isInterval()) continue;
                    lastX = 0;
                    int lastLY = 0;
                    int lastHY = 0;
                    for (int i3 = 0; i3 < numEvents; ++i3) {
                        double time = ws.sSig.getTime(i3);
                        int x3 = this.scaleTimeToX(time);
                        int lowY = this.scaleValueToY(as.getIntervalLowValue(i3));
                        int highY = this.scaleValueToY(as.getIntervalHighValue(i3));
                        if (i3 != 0 && (this.processALine(g, lastX, lastLY, x3, lowY, bounds, selectedObjects, ws, -1) || this.processALine(g, lastX, lastHY, x3, highY, bounds, selectedObjects, ws, -1) || this.processALine(g, lastX, lastHY, x3, lowY, bounds, selectedObjects, ws, -1) || this.processALine(g, lastX, lastLY, x3, highY, bounds, selectedObjects, ws, -1))) continue block17;
                        lastX = x3;
                        lastLY = lowY;
                        lastHY = highY;
                    }
                    continue;
                }
                if (!(ws.sSig instanceof DigitalSignal)) continue;
                DigitalSignal ds = (DigitalSignal)ws.sSig;
                List bussedSignals = ds.getBussedSignals();
                if (bussedSignals != null) {
                    double nextTime;
                    int busWidth = bussedSignals.size();
                    long curValue = 0L;
                    double curTime = 0.0;
                    int lastX = this.vertAxisPos;
                    do {
                        int x4;
                        nextTime = Double.MAX_VALUE;
                        int bit = 0;
                        boolean curDefined = true;
                        Iterator bIt = bussedSignals.iterator();
                        while (bIt.hasNext()) {
                            DigitalSignal subDS = (DigitalSignal)bIt.next();
                            int numEvents = subDS.getNumEvents();
                            boolean undefined = false;
                            for (int i4 = 0; i4 < numEvents; ++i4) {
                                double time = subDS.getTime(i4);
                                if (time <= curTime) {
                                    switch (subDS.getState(i4) & 3) {
                                        case 0: {
                                            curValue &= (long)(~(1 << bit));
                                            undefined = false;
                                            break;
                                        }
                                        case 2: {
                                            curValue |= (long)(1 << bit);
                                            undefined = false;
                                            break;
                                        }
                                        case 1: 
                                        case 3: {
                                            undefined = true;
                                        }
                                    }
                                    continue;
                                }
                                if (!(time < nextTime)) break;
                                nextTime = time;
                                break;
                            }
                            if (undefined) {
                                curDefined = false;
                                break;
                            }
                            ++bit;
                        }
                        if ((x4 = this.scaleTimeToX(curTime)) >= this.vertAxisPos) {
                            if (x4 < this.vertAxisPos + 5) {
                                if (this.processALine(g, x4, hei / 2, x4 + 5, hei - 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                                if (this.processALine(g, x4, hei / 2, x4 + 5, 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                            } else {
                                if (this.processALine(g, x4 - 5, 5, x4 + 5, hei - 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                                if (this.processALine(g, x4 + 5, 5, x4 - 5, hei - 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                            }
                            if (lastX + 5 < x4 - 5) {
                                if (this.processALine(g, lastX + 5, 5, x4 - 5, 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                                if (this.processALine(g, lastX + 5, hei - 5, x4 - 5, hei - 5, bounds, selectedObjects, ws, -1)) {
                                    return selectedObjects;
                                }
                            }
                            if (g != null) {
                                String valString = "XX";
                                if (curDefined) {
                                    valString = Long.toString(curValue);
                                }
                                g.setFont(this.waveWindowFont);
                                GlyphVector gv = this.waveWindowFont.createGlyphVector(this.waveWindowFRC, valString);
                                Rectangle2D glyphBounds = gv.getLogicalBounds();
                                int textHei = (int)glyphBounds.getHeight();
                                g.drawString(valString, x4 + 2, hei / 2 + textHei / 2);
                            }
                        }
                        curTime = nextTime;
                        lastX = x4;
                    } while (nextTime != Double.MAX_VALUE);
                    if (lastX + 5 >= wid) continue;
                    if (this.processALine(g, lastX + 5, 5, wid, 5, bounds, selectedObjects, ws, -1)) {
                        return selectedObjects;
                    }
                    if (!this.processALine(g, lastX + 5, hei - 5, wid, hei - 5, bounds, selectedObjects, ws, -1)) continue;
                    return selectedObjects;
                }
                int lastx = this.vertAxisPos;
                int lastState = 0;
                if (ds.getStateVector() == null) continue;
                int numEvents = ds.getNumEvents();
                int lastLowy = 0;
                int lastHighy = 0;
                for (i = 0; i < numEvents; ++i) {
                    double time = ds.getTime(i);
                    x = this.scaleTimeToX(time);
                    if (Simulation.isWaveformDisplayMultiState() && g != null) {
                        switch (ds.getState(i) & 0xC) {
                            case 0: {
                                g.setColor(this.offStrengthColor);
                                break;
                            }
                            case 4: {
                                g.setColor(this.nodeStrengthColor);
                                break;
                            }
                            case 8: {
                                g.setColor(this.gateStrengthColor);
                                break;
                            }
                            case 12: {
                                g.setColor(this.powerStrengthColor);
                            }
                        }
                    }
                    int state = ds.getState(i) & 3;
                    int lowy = 0;
                    int highy = 0;
                    switch (state) {
                        case 2: {
                            highy = 5;
                            lowy = 5;
                            break;
                        }
                        case 0: {
                            lowy = highy = hei - 5;
                            break;
                        }
                        case 1: {
                            lowy = 5;
                            highy = hei - 5;
                            break;
                        }
                        case 3: {
                            lowy = 5;
                            highy = hei - 5;
                        }
                    }
                    if (i != 0 && state != lastState && this.processALine(g, x, 5, x, hei - 5, bounds, selectedObjects, ws, -1)) {
                        return selectedObjects;
                    }
                    if (lastLowy == lastHighy ? this.processALine(g, lastx, lastLowy, x, lastLowy, bounds, selectedObjects, ws, -1) : this.processABox(g, lastx, lastLowy, x, lastHighy, bounds, selectedObjects, ws, false, 0.0)) {
                        return selectedObjects;
                    }
                    if (i >= numEvents - 1 && (lowy == highy ? this.processALine(g, x, lowy, wid - 1, lowy, bounds, selectedObjects, ws, -1) : this.processABox(g, x, lowy, wid - 1, highy, bounds, selectedObjects, ws, false, 0.0))) {
                        return selectedObjects;
                    }
                    lastx = x;
                    lastLowy = lowy;
                    lastHighy = highy;
                    lastState = state;
                }
            }
            return selectedObjects;
        }

        private List processControlPoints(Graphics g, Rectangle2D bounds) {
            ArrayList selectedObjects = null;
            if (bounds != null) {
                selectedObjects = new ArrayList();
            }
            this.sz = this.getSize();
            int wid = this.sz.width;
            int hei = this.sz.height;
            Iterator it = this.waveSignals.values().iterator();
            block0: while (it.hasNext()) {
                double time;
                int x;
                double[] points;
                WaveSignal ws = (WaveSignal)it.next();
                if (g != null) {
                    g.setColor(ws.color);
                }
                if ((points = ws.sSig.getControlPoints()) == null) continue;
                if (g != null) {
                    g.setColor(ws.color);
                }
                for (int i = 0; i < points.length && !this.processABox(g, (x = this.scaleTimeToX(time = points[i])) - 6, hei - 12, x + 6, hei, bounds, selectedObjects, ws, true, time); ++i) {
                    boolean found = false;
                    if (bounds == null && ws.controlPointsSelected != null) {
                        for (int j = 0; j < ws.controlPointsSelected.length; ++j) {
                            if (ws.controlPointsSelected[j] != time) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) continue;
                    g.setColor(Color.GREEN);
                    if (this.processABox(g, x - 6 + 2, hei - 12 + 2, x + 6 - 2, hei - 2, bounds, selectedObjects, ws, true, time)) continue block0;
                    g.setColor(ws.color);
                }
            }
            return selectedObjects;
        }

        private boolean processABox(Graphics g, int lX, int lY, int hX, int hY, Rectangle2D bounds, List result, WaveSignal ws, boolean controlPoint, double controlTime) {
            if (bounds != null) {
                if ((double)hX > bounds.getMinX() && (double)lX < bounds.getMaxX() && (double)hY > bounds.getMinY() && (double)lY < bounds.getMaxY()) {
                    WaveSelection wSel = new WaveSelection();
                    wSel.ws = ws;
                    wSel.controlPoint = controlPoint;
                    wSel.controlTime = controlTime;
                    result.add(wSel);
                    return true;
                }
                return false;
            }
            g.fillRect(lX, lY, hX - lX, hY - lY);
            return false;
        }

        private boolean processALine(Graphics g, int fX, int fY, int tX, int tY, Rectangle2D bounds, List result, WaveSignal ws, int sweepNum) {
            if (bounds != null) {
                Point2D.Double from = new Point2D.Double(fX, fY);
                Point2D.Double to = new Point2D.Double(tX, tY);
                if (!GenMath.clipLine(from, to, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY())) {
                    WaveSelection wSel = new WaveSelection();
                    wSel.ws = ws;
                    wSel.controlPoint = false;
                    result.add(wSel);
                    return true;
                }
                return false;
            }
            if (fX < this.vertAxisPos || tX < this.vertAxisPos) {
                Point2D.Double from = new Point2D.Double(fX, fY);
                Point2D.Double to = new Point2D.Double(tX, tY);
                this.sz = this.getSize();
                if (GenMath.clipLine(from, to, (double)this.vertAxisPos, (double)this.sz.width, 0.0, (double)this.sz.height)) {
                    return false;
                }
                fX = (int)((Point2D)from).getX();
                fY = (int)((Point2D)from).getY();
                tX = (int)((Point2D)to).getX();
                tY = (int)((Point2D)to).getY();
            }
            g.drawLine(fX, fY, tX, tY);
            boolean highlighted = ws.highlighted;
            if (((WaveSignal)ws).wavePanel.waveWindow.highlightedSweep >= 0) {
                boolean bl = highlighted = ((WaveSignal)ws).wavePanel.waveWindow.highlightedSweep == sweepNum;
            }
            if (highlighted) {
                if (fX == tX) {
                    g.drawLine(fX - 1, fY, tX - 1, tY);
                    g.drawLine(fX + 1, fY, tX + 1, tY);
                } else if (fY == tY) {
                    g.drawLine(fX, fY + 1, tX, tY + 1);
                    g.drawLine(fX, fY - 1, tX, tY - 1);
                } else {
                    int xDelta = 0;
                    int yDelta = 1;
                    if (Math.abs(fX - tX) < Math.abs(fY - tY)) {
                        xDelta = 1;
                        yDelta = 0;
                    }
                    g.drawLine(tX + xDelta, tY + yDelta, fX + xDelta, fY + yDelta);
                    g.drawLine(tX - xDelta, tY - yDelta, fX - xDelta, fY - yDelta);
                }
            }
            return false;
        }

        private int scaleTimeToX(double time) {
            double x = (time - this.minTime) / (this.maxTime - this.minTime) * (double)(this.sz.width - this.vertAxisPos) + (double)this.vertAxisPos;
            return (int)x;
        }

        private double scaleXToTime(int x) {
            double time = (double)(x - this.vertAxisPos) / (double)(this.sz.width - this.vertAxisPos) * (this.maxTime - this.minTime) + this.minTime;
            return time;
        }

        private double scaleDeltaXToTime(int dx) {
            double dTime = (double)dx / (double)(this.sz.width - this.vertAxisPos) * (this.maxTime - this.minTime);
            return dTime;
        }

        private int scaleValueToY(double value) {
            double y = (double)(this.sz.height - 1) - (value - this.analogLowValue) / this.analogRange * (double)(this.sz.height - 1);
            return (int)y;
        }

        private double scaleYToValue(int y) {
            double value = this.analogLowValue - (double)(y - this.sz.height + 1) / (double)(this.sz.height - 1) * this.analogRange;
            return value;
        }

        private double scaleDeltaYToValue(int dy) {
            double dValue = -((double)dy) / (double)(this.sz.height - 1) * this.analogRange;
            return dValue;
        }

        private List findSignalsInArea(int lX, int hX, int lY, int hY) {
            double swap;
            double lXd = Math.min(lX, hX) - 2;
            double hXd = Math.max(lX, hX) + 2;
            double hYd = Math.min(lY, hY) - 2;
            double lYd = Math.max(lY, hY) + 2;
            if (lXd > hXd) {
                swap = lXd;
                lXd = hXd;
                hXd = swap;
            }
            if (lYd > hYd) {
                swap = lYd;
                lYd = hYd;
                hYd = swap;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(lXd, lYd, hXd - lXd, hYd - lYd);
            List sigs = this.processSignals(null, bounds);
            List cps = this.processControlPoints(null, bounds);
            Iterator it = sigs.iterator();
            while (it.hasNext()) {
                cps.add(it.next());
            }
            return cps;
        }

        private void clearHighlightedSignals() {
            Iterator it = this.waveSignals.values().iterator();
            while (it.hasNext()) {
                WaveSignal ws = (WaveSignal)it.next();
                if (!ws.highlighted) continue;
                ws.highlighted = false;
                WaveSignal.access$3902(ws, null);
                if (ws.sigButton == null) continue;
                ws.sigButton.setBackground(background);
            }
            this.waveWindow.highlightedSweep = -1;
            this.repaint();
        }

        private void addHighlightedSignal(WaveSignal ws) {
            if (ws.sigButton != null) {
                if (background == null) {
                    background = ws.sigButton.getBackground();
                }
                ws.sigButton.setBackground(new Color(User.getColorWaveformBackground()));
            }
            ws.highlighted = true;
            this.waveWindow.highlightedSweep = -1;
            this.repaint();
        }

        private void removeHighlightedSignal(WaveSignal ws) {
            ws.highlighted = false;
            if (ws.sigButton != null) {
                ws.sigButton.setBackground(background);
            }
            this.waveWindow.highlightedSweep = -1;
            this.repaint();
        }

        public void makeSelectedPanel() {
            Iterator it = this.waveWindow.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (!wp.selected || wp == this) continue;
                wp.selected = false;
                wp.repaint();
            }
            if (!this.selected) {
                this.selected = true;
                this.repaint();
            }
        }

        public void mousePressed(MouseEvent evt) {
            this.requestFocus();
            this.waveWindow.vcrClickStop();
            this.makeSelectedPanel();
            Iterator it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (wp.draggingArea) {
                    wp.repaint();
                }
                wp.draggingArea = false;
            }
            if (evt.getClickCount() == 2 && evt.getX() < this.vertAxisPos) {
                WaveformZoom dialog = new WaveformZoom(TopLevel.getCurrentJFrame(), this.analogLowValue, this.analogHighValue, this.minTime, this.maxTime, this.waveWindow, this);
                return;
            }
            ToolBar.CursorMode mode = ToolBar.getCursorMode();
            if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
                mode = ToolBar.CursorMode.ZOOM;
            }
            if (mode == ToolBar.CursorMode.ZOOM) {
                this.mousePressedZoom(evt);
            } else if (mode == ToolBar.CursorMode.PAN) {
                this.mousePressedPan(evt);
            } else {
                this.mousePressedSelect(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            ToolBar.CursorMode mode = ToolBar.getCursorMode();
            if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
                mode = ToolBar.CursorMode.ZOOM;
            }
            if (mode == ToolBar.CursorMode.ZOOM) {
                this.mouseReleasedZoom(evt);
            } else if (mode == ToolBar.CursorMode.PAN) {
                this.mouseReleasedPan(evt);
            } else {
                this.mouseReleasedSelect(evt);
            }
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
            ToolBar.CursorMode mode = ToolBar.getCursorMode();
            if (mode == ToolBar.CursorMode.ZOOM) {
                this.mouseMovedZoom(evt);
            } else if (mode == ToolBar.CursorMode.PAN) {
                this.mouseMovedPan(evt);
            } else {
                this.mouseMovedSelect(evt);
            }
        }

        public void mouseDragged(MouseEvent evt) {
            ToolBar.CursorMode mode = ToolBar.getCursorMode();
            if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
                mode = ToolBar.CursorMode.ZOOM;
            }
            if (mode == ToolBar.CursorMode.ZOOM) {
                this.mouseDraggedZoom(evt);
            } else if (mode == ToolBar.CursorMode.PAN) {
                this.mouseDraggedPan(evt);
            } else {
                this.mouseDraggedSelect(evt);
            }
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyPressed(KeyEvent evt) {
            this.waveWindow.vcrClickStop();
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }

        public void mousePressedSelect(MouseEvent evt) {
            this.draggingVertAxis = false;
            this.draggingExt = false;
            this.draggingMain = false;
            int mainX = this.scaleTimeToX(this.waveWindow.mainTime);
            if (Math.abs(mainX - evt.getX()) < 5) {
                this.draggingMain = true;
                return;
            }
            int extX = this.scaleTimeToX(this.waveWindow.extTime);
            if (Math.abs(extX - evt.getX()) < 5) {
                this.draggingExt = true;
                return;
            }
            if (Math.abs(this.vertAxisPos - evt.getX()) < 5) {
                this.draggingVertAxis = true;
                return;
            }
            this.draggingArea = true;
            Point pt = new Point(evt.getX(), evt.getY());
            if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
                pt = this.snapPoint(pt);
                this.measureWindows = new HashSet();
                this.measureWindows.add(this);
            }
            this.dragEndX = this.dragStartX = pt.x;
            this.dragEndY = this.dragStartY = pt.y;
        }

        private Point snapPoint(Point pt) {
            Iterator it = this.waveSignals.values().iterator();
            while (it.hasNext()) {
                WaveSignal ws = (WaveSignal)it.next();
                if (!(ws.sSig instanceof AnalogSignal)) continue;
                AnalogSignal as = (AnalogSignal)ws.sSig;
                int numEvents = as.getNumEvents();
                if (as.isBasic()) {
                    for (int i = 0; i < numEvents; ++i) {
                        double time = ws.sSig.getTime(i);
                        int x = this.scaleTimeToX(time);
                        int y = this.scaleValueToY(as.getValue(i));
                        if (Math.abs(x - pt.x) >= 5 || Math.abs(y - pt.y) >= 5) continue;
                        pt.x = x;
                        pt.y = y;
                    }
                    continue;
                }
                if (!as.isSweep()) continue;
                List sweepSignals = this.waveWindow.sweepSignals;
                for (int s = 0; s < as.getNumSweeps(); ++s) {
                    SweepSignal ss = (SweepSignal)sweepSignals.get(s);
                    if (ss != null && !ss.included) continue;
                    numEvents = as.getNumEvents(s);
                    for (int i = 0; i < numEvents; ++i) {
                        double time = ws.sSig.getTime(i, s);
                        int x = this.scaleTimeToX(time);
                        int y = this.scaleValueToY(as.getSweepValue(s, i));
                        if (Math.abs(x - pt.x) >= 5 || Math.abs(y - pt.y) >= 5) continue;
                        pt.x = x;
                        pt.y = y;
                    }
                }
            }
            return pt;
        }

        public void mouseReleasedSelect(MouseEvent evt) {
            if (this.draggingArea) {
                Panel wp = (Panel)evt.getSource();
                if (ToolBar.getCursorMode() != ToolBar.CursorMode.MEASURE && ToolBar.getSelectMode() == ToolBar.SelectMode.OBJECTS) {
                    this.draggingArea = false;
                    List selectedObjects = wp.findSignalsInArea(this.dragStartX, this.dragEndX, this.dragStartY, this.dragEndY);
                    if ((evt.getModifiers() & 1) == 0) {
                        Iterator it;
                        if (wp.isAnalog) {
                            this.clearHighlightedSignals();
                        } else {
                            it = this.waveWindow.wavePanels.iterator();
                            while (it.hasNext()) {
                                Panel oWp = (Panel)it.next();
                                oWp.clearHighlightedSignals();
                            }
                        }
                        it = selectedObjects.iterator();
                        while (it.hasNext()) {
                            WaveSelection wSel = (WaveSelection)it.next();
                            if (wSel.controlPoint) {
                                wSel.ws.addSelectedControlPoint(wSel.controlTime);
                            }
                            wp.addHighlightedSignal(wSel.ws);
                        }
                    } else {
                        Iterator it = selectedObjects.iterator();
                        while (it.hasNext()) {
                            WaveSelection wSel = (WaveSelection)it.next();
                            WaveSignal ws = wSel.ws;
                            if (ws.highlighted) {
                                if (wSel.controlPoint) {
                                    ws.removeSelectedControlPoint(wSel.controlTime);
                                }
                                this.removeHighlightedSignal(ws);
                                continue;
                            }
                            if (wSel.controlPoint) {
                                ws.addSelectedControlPoint(wSel.controlTime);
                            }
                            wp.addHighlightedSignal(ws);
                        }
                    }
                    wp.waveWindow.showSelectedNetworksInSchematic();
                }
            }
            this.repaint();
        }

        public void mouseDraggedSelect(MouseEvent evt) {
            if (this.draggingMain) {
                if (evt.getX() <= 0) {
                    return;
                }
                double time = this.scaleXToTime(evt.getX());
                this.waveWindow.setMainTimeCursor(time);
                this.waveWindow.redrawAllPanels();
            } else if (this.draggingExt) {
                if (evt.getX() <= 0) {
                    return;
                }
                double time = this.scaleXToTime(evt.getX());
                this.waveWindow.setExtensionTimeCursor(time);
                this.waveWindow.redrawAllPanels();
            } else if (this.draggingVertAxis) {
                if (evt.getX() <= 0) {
                    return;
                }
                if (this.waveWindow.timeLocked) {
                    Iterator it = this.waveWindow.getPanels();
                    while (it.hasNext()) {
                        Panel wp = (Panel)it.next();
                        wp.vertAxisPos = evt.getX();
                    }
                    this.waveWindow.redrawAllPanels();
                    this.waveWindow.mainTimePanel.repaint();
                } else {
                    this.vertAxisPos = evt.getX();
                    this.repaintWithTime();
                }
            } else if (this.draggingArea) {
                Point pt = new Point(evt.getX(), evt.getY());
                if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
                    Rectangle rect = this.getBounds();
                    Panel curPanel = (Panel)evt.getSource();
                    Point scPt = evt.getComponent().getLocationOnScreen();
                    if (!rect.contains(pt)) {
                        Point globalPt = new Point(scPt.x + evt.getX(), scPt.y + evt.getY());
                        Iterator it = this.waveWindow.getPanels();
                        while (it.hasNext()) {
                            Panel wp = (Panel)it.next();
                            Point oPt = wp.getLocationOnScreen();
                            Dimension sz = wp.getSize();
                            if (globalPt.x < oPt.x || globalPt.x > oPt.x + sz.width || globalPt.y < oPt.y || globalPt.y > oPt.y + sz.height) continue;
                            this.measureWindows.add(wp);
                            wp.draggingArea = true;
                            curPanel = wp;
                        }
                    }
                    if (curPanel == this) {
                        pt = this.snapPoint(pt);
                    } else {
                        Point oPt = curPanel.getLocationOnScreen();
                        pt.y = pt.y + scPt.y - oPt.y;
                        pt = curPanel.snapPoint(pt);
                        pt.y = pt.y - scPt.y + oPt.y;
                    }
                    Iterator it = this.measureWindows.iterator();
                    while (it.hasNext()) {
                        Panel wp = (Panel)it.next();
                        if (wp == this) continue;
                        Point oPt = wp.getLocationOnScreen();
                        wp.dragStartX = this.dragStartX;
                        wp.dragStartY = this.dragStartY + scPt.y - oPt.y;
                        wp.dragEndX = pt.x;
                        wp.dragEndY = pt.y + scPt.y - oPt.y;
                        wp.repaint();
                    }
                }
                this.dragEndX = pt.x;
                this.dragEndY = pt.y;
                this.repaint();
            }
        }

        public void mouseMovedSelect(MouseEvent evt) {
            int mainX = this.scaleTimeToX(this.waveWindow.mainTime);
            int extX = this.scaleTimeToX(this.waveWindow.extTime);
            if (Math.abs(mainX - evt.getX()) < 5 || Math.abs(extX - evt.getX()) < 5 || Math.abs(this.vertAxisPos - evt.getX()) < 5) {
                this.setCursor(dragTimeCursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mousePressedZoom(MouseEvent evt) {
            this.dragStartX = evt.getX();
            this.dragStartY = evt.getY();
            ZoomAndPanListener.setProperCursor(evt);
            this.draggingArea = true;
        }

        public void mouseReleasedZoom(MouseEvent evt) {
            ZoomAndPanListener.setProperCursor(evt);
            this.draggingArea = false;
            double lowTime = this.scaleXToTime(Math.min(this.dragEndX, this.dragStartX));
            double highTime = this.scaleXToTime(Math.max(this.dragEndX, this.dragStartX));
            double timeRange = highTime - lowTime;
            lowTime -= timeRange / 8.0;
            highTime += timeRange / 8.0;
            double lowValue = this.scaleYToValue(Math.max(this.dragEndY, this.dragStartY));
            double highValue = this.scaleYToValue(Math.min(this.dragEndY, this.dragStartY));
            double valueRange = highValue - lowValue;
            lowValue -= valueRange / 8.0;
            highValue += valueRange / 8.0;
            Iterator it = this.waveWindow.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (!this.waveWindow.timeLocked && wp != this) continue;
                if ((evt.getModifiers() & 1) == 0 || ClickZoomWireListener.isRightMouse(evt)) {
                    wp.minTime = lowTime;
                    wp.maxTime = highTime;
                    if (wp == this) {
                        wp.setValueRange(lowValue, highValue);
                    }
                } else {
                    double oldRange = wp.maxTime - wp.minTime;
                    wp.minTime = (lowTime + highTime) / 2.0 - oldRange;
                    wp.maxTime = (lowTime + highTime) / 2.0 + oldRange;
                    if (wp == this) {
                        wp.setValueRange((lowValue + highValue) / 2.0 - wp.analogRange, (lowValue + highValue) / 2.0 + wp.analogRange);
                    }
                }
                wp.repaintWithTime();
            }
        }

        public void mouseDraggedZoom(MouseEvent evt) {
            ZoomAndPanListener.setProperCursor(evt);
            if (this.draggingArea) {
                this.dragEndX = evt.getX();
                this.dragEndY = evt.getY();
                this.repaint();
            }
        }

        public void mouseMovedZoom(MouseEvent evt) {
            ZoomAndPanListener.setProperCursor(evt);
        }

        public void mousePressedPan(MouseEvent evt) {
            this.dragStartX = evt.getX();
            this.dragStartY = evt.getY();
        }

        public void mouseReleasedPan(MouseEvent evt) {
        }

        public void mouseDraggedPan(MouseEvent evt) {
            this.dragEndX = evt.getX();
            this.dragEndY = evt.getY();
            double dTime = this.scaleDeltaXToTime(this.dragEndX - this.dragStartX);
            double dValue = this.scaleDeltaYToValue(this.dragEndY - this.dragStartY);
            Iterator it = this.waveWindow.wavePanels.iterator();
            while (it.hasNext()) {
                Panel wp = (Panel)it.next();
                if (!this.waveWindow.timeLocked && wp != this) continue;
                wp.minTime -= dTime;
                wp.maxTime -= dTime;
                if (wp == this) {
                    this.setValueRange(this.analogLowValue - dValue, this.analogHighValue - dValue);
                }
                wp.repaintWithTime();
            }
            this.dragStartX = this.dragEndX;
            this.dragStartY = this.dragEndY;
        }

        public void mouseMovedPan(MouseEvent evt) {
        }

        private static class WaveSelection {
            WaveSignal ws;
            boolean controlPoint;
            double controlTime;

            private WaveSelection() {
            }
        }
    }
}

