/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class FileBasedKeySupplier
implements SessionKeySupplier {
    private volatile KeyPair keyPair;
    private final String privateKeyPath;
    private final Path passphrasePath;

    public FileBasedKeySupplier(String privateKeyPath, String passphrasePath) {
        this.privateKeyPath = privateKeyPath;
        this.passphrasePath = passphrasePath != null ? new File(passphrasePath).toPath() : null;
        this.refreshKeys();
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public void refreshKeys() {
        if (this.privateKeyPath == null) {
            throw new IllegalArgumentException("privateKeyPath not set");
        }
        try (FileInputStream in = new FileInputStream(this.privateKeyPath);){
            char[] passphrase = null;
            if (this.passphrasePath != null) {
                passphrase = new String(Files.readAllBytes(this.passphrasePath)).toCharArray();
            }
            RSAPrivateKey privateKey = new PEMFileRSAPrivateKeySupplier(in, passphrase).supplyKey("unused").orElse(null);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKeySpec keySpec = keyFactory.getKeySpec(keyFactory.translateKey(privateKey), RSAPrivateCrtKeySpec.class);
            RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(keySpec.getModulus(), keySpec.getPublicExponent()));
            this.keyPair = new KeyPair(publicKey, privateKey);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Can't find file for private key", e);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot read the passphrase", e);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("problem handling private key", e);
        }
    }
}

