/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.WorkbenchMessages;

public class LanguagePrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String LANGUAGE_OSGI_NL_KEY = "osgi.nl";
    private static final String LOADED_LANGUAGES_URL = "platform:/plugin/org.xmind.cathy/resource/langs.properties";
    private static final String[] supportedLangsKey = new String[]{"en_US", "de", "fr", "zh_CN", "zh_TW", "ja", "ko", "da", "ru", "it", "sl", "ar", "es", "pt_BR"};
    private static String oldLangKey = null;
    private Properties configIniProperties = this.loadProperties(this.getConfigFile());
    private Properties supportLanguageProperties = this.loadProperties(this.getSupportLanguageFile());
    private HashMap<String, String> supportLangsMap;
    private ListViewer langsViewer;
    private Label changingToLangText;
    private Button changeButton;

    public LanguagePrefPage() {
        super(WorkbenchMessages.LanguagePrefPage_title, 0);
        this.initSupportLanguageMap();
        if (oldLangKey == null) {
            String languageKey = this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY);
            oldLangKey = languageKey != null ? languageKey : System.getProperty(LANGUAGE_OSGI_NL_KEY);
        }
    }

    private void initSupportLanguageMap() {
        if (this.supportLangsMap != null) {
            return;
        }
        this.supportLangsMap = new HashMap();
        this.supportLangsMap.put("en_US", WorkbenchMessages.SupportLanguageName_English);
        this.supportLangsMap.put("ar", WorkbenchMessages.SupportLanguageName_Arabic);
        this.supportLangsMap.put("da", WorkbenchMessages.SupportLanguageName_Danish);
        this.supportLangsMap.put("de", WorkbenchMessages.SupportLanguageName_German);
        this.supportLangsMap.put("es", WorkbenchMessages.SupportLanguageName_Spanish);
        this.supportLangsMap.put("fr", WorkbenchMessages.SupportLanguageName_French);
        this.supportLangsMap.put("it", WorkbenchMessages.SupportLanguageName_Italian);
        this.supportLangsMap.put("ja", WorkbenchMessages.SupportLanguageName_Japanese);
        this.supportLangsMap.put("ko", WorkbenchMessages.SupportLanguageName_Korean);
        this.supportLangsMap.put("pt_BR", WorkbenchMessages.SupportLanguageName_Portuguese_Brazilian);
        this.supportLangsMap.put("ru", WorkbenchMessages.SupportLanguageName_Russian);
        this.supportLangsMap.put("sl", WorkbenchMessages.SupportLanguageName_Slovenian);
        this.supportLangsMap.put("zh_CN", WorkbenchMessages.SupportLanguageName_SimplifiedCN);
        this.supportLangsMap.put("zh_TW", WorkbenchMessages.SupportLanguageName_TraditionalCN);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File file) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try {
            Properties properties2;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1024);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                properties2 = properties;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
                return properties2;
            }
            catch (IOException iOException) {}
            return properties2;
        }
        catch (IOException iOException) {}
        return null;
    }

    private void storeProperties(Properties properties, File file) {
        if (file != null && file.exists() && file.canWrite()) {
            try {
                BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file), 1024);
                try {
                    properties.store(stream, "Store properties into file.");
                }
                catch (Throwable throwable) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {}
        }
    }

    private File getConfigFile() {
        URL configDir = Platform.getConfigurationLocation().getURL();
        try {
            URL configIni = new URL(configDir, "config.ini");
            File file = new File(configIni.getFile());
            return file;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private File getSupportLanguageFile() {
        try {
            URL url = FileLocator.find((URL)new URL(LOADED_LANGUAGES_URL));
            File supportLanguageFile = new File(FileLocator.toFileURL((URL)url).getPath());
            return supportLanguageFile;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.addLanguageGroup();
    }

    private void addLanguageGroup() {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.addChangeLanguageField(parent);
    }

    private void addChangeLanguageField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)new GridLayout());
        this.createLangsDescription(composite);
        this.createChangeLanguageControl(parent);
    }

    private void createChangeLanguageControl(Composite parent) {
        Composite line = new Composite(parent, 0);
        line.setLayoutData((Object)new GridData(4, 4, true, false));
        line.setLayout((Layout)new GridLayout(2, false));
        int flags = 2820;
        this.langsViewer = new ListViewer(line, flags);
        GridData layoutData = new GridData(4, 1, true, false);
        this.langsViewer.getControl().setLayoutData((Object)layoutData);
        this.langsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.langsViewer.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.langsViewer.setInput((Object)supportedLangsKey);
        String languageKey = this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY);
        String currentLanguageKey = languageKey != null ? languageKey : oldLangKey;
        this.langsViewer.setSelection((ISelection)new StructuredSelection((Object)currentLanguageKey));
        this.langsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection langElementSelection = event.getSelection();
                if (langElementSelection instanceof StructuredSelection) {
                    boolean isChanged;
                    Object langKey = ((StructuredSelection)langElementSelection).getFirstElement();
                    boolean bl = isChanged = !oldLangKey.equals(langKey);
                    if (isChanged) {
                        String langSelected = ((LanguageLabelProvider)LanguagePrefPage.this.langsViewer.getLabelProvider()).getText(langKey);
                        LanguagePrefPage.this.changingToLangText.setText(langSelected);
                    } else {
                        LanguagePrefPage.this.changingToLangText.setText("");
                    }
                    LanguagePrefPage.this.changeButton.setEnabled(isChanged);
                }
            }
        });
        this.changeButton = new Button(line, 0);
        this.changeButton.setText(WorkbenchMessages.ChangeLanguage_button);
        this.changeButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.changeButton.setEnabled(!currentLanguageKey.equals(oldLangKey));
        this.changeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection langElementSelection = LanguagePrefPage.this.langsViewer.getSelection();
                if (langElementSelection instanceof StructuredSelection) {
                    Object langKey = ((StructuredSelection)langElementSelection).getFirstElement();
                    String langSelected = ((LanguageLabelProvider)LanguagePrefPage.this.langsViewer.getLabelProvider()).getText(langKey);
                    String message = NLS.bind((String)WorkbenchMessages.ConfirmToRestart_description, (Object)langSelected);
                    MessageDialog confirmDialog = new MessageDialog(LanguagePrefPage.this.getShell(), WorkbenchMessages.ConfirmToRestart_title, null, message, 5, new String[]{WorkbenchMessages.ConfirmToRestart_defaultButton, WorkbenchMessages.ConfirmToRestart_cancelButton}, 0);
                    int restart = confirmDialog.open();
                    LanguagePrefPage.this.configIniProperties.put(LanguagePrefPage.LANGUAGE_OSGI_NL_KEY, langKey);
                    LanguagePrefPage.this.storeProperties(LanguagePrefPage.this.configIniProperties, LanguagePrefPage.this.getConfigFile());
                    if (restart == 0) {
                        PlatformUI.getWorkbench().restart();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createLangsDescription(Composite composite) {
        Composite descriptionComposite = new Composite(composite, 0);
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout descriptionLayout = new GridLayout(2, false);
        descriptionLayout.marginHeight = 0;
        descriptionLayout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)descriptionLayout);
        Label langToChangeDescription = new Label(descriptionComposite, 0);
        langToChangeDescription.setText(WorkbenchMessages.ChangeLanguageTo_description);
        langToChangeDescription.setLayoutData((Object)new GridData(4));
        this.changingToLangText = new Label(descriptionComposite, 18444);
        this.changingToLangText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        String languageKey = this.configIniProperties.getProperty(LANGUAGE_OSGI_NL_KEY);
        String supportLang = this.supportLangsMap.get(languageKey);
        if (supportLang != null) {
            this.changingToLangText.setText(supportLang);
        }
    }

    protected void performDefaults() {
        this.configIniProperties.put(LANGUAGE_OSGI_NL_KEY, System.getProperty(LANGUAGE_OSGI_NL_KEY));
        this.langsViewer.setSelection((ISelection)new StructuredSelection((Object)System.getProperty(LANGUAGE_OSGI_NL_KEY)), true);
        this.storeProperties(this.configIniProperties, this.getConfigFile());
        super.performDefaults();
    }

    public boolean performOk() {
        Object langKey;
        if (!super.performOk()) {
            return false;
        }
        ISelection langElementSelection = this.langsViewer.getSelection();
        if (langElementSelection instanceof StructuredSelection && !oldLangKey.equals(langKey = ((StructuredSelection)langElementSelection).getFirstElement())) {
            String message = WorkbenchMessages.LanguagePrefPage_ConfirmToRestart2_description;
            MessageDialog confirmDialog = new MessageDialog(this.getShell(), WorkbenchMessages.ConfirmToRestart_title, null, message, 5, new String[]{WorkbenchMessages.LanguagePrefPage_ConfirmToRestart2_defaultButton, WorkbenchMessages.LanguagePrefPage_ConfirmToRestart_laterButton}, 0);
            int restart = confirmDialog.open();
            if (restart == -1) {
                return false;
            }
            this.configIniProperties.put(LANGUAGE_OSGI_NL_KEY, langKey);
            this.storeProperties(this.configIniProperties, this.getConfigFile());
            if (restart == 0) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return true;
    }

    private class LanguageLabelProvider
    extends LabelProvider {
        private LanguageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                StringBuffer buffer = new StringBuffer(3);
                String langKey = (String)element;
                String supportLang = LanguagePrefPage.this.supportLanguageProperties.getProperty(langKey);
                buffer.append(supportLang);
                buffer.append(" - ");
                buffer.append((String)LanguagePrefPage.this.supportLangsMap.get(langKey));
                return buffer.toString();
            }
            return super.getText(element);
        }
    }
}

