/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IEditDomainListener;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.mindmap.MindMapViewer;

public class BrainstormViewer
extends MindMapViewer
implements IEditDomainListener {
    private static final String CONTEXT_MINDMAP_ID = "org.xmind.ui.context.mindmap";
    private static final String CONTEXT_BRAINSTORM_ID = "org.xmind.ui.context.brainstorm.edit";
    public static final Object LAYER_TIMER = "timer layer";
    public static final Object LAYER_IDEAFACTORY = "ideaFactory layer";
    public static final Object LAYER_MENU = "menu layer";
    private IActionRegistry actionRegistry;
    private boolean keysActive = false;
    private EContextService service;
    private String lastContextId;

    public Object getAdapter(Class adapter) {
        if (adapter == IActionRegistry.class) {
            if (this.actionRegistry == null) {
                this.actionRegistry = new ActionRegistry();
            }
            return this.actionRegistry;
        }
        return super.getAdapter(adapter);
    }

    public void setEditDomain(EditDomain domain) {
        if (this.getEditDomain() != null) {
            this.getEditDomain().removeEditDomainListener((IEditDomainListener)this);
            this.deactivateContext();
        }
        super.setEditDomain(domain);
        if (this.getEditDomain() != null) {
            this.getEditDomain().addEditDomainListener((IEditDomainListener)this);
        }
    }

    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.keysActive = control != null && control.isFocusControl();
        this.service = (EContextService)PlatformUI.getWorkbench().getService(EContextService.class);
        control.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                BrainstormViewer.this.keysActive = false;
                BrainstormViewer.this.changeContext(null);
            }

            public void focusGained(FocusEvent e) {
                if (BrainstormViewer.this.getEditDomain() != null) {
                    BrainstormViewer.this.keysActive = true;
                    BrainstormViewer.this.changeContext(BrainstormViewer.this.getEditDomain().getActiveTool());
                }
            }
        });
        return control;
    }

    public void activeToolChanged(ITool oldTool, ITool newTool) {
        if (this.keysActive) {
            this.changeContext(newTool);
        }
    }

    protected void changeContext(ITool newTool) {
        this.deactivateContext();
        this.activateContext(newTool == null ? null : newTool.getContextId());
    }

    private void activateContext(String contextId) {
        if (contextId == null) {
            return;
        }
        this.service.activateContext(CONTEXT_MINDMAP_ID);
        this.service.activateContext(CONTEXT_BRAINSTORM_ID);
        this.service.activateContext(contextId);
        this.lastContextId = contextId;
    }

    private void deactivateContext() {
        if (this.service != null && this.lastContextId != null) {
            this.service.deactivateContext(CONTEXT_MINDMAP_ID);
            this.service.deactivateContext(CONTEXT_BRAINSTORM_ID);
            this.service.deactivateContext(this.lastContextId);
        }
    }
}

