/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.datepicker.DatePicker;
import org.xmind.ui.gantt2.viewer.DateInfoPickerViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeEditableTracker;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskTreeEndDateEditableTracker
extends TaskTreeEditableTracker {
    public TaskTreeEndDateEditableTracker(IFigure target, FigureCanvas canvas, TaskTreeItemPart host) {
        super(target, canvas, host);
    }

    protected void edit() {
        this.editEndDate();
    }

    private void editEndDate() {
        DateInfoPickerViewer endDatePicker = this.createEndDatePicker((Composite)this.canvas);
        final Control control = endDatePicker.getControl();
        this.locateEditor(control, this.target, this.canvas.getViewport());
        this.setActiveEditor(control);
        final DatePicker datePicker = endDatePicker.getDatePicker();
        Control datePickerControl = datePicker.getControl();
        datePickerControl.forceFocus();
        datePicker.open();
        endDatePicker.refresh();
        datePicker.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!datePicker.getControl().isDisposed()) {
                    datePicker.close();
                }
            }
        });
        datePicker.getDatePicker().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskTreeEndDateEditableTracker.this.preCancelEditing();
                e.display.timerExec(200, new Runnable(){

                    public void run() {
                        if (control != null && !control.isDisposed()) {
                            control.dispose();
                        }
                    }
                });
            }
        });
    }

    private DateInfoPickerViewer createEndDatePicker(Composite parent) {
        final DateInfoPickerViewer endDatePicker = new DateInfoPickerViewer(parent);
        endDatePicker.setInvalidColor(invalidColor);
        endDatePicker.setValidColor(validColor);
        DateInfo endDate = TaskInfoUtils.calculateEndDateInfo((ITopic)this.topic);
        endDatePicker.setDate(endDate);
        endDatePicker.setEnabled(this.topic != null);
        endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TaskTreeEndDateEditableTracker.this.changeEndDate((DateInfo)((IStructuredSelection)event.getSelection()).getFirstElement());
                TaskTreeEndDateEditableTracker.this.preCancelEditing();
                endDatePicker.refresh();
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        endDatePicker.close();
                    }
                });
            }
        });
        return endDatePicker;
    }

    private void changeEndDate(DateInfo date) {
        if (date == null) {
            TaskInfoUtils.changeStartDate((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (DateInfo)date);
        }
        TaskInfoUtils.changeEndDate((ITopic)this.topic, (ICommandStack)this.getCommandStack(), (DateInfo)date);
    }
}

