/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.runtime.taskParallel;

import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;

public class ThreadPoolJdkForkJoin
extends IThreadPool {
    private ForkJoinPool pool;
    private int threads;

    private ThreadPoolJdkForkJoin() {
        this(Runtime.getRuntime().availableProcessors());
    }

    private ThreadPoolJdkForkJoin(int threads) {
        this.threads = threads;
    }

    public static ThreadPoolJdkForkJoin initialize() {
        ThreadPoolJdkForkJoin pool = new ThreadPoolJdkForkJoin();
        pool.start();
        return pool;
    }

    public static ThreadPoolJdkForkJoin initialize(int numOfThreads) {
        ThreadPoolJdkForkJoin pool = new ThreadPoolJdkForkJoin(numOfThreads);
        pool.start();
        return pool;
    }

    @Override
    public void start() {
        this.pool = new ForkJoinPool(this.threads);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.pool.shutdown();
    }

    @Override
    public void join() throws InterruptedException {
        if (this.threads > 1) {
            this.pool.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    @Override
    public void sleep() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void weakUp() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void trigger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(PTask item) {
        this.pool.execute(new PTaskWrapper(item));
    }

    @Override
    public void add(PTask item, int threadId) {
        this.pool.execute(new PTaskWrapper(item));
    }

    @Override
    public int getPoolSize() {
        return this.pool.getParallelism();
    }

    private class PTaskWrapper
    extends ForkJoinTask<String> {
        private PTask task;

        public PTaskWrapper(PTask task) {
            this.task = task;
        }

        @Override
        public boolean exec() {
            this.task.setThreadID((int)Thread.currentThread().getId());
            this.task.before();
            this.task.execute();
            this.task.after();
            return true;
        }

        @Override
        public String getRawResult() {
            return null;
        }

        @Override
        protected void setRawResult(String value) {
        }
    }
}

