/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerObjectReader
extends OsmServerReader {
    private final PrimitiveId id;
    private final boolean full;
    private final int version;

    public OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full) {
        this(id, type, full, -1);
    }

    public OsmServerObjectReader(long id, OsmPrimitiveType type, int version) {
        this(id, type, false, version);
    }

    protected OsmServerObjectReader(long id, OsmPrimitiveType type, boolean full, int version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value > 0 for parameter ''{0}'', got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = new SimplePrimitiveId(id, type);
        this.full = full;
        this.version = version;
    }

    public OsmServerObjectReader(PrimitiveId id, boolean full) {
        this(id, full, -1);
    }

    public OsmServerObjectReader(PrimitiveId id, int version) {
        this(id, false, version);
    }

    protected OsmServerObjectReader(PrimitiveId id, boolean full, int version) {
        CheckParameterUtil.ensureThat(id.getUniqueId() > 0L, "id > 0");
        this.id = id;
        this.full = full;
        this.version = version;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask("", 1);
        try {
            DataSet dataSet;
            block24: {
                InputStream in;
                block22: {
                    DataSet dataSet2;
                    block23: {
                        progressMonitor.indeterminateSubTask(I18n.tr("Downloading OSM data...", new Object[0]));
                        StringBuilder sb = new StringBuilder();
                        sb.append(this.id.getType().getAPIName()).append('/').append(this.id.getUniqueId());
                        if (this.full && this.id.getType() != OsmPrimitiveType.NODE) {
                            sb.append("/full");
                        } else if (this.version > 0) {
                            sb.append('/').append(this.version);
                        }
                        in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
                        try {
                            if (in != null) break block22;
                            dataSet2 = null;
                            if (in == null) break block23;
                        }
                        catch (Throwable throwable) {
                            DataSet dataSet3;
                            try {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (OsmTransferException e) {
                                if (this.cancel) {
                                    dataSet3 = null;
                                    return dataSet3;
                                }
                                throw e;
                            }
                            catch (IOException | IllegalDataException e) {
                                if (this.cancel) {
                                    dataSet3 = null;
                                    return dataSet3;
                                }
                                throw new OsmTransferException(e);
                            }
                        }
                        in.close();
                    }
                    return dataSet2;
                }
                dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(-1, false));
                if (in == null) break block24;
                in.close();
            }
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }
}

