/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.data.TrackExtents;

public class PointScaler {
    private final Track _track;
    private Track _terrainTrack = null;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private double[] _altValues = null;
    private double[] _terrainxValues = null;
    private double[] _terrainyValues = null;
    private double[] _terrainAltValues = null;
    private double _altitudeRange = 0.0;

    public PointScaler(Track track) {
        this._track = track;
    }

    public void addTerrain(Track track) {
        this._terrainTrack = track;
    }

    public void scale() {
        TrackExtents trackExtents = new TrackExtents(this._track);
        trackExtents.applySquareBorder();
        double d = Math.max(trackExtents.getHorizontalDistanceMetres(), 1.0);
        int n = this._track.getNumPoints();
        DoubleRange doubleRange = trackExtents.getAltitudeRange();
        if (this._terrainTrack != null) {
            doubleRange.combine(new TrackExtents(this._terrainTrack).getAltitudeRange());
        }
        this._altitudeRange = doubleRange.getRange() / d;
        double d2 = doubleRange.getMinimum();
        if (this._xValues == null || this._xValues.length != n) {
            this._xValues = new double[n];
            this._yValues = new double[n];
            this._altValues = new double[n];
            if (this._terrainTrack != null) {
                this._terrainxValues = new double[this._terrainTrack.getNumPoints()];
                this._terrainyValues = new double[this._terrainTrack.getNumPoints()];
                this._terrainAltValues = new double[this._terrainTrack.getNumPoints()];
            }
        }
        double d3 = trackExtents.getXRange().getMidValue();
        double d4 = trackExtents.getYRange().getMidValue();
        double d5 = trackExtents.getXRange().getRange();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._track.getPoint(n2);
            if (dataPoint != null) {
                this._xValues[n2] = (this._track.getX(n2) - d3) / d5;
                this._yValues[n2] = (d4 - this._track.getY(n2)) / d5;
                this._altValues[n2] = (dataPoint.getAltitude().getMetricValue() - d2) / d;
            }
            ++n2;
        }
        if (this._terrainTrack != null) {
            n2 = 0;
            while (n2 < this._terrainTrack.getNumPoints()) {
                this._terrainxValues[n2] = (this._terrainTrack.getX(n2) - d3) / d5;
                this._terrainyValues[n2] = (d4 - this._terrainTrack.getY(n2)) / d5;
                this._terrainAltValues[n2] = (this._terrainTrack.getPoint(n2).getAltitude().getMetricValue() - d2) / d;
                ++n2;
            }
        }
    }

    public double getHorizValue(int n) {
        return this._xValues[n];
    }

    public double getVertValue(int n) {
        return this._yValues[n];
    }

    public double getAltValue(int n) {
        return this._altValues[n];
    }

    public double getAltitudeRange() {
        return this._altitudeRange;
    }

    public double getTerrainHorizValue(int n) {
        return this._terrainxValues[n];
    }

    public double getTerrainVertValue(int n) {
        return this._terrainyValues[n];
    }

    public double getTerrainAltValue(int n) {
        if (this._terrainAltValues != null) {
            return this._terrainAltValues[n];
        }
        return 0.0;
    }
}

