# Viewer Example, A minimal OSG viewer
#
# Modified for Tcl3D by Paul Obermeier 2009/03/20.
# See www.tcl3d.org for the Tcl3D extension.

package require tcl3d

if { $argc == 0 } {
    set osgFile "cow.osg"
} else {
    set osgFile [lindex $argv 0]
}

# Create a Viewer.
osgViewer::ViewerRef viewer [osgViewer::Viewer]

# Load a model and add it to the Viewer.
viewer setSceneData [osgDB::readNodeFile $osgFile]
viewer setCameraManipulator [osgGA::TrackballManipulator]

if { [viewer getSceneData] eq "NULL" } {
    puts "Unable to load data file $osgFile."
    exit 1
}

viewer realize

while { ! [viewer done] } {
    viewer frame
}
exit 0
