/******************************************************************************
 *{@C
 *      Copyright:      2009-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osg.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module osg.
 *
 *****************************************************************************/

%include "tcl3dSwigDefines.i"

%include "std_string.i"

%include "tcl3dStdVector.i"
%include "tcl3dMixinVector.i"

%include "osgOpenThreadsHeader.i"

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgParticleHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"
%include "osgSimHeader.i"
%include "osgVolumeHeader.i"

%{
    using namespace osg;
%}

%import "osgOpenThreads.i"


// OPA TODO This should be specified centrally or using the tcl3dDefines.i specifications.
#define APIENTRY
#define GL_APIENTRY
typedef unsigned int GLenum;

%include osg/Version

%include osg/Config

%ignore osg::Referenced::operator=;
%ignore osg::ref_ptr::operator <;
%ignore osg::ref_ptr::operator ==;
%ignore osg::ref_ptr::operator !=;
%ignore osg::ref_ptr::operator !;
%ignore osg::ref_ptr::operator .;
%ignore osg::ref_ptr::operator unspecified_bool_type;
%include osg/Referenced
%include osg/ref_ptr

%rename(get) osg::CopyOp::operator();
%include osg/CopyOp
%ignore osg::observer_ptr::operator !=;
%include osg/observer_ptr
%include osg/Object

%include "osgBasic.i"

// Classes inherited only from Referenced or not derived at all.
%include osg/BoundsChecking
%include osg/DisplaySettings
%include osg/FrameStamp
%include osg/Stats
%include osg/Timer

// Classes inherited from Object.
%include osg/Callback
%include osg/LineSegment
%include osg/AnimationPath
%include osg/Shader

%ignore osg::Uniform::setUpdateCallback;
%ignore osg::Uniform::getUpdateCallback;
%ignore osg::Uniform::setEventCallback;
%ignore osg::Uniform::getEventCallback;
%ignore osg::Uniform::getParents;
%OPERATOR_RENAME(osg::Uniform)
%include osg/Uniform

%include osg/RenderInfo
%include osg/PrimitiveSet

%include osg/Image
%template(ImageRef) osg::ref_ptr<osg::Image>;

%include osg/ImageStream

%ignore osg::HeightField::getHeight(unsigned int, unsigned int);
%ignore osg::TriangleMesh::setVertices;
%ignore osg::TriangleMesh::getVertices;
%ignore osg::TriangleMesh::setIndices;
%ignore osg::TriangleMesh::getIndices;
%include osg/Shape


%include osg/CullSettings

%ignore osg::StateSet::setUpdateCallback;
%ignore osg::StateSet::getUpdateCallback;
%ignore osg::StateSet::setEventCallback;
%ignore osg::StateSet::getEventCallback;
%ignore osg::StateSet::Callback;

// Method available in const and non-const version: SWIG shadowing warning.
%ignore osg::StateSet::getParents();

// Default parameter "value" hinders SWIG from generating code to look-up
// the ConstHash table. So ignore the default parameter version in the wrapper,
// i.e. the OverrideValue must always be specified in the Tcl version.
%ignore setAttribute(StateAttribute *attribute);

%OPERATOR_RENAME(osg::StateSet)

%include osg/StateSet

%ignore osg::StateAttribute::setUpdateCallback;
%ignore osg::StateAttribute::getUpdateCallback;
%ignore osg::StateAttribute::setEventCallback;
%ignore osg::StateAttribute::getEventCallback;
%ignore osg::StateAttribute::getModeUsage;
%ignore osg::StateAttribute::ModeUsage;

%OPERATOR_RENAME(osg::StateAttribute)

%include osg/StateAttribute

// Classes inherited from StateAttribute.
%include osg/AlphaFunc
%ignore osg::BlendColor::getExtensions;
%ignore osg::BlendColor::setExtensions;
%include osg/BlendColor
%ignore osg::BlendEquation::getExtensions;
%ignore osg::BlendEquation::setExtensions;
%include osg/BlendEquation
%ignore osg::BlendFunc::getExtensions;
%ignore osg::BlendFunc::setExtensions;
%include osg/BlendFunc
%ignore osg::ClampColor::getExtensions;
%ignore osg::ClampColor::setExtensions;
%include osg/ClampColor
%include osg/ClipPlane
%include osg/ColorMask
%include osg/ColorMatrix
%include osg/CullFace
%include osg/Depth
%include osg/Fog
%ignore osg::FragmentProgram::getExtensions;
%ignore osg::FragmentProgram::setExtensions;
%include osg/FragmentProgram
// OPA TODO: FBO include file generates a SWIG parse error.
// %include osg/FrameBufferObject
%include osg/FrontFace
%include osg/Hint
%include osg/Light
%template(LightRef) osg::ref_ptr<osg::Light>;

%include osg/LightModel
%include osg/LineStipple
%include osg/LineWidth
%include osg/LogicOp
%include osg/Material
%ignore osg::Multisample::getExtensions;
%ignore osg::Multisample::setExtensions;
%include osg/Multisample
%ignore osg::Point::getExtensions;
%ignore osg::Point::setExtensions;
%include osg/Point
%include osg/PointSprite
%feature("notabstract") osg::PolygonMode;
%include osg/PolygonMode
%include osg/PolygonOffset
%include osg/PolygonStipple
%ignore osg::Program::getUniformBlocks;
%include osg/Program
%ignore osg::Scissor::x()      const;
%ignore osg::Scissor::y()      const;
%ignore osg::Scissor::width()  const;
%ignore osg::Scissor::height() const;
%include osg/Scissor
%include osg/ShadeModel
%include osg/Stencil
%ignore osg::StencilTwoSided::getExtensions;
%ignore osg::StencilTwoSided::setExtensions;
%include osg/StencilTwoSided
%include osg/TexEnv
%include osg/TexEnvCombine
%include osg/TexEnvFilter
%include osg/TexGen
%include osg/TexMat
%ignore osg::Texture::getExtensions;
%ignore osg::Texture::setExtensions;
%ignore osg::Texture::getTextureObjectManager;
%include osg/Texture
%template(TextureRef) osg::ref_ptr<osg::Texture>;

%ignore osg::VertexProgram::getExtensions;
%ignore osg::VertexProgram::setExtensions;
%include osg/VertexProgram
%ignore osg::Viewport::x()      const;
%ignore osg::Viewport::y()      const;
%ignore osg::Viewport::width()  const;
%ignore osg::Viewport::height() const;
%include osg/Viewport

// Classes inherited from Texture.
%feature("notabstract") osg::Texture1D;
%feature("notabstract") osg::Texture2D;
%feature("notabstract") osg::Texture3D;

%ignore osg::Texture1D::setSubloadCallback;
%ignore osg::Texture1D::getSubloadCallback;
%include osg/Texture1D
%ignore osg::Texture2D::setSubloadCallback;
%ignore osg::Texture2D::getSubloadCallback;
%include osg/Texture2D
%ignore osg::Texture2DArray::setSubloadCallback;
%ignore osg::Texture2DArray::getSubloadCallback;
%include osg/Texture2DArray
%ignore osg::Texture3D::setSubloadCallback;
%ignore osg::Texture3D::getSubloadCallback;
%ignore osg::Texture3D::getExtensions;
%ignore osg::Texture3D::setExtensions;
%include osg/Texture3D
%ignore osg::TextureCubeMap::setSubloadCallback;
%ignore osg::TextureCubeMap::getSubloadCallback;
%ignore osg::TextureCubeMap::getExtensions;
%ignore osg::TextureCubeMap::setExtensions;
%include osg/TextureCubeMap
%ignore osg::TextureRectangle::setSubloadCallback;
%ignore osg::TextureRectangle::getSubloadCallback;
%include osg/TextureRectangle


// NodeVisitors are handled specially within tcl3dOsgNodeVisitor to enable
// visitor procs written in Tcl. So we ignore everything which generates
// SWIG warnings.
%ignore osg::NodeVisitor::setDatabaseRequestHandler;
%ignore osg::NodeVisitor::getDatabaseRequestHandler;
%ignore osg::NodeVisitor::setImageRequestHandler;
%ignore osg::NodeVisitor::getImageRequestHandler;

%ignore osg::PushPopValue;

%ignore osg::NodeVisitor::NodeVisitor(TraversalMode tm);
%ignore osg::NodeAcceptOp;

%include osg/NodeVisitor

// To return a Tcl string ignore the version of getDescription without const.
%ignore osg::Node::getDescription(unsigned int i);

// Method available in const and non-const version: SWIG shadowing warning.
%ignore osg::Node::getParents();

%ignore osg::Node::setComputeBoundingSphereCallback;
%ignore osg::Node::getComputeBoundingSphereCallback;

%extend osg::Node {
    osg::Group * asGroup () {
        return dynamic_cast <osg::Group *> (self);
    }
    osg::MatrixTransform * asMatrixTransform () {
        return dynamic_cast <osg::MatrixTransform *> (self);
    }
    osgSim::DOFTransform * asDOFTransform () {
        return dynamic_cast <osgSim::DOFTransform *> (self);
    }
};

%include osg/Node
%template(NodeRef)    osg::ref_ptr<osg::Node>;
// Wrapper for osg::NodePath
%template(NodeStdVec) std::vector<osg::Node*>;

// Classes inherited from Node.

// Drawable and classes derived from Drawable.

/* osg::Drawable: Ignore functions that handle nested classes. 
 * Nested classes itself are globally ignored by setting the -w312
 * SWIG command line option.
 */
%ignore osg::Drawable::getUpdateCallback;
%ignore osg::Drawable::setUpdateCallback;
%ignore osg::Drawable::getComputeBoundingBoxCallback;
%ignore osg::Drawable::setComputeBoundingBoxCallback;
%ignore osg::Drawable::getEventCallback;
%ignore osg::Drawable::setEventCallback;
%ignore osg::Drawable::getDrawCallback;
%ignore osg::Drawable::setDrawCallback;
%ignore osg::Drawable::getCullCallback;
%ignore osg::Drawable::setCullCallback;
%ignore osg::Drawable::supports;
%ignore osg::Drawable::accept;
%ignore osg::Drawable::getExtensions;
%ignore osg::Drawable::setExtensions;
// Method available in const and non-const version: SWIG shadowing warning.
%ignore osg::Drawable::getParents();

%include osg/Drawable


%ignore osg::Geometry::s_InvalidArrayData;
%ignore osg::Geometry::setTexCoordIndices;
%ignore osg::Geometry::getTexCoordIndices;
%ignore osg::Geometry::setVertexAttribIndices;
%ignore osg::Geometry::getVertexAttribIndices;
%ignore osg::Geometry::setVertexIndices;
%ignore osg::Geometry::getVertexIndices;
%ignore osg::Geometry::setVertexData;
%ignore osg::Geometry::getVertexData;
%ignore osg::Geometry::setNormalData;
%ignore osg::Geometry::getNormalData;
%ignore osg::Geometry::setVertexAttribData;
%ignore osg::Geometry::getVertexAttribData;
%ignore osg::Geometry::setNormalIndices;
%ignore osg::Geometry::getNormalIndices;
%ignore osg::Geometry::setColorData;
%ignore osg::Geometry::getColorData;
%ignore osg::Geometry::setSecondaryColorIndices;
%ignore osg::Geometry::getSecondaryColorIndices;
%ignore osg::Geometry::setSecondaryColorData;
%ignore osg::Geometry::getSecondaryColorData;
%ignore osg::Geometry::setFogCoordIndices;
%ignore osg::Geometry::getFogCoordIndices;
%ignore osg::Geometry::setFogCoordData;
%ignore osg::Geometry::getFogCoordData;
%ignore osg::Geometry::setTexCoordData;
%ignore osg::Geometry::getTexCoordData;
%ignore deprecated_osg::Geometry;
%include osg/Geometry
%template(GeometryRef) osg::ref_ptr<osg::Geometry>;

%include osg/DrawPixels
%include osg/ShapeDrawable
// End of Drawable and classes derived from Drawable.

%include osg/Group
%template(GroupRef)    osg::ref_ptr<osg::Group>;
// Wrapper for osg::ParentList
%template(GroupStdVec) std::vector<osg::Group*>;


// Classes inherited from Group.
%include osg/Geode
%template(GeodeRef) osg::ref_ptr<osg::Geode>;
%include osg/ClearNode
%include osg/ClipNode
%include osg/CoordinateSystemNode
%include osg/LightSource
%include osg/LOD
%template(LODRef) osg::ref_ptr<osg::LOD>;

// Classes inherited from Geode.
%include osg/Billboard
%template(BillboardRef) osg::ref_ptr<osg::Billboard>;

%ignore osg::QueryGeometry;
%ignore osg::initOQState;
%ignore osg::initOQDebugState;
%include osg/OccluderNode
%include osg/OcclusionQueryNode
%include osg/Projection
%template(ProjectionRef) osg::ref_ptr<osg::Projection>;

%include osg/ProxyNode
%template(ProxyNodeRef) osg::ref_ptr<osg::ProxyNode>;

%include osg/Sequence
%include osg/Switch
%template(SwitchRef) osg::ref_ptr<osg::Switch>;

%include osg/TexGenNode
%ignore osg::Transform::asPositionAttitudeTransform;
%include osg/Transform
%template(TransformRef) osg::ref_ptr<osg::Transform>;

// Classes inherited from LOD.
%include osg/PagedLOD
%template(PagedLODRef) osg::ref_ptr<osg::PagedLOD>;

// Classes inherited from Transform.
%ignore osg::Camera::Attachment;
%ignore osg::Camera::getBufferAttachmentMap;
%ignore osg::Camera::getBufferAttachmentMap;
%ignore osg::Camera::DrawCallback;
%ignore osg::Camera::setPreDrawCallback;
%ignore osg::Camera::getPreDrawCallback;
%ignore osg::Camera::setPostDrawCallback;
%ignore osg::Camera::getPostDrawCallback;
%ignore osg::Camera::setIntialDrawCallback;
%ignore osg::Camera::setInitialDrawCallback;
%ignore osg::Camera::getInitialDrawCallback;
%ignore osg::Camera::setFinalDrawCallback;
%ignore osg::Camera::getFinalDrawCallback;

%include osg/AutoTransform
%template(AutoTransformRef) osg::ref_ptr<osg::AutoTransform>;

%include osg/Camera
%template(CameraRef) osg::ref_ptr<osg::Camera>;

%include osg/CameraView
%template(CameraViewRef) osg::ref_ptr<osg::CameraView>;

%include osg/MatrixTransform
%template(MatrixTransformRef) osg::ref_ptr<osg::MatrixTransform>;

%include osg/PositionAttitudeTransform


%ignore osg::View::getSlave;
%ignore osg::View::findSlaveForCamera;
%include osg/View



%ignore osg::GraphicsContext::setCreateGraphicsContextCallback;
%ignore osg::GraphicsContext::getCreateGraphicsContextCallback;
%ignore osg::GraphicsContext::setWindowingSystemInterface;
%ignore osg::GraphicsContext::getWindowingSystemInterface;
%ignore osg::GraphicsContext::setResizedCallback;
%ignore osg::GraphicsContext::getResizedCallback;
%ignore osg::GraphicsContext::createGraphicsContext;
%ignore osg::GraphicsContext::getTraits;

%include osg/GraphicsContext

%include osg/Observer
// TODO %ignore osg::State::DynamicObjectRenderingCompletedCallback;
%include osg/State

%rename(get) osg::Operation::operator (); 
%include osg/OperationThread

// TODO %ignore osg::EndOfDynamicDrawBlock;
%include osg/GraphicsThread

/*
 * Section for wrapping file osg/ArgumentParser.
 */

%ignore osg::ArgumentParser::read;        // Use nested class as parameter.
%ignore osg::ArgumentParser::operator []; // Redefined as method get.

//%template(ErrorMessageMap) std::map<std::string,osg::ArgumentParser::ErrorSeverity>;

// The following typemap without a corresponding free typemap is a memory leak.
// ArgumentParser does not create a copy of the argument list, so we cannot
// free argv after calling the constructor.
// As the ArgumentParser is typically used only at the main level, we ignore
// this memory leak.
%typemap(in) (int *argc, char ** argv) {
    Tcl_Obj **listobjv;
    int       nitems;
    int       i;
    int      *argcp = (int *) malloc (sizeof (int));

    if (Tcl_ListObjGetElements(interp, $input, &nitems, &listobjv) == TCL_ERROR) {
        return TCL_ERROR;
    }
    *argcp = nitems;
    $1 = argcp;
    $2 = (char **) malloc ((nitems+1)*sizeof (char *));
    for (i = 0; i < nitems; i++) {
        $2[i] = Tcl_GetStringFromObj (listobjv[i],0);
    }
    $2[i] = 0;
}

// Put the extension methods after the include of the header files,
// so that new defined methods of equal signature are overwritten.
%extend osg::ArgumentParser {
    // Additional method for returning a string instead of writing to
    // a C++ iostream.
    std::string writeErrorMessages (ErrorSeverity severity=BENIGN) {
        std::stringstream s;
        self->writeErrorMessages (s, severity);
        return s.str();
    }

    int getNumArgs () {
        return self->argc();
    }
 
    // Replacement for operator []
    const char* get (int pos) const {
        return (*self)[pos];
    }
};

%include osg/ArgumentParser

/*
 * Section for wrapping file osg/ApplicationUsage.
 */

%extend osg::ApplicationUsage {
    // Additional method for returning a string instead of writing to
    // a C++ iostream.
    std::string write (unsigned int type=COMMAND_LINE_OPTION,
                       unsigned int widthOfOutput=80,
                       bool showDefaults=false) {
        std::stringstream s;
        self->write(s, type, widthOfOutput, showDefaults);
        return s.str();
    }

    // Additional method for returning a string instead of writing to
    // a C++ iostream.
    std::string writeEnvironmentSettings () {
        std::stringstream s;
        self->writeEnvironmentSettings (s);
        return s.str();
    }
};

%include osg/ApplicationUsage

#ifdef USE_SWIG_PRE_203
  %import "osgUtil.i"
  %import "osgText.i"
  %import "osgSim.i"
  %import "osgAnimation.i"
  %import "osgParticle.i"
#endif
