/******************************************************************************
 *{@C
 *      Copyright:      2010-2018 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dViewMath.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for OpenGL compatible viewing 
 *                      transformation functions.
 *                      These are needed as a replacement for the deprecated
 *                      funtionality of the fixed-function pipeline introduced
 *                      in OpenGL 3.
 *
 *****************************************************************************/

#ifndef __TCL3D_VIEWMATH_H__
#define __TCL3D_VIEWMATH_H__

#ifdef __cplusplus
   extern "C" {
#endif

    void tcl3dOrtho (double left, double right, 
                     double bottom, double top,
                     double zNear, double zFar,
                     float *res);
    void tcl3dFrustum (double left, double right,
                       double bottom, double top,
                       double zNear, double zFar,
                       float *res);
    void tcl3dPerspective (double fovy, double aspect,
                           double zNear, double zFar,
                           float *res);
    void tcl3dPerspectiveWithOffset (double fovX, double fovY,
                                     double zNear, double zFar,
                                     int winWidth, int winHeight,
                                     int subWidth, int subHeight,
                                     int offX, int offY, 
                                     float *res);
    void tcl3dLookAt (double eyeX, double eyeY, double eyeZ, 
                      double centerX, double centerY, double centerZ,
                      double upX, double upY, double upZ,
                      float *res);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_VIEWMATH_H__ */
