/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;

public abstract class AbstractComponentGraphResolveState<T extends ComponentGraphResolveMetadata, S extends ComponentResolveMetadata>
implements ComponentGraphResolveState,
ComponentArtifactResolveState {
    private final long instanceId;
    private final T graphMetadata;
    private final S artifactMetadata;
    private final AttributeDesugaring attributeDesugaring;

    public AbstractComponentGraphResolveState(long instanceId, T graphMetadata, S artifactMetadata, AttributeDesugaring attributeDesugaring) {
        this.instanceId = instanceId;
        this.graphMetadata = graphMetadata;
        this.artifactMetadata = artifactMetadata;
        this.attributeDesugaring = attributeDesugaring;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.graphMetadata.getId();
    }

    public T getMetadata() {
        return this.graphMetadata;
    }

    public S getArtifactMetadata() {
        return this.artifactMetadata;
    }

    @Override
    public GraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        Optional<List<? extends VariantGraphResolveState>> variants = this.getVariantsForGraphTraversal();
        return new DefaultGraphSelectionCandidates(variants);
    }

    @Override
    public boolean isAdHoc() {
        return false;
    }

    protected abstract Optional<List<? extends VariantGraphResolveState>> getVariantsForGraphTraversal();

    @Override
    @Nullable
    public ComponentGraphResolveState maybeAsLenientPlatform(ModuleComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier) {
        return null;
    }

    @Override
    public ComponentArtifactResolveState prepareForArtifactResolution() {
        return this;
    }

    @Override
    public void resolveArtifactsWithType(ArtifactResolver artifactResolver, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        artifactResolver.resolveArtifactsWithType(this.getResolveMetadata(), artifactType, result);
    }

    protected List<? extends Capability> capabilitiesFor(CapabilitiesMetadata variantCapabilities) {
        List capabilities = variantCapabilities.getCapabilities();
        capabilities = capabilities.isEmpty() ? ImmutableList.of((Object)DefaultImmutableCapability.defaultCapabilityForComponent(this.getMetadata().getModuleVersionId())) : ImmutableList.copyOf((Collection)capabilities);
        return capabilities;
    }

    private class DefaultGraphSelectionCandidates
    implements GraphSelectionCandidates {
        private final Optional<List<? extends VariantGraphResolveState>> variants;

        public DefaultGraphSelectionCandidates(Optional<List<? extends VariantGraphResolveState>> variants) {
            this.variants = variants;
        }

        @Override
        public boolean isUseVariants() {
            return this.variants.isPresent() && !this.variants.get().isEmpty();
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariants() {
            return this.variants.get();
        }

        @Override
        @Nullable
        public ConfigurationGraphResolveState getLegacyConfiguration() {
            return AbstractComponentGraphResolveState.this.getConfiguration("default");
        }

        @Override
        public List<? extends ConfigurationGraphResolveMetadata> getCandidateConfigurations() {
            Set<String> configurationNames = AbstractComponentGraphResolveState.this.graphMetadata.getConfigurationNames();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (String configurationName : configurationNames) {
                ConfigurationGraphResolveMetadata configuration = AbstractComponentGraphResolveState.this.graphMetadata.getConfiguration(configurationName);
                if (!configuration.isCanBeConsumed()) continue;
                builder.add((Object)configuration);
            }
            return builder.build();
        }
    }

    protected abstract class AbstractVariantGraphResolveState
    implements VariantGraphResolveState {
        private final Lazy<ResolvedVariantResult> publicView = Lazy.locking().of(() -> this.createVariantResult(null));

        @Override
        public boolean isAdHoc() {
            return AbstractComponentGraphResolveState.this.isAdHoc();
        }

        @Override
        public ResolvedVariantResult getVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            if (externalVariant != null) {
                return this.createVariantResult(externalVariant);
            }
            return (ResolvedVariantResult)this.publicView.get();
        }

        private DefaultResolvedVariantResult createVariantResult(@Nullable ResolvedVariantResult externalVariant) {
            VariantGraphResolveMetadata metadata = this.getMetadata();
            return new DefaultResolvedVariantResult(AbstractComponentGraphResolveState.this.getId(), Describables.of((Object)metadata.getName()), (AttributeContainer)AbstractComponentGraphResolveState.this.attributeDesugaring.desugar(metadata.getAttributes()), AbstractComponentGraphResolveState.this.capabilitiesFor(metadata.getCapabilities()), externalVariant);
        }
    }
}

