/* ex: set tabstop=4 noet: */
/**
 *
 */

#ifndef FACTS_H
#define FACTS_H

#include "lanmap.h"
#include "protocols.h"
#include "lhash.h"


int reporting_init(void);


#ifndef HASH_SLOTS_MAC
	#define HASH_SLOTS_MAC	503
#endif

#ifndef HASH_SLOTS_IP
	#define HASH_SLOTS_IP	503
#endif


#define HINT_OS_MAX		5 /* maximum OS entries */

/**
 * 
 */
typedef struct {
	int id; /*  */
	int certainty; /* scale between 0-100 of how good an indicator we are */ /* NOTE: current unused */
	int len; /* how many OSs we hint for */
	int os[HINT_OS_MAX][3]; /* { OS start, points, OS stop } */
} hint;

/**
 * all possible operating system hints
 * should be in order from network levle lowest->highest
 * and within a grouping from most specific to least specific
 * @note TCP SYN fingerprints are separate as they are more complex, see below
 */
enum {
	HINT_NONE = 0,
	/* MAC */
	HINT_MAC_VEND_APPLE,
	/* ARP */
	HINT_ARP_,
	/* BOOTP */
	HINT_BOOTP_VENDOR_MACOS,
	HINT_BOOTP_VENDOR_MACOS_9,
	HINT_BOOTP_VENDOR_MACOS_92,
	HINT_BOOTP_VENDOR_MACOS_922,
	HINT_BOOTP_VENDOR_MSFT_50,
	HINT_BOOTP_VENDOR_MSFT_51,

	HINT_OOPS_TOO_HIGH
};


/**
 * a tcp signature, a unique fingerprint of a tcp stack in action which
 * we can use to derive the implementation
 */
struct tcp_sig {
	int ttl;
	int df;
	int window;
	int headlen;
	int ts; /* -1 if doesn't exist, 0 for 0 tsval, 1 for non-zero tsval */
	int ws;
	int opts;
	int opt[TCP_OPTS_MAX];
	int oslen;
	int os[HINT_OS_MAX][3];
};

/**
 * an ICMP Echo Req/"ping" signature/fingerprint
 */
struct ping_sig {
	int type;
	int ttl; /* IP ttl -1==wildcard */
	int seq_msbf; /* ICMP sequence number is msbf?  1=msbf, 0=lsbf, -1=doesn't matter */
	int id; /* ICMP echo id  -1==wildcard */
	int df; /* IP dontfrag set? 1=yes, 0=no, -1=wildcard */
	int plbytes; /* length of payload >=0=matters, -1=wildcard */
	int ploffset; /* offset of data to match (for 8-bytes Muuss ts, i.e.) */
	size_t plpatlen; /* length of data pattern, which may appear partially or be repeated in the match */
	const u_char *payload; /*  */
	int oslen;
	int os[HINT_OS_MAX][3];
};

/**
 * 
 */
#define BOOTP_SIG_FLAGS_MAX 25
struct bootp_sig {
	int ttl;
	int type; /* IP lowdelay flag set */
	int flags;
	u_char flag[BOOTP_SIG_FLAGS_MAX];
	int flagreqs;
	u_char flagreq[BOOTP_SIG_FLAGS_MAX];
	int oslen;
	int os[HINT_OS_MAX][3];
};


/**
 *
 */
enum {
	FACT_UNKNOWN = 0,

	/* Role */
	/* NOTE: if you add a role, make sure to modify FACT_ROLE_* in facts.c */
	FACT_ROLE = 0x400,
	FACT_ROLE_DESKTOP,
	FACT_ROLE_LAPTOP,
	FACT_ROLE_PRINTER,
	FACT_ROLE_ROUTER,
	FACT_ROLE_SWITCH,
	FACT_ROLE_HOST,
	FACT_ROLE_REPEATER,
	FACT_ROLE_BRIDGE,
	FACT_ROLE_ACCESS_POINT,
	FACT_ROLE_WIFI_CLIENT,
	FACT_ROLE_SERVER,
	FACT_ROLE_SERVER_WEB,
	FACT_ROLE_SERVER_MAIL,
	FACT_ROLE_SERVER_DNS,
	FACT_ROLE_SERVER_SMB,
	FACT_ROLE_SERVER_PRINTER,
	FACT_ROLE_SERVER_SQL,
	FACT_ROLE_SERVER_FILES,
	FACT_ROLE_SERVER_DHCP,
	/* ... */
	FACT_ROLE_CLIENT_WEB,
	FACT_ROLE_CLIENT_MAIL,
	FACT_ROLE_CLIENT_DNS,
	FACT_ROLE_CLIENT_PRINTER,
	FACT_ROLE_CLIENT_SQL,
	/* ... */
	FACT_ROLE_WHOOPS_TOO_HIGH,

	/* Properties */
	FACT_PROP = 0x800,
	FACT_PROP_EXISTS,
	FACT_PROP_ALIVE,
	FACT_PROP_HOSTNAME,
	FACT_PROP_UPTIME,
	FACT_PROP_REBOOT,
	FACT_PROP_DHCP,
	FACT_PROP_OUTSIDE_TRAFFIC,
	FACT_PROP_WIRELESS,
	FACT_PROP_WHOOPS_TOO_HIGH,

	/* Hardware */
	FACT_HW = 0x2000,
	FACT_HW_LINKSYS,
	FACT_HW_CISCO,
	FACT_HW_CISCO_CATALYST,
	FACT_HW_APPLE,
	FACT_HW_APPLE_IBOOK,
	FACT_HW_APPLE_POWERBOOK,
	FACT_HW_APPLE_POWER_MAC,
	FACT_HW_APPLE_POWER_MAC_G4,
	FACT_HW_APPLE_POWER_MAC_G4_GRAPHITE,
	FACT_HW_WHOOPS_TOO_HIGH,

	FACT_WHOOPS_TOO_HIGH
};
#define FACT_BUFLEN				32

/**
 *
 */
enum {
	SURE_UNKNOWN = 0,
	SURE_POSSIBLY,
	SURE_MAYBE,
	SURE_PROBABLY,
	SURE_VERY,
	SURE_POSITIVE,
	SURE_WHOOPS_TOO_HIGH

};
#define SURE_BUFLEN				16


/**
 *
 */
enum {
	CMP_UNKNOWN = 0,
	CMP_EQ,
	CMP_NEQ,
	CMP_GT,
	CMP_GTE,
	CMP_LT,
	CMP_LTE,
	CMP_WHOOPS_TOO_HIGH
};
#define CMP_BUFLEN			8

enum {
	TYPE_UNKNOWN,
	TYPE_STR,
	TYPE_IP,
	TYPE_MAC,
	TYPE_WHOOPS_TOO_HIGH
};

/* exported */

void report_mac(const struct mac *);
void report_mac_fact(const struct mac *, int fact);
void report_mac_ip(const struct mac *, const struct ip *);
void report_mac_os(const struct mac *, int os, int sure, const char *extra);
void report_mac_relation_by_mac(int, const struct mac *, struct mac *);
void report_mac_traffic(const struct mac *from, const struct mac *to, size_t *, size_t *);
void report_mac_bootp_sig(const struct mac *, int hint);


void report_ip_fact(const struct ip *, int fact);
void report_ip_subnet(const struct ip *, const struct ip *);
void report_ip_hostname(const struct ip *, const char *);
void report_ip_domain(const struct ip *, const char *);
void report_reboot(const struct ip *);
void report_ip_relation(int, const struct ip *, const struct ip *);
void report_ip_traffic(const struct mac *macfrom, const struct ip *ipfrom, const struct mac *macto, const struct ip *ipto);

/* new and improved functions for reporting OS hints... need to nuke previous */
void report_mac_hint(const struct mac *, int hint);
void report_ip_hint(const struct ip *, int hint);
void report_ip_tcp_syn_sig(const struct ip *, int hint);
void report_ip_ping_sig(const struct ip *, int hint);


const char * fact_to_str(int); /* too basic? */
const char * sure_to_str(int);
const char * cmp_to_str(int);
const char * hint_to_str(int);

void check_dump(void);
void dump_world(void);

/* callbacks for hashtables */

int ip_cmp(const void *va, const void *vb);
void * ip_copy(void *v);

int mac_ip_ptr_cmp(const void *, const void *);
void * mac_ip_ptr_copy(void *v);


#endif /* FACTS_H */


