/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import mill.api.PathRef$;
import mill.api.PathRef$Revalidate$Always$;
import mill.api.PathRef$Revalidate$Never$;
import mill.api.PathRef$Revalidate$Once$;
import mill.moduledefs.Scaladoc;
import os.Path;
import os.Shellable;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import upickle.core.Types;

@Scaladoc(value="/**\n * A wrapper around `os.Path` that calculates it's hashcode based\n * on the contents of the filesystem underneath it. Used to ensure filesystem\n * changes can bust caches which are keyed off hashcodes.\n */")
@ScalaSignature(bytes="\u0006\u0005\rEa\u0001\u0002-Z\u0001zC\u0001\u0002\u001e\u0001\u0003\u0016\u0004%\t!\u001e\u0005\ty\u0002\u0011\t\u0012)A\u0005m\"AQ\u0010\u0001BK\u0002\u0013\u0005a\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0012)A\u0005\u007f\"Q\u0011q\u0001\u0001\u0003\u0016\u0004%\t!!\u0003\t\u0015\u0005E\u0001A!E!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u0014\u0001\u0011)\u001a!C\u0001\u0003+A!B!,\u0001\u0005#\u0005\u000b\u0011BA\f\u0011\u001d\t\t\u0004\u0001C\u0005\u0005_CqA!/\u0001\t\u0003\u0011I\u0001C\u0004\u0003<\u0002!\tA!0\t\u000f\t}\u0006\u0001\"\u0003\u0003B\"I!1\u001a\u0001\u0012\u0002\u0013%!Q\u001a\u0005\n\u0005#\u0004\u0011\u0013!C\u0005\u00053B\u0011Ba5\u0001#\u0003%IA!6\t\u0013\te\u0007!%A\u0005\n\tm\u0007b\u0002Bp\u0001\u0011\u0005!\u0011\u001d\u0005\b\u0005K\u0004A\u0011AAV\u0011\u001d\u0011Y\u0001\u0001C!\u0005OD\u0011\"!5\u0001\u0003\u0003%\t%a5\t\u0013\u0005\u0005\b!!A\u0005\u0002\u0005%\u0001\"CAr\u0001\u0005\u0005I\u0011\u0001B|\u0011%\t\t\u0010AA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0001\u0003|\"I!q \u0001\u0002\u0002\u0013\u00053\u0011\u0001\u0005\n\u0005\u000f\u0001\u0011\u0011!C!\u0005\u0013A\u0011b!\u0002\u0001\u0003\u0003%\tea\u0002\b\u000f\u0005u\u0011\f#\u0001\u0002 \u00191\u0001,\u0017E\u0001\u0003CAq!!\r\u001e\t\u0003\t\u0019\u0004C\u0004\u00026u!\u0019!a\u000e\u0007\r\u0005\u0015S\u0004AA$\u0011\u001d\t\t\u0004\tC\u0001\u0003\u0013B\u0011\"a\u0014!\u0005\u0004%I!!\u0015\t\u0011\u0005\r\u0004\u0005)A\u0005\u0003'Bq!!\u001a!\t\u0003\t9\u0007C\u0004\u0002\b\u0002\"\t!!#\t\u0015\u0005EUD1A\u0005\u0002m\u000b\u0019\n\u0003\u0005\u0002 v\u0001\u000b\u0011BAK\r\u0019\t\t+\b\u0001\u0002$\"Q\u0011\u0011\u000f\u0015\u0003\u0006\u0004%\t!a+\t\u0015\u00055\u0006F!A!\u0002\u0013\t\u0019\u0005C\u0004\u00022!\"\t!a,\u0007\u0013\u0005UV\u0004%A\u0012\"\u0005]va\u0002B\u001e;!\u0005\u0011\u0011\u0019\u0004\b\u0003kk\u0002\u0012AA_\u0011\u001d\t\tD\fC\u0001\u0003\u007f;q!a1/\u0011\u0003\u000b)MB\u0004\u0002J:B\t)a3\t\u000f\u0005E\u0012\u0007\"\u0001\u0002P\"I\u0011\u0011[\u0019\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003C\f\u0014\u0011!C\u0001\u0003\u0013A\u0011\"a92\u0003\u0003%\t!!:\t\u0013\u0005E\u0018'!A\u0005B\u0005M\b\"\u0003B\u0001c\u0005\u0005I\u0011\u0001B\u0002\u0011%\u00119!MA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\fE\n\t\u0011\"\u0011\u0003\u000e!I!qB\u0019\u0002\u0002\u0013%!\u0011C\u0004\b\u00053q\u0003\u0012\u0011B\u000e\r\u001d\u0011iB\fEA\u0005?Aq!!\r=\t\u0003\u0011\t\u0003C\u0005\u0002Rr\n\t\u0011\"\u0011\u0002T\"I\u0011\u0011\u001d\u001f\u0002\u0002\u0013\u0005\u0011\u0011\u0002\u0005\n\u0003Gd\u0014\u0011!C\u0001\u0005GA\u0011\"!==\u0003\u0003%\t%a=\t\u0013\t\u0005A(!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0004y\u0005\u0005I\u0011\tB\u0005\u0011%\u0011Y\u0001PA\u0001\n\u0003\u0012i\u0001C\u0005\u0003\u0010q\n\t\u0011\"\u0003\u0003\u0012\u001d9!1\u0006\u0018\t\u0002\n5baBA^]!\u0005%q\u0006\u0005\b\u0003c9E\u0011\u0001B\u0019\u0011%\t\tnRA\u0001\n\u0003\n\u0019\u000eC\u0005\u0002b\u001e\u000b\t\u0011\"\u0001\u0002\n!I\u00111]$\u0002\u0002\u0013\u0005!1\u0007\u0005\n\u0003c<\u0015\u0011!C!\u0003gD\u0011B!\u0001H\u0003\u0003%\tAa\u000e\t\u0013\t\u001dq)!A\u0005B\t%\u0001\"\u0003B\u0006\u000f\u0006\u0005I\u0011\tB\u0007\u0011%\u0011yaRA\u0001\n\u0013\u0011\t\u0002C\u0004\u0003>u!\tAa\u0010\t\u000f\tuR\u0004\"\u0001\u0003J!I!qK\u000f\u0012\u0002\u0013\u0005!\u0011\f\u0005\n\u0005_j\u0012\u0013!C\u0001\u0005cBqA!\u001e\u001e\t\u0007\u00119\bC\u0004\u0003\u001cv!IA!(\t\u0013\t=Q$!A\u0005\n\tE!a\u0002)bi\"\u0014VM\u001a\u0006\u00035n\u000b1!\u00199j\u0015\u0005a\u0016\u0001B7jY2\u001c\u0001a\u0005\u0003\u0001?\u0016D\u0007C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'AB!osJ+g\r\u0005\u0002aM&\u0011q-\u0019\u0002\b!J|G-^2u!\tI\u0017O\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011Q.X\u0001\u0007yI|w\u000e\u001e \n\u0003\tL!\u0001]1\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003a\u0006\fA\u0001]1uQV\ta\u000f\u0005\u0002xu6\t\u0001PC\u0001z\u0003\ty7/\u0003\u0002|q\n!\u0001+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0015\tX/[2l+\u0005y\bc\u00011\u0002\u0002%\u0019\u00111A1\u0003\u000f\t{w\u000e\\3b]\u00061\u0011/^5dW\u0002\n1a]5h+\t\tY\u0001E\u0002a\u0003\u001bI1!a\u0004b\u0005\rIe\u000e^\u0001\u0005g&<\u0007%\u0001\u0006sKZ\fG.\u001b3bi\u0016,\"!a\u0006\u0011\u0007\u0005eAFD\u0002\u0002\u001cqi\u0011!W\u0001\b!\u0006$\bNU3g!\r\tY\"H\n\u0005;}\u000b\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0005%|'BAA\u0017\u0003\u0011Q\u0017M^1\n\u0007I\f9#\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003?\t\u0011b\u001d5fY2\f'\r\\3\u0015\t\u0005e\u0012q\b\t\u0004o\u0006m\u0012bAA\u001fq\nI1\u000b[3mY\u0006\u0014G.\u001a\u0005\b\u0003\u0003z\u0002\u0019AA\"\u0003\u0005\u0001\bcAA\u000e\u0001\tqa+\u00197jI\u0006$X\r\u001a)bi\"\u001c8C\u0001\u0011`)\t\tY\u0005E\u0002\u0002N\u0001j\u0011!H\u0001\u0004[\u0006\u0004XCAA*!!\t)&a\u0018\u0002\f\u0005\rSBAA,\u0015\u0011\tI&a\u0017\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002^\u0005-\u0012\u0001B;uS2LA!!\u0019\u0002X\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002\t5\f\u0007\u000fI\u0001\u001ae\u00164\u0018\r\\5eCR,\u0017J\u001a(fK\u0012,Gm\u0014:UQJ|w\u000f\u0006\u0003\u0002j\u0005=\u0004c\u00011\u0002l%\u0019\u0011QN1\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003c\"\u0003\u0019AA\"\u0003\u001d\u0001\u0018\r\u001e5SK\u001aDs\u0001JA;\u0003\u0003\u000b\u0019\t\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tYhW\u0001\u000b[>$W\u000f\\3eK\u001a\u001c\u0018\u0002BA@\u0003s\u0012\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000b\u000b!qM\u0018+U)\u0001\u0003\u0005\t\u0011!U\u0001\u0012VM^1mS\u0012\fG/Z:!i\",\u0007eZ5wK:\u00043l\u0017)bi\"\u0014VMZ/^Y\u0001Jg\r\t:fcVL'/\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011+A%#\be^5mY\u0002zg\u000e\\=!e\u00164\u0018\r\\5eCR,\u0007%\u0019\u0011\\7B\u000bG\u000f\u001b*fMvk\u0006%\u001b4!SR<3\u000f\t<bYV,\u0007EZ8sAm[\u0006+\u0019;i%\u00164gF]3wC2LG-\u0019;f;v\u00033/Y=tAM|\u0007%\u00198eA\u0005d7o\u001c\u0011d_:\u001c\u0018\u000eZ3sg\u0002\"\b.\u001a\u0011qe\u00164\u0018n\\;tYf\u0004#/\u001a<bY&$\u0017\r^3eAA\fG\u000f[:/\u0015\u0001\u0002\u0003\u0005\t\u0011+A\u0001#\bN]8xg\u0002\u0002\u0016\r\u001e5SK\u001a4\u0016\r\\5eCRLwN\\#yG\u0016\u0004H/[8oA%3\u0007%\u0019\u0011uQ\u0016\u00043l\u0017)bi\"\u0014VMZ/^A9,W\rZ:!e\u00164\u0018\r\\5eCRLwN\u001c\u0011xQ&\u001c\u0007\u000e\t4bS2\u001c(\u0002\t\u0011!A\u0001Rs&A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002j!:\u0001%!\u001e\u0002\u0002\u00065\u0015EAAH\u0003\u0005mrF\u000b\u0016\u000bA\u0001\u0002#\u0006\t+iSN\u00043\r\\1tg\u0002j\u0017-\u001b8uC&t7\u000fI1!G\u0006\u001c\u0007.\u001a\u0011pM\u0002\nGN]3bIf\u0004c/\u00197jI\u0006$X\r\u001a\u0011qCRD7O\f\u0006!A\u0001R\u0003%\u0013;!SN\u0004C\u000f\u001b:fC\u0012l3/\u00194fA\u0005tG\rI7fC:$\b\u0005^8!E\u0016\u00043\u000f[1sK\u0012\u0004#-\u001a;xK\u0016t\u0007\u0005\u001e5sK\u0006$7\u000f\f\u0011f]\u001dt\u0003%\u001b8!C\u0002\"\u0006N]3bI2{7-\u00197/\u0015\u0001\u0002\u0003EK\u0018\u0002\u001dY\fG.\u001b3bi\u0016$\u0007+\u0019;igV\u0011\u0011Q\u0013\t\u0007\u0003/\u000bY*a\u0013\u000e\u0005\u0005e%bAA/C&!\u0011QTAM\u0005=!\u0015P\\1nS\u000e4\u0016M]5bE2,\u0017a\u0004<bY&$\u0017\r^3e!\u0006$\bn\u001d\u0011\u00035A\u000bG\u000f\u001b*fMZ\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\u0014\u0007!\n)\u000bE\u0002j\u0003OK1!!+t\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|g.\u0006\u0002\u0002D\u0005A\u0001/\u0019;i%\u00164\u0007\u0005\u0006\u0003\u00022\u0006M\u0006cAA'Q!9\u0011\u0011O\u0016A\u0002\u0005\r#A\u0003*fm\u0006d\u0017\u000eZ1uKN\u0011AfX\u0015\u0005Y\u001d\u000bDH\u0001\u0004BY^\f\u0017p]\n\u0003]}#\"!!1\u0011\u0007\u00055c&A\u0003OKZ,'\u000fE\u0002\u0002HFj\u0011A\f\u0002\u0006\u001d\u00164XM]\n\u0007c}\u000bi-\u001a5\u0011\u0007\u00055C\u0006\u0006\u0002\u0002F\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!6\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u0002,\u0005!A.\u00198h\u0013\u0011\ty.!7\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a:\u0002nB\u0019\u0001-!;\n\u0007\u0005-\u0018MA\u0002B]fD\u0011\"a<6\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0010\u0005\u0004\u0002x\u0006u\u0018q]\u0007\u0003\u0003sT1!a?b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\fIP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA@\u0003\u0006!I\u0011q^\u001c\u0002\u0002\u0003\u0007\u0011q]\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111B\u0001\ti>\u001cFO]5oOR\u0011\u0011Q[\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005'\u0001B!a6\u0003\u0016%!!qCAm\u0005\u0019y%M[3di\u0006!qJ\\2f!\r\t9\r\u0010\u0002\u0005\u001f:\u001cWm\u0005\u0004=?\u00065W\r\u001b\u000b\u0003\u00057!B!a:\u0003&!I\u0011q\u001e!\u0002\u0002\u0003\u0007\u00111\u0002\u000b\u0004\u007f\n%\u0002\"CAx\u0005\u0006\u0005\t\u0019AAt\u0003\u0019\tEn^1zgB\u0019\u0011qY$\u0014\r\u001d{\u0016QZ3i)\t\u0011i\u0003\u0006\u0003\u0002h\nU\u0002\"CAx\u0017\u0006\u0005\t\u0019AA\u0006)\ry(\u0011\b\u0005\n\u0003_l\u0015\u0011!a\u0001\u0003O\f!BU3wC2LG-\u0019;f\u0003\u0015\t\u0007\u000f\u001d7z))\t\u0019E!\u0011\u0003D\t\u0015#q\t\u0005\u0006iF\u0003\rA\u001e\u0005\u0006{F\u0003\ra \u0005\b\u0003\u000f\t\u0006\u0019AA\u0006\u0011\u001d\t\u0019\"\u0015a\u0001\u0003\u001b$\u0002\"a\u0011\u0003L\t5#q\n\u0005\u0006iJ\u0003\rA\u001e\u0005\b{J\u0003\n\u00111\u0001\u0000\u0011%\t\u0019B\u0015I\u0001\u0002\u0004\ti\rK\u0004S\u0003k\n\tIa\u0015\"\u0005\tU\u0013A! 0U)R\u0001\u0005\t\u0011+A\r\u0013X-\u0019;fA\u0005\u00043l\u0017)bi\"\u0014VMZ/^A\tL\bE]3dkJ\u001c\u0018N^3ms\u0002\"\u0017nZ3ti&tw\r\t;iK\u0002\u001awN\u001c;f]R\u0004sN\u001a\u0011bA\u001dLg/\u001a8!AB\fG\u000f\u001b1/\u0015\u0001\u0002\u0003E\u000b\u0006!A\u0001R\u0003\u0005\u00119be\u0006l\u0007\u0005]1uQ\u0002\"\u0006.\u001a\u0011eS\u001e,7\u000f^3eAA\fG\u000f\u001b\u0018\u000bA\u0001\u0002#\u0006\t!qCJ\fW\u000eI9vS\u000e\\\u0007%\u00134!AR\u0014X/\u001a1!i\",\u0007\u0005Z5hKN$\b%[:!_:d\u0017\u0010\t2bg\u0016$\u0007\u0005^8!g>lW\r\t4jY\u0016\u0004\u0013\r\u001e;sS\n,H/Z:!Q1L7.\u001a\u0011ni&lW\rI1oI\u0002\u001a\u0018N_3*])\u0001\u0003\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u0002g-\u00197tK\u0002\u0004C\u000f[3!I&<Wm\u001d;!SN\u00043M]3bi\u0016$\u0007e\u001c4!i\",\u0007EZ5mKN\u00043m\u001c8uK:$hF\u0003\u0011!A)\u0002\u0003I]3ukJt'\u0002\t\u0011!U=\nq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u00057R3a B/W\t\u0011y\u0006\u0005\u0003\u0003b\t-TB\u0001B2\u0015\u0011\u0011)Ga\u001a\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B5C\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5$1\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM$\u0006BAg\u0005;\nQB[:p]\u001a{'/\\1ui\u0016\u0014XC\u0001B=!\u0019\u0011YH!#\u0002D9!!Q\u0010BB\u001d\rY'qP\u0005\u0003\u0005\u0003\u000bq!\u001e9jG.dW-\u0003\u0003\u0003\u0006\n\u001d\u0015a\u00023fM\u0006,H\u000e\u001e\u0006\u0003\u0005\u0003KAAa#\u0003\u000e\nQ!+Z1e/JLG/\u001a:\n\t\t=%\u0011\u0013\u0002\u0006)f\u0004Xm\u001d\u0006\u0005\u0005'\u00139)\u0001\u0003d_J,\u0007fB+\u0002v\u0005\u0005%qS\u0011\u0003\u00053\u000bag\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011EK\u001a\fW\u000f\u001c;!\u0015N{e\n\t4pe6\fG\u000f^3sA\u0019|'\u000fI.\\!\u0006$\bNU3g;vs#\u0002\t\u0011!U=\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003 \n-\u0006#\u00021\u0003\"\n\u0015\u0016b\u0001BRC\n1q\n\u001d;j_:\u0004\u0012\u0002\u0019BTm~\fY!!4\n\u0007\t%\u0016M\u0001\u0004UkBdW\r\u000e\u0005\b\u0003c2\u0006\u0019AA\"\u0003-\u0011XM^1mS\u0012\fG/\u001a\u0011\u0015\u0015\u0005\r#\u0011\u0017BZ\u0005k\u00139\fC\u0003u\u0013\u0001\u0007a\u000fC\u0003~\u0013\u0001\u0007q\u0010C\u0004\u0002\b%\u0001\r!a\u0003\t\u000f\u0005M\u0011\u00021\u0001\u0002\u0018\u0005a!/Z2p[B,H/Z*jO\u0006Aa/\u00197jI\u0006$X\rF\u0001\u0000\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005\r#1\u0019Bc\u0005\u000f\u0014I\rC\u0004u\u0019A\u0005\t\u0019\u0001<\t\u000fud\u0001\u0013!a\u0001\u007f\"I\u0011q\u0001\u0007\u0011\u0002\u0003\u0007\u00111\u0002\u0005\n\u0003'a\u0001\u0013!a\u0001\u0003/\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003P*\u001aaO!\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001BlU\u0011\tYA!\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001c\u0016\u0005\u0003/\u0011i&\u0001\bxSRD'+\u001a<bY&$\u0017\r^3\u0015\t\u0005\r#1\u001d\u0005\b\u0003'\t\u0002\u0019AA\f\u0003I9\u0018\u000e\u001e5SKZ\fG.\u001b3bi\u0016|enY3\u0015\u0005\t%\b\u0003\u0002Bv\u0005gtAA!<\u0003pB\u00111.Y\u0005\u0004\u0005c\f\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002`\nU(b\u0001ByCR!\u0011q\u001dB}\u0011%\tyOFA\u0001\u0002\u0004\tY\u0001F\u0002\u0000\u0005{D\u0011\"a<\u0019\u0003\u0003\u0005\r!a:\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003+\u001c\u0019\u0001C\u0005\u0002pf\t\t\u00111\u0001\u0002\f\u00051Q-];bYN$2a`B\u0005\u0011%\tyoGA\u0001\u0002\u0004\t9\u000fK\u0004\u0001\u0003k\n\ti!\u0004\"\u0005\r=\u0011!a)0U)R\u0001E\u000b\u0011BA]\u0014\u0018\r\u001d9fe\u0002\n'o\\;oI\u0002\u0002wn\u001d\u0018QCRD\u0007\r\t;iCR\u00043-\u00197dk2\fG/Z:!SR<3\u000f\t5bg\"\u001cw\u000eZ3!E\u0006\u001cX\r\u001a\u0006!U\u0001zg\u000e\t;iK\u0002\u001awN\u001c;f]R\u001c\be\u001c4!i\",\u0007EZ5mKNL8\u000f^3nAUtG-\u001a:oK\u0006$\b\u000eI5u]\u0001*6/\u001a3!i>\u0004SM\\:ve\u0016\u0004c-\u001b7fgf\u001cH/Z7\u000bA)\u00023\r[1oO\u0016\u001c\beY1oA\t,8\u000f\u001e\u0011dC\u000eDWm\u001d\u0011xQ&\u001c\u0007\u000eI1sK\u0002ZW-_3eA=4g\r\t5bg\"\u001cw\u000eZ3t])\u0001#f\f")
public class PathRef
implements Product,
Serializable {
    private final Path path;
    private final boolean quick;
    private final int sig;
    private final Revalidate revalidate;

    @Scaladoc(value="/**\n   * Default JSON formatter for [[PathRef]].\n   */")
    public static Types.ReadWriter<PathRef> jsonFormatter() {
        return PathRef$.MODULE$.jsonFormatter();
    }

    public static Revalidate apply$default$3() {
        return PathRef$.MODULE$.apply$default$3();
    }

    public static boolean apply$default$2() {
        return PathRef$.MODULE$.apply$default$2();
    }

    @Scaladoc(value="/**\n   * Create a [[PathRef]] by recursively digesting the content of a given `path`.\n   *\n   * @param path The digested path.\n   * @param quick If `true` the digest is only based to some file attributes (like mtime and size).\n   *              If `false` the digest is created of the files content.\n   * @return\n   */")
    public static PathRef apply(Path path, boolean quick, Revalidate revalidate) {
        return PathRef$.MODULE$.apply(path, quick, revalidate);
    }

    public static PathRef apply(Path path, boolean quick, int sig, Revalidate revalidate) {
        return PathRef$.MODULE$.apply(path, quick, sig, revalidate);
    }

    public static Shellable shellable(PathRef p) {
        return PathRef$.MODULE$.shellable(p);
    }

    @Override
    public Iterator<String> productElementNames() {
        return Product.productElementNames$(this);
    }

    public Path path() {
        return this.path;
    }

    public boolean quick() {
        return this.quick;
    }

    public int sig() {
        return this.sig;
    }

    public Revalidate revalidate() {
        return this.revalidate;
    }

    public int recomputeSig() {
        return PathRef$.MODULE$.apply(this.path(), this.quick(), PathRef$.MODULE$.apply$default$3()).sig();
    }

    public boolean validate() {
        return this.recomputeSig() == this.sig();
    }

    private PathRef copy(Path path, boolean quick, int sig, Revalidate revalidate) {
        return PathRef$.MODULE$.apply(path, quick, sig, revalidate);
    }

    private Path copy$default$1() {
        return this.path();
    }

    private boolean copy$default$2() {
        return this.quick();
    }

    private int copy$default$3() {
        return this.sig();
    }

    private Revalidate copy$default$4() {
        return this.revalidate();
    }

    public PathRef withRevalidate(Revalidate revalidate) {
        Revalidate x$1 = revalidate;
        Path x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    public PathRef withRevalidateOnce() {
        PathRef$Revalidate$Once$ x$1 = PathRef$Revalidate$Once$.MODULE$;
        Path x$2 = this.copy$default$1();
        boolean x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    public String toString() {
        String string;
        String quick = this.quick() ? "qref:" : "ref:";
        Revalidate revalidate = this.revalidate();
        if (PathRef$Revalidate$Never$.MODULE$.equals(revalidate)) {
            string = "v0:";
        } else if (PathRef$Revalidate$Once$.MODULE$.equals(revalidate)) {
            string = "v1:";
        } else if (PathRef$Revalidate$Always$.MODULE$.equals(revalidate)) {
            string = "vn:";
        } else {
            throw new MatchError(revalidate);
        }
        String valid = string;
        String sig = String.format("%08x", Predef$.MODULE$.int2Integer(this.sig()));
        return new StringBuilder(1).append(quick).append(valid).append(sig).append(":").append(this.path().toString()).toString();
    }

    @Override
    public String productPrefix() {
        return "PathRef";
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.path();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean(this.quick());
            }
            case 2: {
                return BoxesRunTime.boxToInteger(this.sig());
            }
            case 3: {
                return this.revalidate();
            }
        }
        return Statics.ioobe(x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof PathRef;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "path";
            }
            case 1: {
                return "quick";
            }
            case 2: {
                return "sig";
            }
            case 3: {
                return "revalidate";
            }
        }
        return (String)Statics.ioobe(x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.anyHash(this.path()));
        n = Statics.mix(n, this.quick() ? 1231 : 1237);
        n = Statics.mix(n, this.sig());
        n = Statics.mix(n, Statics.anyHash(this.revalidate()));
        return Statics.finalizeHash(n, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PathRef)) return false;
        boolean bl = true;
        if (!bl) return false;
        PathRef pathRef = (PathRef)x$1;
        if (this.quick() != pathRef.quick()) return false;
        if (this.sig() != pathRef.sig()) return false;
        Path path = this.path();
        Path path2 = pathRef.path();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Revalidate revalidate = this.revalidate();
        Revalidate revalidate2 = pathRef.revalidate();
        if (revalidate == null) {
            if (revalidate2 != null) {
                return false;
            }
        } else if (!revalidate.equals(revalidate2)) return false;
        if (!pathRef.canEqual(this)) return false;
        return true;
    }

    public PathRef(Path path, boolean quick, int sig, Revalidate revalidate) {
        this.path = path;
        this.quick = quick;
        this.sig = sig;
        this.revalidate = revalidate;
        Product.$init$(this);
    }

    public static class PathRefValidationException
    extends RuntimeException {
        private final PathRef pathRef;

        public PathRef pathRef() {
            return this.pathRef;
        }

        public PathRefValidationException(PathRef pathRef) {
            this.pathRef = pathRef;
            super(new StringBuilder(33).append("Invalid path signature detected: ").append(pathRef).toString());
        }
    }

    public static interface Revalidate {
    }

    @Scaladoc(value="/**\n   * This class maintains a cache of already validated paths.\n   * It is thread-safe and meant to be shared between threads, e.g. in a ThreadLocal.\n   */")
    public static class ValidatedPaths {
        private final ConcurrentHashMap<Object, PathRef> map = new ConcurrentHashMap();

        private ConcurrentHashMap<Object, PathRef> map() {
            return this.map;
        }

        @Scaladoc(value="/**\n     * Revalidates the given [[PathRef]], if required.\n     * It will only revalidate a [[PathRef]] if it's value for [[PathRef.revalidate]] says so and also considers the previously revalidated paths.\n     * @throws PathRefValidationException If a the [[PathRef]] needs revalidation which fails\n     */")
        public void revalidateIfNeededOrThrow(PathRef pathRef) {
            Revalidate revalidate = pathRef.revalidate();
            if (PathRef$Revalidate$Never$.MODULE$.equals(revalidate)) {
                return;
            }
            if (PathRef$Revalidate$Once$.MODULE$.equals(revalidate) && this.map().contains(BoxesRunTime.boxToInteger(ValidatedPaths.mapKey$1(pathRef)))) {
                return;
            }
            if (PathRef$Revalidate$Once$.MODULE$.equals(revalidate) ? true : PathRef$Revalidate$Always$.MODULE$.equals(revalidate)) {
                int changedSig = PathRef$.MODULE$.apply(pathRef.path(), pathRef.quick(), PathRef$.MODULE$.apply$default$3()).sig();
                if (pathRef.sig() != changedSig) {
                    throw new PathRefValidationException(pathRef);
                }
                PathRef pathRef2 = this.map().put(BoxesRunTime.boxToInteger(ValidatedPaths.mapKey$1(pathRef)), pathRef);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError(revalidate);
        }

        public void clear() {
            this.map().clear();
        }

        private static final int mapKey$1(PathRef pr) {
            return new Tuple3<Path, Boolean, Integer>(pr.path(), BoxesRunTime.boxToBoolean(pr.quick()), BoxesRunTime.boxToInteger(pr.sig())).hashCode();
        }
    }
}

