/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.math.BigDecimal;
import java.util.ArrayList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CostToken
extends AbstractNonEmptyToken<Spell>
implements CDOMPrimaryToken<Spell> {
    public String getTokenName() {
        return "COST";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, Spell spell, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().remove((CDOMObject)spell, ObjectKey.COST);
        } else {
            try {
                BigDecimal cost = new BigDecimal(value);
                if (cost.compareTo(BigDecimal.ZERO) <= 0) {
                    return new ParseResult.Fail(this.getTokenName() + " requires a positive Integer", context);
                }
                context.getObjectContext().put((CDOMObject)spell, ObjectKey.COST, (Object)cost);
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
            }
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        BigDecimal i = (BigDecimal)context.getObjectContext().getObject((CDOMObject)spell, ObjectKey.COST);
        boolean globalClear = context.getObjectContext().wasRemoved((CDOMObject)spell, ObjectKey.COST);
        ArrayList<String> list = new ArrayList<String>();
        if (globalClear) {
            list.add(".CLEAR");
        }
        if (i != null) {
            if (i.compareTo(BigDecimal.ZERO) <= 0) {
                context.addWriteMessage(this.getTokenName() + " requires a positive Integer");
                return null;
            }
            list.add(i.toString());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

