/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.html2.HTMLOptionElement;
import org.w3c.dom.html2.HTMLOptionsCollection;

class InputSelectControl
extends BaseInputControl {
    private final JComboBox comboBox;
    private final JList list;
    private final DefaultListModel listModel;
    private boolean inSelectionEvent;
    private static final int STATE_NONE = 0;
    private static final int STATE_COMBO = 1;
    private static final int STATE_LIST = 2;
    private int state = 0;
    private boolean suspendSelections = false;
    private int selectedIndex = -1;

    public InputSelectControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        final JComboBox comboBox = new JComboBox();
        comboBox.addItemListener(new ItemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void itemStateChanged(ItemEvent e) {
                block6: {
                    OptionItem item = (OptionItem)e.getItem();
                    if (item == null) break block6;
                    switch (e.getStateChange()) {
                        case 1: {
                            if (InputSelectControl.this.suspendSelections) break;
                            InputSelectControl.this.inSelectionEvent = true;
                            try {
                                int selectedIndex = comboBox.getSelectedIndex();
                                HTMLSelectElementImpl selectElement = (HTMLSelectElementImpl)modelNode;
                                selectElement.setSelectedIndex(selectedIndex);
                            }
                            finally {
                                InputSelectControl.this.inSelectionEvent = false;
                            }
                            HtmlController.getInstance().onChange(modelNode);
                            break;
                        }
                    }
                }
            }
        });
        final DefaultListModel listModel = new DefaultListModel();
        final JList list = new JList(listModel);
        this.listModel = listModel;
        list.setSelectionMode(2);
        list.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !InputSelectControl.this.suspendSelections) {
                    boolean changed = false;
                    InputSelectControl.this.inSelectionEvent = true;
                    try {
                        int modelSize = listModel.getSize();
                        for (int i = 0; i < modelSize; ++i) {
                            boolean newIsSelected;
                            boolean oldIsSelected;
                            OptionItem item = (OptionItem)listModel.get(i);
                            if (item == null || (oldIsSelected = item.isSelected()) == (newIsSelected = list.isSelectedIndex(i))) continue;
                            changed = true;
                            item.setSelected(newIsSelected);
                        }
                    }
                    finally {
                        InputSelectControl.this.inSelectionEvent = false;
                    }
                    if (changed) {
                        HtmlController.getInstance().onChange(modelNode);
                    }
                }
            }
        });
        this.comboBox = comboBox;
        this.list = list;
        this.resetItemList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetItemList() {
        HTMLSelectElementImpl selectElement = (HTMLSelectElementImpl)this.controlElement;
        boolean isMultiple = selectElement.getMultiple();
        if (isMultiple && this.state != 2) {
            this.state = 2;
            this.removeAll();
            JScrollPane scrollPane = new JScrollPane(this.list);
            this.add(scrollPane);
        } else if (!isMultiple && this.state != 1) {
            this.state = 1;
            this.removeAll();
            this.add(this.comboBox);
        }
        this.suspendSelections = true;
        try {
            HTMLOptionsCollection optionElements = selectElement.getOptions();
            if (this.state == 1) {
                JComboBox comboBox = this.comboBox;
                HTMLOptionElement priorSelectedOption = null;
                int priorIndex = selectElement.getSelectedIndex();
                if (priorIndex != -1) {
                    int numOptions = optionElements.getLength();
                    for (int index = 0; index < numOptions; ++index) {
                        HTMLOptionElement option = (HTMLOptionElement)optionElements.item(index);
                        if (index != priorIndex) continue;
                        priorSelectedOption = option;
                    }
                }
                comboBox.removeAllItems();
                OptionItem defaultItem = null;
                OptionItem selectedItem = null;
                OptionItem firstItem = null;
                int numOptions = optionElements.getLength();
                for (int index = 0; index < numOptions; ++index) {
                    HTMLOptionElement option = (HTMLOptionElement)optionElements.item(index);
                    if (option == null) continue;
                    OptionItem item = new OptionItem(option);
                    if (firstItem == null) {
                        firstItem = item;
                        comboBox.addItem(item);
                        selectElement.setSelectedIndex(-1);
                        if (priorSelectedOption != null) {
                            priorSelectedOption.setSelected(true);
                        }
                    } else {
                        comboBox.addItem(item);
                    }
                    if (option.getSelected()) {
                        selectedItem = item;
                    }
                    if (!option.getDefaultSelected()) continue;
                    defaultItem = item;
                }
                if (selectedItem != null) {
                    comboBox.setSelectedItem(selectedItem);
                } else if (defaultItem != null) {
                    comboBox.setSelectedItem(defaultItem);
                } else if (firstItem != null) {
                    comboBox.setSelectedItem(firstItem);
                }
            } else {
                Integer si;
                JList list = this.list;
                LinkedList<Integer> defaultSelectedIndexes = null;
                LinkedList<Integer> selectedIndexes = null;
                OptionItem firstItem = null;
                DefaultListModel listModel = this.listModel;
                listModel.clear();
                int numOptions = optionElements.getLength();
                for (int index = 0; index < numOptions; ++index) {
                    HTMLOptionElement option = (HTMLOptionElement)optionElements.item(index);
                    OptionItem item = new OptionItem(option);
                    if (firstItem == null) {
                        firstItem = item;
                        listModel.addElement(item);
                        list.setSelectedIndex(-1);
                    } else {
                        listModel.addElement(item);
                    }
                    if (option.getSelected()) {
                        if (selectedIndexes == null) {
                            selectedIndexes = new LinkedList<Integer>();
                        }
                        selectedIndexes.add(new Integer(index));
                    }
                    if (!option.getDefaultSelected()) continue;
                    if (defaultSelectedIndexes == null) {
                        defaultSelectedIndexes = new LinkedList<Integer>();
                    }
                    defaultSelectedIndexes.add(new Integer(index));
                }
                if (selectedIndexes != null && selectedIndexes.size() != 0) {
                    Iterator sii = selectedIndexes.iterator();
                    while (sii.hasNext()) {
                        si = (Integer)sii.next();
                        list.addSelectionInterval(si, si);
                    }
                } else if (defaultSelectedIndexes != null && defaultSelectedIndexes.size() != 0) {
                    Iterator sii = defaultSelectedIndexes.iterator();
                    while (sii.hasNext()) {
                        si = (Integer)sii.next();
                        list.addSelectionInterval(si, si);
                    }
                }
            }
        }
        finally {
            this.suspendSelections = false;
        }
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        this.resetItemList();
    }

    public String getValue() {
        if (this.state == 1) {
            OptionItem item = (OptionItem)this.comboBox.getSelectedItem();
            return item == null ? null : item.getValue();
        }
        OptionItem item = (OptionItem)this.list.getSelectedValue();
        return item == null ? null : item.getValue();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int value) {
        this.selectedIndex = value;
        boolean prevSuspend = this.suspendSelections;
        this.suspendSelections = true;
        try {
            if (!this.inSelectionEvent) {
                if (this.state == 1) {
                    int size;
                    JComboBox comboBox = this.comboBox;
                    if (comboBox.getSelectedIndex() != value && value < (size = comboBox.getItemCount())) {
                        comboBox.setSelectedIndex(value);
                    }
                } else {
                    int size;
                    JList list = this.list;
                    int[] selectedIndices = list.getSelectedIndices();
                    if ((selectedIndices == null || selectedIndices.length != 1 || selectedIndices[0] != value) && value < (size = this.listModel.getSize())) {
                        list.setSelectedIndex(value);
                    }
                }
            }
        }
        finally {
            this.suspendSelections = prevSuspend;
        }
    }

    public int getVisibleSize() {
        return this.comboBox.getMaximumRowCount();
    }

    public void setVisibleSize(int value) {
        this.comboBox.setMaximumRowCount(value);
    }

    public void resetInput() {
        this.list.setSelectedIndex(-1);
        this.comboBox.setSelectedIndex(-1);
    }

    public String[] getValues() {
        if (this.state == 1) {
            String[] stringArray;
            OptionItem item = (OptionItem)this.comboBox.getSelectedItem();
            if (item == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = item.getValue();
            }
            return stringArray;
        }
        Object[] values = this.list.getSelectedValues();
        if (values == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            OptionItem item = (OptionItem)values[i];
            al.add(item.getValue());
        }
        return al.toArray(new String[0]);
    }

    private static class OptionItem {
        private final HTMLOptionElement option;
        private final String caption;

        public OptionItem(HTMLOptionElement option) {
            this.option = option;
            String label = option.getLabel();
            this.caption = label == null ? option.getText() : label;
        }

        public void setSelected(boolean value) {
            this.option.setSelected(value);
        }

        public boolean isSelected() {
            return this.option.getSelected();
        }

        public String toString() {
            return this.caption;
        }

        public String getValue() {
            String value = this.option.getValue();
            if (value == null) {
                value = this.option.getText();
            }
            return value;
        }
    }
}

