/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.content.DamageReduction;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class DrLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    @Override
    public String getTokenName() {
        return "DR";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList(obj, ListKey.DAMAGE_REDUCTION);
            return ParseResult.SUCCESS;
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        String drString = tok.nextToken();
        ParseResult pr = this.checkForIllegalSeparator('/', drString);
        if (!pr.passed()) {
            return pr;
        }
        String[] values = drString.split("/");
        if (values.length != 2) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage(this.getTokenName() + " failed to build DamageReduction with value " + value);
            cpr.addErrorMessage("  ...expected a String with one / as a separator");
            return cpr;
        }
        Formula formula = FormulaFactory.getFormulaFor(values[0]);
        if (!formula.isValid()) {
            return new ParseResult.Fail("Formula in " + this.getTokenName() + " was not valid: " + formula.toString(), context);
        }
        DamageReduction dr = new DamageReduction(formula, values[1]);
        if (tok.hasMoreTokens()) {
            String currentToken = tok.nextToken();
            Prerequisite prereq = this.getPrerequisite(currentToken);
            if (prereq == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            dr.addPrerequisite(prereq);
        }
        context.getObjectContext().addToList(obj, ListKey.DAMAGE_REDUCTION, dr);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<DamageReduction> changes = context.getObjectContext().getListChanges(obj, ListKey.DAMAGE_REDUCTION);
        Collection<DamageReduction> added = changes.getAdded();
        ArrayList<String> list = new ArrayList<String>();
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        } else if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        if (added != null) {
            for (DamageReduction lw : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(lw.getLSTformat());
                if (lw.hasPrerequisites()) {
                    sb.append("|");
                    sb.append(context.getPrerequisiteString(lw.getPrerequisiteList()));
                }
                set.add(sb.toString());
            }
        }
        list.addAll(set);
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

