/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Globals;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.SourceEntry;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public final class SpellLoader
extends LstObjectFileLoader<Spell> {
    @Override
    public Spell parseLine(LoadContext context, Spell aSpell, String lstLine, SourceEntry source) throws PersistenceLayerException {
        StringTokenizer colToken;
        Spell spell = aSpell;
        boolean isnew = false;
        if (spell == null) {
            spell = new Spell();
            isnew = true;
        }
        if ((colToken = new StringTokenizer(lstLine, "\t")).hasMoreTokens()) {
            spell.setName(colToken.nextToken().intern());
            spell.put(ObjectKey.SOURCE_CAMPAIGN, source.getCampaign());
            spell.setSourceURI(source.getURI());
            if (isnew) {
                context.addStatefulInformation(spell);
                context.getReferenceContext().importObject(spell);
            }
        }
        while (colToken.hasMoreElements()) {
            LstUtils.processToken(context, spell, source, colToken.nextToken());
        }
        this.completeObject(context, source, spell);
        return null;
    }

    @Override
    protected Spell getObjectKeyed(LoadContext context, String aKey) {
        return Globals.getSpellKeyed(aKey);
    }

    @Override
    protected void performForget(LoadContext context, Spell objToForget) {
        super.performForget(context, objToForget);
        Globals.removeFromSpellMap(objToForget.getKeyName());
    }

    @Override
    protected void addGlobalObject(CDOMObject cdo) {
        if (cdo instanceof Spell) {
            Spell spell = Globals.getSpellMap().get(cdo.getKeyName());
            if (spell == null) {
                Globals.addToSpellMap(cdo.getKeyName(), (Spell)cdo);
            } else {
                ArrayList<Spell> spellList = new ArrayList<Spell>();
                Globals.removeFromSpellMap(spell.getKeyName());
                spellList.add(spell);
            }
        } else {
            Logging.errorPrint("Non-spell object passed: " + cdo);
        }
    }
}

