/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.StringTokenizer;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstFileLoader;
import pcgen.rules.context.LoadContext;

public abstract class LstLineFileLoader
extends Observable {
    protected String gameMode = "*";

    public void loadLstFile(LoadContext context, URI uri) throws PersistenceLayerException {
        StringBuilder dataBuffer = LstFileLoader.readFromURI(uri);
        String aString = dataBuffer.toString();
        if (context != null) {
            context.setSourceURI(uri);
        }
        this.loadLstString(context, uri, aString);
    }

    public void loadLstString(LoadContext context, URI uri, String aString) throws PersistenceLayerException {
        String newlinedelim = "\r\n";
        StringTokenizer fileLines = new StringTokenizer(aString, "\r\n");
        while (fileLines.hasMoreTokens()) {
            String line = fileLines.nextToken().trim();
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            this.parseLine(context, line, uri);
        }
    }

    public void loadLstFile(LoadContext context, URI fileName, String game) throws PersistenceLayerException {
        this.gameMode = game;
        this.loadLstFile(context, fileName);
    }

    public void loadLstFiles(LoadContext context, List<CampaignSourceEntry> fileList) throws PersistenceLayerException {
        HashSet<CampaignSourceEntry> loadedFiles = new HashSet<CampaignSourceEntry>();
        for (CampaignSourceEntry cse : fileList) {
            if (loadedFiles.contains(cse)) continue;
            this.loadLstFile(context, cse.getURI());
            loadedFiles.add(cse);
        }
    }

    public abstract void parseLine(LoadContext var1, String var2, URI var3) throws PersistenceLayerException;

    public String getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(String gameMode) {
        this.gameMode = gameMode;
    }
}

