/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pcgen.gui2.util.event.DynamicTableColumnModelListener;
import pcgen.gui2.util.table.DynamicTableColumnModel;

public class DefaultDynamicTableColumnModel
extends DefaultTableColumnModel
implements DynamicTableColumnModel {
    private final List<TableColumn> availableColumns = new ArrayList<TableColumn>(5);
    private final List<TableColumn> safeColumns = Collections.unmodifiableList(this.availableColumns);
    private int offset;

    public DefaultDynamicTableColumnModel(int offset) {
        this.offset = offset;
    }

    public DefaultDynamicTableColumnModel(TableColumnModel model, int offset) {
        this(offset);
        ArrayList<TableColumn> allColumns = Collections.list(model.getColumns());
        if (offset < allColumns.size()) {
            this.tableColumns.addAll(allColumns.subList(0, offset));
            this.availableColumns.addAll(allColumns.subList(offset, allColumns.size()));
        }
    }

    public DefaultDynamicTableColumnModel(TableColumnModel model, int offset, int[] visibleColumns) {
        this(model, offset);
        for (int column : visibleColumns) {
            super.addColumn(this.availableColumns.get(column - offset));
        }
    }

    @Override
    public void addDynamicTableColumnModelListener(DynamicTableColumnModelListener listener) {
        this.listenerList.add(DynamicTableColumnModelListener.class, listener);
    }

    @Override
    public void removeDynamicTableColumnModelListener(DynamicTableColumnModelListener listener) {
        this.listenerList.remove(DynamicTableColumnModelListener.class, listener);
    }

    protected void fireAvailableColumnAdded(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DynamicTableColumnModelListener.class) continue;
            ((DynamicTableColumnModelListener)listeners[i + 1]).availableColumnAdded(e);
        }
    }

    protected void fireAvailableColumnRemoved(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DynamicTableColumnModelListener.class) continue;
            ((DynamicTableColumnModelListener)listeners[i + 1]).availableColumnRemove(e);
        }
    }

    @Override
    public void addColumn(TableColumn column) {
        if (this.getColumnCount() < this.offset) {
            super.addColumn(column);
        } else {
            int index = this.availableColumns.size();
            this.availableColumns.add(column);
            this.fireAvailableColumnAdded(new TableColumnModelEvent(this, -1, index));
        }
    }

    @Override
    public void removeColumn(TableColumn column) {
        super.removeColumn(column);
        if (this.availableColumns.contains(column)) {
            int index = this.availableColumns.indexOf(column);
            this.availableColumns.remove(column);
            this.fireAvailableColumnRemoved(new TableColumnModelEvent(this, index, -1));
        }
    }

    @Override
    public List<TableColumn> getAvailableColumns() {
        return this.safeColumns;
    }

    @Override
    public boolean isVisible(TableColumn column) {
        return this.tableColumns.contains(column);
    }

    @Override
    public void setVisible(TableColumn column, boolean visible) {
        if (this.availableColumns.contains(column) && this.isVisible(column) != visible) {
            if (visible) {
                super.addColumn(column);
            } else {
                super.removeColumn(column);
            }
        }
    }
}

