/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.summary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.CharacterLevelFacade;
import pcgen.facade.core.CharacterLevelsFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.Utilities;
import pcgen.gui2.util.SignIcon;
import pcgen.gui2.util.table.TableCellUtilities;

public class ClassLevelTableModel
extends AbstractTableModel
implements ListListener<CharacterLevelFacade>,
ItemListener,
PropertyChangeListener,
CharacterLevelsFacade.HitPointListener,
CharacterLevelsFacade.ClassListener {
    private CharacterLevelsFacade levels;
    private Map<String, Integer> finalLevelMap;
    private CharacterFacade character;
    private Editor editor = new Editor();
    private Editor renderer = new Editor();
    private JComboBox classComboBox;
    private JTable classTable;

    public ClassLevelTableModel(CharacterFacade character, JTable table, JComboBox comboBox) {
        this.character = character;
        this.levels = character.getCharacterLevelsFacade();
        this.finalLevelMap = new HashMap<String, Integer>();
        this.resetLevelMap();
        this.levels.addListListener(this);
        this.levels.addClassListener(this);
        this.levels.addHitPointListener(this);
        this.classComboBox = comboBox;
        this.classTable = table;
    }

    public static void initializeTable(JTable classLevelTable) {
        JTableHeader tableHeader = classLevelTable.getTableHeader();
        tableHeader.setResizingAllowed(false);
        tableHeader.setReorderingAllowed(false);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        columnModel.addColumn(Utilities.createTableColumn(0, "Level", headerRenderer, false));
        columnModel.addColumn(Utilities.createTableColumn(1, "HP", headerRenderer, false));
        columnModel.addColumn(Utilities.createTableColumn(2, "Class (All Levels In Class)", headerRenderer, true));
        classLevelTable.setColumnModel(columnModel);
        classLevelTable.setAutoCreateColumnsFromModel(false);
        classLevelTable.setAutoResizeMode(3);
        classLevelTable.setFocusable(false);
        classLevelTable.setCellSelectionEnabled(false);
        classLevelTable.setRowHeight(20);
    }

    public void install() {
        this.classTable.setModel(this);
        this.classTable.setDefaultRenderer(Object.class, this.renderer);
        this.classTable.setDefaultRenderer(Integer.class, new TableCellUtilities.AlignRenderer(0));
        this.classTable.setDefaultEditor(Object.class, this.editor);
        this.classComboBox.addItemListener(this);
        this.classComboBox.addPropertyChangeListener("model", this);
    }

    public void uninstall() {
        this.classComboBox.removeItemListener(this);
        this.classComboBox.removePropertyChangeListener("model", this);
    }

    private void resetLevelMap() {
        this.finalLevelMap.clear();
        for (int i = this.levels.getSize() - 1; i >= 0; --i) {
            String c = this.levels.getClassTaken((CharacterLevelFacade)this.levels.getElementAt(i)).getKeyName();
            if (this.finalLevelMap.containsKey(c)) continue;
            this.finalLevelMap.put(c, i);
        }
    }

    @Override
    public int getRowCount() {
        return this.levels.getSize() + 1;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return rowIndex >= this.levels.getSize() - 1 && columnIndex == 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == this.levels.getSize()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return rowIndex + 1;
            }
            case 1: {
                return this.levels.getHPGained((CharacterLevelFacade)this.levels.getElementAt(rowIndex));
            }
            case 2: {
                ClassFacade c = this.levels.getClassTaken((CharacterLevelFacade)this.levels.getElementAt(rowIndex));
                String classKey = c.getKeyName();
                if (this.finalLevelMap.get(classKey) == rowIndex) {
                    return c.toString() + " (" + this.character.getClassLevel(c) + ")";
                }
                return c.toString();
            }
        }
        return null;
    }

    @Override
    public void elementAdded(ListEvent<CharacterLevelFacade> e) {
        this.editor.cancelCellEditing();
        int i = e.getIndex();
        String c = this.levels.getClassTaken((CharacterLevelFacade)this.levels.getElementAt(i)).getKeyName();
        this.finalLevelMap.put(c, i);
        this.fireTableDataChanged();
    }

    @Override
    public void elementRemoved(ListEvent<CharacterLevelFacade> e) {
        this.editor.cancelCellEditing();
        this.resetLevelMap();
        this.fireTableDataChanged();
    }

    @Override
    public void elementsChanged(ListEvent<CharacterLevelFacade> e) {
        this.editor.cancelCellEditing();
        this.resetLevelMap();
        this.fireTableDataChanged();
    }

    @Override
    public void elementModified(ListEvent<CharacterLevelFacade> e) {
        this.fireTableDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.fireTableRowsUpdated(this.levels.getSize(), this.levels.getSize());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableRowsUpdated(this.levels.getSize(), this.levels.getSize());
    }

    @Override
    public void classChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.levelChanged(e);
    }

    @Override
    public void hitPointsChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        this.levelChanged(e);
    }

    private void levelChanged(CharacterLevelsFacade.CharacterLevelEvent e) {
        int firstRow = e.getBaseLevelIndex();
        int lastRow = e.affectsHigherLevels() ? this.levels.getSize() - 1 : firstRow;
        this.fireTableRowsUpdated(firstRow, lastRow);
    }

    private class Editor
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer,
    ActionListener {
        private JPanel cellPanel = new JPanel();
        private JLabel cellLabel = new JLabel();
        private JButton addLevelButton = Utilities.createSignButton(SignIcon.Sign.Plus);
        private JButton removeLevelButton = Utilities.createSignButton(SignIcon.Sign.Minus);

        public Editor() {
            this.cellPanel.setLayout(new BoxLayout(this.cellPanel, 0));
            this.cellPanel.setOpaque(true);
            this.addLevelButton.setFocusable(false);
            this.removeLevelButton.setFocusable(false);
            this.addLevelButton.addActionListener(this);
            this.removeLevelButton.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cellPanel.removeAll();
            TableCellUtilities.setToRowBackground(this.cellPanel, table, row);
            this.cellLabel.setForeground(table.getForeground());
            this.cellLabel.setFont(table.getFont());
            if (row == ClassLevelTableModel.this.levels.getSize() - 1) {
                this.cellLabel.setText(value.toString());
                this.cellPanel.add(this.cellLabel);
                this.cellPanel.add(Box.createHorizontalGlue());
                this.cellPanel.add(this.removeLevelButton);
            } else if (row == ClassLevelTableModel.this.levels.getSize()) {
                this.cellLabel.setText("Add Level");
                this.cellPanel.add(Box.createHorizontalGlue());
                this.cellPanel.add(this.cellLabel);
                this.cellPanel.add(Box.createHorizontalStrut(3));
                this.addLevelButton.setEnabled(ClassLevelTableModel.this.classComboBox.getSelectedItem() != null);
                this.cellPanel.add(this.addLevelButton);
            } else {
                this.cellLabel.setText(value.toString());
                this.cellPanel.add(this.cellLabel);
            }
            return this.cellPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.addLevelButton) {
                ClassFacade c = (ClassFacade)ClassLevelTableModel.this.classComboBox.getSelectedItem();
                if (c != null) {
                    ClassLevelTableModel.this.character.addCharacterLevels(new ClassFacade[]{c});
                }
            } else {
                ClassLevelTableModel.this.character.removeCharacterLevels(1);
            }
            this.cancelCellEditing();
        }
    }
}

