/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.equip;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.UIPropertyContext;
import pcgen.gui2.tabs.equip.EquipmentTreeTableModel;
import pcgen.gui2.tabs.models.CharacterTreeCellRenderer;
import pcgen.gui2.util.FontManipulation;
import pcgen.gui2.util.JTreeTable;

public class EquipmentModel
implements ListListener<EquipmentSetFacade>,
ReferenceListener<EquipmentSetFacade>,
TableModelListener {
    private static Font normFont;
    private static Font headerFont;
    private static Font biggerFont;
    private static Font lessFont;
    private final CharacterFacade character;
    private final TreeRenderer treeRenderer;
    private final Map<EquipmentSetFacade, EquipmentTreeTableModel> equipsetMap;
    private final ListFacade<EquipmentSetFacade> equipsets;
    private EquipmentTreeTableModel selectedModel;
    private final JTreeTable treeTable;

    public EquipmentModel(CharacterFacade character, JTreeTable table) {
        this.character = character;
        this.treeTable = table;
        this.treeRenderer = (TreeRenderer)this.treeTable.getTreeCellRenderer();
        this.equipsetMap = new HashMap<EquipmentSetFacade, EquipmentTreeTableModel>();
        this.equipsets = character.getEquipmentSets();
        for (EquipmentSetFacade equipset : this.equipsets) {
            this.equipsetMap.put(equipset, new EquipmentTreeTableModel(character, equipset));
        }
        this.equipsets.addListListener(this);
    }

    public static void initializeTreeTable(JTreeTable treeTable) {
        treeTable.getTree().setRowHeight(0);
        treeTable.setFocusable(false);
        treeTable.getTree().putClientProperty("JTree.lineStyle", "Horizontal");
        normFont = treeTable.getFont();
        headerFont = FontManipulation.title(normFont);
        biggerFont = FontManipulation.title(FontManipulation.xxlarge(normFont));
        lessFont = FontManipulation.less(normFont);
        treeTable.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        CellRenderer renderer = new CellRenderer();
        TableColumn column = new TableColumn(0);
        column.setResizable(true);
        model.addColumn(column);
        model.addColumn(EquipmentModel.createFixedColumn(1, 75, renderer));
        model.addColumn(EquipmentModel.createFixedColumn(2, 75, renderer));
        model.addColumn(EquipmentModel.createFixedColumn(3, 50, renderer));
        model.addColumn(EquipmentModel.createFixedColumn(4, 50, renderer));
        treeTable.setAutoResizeMode(4);
        treeTable.setColumnModel(model);
        treeTable.getTableHeader().setResizingAllowed(false);
        treeTable.setTreeCellRenderer(new TreeRenderer());
    }

    private static TableColumn createFixedColumn(int index, int width, CellRenderer renderer) {
        TableColumn column = new TableColumn(index, width, renderer, null);
        column.setMaxWidth(width);
        column.setResizable(false);
        return column;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.realignRowHeights();
    }

    @Override
    public void elementModified(ListEvent<EquipmentSetFacade> e) {
    }

    public void install() {
        this.treeRenderer.setCharacter(this.character);
        this.selectedModel = this.equipsetMap.get(this.character.getEquipmentSetRef().getReference());
        this.treeTable.setTreeTableModel(this.selectedModel);
        this.treeTable.getModel().addTableModelListener(this);
        this.realignRowHeights();
        this.character.getEquipmentSetRef().addReferenceListener(this);
    }

    public void uninstall() {
        if (this.treeTable != null) {
            this.treeTable.getModel().removeTableModelListener(this);
        }
        this.character.getEquipmentSetRef().removeReferenceListener(this);
        this.treeRenderer.setCharacter(null);
    }

    private void realignRowHeights() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JTree tree = EquipmentModel.this.treeTable.getTree();
                for (int row = 0; row < tree.getRowCount(); ++row) {
                    Rectangle bounds = tree.getRowBounds(row);
                    if (bounds == null || EquipmentModel.this.treeTable.getRowHeight(row) == bounds.height) continue;
                    EquipmentModel.this.treeTable.setRowHeight(row, bounds.height);
                }
            }
        });
    }

    @Override
    public void elementAdded(ListEvent<EquipmentSetFacade> e) {
        this.equipsetMap.put(e.getElement(), new EquipmentTreeTableModel(this.character, e.getElement()));
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentSetFacade> e) {
        this.equipsetMap.remove(e.getElement());
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentSetFacade> e) {
        this.equipsetMap.clear();
        for (EquipmentSetFacade equipset : this.equipsets) {
            this.equipsetMap.put(equipset, new EquipmentTreeTableModel(this.character, equipset));
        }
    }

    @Override
    public void referenceChanged(ReferenceEvent<EquipmentSetFacade> e) {
        this.treeTable.getModel().removeTableModelListener(this);
        this.selectedModel = this.equipsetMap.get(e.getNewReference());
        this.treeTable.setTreeTableModel(this.selectedModel);
        this.treeTable.getModel().addTableModelListener(this);
        this.realignRowHeights();
    }

    private static class TreeRenderer
    extends CharacterTreeCellRenderer {
        private Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();

        private TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            boolean isPhantomSlot;
            String text = String.valueOf(value);
            boolean isEquipNode = value instanceof EquipmentSetFacade.EquipNode;
            boolean bl = isPhantomSlot = isEquipNode && ((EquipmentSetFacade.EquipNode)value).getNodeType() == EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT;
            if (isPhantomSlot) {
                text = "Empty slot";
            }
            super.getTreeCellRendererComponent(tree, text, sel, expanded, leaf, row, focus);
            if (isEquipNode && ((EquipmentSetFacade.EquipNode)value).getParent() == null) {
                this.setFont(biggerFont);
                this.setIcon(null);
            } else if (isPhantomSlot) {
                this.setFont(lessFont);
                this.setForeground(Color.GRAY);
                this.setIcon(null);
            } else {
                this.setFont(normFont);
                EquipmentFacade equip = null;
                if (!this.selected) {
                    this.setForeground(UIPropertyContext.getQualifiedColor());
                }
                if (isEquipNode && ((EquipmentSetFacade.EquipNode)value).getNodeType() == EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) {
                    equip = ((EquipmentSetFacade.EquipNode)value).getEquipment();
                    String path = equip.getIcon().getAbsolutePath();
                    ImageIcon icon = this.iconCache.get(path);
                    if (icon == null) {
                        icon = new ImageIcon(path);
                        this.iconCache.put(path, icon);
                    }
                    this.setIcon(icon);
                    if (!this.character.isQualifiedFor(equip)) {
                        this.setForeground(UIPropertyContext.getNotQualifiedColor());
                    }
                }
            }
            return this;
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            EquipmentSetFacade.EquipNode node = (EquipmentSetFacade.EquipNode)table.getValueAt(row, 0);
            if (node != null && node.getParent() == null) {
                FontManipulation.title(this);
                this.setFont(headerFont);
                Color line = UIManager.getColor("Tree.line");
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, line));
            } else {
                this.setFont(normFont);
            }
            return this;
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(value);
            this.setToolTipText(this.getText());
        }
    }
}

