/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.MapFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.tabs.AbilityChooserTab;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.TodoHandler;
import pcgen.gui2.util.SharedTabPane;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class AbilitiesInfoTab
extends SharedTabPane
implements CharacterInfoTab,
TodoHandler {
    private final AbilityChooserTab abilityTab = new AbilityChooserTab();
    private final TabTitle tabTitle = new TabTitle(Tab.ABILITIES);

    public AbilitiesInfoTab() {
        this.setSharedComponent(this.abilityTab);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(AbilityTabsModel.class, new AbilityTabsModel(character));
        return models;
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(AbilityTabsModel.class).uninstall();
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(AbilityTabsModel.class).install();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    @Override
    public void adviseTodo(String fieldName) {
        this.abilityTab.adviseTodo(fieldName);
    }

    private class AbilityTabsModel
    implements ListListener<AbilityCategoryFacade>,
    ChangeListener {
        private final Map<String, TabInfo> typeMap = new HashMap<String, TabInfo>();
        private final List<TabInfo> tabs = new ArrayList<TabInfo>();
        private final MapFacade<AbilityCategoryFacade, ListFacade<AbilityFacade>> categoryMap;
        private final CharacterFacade character;
        private boolean isInstalled = false;
        private String selectedTitle = null;
        private ListFacade<AbilityCategoryFacade> activeCategories;

        public AbilityTabsModel(CharacterFacade character) {
            this.character = character;
            this.activeCategories = character.getActiveAbilityCategories();
            this.categoryMap = character.getDataSet().getAbilities();
            for (AbilityCategoryFacade category : this.activeCategories) {
                String type = category.getType();
                if (!this.typeMap.containsKey(type)) {
                    this.tabs.add(new TabInfo(type, character));
                    this.populateFullCategoryList(type, this.typeMap.get(type));
                }
                this.typeMap.get((Object)type).categoryList.addElement(category);
            }
            this.selectedTitle = this.tabs.get((int)0).title;
        }

        private void populateFullCategoryList(String type, TabInfo tabInfo) {
            for (AbilityCategoryFacade category : this.categoryMap.getKeys()) {
                if (!type.equals(category.getType())) continue;
                tabInfo.fullCategoryList.addElement(category);
            }
        }

        @Override
        public void elementAdded(ListEvent<AbilityCategoryFacade> e) {
            AbilityCategoryFacade element = e.getElement();
            String type = element.getType();
            if (!this.typeMap.containsKey(type)) {
                int index = e.getIndex();
                if (index > this.tabs.size()) {
                    Logging.log(Logging.WARNING, "Trying to add " + type + " to " + this.tabs + " at index " + index + ". Putting at end.");
                    index = this.tabs.size();
                    this.tabs.add(new TabInfo(type, this.character));
                } else {
                    this.tabs.add(index, new TabInfo(type, this.character));
                }
                this.populateFullCategoryList(type, this.typeMap.get(type));
                if (this.isInstalled) {
                    AbilitiesInfoTab.this.addTab(type, index);
                }
            }
            this.typeMap.get((Object)type).categoryList.addElement(element);
        }

        @Override
        public void elementRemoved(ListEvent<AbilityCategoryFacade> e) {
            AbilityCategoryFacade element = e.getElement();
            String type = element.getType();
            TabInfo info = this.typeMap.get(type);
            info.categoryList.removeElement(element);
            if (info.categoryList.isEmpty()) {
                this.tabs.remove(this.typeMap.remove(type));
                if (this.isInstalled) {
                    AbilitiesInfoTab.this.removeTab(type);
                }
            }
        }

        @Override
        public void elementsChanged(ListEvent<AbilityCategoryFacade> e) {
            HashMap tempMap = new HashMap();
            for (AbilityCategoryFacade category : this.categoryMap.getKeys()) {
                String type = category.getType();
                if (!tempMap.containsKey(type)) {
                    tempMap.put(type, new ArrayList());
                }
                ((List)tempMap.get(type)).add(category);
            }
            for (String type : tempMap.keySet()) {
                if (!this.typeMap.containsKey(type)) {
                    this.tabs.add(new TabInfo(type, this.character));
                    this.populateFullCategoryList(type, this.typeMap.get(type));
                    if (this.isInstalled) {
                        AbilitiesInfoTab.this.addTab(type);
                    }
                }
                this.typeMap.get((Object)type).categoryList.updateContents((List)tempMap.get(type));
            }
            Iterator<String> oldTypes = this.typeMap.keySet().iterator();
            while (oldTypes.hasNext()) {
                String type;
                type = oldTypes.next();
                if (tempMap.containsKey(type)) continue;
                this.tabs.remove(this.typeMap.get(type));
                oldTypes.remove();
                if (!this.isInstalled) continue;
                AbilitiesInfoTab.this.removeTab(type);
            }
        }

        @Override
        public void elementModified(ListEvent<AbilityCategoryFacade> e) {
        }

        public void install() {
            this.activeCategories.addListListener(this);
            for (TabInfo tabInfo : this.tabs) {
                AbilitiesInfoTab.this.addTab(tabInfo.title);
            }
            AbilitiesInfoTab.this.setSelectedIndex(AbilitiesInfoTab.this.indexOfTab(this.selectedTitle));
            AbilitiesInfoTab.this.abilityTab.restoreState(this.typeMap.get((Object)this.selectedTitle).tabData);
            AbilitiesInfoTab.this.addChangeListener(this);
            this.isInstalled = true;
        }

        public void uninstall() {
            AbilitiesInfoTab.this.abilityTab.storeState(this.typeMap.get((Object)this.selectedTitle).tabData);
            AbilitiesInfoTab.this.removeChangeListener(this);
            AbilitiesInfoTab.this.removeAll();
            this.activeCategories.removeListListener(this);
            this.isInstalled = false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            TabInfo tabInfo = this.typeMap.get(this.selectedTitle);
            if (tabInfo != null) {
                AbilitiesInfoTab.this.abilityTab.storeState(tabInfo.tabData);
            }
            if (AbilitiesInfoTab.this.getSelectedIndex() != -1) {
                this.selectedTitle = AbilitiesInfoTab.this.getTitleAt(AbilitiesInfoTab.this.getSelectedIndex());
                if (this.typeMap.get(this.selectedTitle) == null) {
                    Logging.errorPrint("Selected tab " + this.selectedTitle + " at index " + AbilitiesInfoTab.this.getSelectedIndex() + " but there is no typeMap entry for it.");
                    Logging.reportAllThreads();
                }
                AbilitiesInfoTab.this.abilityTab.restoreState(this.typeMap.get((Object)this.selectedTitle).tabData);
            }
        }

        public String toString() {
            return "AbilityTabsModel [tabs=" + this.tabs + ", isInstalled=" + this.isInstalled + ", selectedTitle=" + this.selectedTitle + "]";
        }

        private class TabInfo {
            public final String title;
            public final Hashtable<Object, Object> tabData;
            public final DefaultListFacade<AbilityCategoryFacade> categoryList;
            public final DefaultListFacade<AbilityCategoryFacade> fullCategoryList;

            public TabInfo(String title, CharacterFacade character) {
                this.title = title;
                this.categoryList = new DefaultListFacade();
                this.fullCategoryList = new DefaultListFacade();
                this.tabData = AbilitiesInfoTab.this.abilityTab.createState(character, this.categoryList, this.fullCategoryList, title);
                AbilityTabsModel.this.typeMap.put(title, this);
            }

            public String toString() {
                return "TabInfo [title=" + this.title + ", categoryList=" + this.categoryList + "]";
            }
        }
    }
}

