/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import pcgen.gui2.prefs.PCGenPrefsPanel;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.WholeNumberField;
import pcgen.system.LanguageBundle;

public class HitPointsPanel
extends PCGenPrefsPanel {
    private static String in_hp = LanguageBundle.getString("in_Prefs_hp");
    private JCheckBox maxHpAtFirstLevel = new JCheckBox();
    private JCheckBox maxHpAtFirstClassLevel = new JCheckBox();
    private JRadioButton hpAutomax = new JRadioButton(LanguageBundle.getString("in_Prefs_hpAutoMax"));
    private JRadioButton hpAverage = new JRadioButton(LanguageBundle.getString("in_Prefs_hpAverage"));
    private JRadioButton hpPercentage = new JRadioButton(LanguageBundle.getString("in_Prefs_hpPercentage"));
    private JRadioButton hpStandard = new JRadioButton(LanguageBundle.getString("in_Prefs_hpStandard"));
    private JRadioButton hpUserRolled = new JRadioButton(LanguageBundle.getString("in_Prefs_hpUserRolled"));
    private JRadioButton hpAverageRoundedUp = new JRadioButton(LanguageBundle.getString("in_Prefs_hpAverageRoundedUp"));
    private WholeNumberField hpPct = new WholeNumberField(0, 6);

    public HitPointsPanel() {
        int iRow = 0;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, in_hp);
        title1.setTitleJustification(1);
        this.setBorder(title1);
        gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 21;
        c.insets = new Insets(2, 2, 2, 2);
        ButtonGroup exclusiveGroup = new ButtonGroup();
        Utility.buildConstraints(c, 0, iRow, 0, 1, 0.0, 0.0);
        JLabel label = new JLabel(LanguageBundle.getString("in_Prefs_hpGenLabel"));
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 0, iRow++, 1, 1, 0.0, 0.0);
        label = new JLabel("    ");
        gridbag.setConstraints(label, c);
        this.add(label);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpUserRolled, c);
        this.add(this.hpUserRolled);
        exclusiveGroup.add(this.hpUserRolled);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpStandard, c);
        this.add(this.hpStandard);
        exclusiveGroup.add(this.hpStandard);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpAverage, c);
        this.add(this.hpAverage);
        exclusiveGroup.add(this.hpAverage);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpAutomax, c);
        this.add(this.hpAutomax);
        exclusiveGroup.add(this.hpAutomax);
        Utility.buildConstraints(c, 1, iRow, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpPercentage, c);
        this.add(this.hpPercentage);
        exclusiveGroup.add(this.hpPercentage);
        Utility.buildConstraints(c, 2, iRow++, 1, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpPct, c);
        this.add(this.hpPct);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        gridbag.setConstraints(this.hpAverageRoundedUp, c);
        this.add(this.hpAverageRoundedUp);
        exclusiveGroup.add(this.hpAverageRoundedUp);
        Utility.buildConstraints(c, 0, iRow++, 0, 1, 0.0, 0.0);
        this.maxHpAtFirstLevel.setText(LanguageBundle.getString("in_Prefs_hpMaxAtFirst"));
        this.add((Component)this.maxHpAtFirstLevel, c);
        Utility.buildConstraints(c, 1, iRow++, 0, 1, 0.0, 0.0);
        this.maxHpAtFirstClassLevel.setText(LanguageBundle.getString("in_Prefs_hpMaxAtFirstClass"));
        this.add((Component)this.maxHpAtFirstClassLevel, c);
        Utility.buildConstraints(c, 0, iRow, 4, 1, 1.0, 1.0);
        c.fill = 1;
        label = new JLabel();
        gridbag.setConstraints(label, c);
        this.add(label);
    }

    @Override
    public String getTitle() {
        return in_hp;
    }

    @Override
    public void setOptionsBasedOnControls() {
        if (this.hpStandard.isSelected()) {
            SettingsHandler.setHPRollMethod(0);
        } else if (this.hpAutomax.isSelected()) {
            SettingsHandler.setHPRollMethod(1);
        } else if (this.hpAverage.isSelected()) {
            SettingsHandler.setHPRollMethod(2);
        } else if (this.hpPercentage.isSelected()) {
            SettingsHandler.setHPRollMethod(3);
        } else if (this.hpUserRolled.isSelected()) {
            SettingsHandler.setHPRollMethod(4);
        } else if (this.hpAverageRoundedUp.isSelected()) {
            SettingsHandler.setHPRollMethod(5);
        }
        SettingsHandler.setHPPercent(this.hpPct.getValue());
        SettingsHandler.setHPMaxAtFirstLevel(this.maxHpAtFirstLevel.isSelected());
        SettingsHandler.setHPMaxAtFirstClassLevel(this.maxHpAtFirstClassLevel.isSelected());
    }

    @Override
    public void applyOptionValuesToControls() {
        switch (SettingsHandler.getHPRollMethod()) {
            case 1: {
                this.hpAutomax.setSelected(true);
                break;
            }
            case 2: {
                this.hpAverage.setSelected(true);
                break;
            }
            case 3: {
                this.hpPercentage.setSelected(true);
                break;
            }
            case 4: {
                this.hpUserRolled.setSelected(true);
                break;
            }
            case 5: {
                this.hpAverageRoundedUp.setSelected(true);
                break;
            }
            default: {
                this.hpStandard.setSelected(true);
            }
        }
        this.hpPct.setValue(SettingsHandler.getHPPercent());
        this.maxHpAtFirstLevel.setSelected(SettingsHandler.isHPMaxAtFirstLevel());
        this.maxHpAtFirstClassLevel.setSelected(SettingsHandler.isHPMaxAtFirstClassLevel());
    }
}

