/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.facade.core.ChooserFacade;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.gui2.util.PrettyIntegerFormat;
import pcgen.system.LanguageBundle;
import pcgen.util.chooser.ChooserFactory;

public class StatApplication {
    public static final int askForStatIncrease(PlayerCharacter aPC, int statsToChoose, boolean isPre) {
        if (isPre && !Globals.checkRule("INTBEFORE")) {
            return statsToChoose;
        }
        String titleKey = "in_statTitle";
        if (isPre && !Globals.checkRule("RETROSKILL")) {
            titleKey = "in_statTitleWithSkill";
        }
        int iCount = 0;
        HashSet<PCStat> statsAlreadyBonused = new HashSet<PCStat>();
        boolean allowStacks = SettingsHandler.getGame().isBonusStatAllowsStack();
        DecimalFormat formatter = PrettyIntegerFormat.getFormat();
        block0: for (int ix = 0; ix < statsToChoose; ++ix) {
            String selectedValue;
            ArrayList<String> selectableStats = new ArrayList<String>();
            for (PCStat aStat : aPC.getDisplay().getStatSet()) {
                StringBuilder sStats = new StringBuilder(100);
                int iAdjStat = aPC.getTotalStatFor(aStat);
                int iCurStat = aPC.getBaseStatFor(aStat);
                sStats.append(aStat.getDisplayName()).append(":  ").append(iCurStat);
                if (iCurStat != iAdjStat) {
                    sStats.append(" adjusted: ").append(iAdjStat);
                }
                sStats.append(" (").append(formatter.format(aPC.getStatModFor(aStat))).append(")");
                if (allowStacks || !statsAlreadyBonused.contains(aStat)) {
                    selectableStats.add(sStats.toString());
                    continue;
                }
                sStats.append(" * Already incremented.");
                selectableStats.add(sStats.toString());
            }
            CDOMChooserFacadeImpl chooserFacade = new CDOMChooserFacadeImpl(LanguageBundle.getString(titleKey), selectableStats, new ArrayList(), 1);
            chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
            chooserFacade.setPreferRadioSelection(true);
            chooserFacade.setInfoFactory(new Gui2InfoFactory(aPC));
            ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
            List selectedValues = chooserFacade.getFinalSelected();
            String string = selectedValue = selectedValues.isEmpty() ? null : (String)selectedValues.get(0);
            if (selectedValue == null) continue;
            for (PCStat aStat : aPC.getStatSet()) {
                if (!selectedValue.startsWith(aStat.getDisplayName())) continue;
                aPC.saveStatIncrease(aStat, 1, isPre);
                aPC.setStat(aStat, aPC.getStat(aStat) + 1);
                aPC.setPoolAmount(aPC.getPoolAmount() - 1);
                statsAlreadyBonused.add(aStat);
                ++iCount;
                continue block0;
            }
        }
        return statsToChoose - iCount;
    }
}

