/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.HashMap;
import java.util.Map;
import pcgen.core.LevelInfo;
import pcgen.core.PObject;
import pcgen.facade.core.XPTableFacade;

public final class XPTable
extends PObject
implements XPTableFacade {
    private String name;
    private Map<String, LevelInfo> infoMap;

    public XPTable() {
        this.name = "Default";
        this.infoMap = new HashMap<String, LevelInfo>();
    }

    public XPTable(String xpTable) {
        this.name = xpTable;
        this.infoMap = new HashMap<String, LevelInfo>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addLevelInfo(String level, LevelInfo levelInfo) {
        this.infoMap.put(level, levelInfo);
    }

    @Override
    public LevelInfo getLevelInfo(String levelString) {
        return this.infoMap.get(levelString);
    }

    public LevelInfo getLevelInfo(int level) {
        if (level < 1) {
            return null;
        }
        LevelInfo lInfo = this.getLevelInfo(String.valueOf(level));
        if (lInfo == null) {
            lInfo = this.getLevelInfo("LEVEL");
        }
        return lInfo;
    }

    public boolean validateSequence(String levelValue) {
        int value = XPTable.getIntValue(levelValue);
        for (String key : this.infoMap.keySet()) {
            int intValue = XPTable.getIntValue(this.infoMap.get(key).getLevelString());
            if (value >= intValue) continue;
            return false;
        }
        return true;
    }

    private static int getIntValue(String level) {
        try {
            return Integer.parseInt(level);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

